/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gen;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.Repository;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.gen.PreGeneralizedFeatureSource;
import org.geotools.data.gen.info.GeneralizationInfo;
import org.geotools.data.gen.info.GeneralizationInfos;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureTypes;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public class PreGeneralizedDataStore
implements DataStore {
    Map<String, PreGeneralizedFeatureSource> featureSources;
    private URI namespace;

    public URI getNamespace() {
        return this.namespace;
    }

    public PreGeneralizedDataStore(GeneralizationInfos infos, Repository repository) {
        this(infos, repository, null);
    }

    public PreGeneralizedDataStore(GeneralizationInfos infos, Repository repository, URI namespace) {
        this.namespace = namespace;
        this.featureSources = new HashMap<String, PreGeneralizedFeatureSource>();
        for (GeneralizationInfo gi : infos.getGeneralizationInfoCollection()) {
            this.featureSources.put(gi.getFeatureName(), new PreGeneralizedFeatureSource(gi, repository, this));
        }
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        PreGeneralizedFeatureSource fs = this.featureSources.get(query.getTypeName());
        if (fs == null) {
            throw new IOException(query.getTypeName() + " not found");
        }
        return fs.getFeatureReader(query, transaction);
    }

    @Override
    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        SimpleFeatureSource fs = this.featureSources.get(typeName);
        if (fs == null) {
            throw new IOException(typeName + " not found");
        }
        return fs;
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("getFeatureWriter");
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("getFeatureWriter");
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("getFeatureWriterAppend");
    }

    @Override
    public LockingManager getLockingManager() {
        throw new UnsupportedOperationException("getLockingManager");
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        return (SimpleFeatureType)this.getFeatureSource(typeName).getSchema();
    }

    @Override
    public String[] getTypeNames() throws IOException {
        Set<String> keys = this.featureSources.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("updateSchema");
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("createSchema");
    }

    @Override
    public void dispose() {
        for (PreGeneralizedFeatureSource fs : this.featureSources.values()) {
            fs.reset();
        }
    }

    @Override
    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        return this.getFeatureSource(typeName.getLocalPart());
    }

    @Override
    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription("Generalized Feature Store ");
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        try {
            info.setPublisher(new URI(System.getProperty("user.name")));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return info;
    }

    @Override
    public List<Name> getNames() throws IOException {
        ArrayList<Name> nameList = new ArrayList<Name>();
        for (PreGeneralizedFeatureSource fs : this.featureSources.values()) {
            nameList.add(fs.getName());
        }
        return nameList;
    }

    @Override
    public SimpleFeatureType getSchema(Name name) throws IOException {
        return (SimpleFeatureType)this.getFeatureSource(name).getSchema();
    }

    @Override
    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("updateSchema");
    }

    @Override
    public void removeSchema(Name typeName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSchema(String typeName) throws IOException {
        throw new UnsupportedOperationException();
    }
}

