/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.spatialschema.geometry.primitive;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Collections;
import java.util.Set;
import org.geotools.factory.BasicFactories;
import org.geotools.geometry.jts.JTSUtils;
import org.geotools.geometry.jts.spatialschema.geometry.DirectPositionImpl;
import org.geotools.geometry.jts.spatialschema.geometry.GeometryImpl;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.UnmodifiableGeometryException;
import org.opengis.geometry.complex.Composite;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Bearing;
import org.opengis.geometry.primitive.OrientablePrimitive;
import org.opengis.geometry.primitive.Point;
import org.opengis.geometry.primitive.PrimitiveBoundary;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

public class PointImpl
extends GeometryImpl
implements Point {
    private DirectPosition position;

    public PointImpl() {
        this(null, DefaultGeographicCRS.WGS84);
    }

    public PointImpl(DirectPosition position) {
        this(position, position.getCoordinateReferenceSystem());
    }

    public PointImpl(DirectPosition position, CoordinateReferenceSystem crs) {
        super(crs);
        this.position = position == null ? new DirectPositionImpl(crs) : position;
    }

    @Deprecated
    public DirectPosition getPosition() {
        return this.getDirectPosition();
    }

    public DirectPosition getDirectPosition() {
        return new DirectPositionImpl(this.position);
    }

    @Deprecated
    public void setPosition(DirectPosition position) throws UnmodifiableGeometryException {
        this.setDirectPosition(position);
    }

    public void setDirectPosition(DirectPosition position) throws UnmodifiableGeometryException {
        DirectPositionImpl copy;
        if (this.isMutable()) {
            CoordinateReferenceSystem myCRS = this.getCoordinateReferenceSystem();
            CoordinateReferenceSystem pointCRS = position.getCoordinateReferenceSystem();
            copy = new DirectPositionImpl(position);
            if (myCRS != null && pointCRS != null && !myCRS.equals(pointCRS)) {
                try {
                    BasicFactories commonFactory = BasicFactories.getDefault();
                    CoordinateOperationFactory cof = commonFactory.getCoordinateOperationFactory();
                    CoordinateOperation coordOp = cof.createOperation(pointCRS, myCRS);
                    MathTransform mt = coordOp.getMathTransform();
                    mt.transform(position, (DirectPosition)copy);
                }
                catch (OperationNotFoundException e) {
                    throw new RuntimeException("Unable to find an operation", e);
                }
                catch (FactoryException e) {
                    throw new RuntimeException("Factory exception", e);
                }
                catch (TransformException e) {
                    throw new RuntimeException("Error transforming", e);
                }
            }
        } else {
            throw new UnmodifiableGeometryException();
        }
        this.position = copy;
        this.invalidateCachedJTSPeer();
    }

    public PrimitiveBoundary getBoundary() {
        return (PrimitiveBoundary)super.getBoundary();
    }

    public Bearing getBearing(Position toPoint) {
        throw new UnsupportedOperationException("Bearing calculation is not supported");
    }

    @Override
    protected Geometry computeJTSPeer() {
        return JTSUtils.directPositionToPoint(this.position);
    }

    public Set getContainedPrimitives() {
        return Collections.EMPTY_SET;
    }

    public Set getContainingPrimitives() {
        throw new UnsupportedOperationException();
    }

    public Set getComplexes() {
        throw new UnsupportedOperationException();
    }

    public Composite getComposite() {
        return null;
    }

    public OrientablePrimitive[] getProxy() {
        return null;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PointImpl other = (PointImpl)obj;
        return !(this.position == null ? other.position != null : !this.position.equals((Object)other.position));
    }
}

