/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.v1_x;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.wfs.internal.GetFeatureParser;
import org.geotools.data.wfs.internal.parsers.EmfAppSchemaParser;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

class WFSFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private SimpleFeature next;
    private GetFeatureParser parser;
    private SimpleFeatureType featureType;

    public WFSFeatureReader(GetFeatureParser parser) throws IOException {
        this.parser = parser;
        this.next = parser.parse();
        if (this.next != null) {
            SimpleFeatureType parsedType = this.next.getFeatureType();
            this.featureType = parsedType instanceof SimpleFeatureType ? parsedType : EmfAppSchemaParser.toSimpleFeatureType((FeatureType)parsedType);
        }
    }

    @Override
    public void close() throws IOException {
        GetFeatureParser parser = this.parser;
        this.parser = null;
        this.next = null;
        if (parser != null) {
            parser.close();
        }
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        if (this.featureType == null) {
            throw new IllegalStateException("No features were retrieved, shouldn't be calling getFeatureType()");
        }
        return this.featureType;
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.next != null;
    }

    @Override
    public SimpleFeature next() throws IOException, NoSuchElementException {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        SimpleFeature current = this.next;
        this.next = this.parser.parse();
        return current;
    }
}

