/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.v1_x;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import net.opengis.ows10.KeywordsType;
import net.opengis.ows10.WGS84BoundingBoxType;
import net.opengis.wfs.FeatureTypeType;
import net.opengis.wfs.OutputFormatListType;
import org.eclipse.emf.common.util.EList;
import org.geotools.data.wfs.internal.FeatureTypeInfo;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class FeatureTypeInfoImpl
implements FeatureTypeInfo {
    private final FeatureTypeType eType;

    public FeatureTypeInfoImpl(FeatureTypeType eType) {
        this.eType = eType;
    }

    @Override
    public String getTitle() {
        return this.eType.getTitle();
    }

    @Override
    public Set<String> getKeywords() {
        Set<String> ret;
        EList keywords = this.eType.getKeywords();
        if (keywords == null) {
            ret = Collections.emptySet();
        } else {
            ret = new HashSet();
            for (KeywordsType k : keywords) {
                ret.addAll((Collection<String>)k.getKeyword());
            }
            ret.remove(null);
        }
        return ret;
    }

    @Override
    public String getDescription() {
        return this.eType.getAbstract();
    }

    @Override
    public String getName() {
        return this.eType.getName().getLocalPart();
    }

    @Override
    public URI getSchema() {
        String namespaceURI = this.eType.getName().getNamespaceURI();
        try {
            return "".equals(namespaceURI) ? null : new URI(namespaceURI);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public ReferencedEnvelope getBounds() {
        ReferencedEnvelope nativeBounds;
        ReferencedEnvelope wgs84Bounds = this.getWGS84BoundingBox();
        CoordinateReferenceSystem crs = this.getCRS();
        if (null == crs) {
            return wgs84Bounds;
        }
        try {
            nativeBounds = wgs84Bounds.transform(crs, true);
        }
        catch (TransformException e) {
            Loggers.MODULE.log(Level.WARNING, "Can't transform bounds of " + this.getName() + " to " + this.getDefaultSRS(), e);
            nativeBounds = new ReferencedEnvelope(crs);
        }
        catch (FactoryException e) {
            Loggers.MODULE.log(Level.WARNING, "Can't transform bounds of " + this.getName() + " to " + this.getDefaultSRS(), e);
            nativeBounds = new ReferencedEnvelope(crs);
        }
        return nativeBounds;
    }

    @Override
    public String getDefaultSRS() {
        return this.eType.getDefaultSRS();
    }

    @Override
    public CoordinateReferenceSystem getCRS() {
        CoordinateReferenceSystem crs = null;
        String defaultSRS = this.eType.getDefaultSRS();
        if (null != defaultSRS) {
            try {
                boolean forceLongitudFirst = defaultSRS.startsWith("EPSG:");
                crs = CRS.decode((String)defaultSRS, (boolean)forceLongitudFirst);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return crs;
    }

    @Override
    public ReferencedEnvelope getWGS84BoundingBox() {
        EList bboxList = this.eType.getWGS84BoundingBox();
        if (bboxList != null && bboxList.size() > 0) {
            WGS84BoundingBoxType bboxType = (WGS84BoundingBoxType)bboxList.get(0);
            List lowerCorner = bboxType.getLowerCorner();
            List upperCorner = bboxType.getUpperCorner();
            double minLon = (Double)lowerCorner.get(0);
            double minLat = (Double)lowerCorner.get(1);
            double maxLon = (Double)upperCorner.get(0);
            double maxLat = (Double)upperCorner.get(1);
            ReferencedEnvelope latLonBounds = new ReferencedEnvelope(minLon, maxLon, minLat, maxLat, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            return latLonBounds;
        }
        return null;
    }

    @Override
    public List<String> getOtherSRS() {
        return this.eType.getOtherSRS();
    }

    @Override
    public Set<String> getOutputFormats() {
        OutputFormatListType outputFormats = this.eType.getOutputFormats();
        if (null == outputFormats) {
            return Collections.emptySet();
        }
        EList ftypeDeclaredFormats = outputFormats.getFormat();
        if (null == ftypeDeclaredFormats || ftypeDeclaredFormats.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>((Collection<String>)ftypeDeclaredFormats);
    }

    @Override
    public String getAbstract() {
        return this.eType.getAbstract();
    }
}

