/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.data.wfs.internal.WFSOperationType;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.data.wfs.internal.WFSResponseFactory;
import org.geotools.factory.FactoryNotFoundException;

public class WFSExtensions {
    private static Set<WFSResponseFactory> registry;

    public static WFSResponseFactory findResponseFactory(WFSRequest originatingRequest, String contentType) {
        Iterator<WFSResponseFactory> serviceProviders = WFSExtensions.getServiceProviders();
        while (serviceProviders.hasNext()) {
            WFSResponseFactory factory = serviceProviders.next();
            if (!factory.isAvailable() || !factory.canProcess(originatingRequest, contentType)) continue;
            return factory;
        }
        throw new FactoryNotFoundException("Can't find a response parser factory for " + (Object)((Object)originatingRequest.getOperation()) + "/'" + contentType + "'");
    }

    public static List<WFSResponseFactory> findResponseFactories(WFSOperationType operation) {
        Iterator<WFSResponseFactory> serviceProviders = WFSExtensions.getServiceProviders();
        ArrayList<WFSResponseFactory> matches = new ArrayList<WFSResponseFactory>(5);
        while (serviceProviders.hasNext()) {
            WFSResponseFactory factory = serviceProviders.next();
            if (!factory.isAvailable() || !factory.canProcess(operation)) continue;
            matches.add(factory);
        }
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Iterator<WFSResponseFactory> getServiceProviders() {
        if (registry != null) return registry.iterator();
        Class<WFSExtensions> clazz = WFSExtensions.class;
        synchronized (WFSExtensions.class) {
            if (registry != null) return registry.iterator();
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader tempClassLoader = WFSDataStoreFactory.class.getClassLoader();
                Thread.currentThread().setContextClassLoader(tempClassLoader);
                Iterator<WFSResponseFactory> providers = ServiceRegistry.lookupProviders(WFSResponseFactory.class);
                registry = new HashSet<WFSResponseFactory>();
                while (providers.hasNext()) {
                    WFSResponseFactory provider = providers.next();
                    registry.add(provider);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return registry.iterator();
        }
    }
}

