/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WFSConfig {
    private String user;
    private String pass;
    private int timeoutMillis;
    private PreferredHttpMethod preferredMethod = PreferredHttpMethod.AUTO;
    private int buffer;
    private boolean tryGZIP;
    private boolean lenient;
    private Integer maxFeatures;
    private Charset defaultEncoding;
    private String wfsStrategy;
    private Integer filterCompliance;
    private String namespaceOverride;
    private String outputformatOverride;
    private boolean useDefaultSrs;
    private String axisOrder;
    private String axisOrderFilter;

    public WFSConfig() {
        this.timeoutMillis = (Integer)WFSDataStoreFactory.TIMEOUT.getDefaultValue();
        this.buffer = (Integer)WFSDataStoreFactory.BUFFER_SIZE.getDefaultValue();
        this.tryGZIP = (Boolean)WFSDataStoreFactory.TRY_GZIP.getDefaultValue();
        this.lenient = (Boolean)WFSDataStoreFactory.LENIENT.getDefaultValue();
        String encoding = (String)WFSDataStoreFactory.ENCODING.getDefaultValue();
        this.defaultEncoding = Charset.forName(encoding);
        this.maxFeatures = (Integer)WFSDataStoreFactory.MAXFEATURES.getDefaultValue();
        this.wfsStrategy = (String)WFSDataStoreFactory.WFS_STRATEGY.getDefaultValue();
        this.filterCompliance = (Integer)WFSDataStoreFactory.FILTER_COMPLIANCE.getDefaultValue();
        this.namespaceOverride = (String)WFSDataStoreFactory.NAMESPACE.getDefaultValue();
    }

    public static WFSConfig fromParams(Map<?, ?> params) throws IOException {
        WFSConfig config = new WFSConfig();
        Boolean preferPost = WFSDataStoreFactory.PROTOCOL.lookUp(params);
        config.preferredMethod = preferPost == null ? PreferredHttpMethod.AUTO : (preferPost != false ? PreferredHttpMethod.HTTP_POST : PreferredHttpMethod.HTTP_GET);
        config.preferredMethod = PreferredHttpMethod.HTTP_POST;
        config.user = WFSDataStoreFactory.USERNAME.lookUp(params);
        config.pass = WFSDataStoreFactory.PASSWORD.lookUp(params);
        config.timeoutMillis = WFSDataStoreFactory.TIMEOUT.lookUp(params);
        config.buffer = WFSDataStoreFactory.BUFFER_SIZE.lookUp(params);
        config.tryGZIP = WFSDataStoreFactory.TRY_GZIP.lookUp(params);
        config.lenient = WFSDataStoreFactory.LENIENT.lookUp(params);
        String encoding = WFSDataStoreFactory.ENCODING.lookUp(params);
        config.defaultEncoding = Charset.forName(encoding);
        config.maxFeatures = WFSDataStoreFactory.MAXFEATURES.lookUp(params);
        config.wfsStrategy = WFSDataStoreFactory.WFS_STRATEGY.lookUp(params);
        config.filterCompliance = WFSDataStoreFactory.FILTER_COMPLIANCE.lookUp(params);
        config.namespaceOverride = WFSDataStoreFactory.NAMESPACE.lookUp(params);
        config.outputformatOverride = WFSDataStoreFactory.OUTPUTFORMAT.lookUp(params);
        return config;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.pass;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public PreferredHttpMethod getPreferredMethod() {
        return this.preferredMethod;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public boolean isTryGZIP() {
        return this.tryGZIP;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public Integer getMaxFeatures() {
        return this.maxFeatures;
    }

    public Charset getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getWfsStrategy() {
        return this.wfsStrategy;
    }

    public Integer getFilterCompliance() {
        return this.filterCompliance;
    }

    public String getNamespaceOverride() {
        return this.namespaceOverride;
    }

    public String getOutputformatOverride() {
        return this.outputformatOverride;
    }

    public boolean isUseDefaultSrs() {
        return this.useDefaultSrs;
    }

    public String getAxisOrder() {
        return this.axisOrder;
    }

    public String getAxisOrderFilter() {
        return this.axisOrderFilter;
    }

    public static boolean invertAxisNeeded(String axisOrder, CoordinateReferenceSystem crs) {
        boolean invertXY = "East / North".equals(axisOrder) ? false : ("North / East".equals(axisOrder) ? true : CRS.getAxisOrder((CoordinateReferenceSystem)crs).equals((Object)CRS.AxisOrder.NORTH_EAST));
        return invertXY;
    }

    public static enum PreferredHttpMethod {
        AUTO,
        HTTP_GET,
        HTTP_POST;

    }
}

