/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.wfs.internal.FeatureTypeInfo;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.data.wfs.internal.WFSOperationType;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.data.wfs.internal.WFSResponse;
import org.geotools.data.wfs.internal.WFSStrategy;
import org.geotools.feature.NameImpl;
import org.geotools.referencing.CRS;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class TransactionRequest
extends WFSRequest {
    private Set<QName> typeNames;
    private List<TransactionElement> txElements = new ArrayList<TransactionElement>();

    public TransactionRequest(WFSConfig config, WFSStrategy strategy) {
        super(WFSOperationType.TRANSACTION, config, strategy);
        this.typeNames = new HashSet<QName>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TransactionElement txElem) {
        List<TransactionElement> list = this.txElements;
        synchronized (list) {
            this.txElements.add(txElem);
            this.typeNames.add(txElem.getTypeName());
        }
    }

    public Set<QName> getTypeNames() {
        return Collections.unmodifiableSet(new HashSet<QName>(this.typeNames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransactionElement> getTransactionElements() {
        List<TransactionElement> list = this.txElements;
        synchronized (list) {
            return new ArrayList<TransactionElement>(this.txElements);
        }
    }

    public Insert createInsert(QName typeName) {
        return new Insert(typeName);
    }

    public Update createUpdate(QName typeName, List<QName> propertyNames, List<Object> newValues, Filter updateFilter) {
        return new Update(typeName, propertyNames, newValues, updateFilter);
    }

    public Delete createDelete(QName typeName, Filter deleteFilter) {
        return new Delete(typeName, deleteFilter);
    }

    @Override
    public WFSResponse createResponse(HTTPResponse response) throws IOException {
        return super.createResponse(response);
    }

    public static class Delete
    extends TransactionElement {
        private final Filter filter;

        Delete(QName typeName, Filter deleteFilter) {
            super(typeName);
            this.filter = deleteFilter;
        }

        public Filter getFilter() {
            return this.filter;
        }
    }

    public static class Update
    extends TransactionElement {
        private final List<QName> propertyNames;
        private final List<Object> newValues;
        private final Filter filter;

        Update(QName typeName, List<QName> propertyNames, List<Object> newValues, Filter updateFilter) {
            super(typeName);
            this.propertyNames = Collections.unmodifiableList(new ArrayList<QName>(propertyNames));
            this.newValues = Collections.unmodifiableList(new ArrayList<Object>(newValues));
            this.filter = updateFilter;
        }

        public List<QName> getPropertyNames() {
            return this.propertyNames;
        }

        public List<Object> getNewValues() {
            return this.newValues;
        }

        public Filter getFilter() {
            return this.filter;
        }
    }

    public class Insert
    extends TransactionElement {
        private List<SimpleFeature> added;

        Insert(QName typeName) {
            super(typeName);
            this.added = new LinkedList<SimpleFeature>();
        }

        public void add(SimpleFeature feature) {
            Name name = feature.getFeatureType().getName();
            QName typeName = this.getTypeName();
            if (!new NameImpl(typeName).equals(name)) {
                throw new IllegalArgumentException("Type name does not match. Expected " + new NameImpl(typeName) + ", but got " + name);
            }
            WFSStrategy strategy = TransactionRequest.this.getStrategy();
            FeatureTypeInfo typeInfo = strategy.getFeatureTypeInfo(typeName);
            CoordinateReferenceSystem crs = typeInfo.getCRS();
            for (Property property : feature.getProperties()) {
                CoordinateReferenceSystem attCrs;
                if (!(property instanceof GeometryAttribute) || CRS.equalsIgnoreMetadata((Object)crs, (Object)(attCrs = ((GeometryType)property.getType()).getCoordinateReferenceSystem()))) continue;
                throw new IllegalArgumentException("Added Features shall match the native CRS: " + typeInfo.getDefaultSRS() + ". Got " + attCrs);
            }
            this.added.add(feature);
        }

        public List<SimpleFeature> getFeatures() {
            return Collections.unmodifiableList(new ArrayList<SimpleFeature>(this.added));
        }
    }

    public static abstract class TransactionElement {
        private QName typeName;

        TransactionElement(QName typeName) {
            this.typeName = typeName;
        }

        public QName getTypeName() {
            return this.typeName;
        }
    }
}

