/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequenceFactory;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.data.crs.ReprojectFeatureReader;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.wfs.InvertAxisFilterVisitor;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDiff;
import org.geotools.data.wfs.WFSFeatureReader;
import org.geotools.data.wfs.WFSLocalTransactionState;
import org.geotools.data.wfs.internal.GetFeatureParser;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.GetFeatureResponse;
import org.geotools.data.wfs.internal.WFSClient;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class WFSFeatureSource
extends ContentFeatureSource {
    private static final Logger LOGGER = Logging.getLogger(WFSFeatureSource.class);
    private final WFSClient client;

    public WFSFeatureSource(ContentEntry entry, WFSClient client) {
        super(entry, null);
        this.client = client;
    }

    WFSClient getWfs() {
        return this.client;
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return false;
    }

    protected boolean canReproject() {
        return true;
    }

    protected boolean canOffset() {
        return false;
    }

    protected boolean canSort() {
        return this.client.canSort();
    }

    protected boolean canRetype() {
        return this.client.canRetype();
    }

    protected boolean canFilter() {
        return this.client.canFilter();
    }

    protected boolean canLimit() {
        return this.client.canLimit();
    }

    public WFSDataStore getDataStore() {
        return (WFSDataStore)super.getDataStore();
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        if (!Filter.INCLUDE.equals(query.getFilter())) {
            return null;
        }
        QName remoteTypeName = this.getRemoteTypeName();
        CoordinateReferenceSystem targetCrs = null == query.getCoordinateSystem() ? this.client.getDefaultCRS(remoteTypeName) : query.getCoordinateSystem();
        ReferencedEnvelope bounds = this.client.getBounds(remoteTypeName, targetCrs);
        return bounds;
    }

    protected int getCountInternal(Query query) throws IOException {
        if (!this.client.canCount()) {
            return -1;
        }
        GetFeatureRequest request = this.createGetFeature(query, GetFeatureRequest.ResultType.HITS);
        GetFeatureResponse response = this.client.issueRequest(request);
        GetFeatureParser featureParser = response.getFeatures(null);
        int resultCount = featureParser.getNumberOfFeatures();
        return resultCount;
    }

    private void invertAxisInFilterIfNeeded(Query query) {
        boolean invertXY = WFSConfig.invertAxisNeeded(this.client.getAxisOrderFilter(), query.getCoordinateSystem());
        if (invertXY) {
            Filter filter = query.getFilter();
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            InvertAxisFilterVisitor visitor = new InvertAxisFilterVisitor(ff, new GeometryFactory());
            filter = (Filter)filter.accept((FilterVisitor)visitor, null);
            query.setFilter(filter);
        }
    }

    protected GetFeatureRequest createGetFeature(Query query, GetFeatureRequest.ResultType resultType) throws IOException {
        GetFeatureRequest request = this.client.createGetFeatureRequest();
        WFSDataStore dataStore = this.getDataStore();
        QName remoteTypeName = dataStore.getRemoteTypeName(this.getEntry().getName());
        SimpleFeatureType remoteSimpleFeatureType = dataStore.getRemoteSimpleFeatureType(remoteTypeName);
        request.setTypeName(remoteTypeName);
        request.setFullType((FeatureType)remoteSimpleFeatureType);
        this.invertAxisInFilterIfNeeded(query);
        request.setFilter(query.getFilter());
        request.setResultType(resultType);
        request.setHints(query.getHints());
        int maxFeatures = query.getMaxFeatures();
        if (Integer.MAX_VALUE > maxFeatures) {
            request.setMaxFeatures(maxFeatures);
        }
        request.setPropertyNames(query.getPropertyNames());
        request.setSortBy(query.getSortBy());
        String srsName = this.getSupportedSrsName(request, query);
        request.setSrsName(srsName);
        return request;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query localQuery) throws IOException {
        ContentEntry entry;
        Transaction.State state;
        WFSLocalTransactionState wfsState;
        if (Filter.EXCLUDE.equals(localQuery.getFilter())) {
            return new EmptyFeatureReader((FeatureType)this.getSchema());
        }
        GetFeatureRequest request = this.createGetFeature(localQuery, GetFeatureRequest.ResultType.RESULTS);
        SimpleFeatureType destType = this.getQueryType(localQuery, this.getSchema());
        SimpleFeatureType contentType = this.getQueryType(localQuery, (SimpleFeatureType)request.getFullType());
        request.setQueryType((FeatureType)contentType);
        GetFeatureResponse response = this.client.issueRequest(request);
        GeometryFactory geometryFactory = this.findGeometryFactory(localQuery.getHints());
        GetFeatureParser features = response.getSimpleFeatures(geometryFactory);
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = new WFSFeatureReader(features);
        if (request.getUnsupportedFilter() != null && request.getUnsupportedFilter() != Filter.INCLUDE) {
            reader = new FilteringFeatureReader((FeatureReader)reader, request.getUnsupportedFilter());
        }
        if (!reader.hasNext()) {
            return new EmptyFeatureReader((FeatureType)contentType);
        }
        SimpleFeatureType readerType = (SimpleFeatureType)reader.getFeatureType();
        if (!destType.equals(readerType)) {
            boolean cloneContents = false;
            reader = new ReTypeFeatureReader((FeatureReader)reader, destType, false);
        }
        reader = this.applyReprojectionDecorator(reader, localQuery, request);
        Transaction transaction = this.getTransaction();
        if (!Transaction.AUTO_COMMIT.equals(transaction) && (wfsState = (WFSLocalTransactionState)((Object)(state = transaction.getState(entry = this.getEntry())))) != null) {
            WFSDiff diff = wfsState.getDiff();
            reader = new DiffFeatureReader((FeatureReader)reader, (Diff)diff, localQuery.getFilter());
        }
        return reader;
    }

    protected String getSupportedSrsName(GetFeatureRequest request, Query query) {
        String epsgCode = GML2EncodingUtils.epsgCode((CoordinateReferenceSystem)query.getCoordinateSystem());
        Set<String> supported = request.getStrategy().getSupportedCRSIdentifiers(request.getTypeName());
        for (String supportedSrs : supported) {
            if (!supportedSrs.endsWith(":" + epsgCode)) continue;
            return supportedSrs;
        }
        return null;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> applyReprojectionDecorator(FeatureReader<SimpleFeatureType, SimpleFeature> reader, Query query, GetFeatureRequest request) {
        ForceCoordinateSystemFeatureReader tmp = reader;
        if (query.getCoordinateSystem() != null && !query.getCoordinateSystem().equals(reader.getFeatureType().getCoordinateReferenceSystem())) {
            if (request.getSrsName() != null) {
                try {
                    reader = new ForceCoordinateSystemFeatureReader(reader, query.getCoordinateSystem());
                }
                catch (SchemaException e) {
                    LOGGER.warning(e.toString());
                    reader = tmp;
                }
            } else {
                try {
                    reader = new ReprojectFeatureReader(reader, query.getCoordinateSystem());
                }
                catch (Exception e) {
                    LOGGER.warning(e.toString());
                    reader = tmp;
                }
            }
        }
        return reader;
    }

    private GeometryFactory findGeometryFactory(Hints hints) {
        GeometryFactory geomFactory = (GeometryFactory)hints.get((Object)Hints.JTS_GEOMETRY_FACTORY);
        if (geomFactory == null) {
            CoordinateSequenceFactory seqFac = (CoordinateSequenceFactory)hints.get((Object)Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
            if (seqFac == null) {
                seqFac = PackedCoordinateSequenceFactory.DOUBLE_FACTORY;
            }
            geomFactory = new GeometryFactory(seqFac);
        }
        return geomFactory;
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        GeometryDescriptor defaultGeometry;
        WFSDataStore dataStore = this.getDataStore();
        Name localTypeName = this.getEntry().getName();
        QName remoteTypeName = dataStore.getRemoteTypeName(localTypeName);
        SimpleFeatureType remoteSimpleFeatureType = dataStore.getRemoteSimpleFeatureType(remoteTypeName);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.init(remoteSimpleFeatureType);
        builder.setName(localTypeName);
        String namespaceOverride = this.entry.getName().getNamespaceURI();
        if (namespaceOverride != null) {
            builder.setNamespaceURI(namespaceOverride);
        }
        if ((defaultGeometry = remoteSimpleFeatureType.getGeometryDescriptor()) != null) {
            builder.setDefaultGeometry(defaultGeometry.getLocalName());
            builder.setCRS(defaultGeometry.getCoordinateReferenceSystem());
        }
        SimpleFeatureType adaptedFeatureType = builder.buildFeatureType();
        return adaptedFeatureType;
    }

    public QName getRemoteTypeName() throws IOException {
        Name localTypeName = this.getEntry().getName();
        QName remoteTypeName = this.getDataStore().getRemoteTypeName(localTypeName);
        return remoteTypeName;
    }

    SimpleFeatureType getQueryType(Query query, SimpleFeatureType featureType) throws IOException {
        CoordinateReferenceSystem coordinateSystemReproject = query.getCoordinateSystemReproject();
        String[] propertyNames = query.getPropertyNames();
        SimpleFeatureType queryType = featureType;
        if (propertyNames != null && propertyNames.length > 0) {
            try {
                queryType = DataUtilities.createSubType((SimpleFeatureType)queryType, (String[])propertyNames);
            }
            catch (SchemaException e) {
                throw new DataSourceException(e);
            }
        } else {
            propertyNames = DataUtilities.attributeNames((SimpleFeatureType)featureType);
        }
        if (coordinateSystemReproject != null) {
            try {
                queryType = DataUtilities.createSubType((SimpleFeatureType)queryType, (String[])propertyNames, (CoordinateReferenceSystem)coordinateSystemReproject);
            }
            catch (SchemaException e) {
                throw new DataSourceException(e);
            }
        }
        return queryType;
    }

    public ResourceInfo getInfo() {
        try {
            return this.client.getInfo(this.getRemoteTypeName());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unexpected error getting ResourceInfo: ", e);
            return super.getInfo();
        }
    }
}

