/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequenceFactory;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.SimpleHttpClient;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.data.wfs.internal.URIs;
import org.geotools.data.wfs.internal.Versions;
import org.geotools.data.wfs.internal.WFSClient;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.ows.ServiceException;
import org.geotools.util.KVP;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Version;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.util.InternationalString;

public class WFSDataStoreFactory
implements DataStoreFactorySpi {
    public static final String AXIS_ORDER_EAST_NORTH = "East / North";
    public static final String AXIS_ORDER_NORTH_EAST = "North / East";
    public static final String AXIS_ORDER_COMPLIANT = "Compliant";
    private static final WFSFactoryParam<?>[] parametersInfo = new WFSFactoryParam[17];
    public static final WFSFactoryParam<URL> URL;
    public static final WFSFactoryParam<Boolean> PROTOCOL;
    public static final WFSFactoryParam<String> USERNAME;
    public static final WFSFactoryParam<String> PASSWORD;
    public static final WFSFactoryParam<String> ENCODING;
    public static final WFSFactoryParam<Integer> TIMEOUT;
    public static final WFSFactoryParam<Integer> BUFFER_SIZE;
    public static final WFSFactoryParam<Boolean> TRY_GZIP;
    public static final WFSFactoryParam<Boolean> LENIENT;
    public static final WFSFactoryParam<Integer> MAXFEATURES;
    public static final WFSFactoryParam<Integer> FILTER_COMPLIANCE;
    public static final WFSFactoryParam<String> WFS_STRATEGY;
    public static final WFSFactoryParam<String> NAMESPACE;
    public static final WFSFactoryParam<Boolean> USEDEFAULTSRS;
    public static final WFSFactoryParam<String> AXIS_ORDER;
    public static final WFSFactoryParam<String> AXIS_ORDER_FILTER;
    public static final WFSFactoryParam<String> OUTPUTFORMAT;

    public WFSDataStore createDataStore(Map<String, Serializable> params) throws IOException {
        WFSClient wfsClient;
        WFSConfig config = WFSConfig.fromParams(params);
        String user = config.getUser();
        String password = config.getPassword();
        if (user == null && password != null || config.getPassword() == null && config.getUser() != null) {
            throw new IOException("Cannot define only one of USERNAME or PASSWORD, must define both or neither");
        }
        SimpleHttpClient http = new SimpleHttpClient();
        http.setUser(config.getUser());
        http.setPassword(config.getPassword());
        int timeoutMillis = config.getTimeoutMillis();
        http.setConnectTimeout(timeoutMillis / 1000);
        URL capabilitiesURL = URL.lookUp((Map)params);
        try {
            wfsClient = new WFSClient(capabilitiesURL, (HTTPClient)http, config);
        }
        catch (ServiceException e) {
            throw new IOException(e);
        }
        WFSDataStore dataStore = new WFSDataStore(wfsClient);
        dataStore.setFilterFactory(CommonFactoryFinder.getFilterFactory(null));
        dataStore.setGeometryFactory(new GeometryFactory(PackedCoordinateSequenceFactory.DOUBLE_FACTORY));
        dataStore.setFeatureTypeFactory((FeatureTypeFactory)new FeatureTypeFactoryImpl());
        dataStore.setFeatureFactory(CommonFactoryFinder.getFeatureFactory(null));
        dataStore.setDataStoreFactory(this);
        dataStore.setNamespaceURI(config.getNamespaceOverride());
        return dataStore;
    }

    @Override
    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        throw new UnsupportedOperationException("Operation not applicable to a WFS service");
    }

    @Override
    public String getDisplayName() {
        return "Web Feature Server (NG)";
    }

    @Override
    public String getDescription() {
        return "Provides access to the Features published a Web Feature Service, and the ability to perform transactions on the server (when supported / allowed).";
    }

    @Override
    public DataAccessFactory.Param[] getParametersInfo() {
        int length = parametersInfo.length;
        DataAccessFactory.Param[] params = new DataAccessFactory.Param[length];
        System.arraycopy(parametersInfo, 0, params, 0, length);
        return params;
    }

    public boolean canProcess(Map params) {
        boolean canProcess = DataUtilities.canProcess((Map)params, (DataAccessFactory.Param[])this.getParametersInfo());
        if (!canProcess) {
            return false;
        }
        try {
            URL url = URL.lookUp(params);
            if (!("http".equalsIgnoreCase(url.getProtocol()) || "https".equalsIgnoreCase(url.getProtocol()) || Boolean.TRUE.equals(params.get("TESTING")))) {
                Loggers.MODULE.finest("Can't process non http or https GetCapabilities URL's");
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return !(params.containsKey(WFSDataStoreFactory.USERNAME.key) ? !params.containsKey(WFSDataStoreFactory.PASSWORD.key) : params.containsKey(WFSDataStoreFactory.PASSWORD.key));
    }

    public static URL createGetCapabilitiesRequest(URL host, Version version) {
        if (host == null) {
            throw new NullPointerException("null url");
        }
        if (version == null) {
            throw new NullPointerException("version");
        }
        HashMap<String, String> getCapsKvp = new HashMap<String, String>();
        getCapsKvp.put("SERVICE", "WFS");
        getCapsKvp.put("REQUEST", "GetCapabilities");
        getCapsKvp.put("VERSION", version.toString());
        return URIs.buildURL(host, getCapsKvp);
    }

    public static URL createGetCapabilitiesRequest(URL host) {
        Version defaultVersion;
        if (host == null) {
            throw new NullPointerException("url");
        }
        String queryString = host.getQuery();
        queryString = queryString == null || "".equals(queryString.trim()) ? "" : queryString.toUpperCase();
        Version requestVersion = defaultVersion = Versions.highest();
        if (queryString.length() > 0) {
            String version;
            String[] split;
            HashMap<String, String> params = new HashMap<String, String>();
            for (String kvp : split = queryString.split("&")) {
                int index = kvp.indexOf(61);
                String key = index > 0 ? kvp.substring(0, index) : kvp;
                String value = index > 0 ? kvp.substring(index + 1) : null;
                params.put(key, value);
            }
            String request = (String)params.get("REQUEST");
            if ("GETCAPABILITIES".equals(request) && (version = (String)params.get("VERSION")) != null && (requestVersion = Versions.find(version)) == null) {
                requestVersion = defaultVersion;
            }
        }
        return WFSDataStoreFactory.createGetCapabilitiesRequest(host, requestVersion);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    static {
        String key = "WFSDataStoreFactory:GET_CAPABILITIES_URL";
        String title = "WFS GetCapabilities URL";
        String description = "Represents a URL to the getCapabilities document or a server instance.";
        URL = new WFSFactoryParam<URL>(key, URL.class, title, description);
        WFSDataStoreFactory.parametersInfo[0] = URL;
        key = "WFSDataStoreFactory:PROTOCOL";
        title = "Protocol";
        description = "Sets a preference for the HTTP protocol to use when requesting WFS functionality. Set this value to Boolean.TRUE for POST, Boolean.FALSE for GET or NULL for AUTO";
        PROTOCOL = new WFSFactoryParam<Object>(key, (Class<Object>)Boolean.class, title, description, null);
        WFSDataStoreFactory.parametersInfo[1] = PROTOCOL;
        key = "WFSDataStoreFactory:USERNAME";
        title = "Username";
        description = "This allows the user to specify a username. This param should not be used without the PASSWORD param.";
        USERNAME = new WFSFactoryParam<String>(key, String.class, title, description);
        WFSDataStoreFactory.parametersInfo[2] = USERNAME;
        key = "WFSDataStoreFactory:PASSWORD";
        title = "Password";
        description = "This allows the user to specify a username. This param should not be used without the USERNAME param.";
        PASSWORD = new WFSFactoryParam<Object>(key, String.class, title, description, null, "isPassword", true);
        WFSDataStoreFactory.parametersInfo[3] = PASSWORD;
        key = "WFSDataStoreFactory:ENCODING";
        title = "Encoding";
        description = "This allows the user to specify the character encoding of the XML-Requests sent to the Server. Defaults to UTF-8";
        String defaultValue = "UTF-8";
        ArrayList<String> options = new ArrayList<String>(Charset.availableCharsets().keySet());
        Collections.sort(options);
        ENCODING = new WFSFactoryParam<String>(key, String.class, title, description, defaultValue, "options", options);
        WFSDataStoreFactory.parametersInfo[4] = ENCODING;
        key = "WFSDataStoreFactory:TIMEOUT";
        title = "Time-out";
        description = "This allows the user to specify a timeout in milliseconds. This param has a default value of 3000ms.";
        TIMEOUT = new WFSFactoryParam<Integer>(key, Integer.class, title, description, 3000);
        WFSDataStoreFactory.parametersInfo[5] = TIMEOUT;
        key = "WFSDataStoreFactory:BUFFER_SIZE";
        title = "Buffer Size";
        description = "This allows the user to specify a buffer size in features. This param has a default value of 10 features.";
        BUFFER_SIZE = new WFSFactoryParam<Integer>(key, Integer.class, title, description, 10);
        WFSDataStoreFactory.parametersInfo[6] = BUFFER_SIZE;
        key = "WFSDataStoreFactory:TRY_GZIP";
        title = "Try GZIP";
        description = "Indicates that datastore should use gzip to transfer data if the server supports it. Default is true";
        TRY_GZIP = new WFSFactoryParam<Boolean>(key, Boolean.class, title, description, Boolean.TRUE);
        WFSDataStoreFactory.parametersInfo[7] = TRY_GZIP;
        key = "WFSDataStoreFactory:LENIENT";
        title = "Lenient";
        description = "Indicates that datastore should do its best to create features from the provided data even if it does not accurately match the schema.  Errors will be logged but the parsing will continue if this is true.  Default is false";
        LENIENT = new WFSFactoryParam<Boolean>(key, Boolean.class, title, description, false);
        WFSDataStoreFactory.parametersInfo[8] = LENIENT;
        key = "WFSDataStoreFactory:MAXFEATURES";
        title = "Maximum features";
        description = "Positive integer used as a hard limit for the amount of Features to retrieve for each FeatureType. A value of zero or not providing this parameter means no limit.";
        MAXFEATURES = new WFSFactoryParam<Integer>(key, Integer.class, title, description, 0);
        WFSDataStoreFactory.parametersInfo[9] = MAXFEATURES;
        key = "WFSDataStoreFactory:FILTER_COMPLIANCE";
        title = "Filter compliance";
        description = "Level of compliance to WFS specification (0-low,1-medium,2-high)";
        List<Object> options2 = Arrays.asList(0, 1, 2);
        FILTER_COMPLIANCE = new WFSFactoryParam<Object>(key, Integer.class, title, description, null, "options", options2);
        WFSDataStoreFactory.parametersInfo[10] = FILTER_COMPLIANCE;
        key = "WFSDataStoreFactory:WFS_STRATEGY";
        title = "WFS Strategy";
        description = "Override wfs stragegy with either cubwerx, ionic, mapserver, geoserver, or nonstrict strategy.";
        options2 = Arrays.asList("auto", "strict", "nonstrict", "mapserver", "geoserver", "cubewerx", "ionic");
        WFS_STRATEGY = new WFSFactoryParam<String>(key, String.class, title, description, "auto", "options", options2);
        WFSDataStoreFactory.parametersInfo[11] = WFS_STRATEGY;
        key = "namespace";
        title = "Namespace";
        description = "Override the original WFS type name namespaces";
        NAMESPACE = new WFSFactoryParam<Object>(key, String.class, title, description, null, "advanced");
        WFSDataStoreFactory.parametersInfo[12] = NAMESPACE;
        key = "usedefaultsrs";
        title = "Use Default SRS";
        description = "Use always the declared DefaultSRS for requests and reproject locally if necessary";
        USEDEFAULTSRS = new WFSFactoryParam<Boolean>(key, Boolean.class, title, description, Boolean.valueOf(false), "advanced");
        WFSDataStoreFactory.parametersInfo[13] = USEDEFAULTSRS;
        key = "WFSDataStoreFactory:AXIS_ORDER";
        title = "Axis Order";
        description = "Indicates axis order used by the remote WFS server in result coordinates. It applies only to WFS 1.1.0 servers. Default is Compliant";
        options2 = Arrays.asList(AXIS_ORDER_COMPLIANT, AXIS_ORDER_EAST_NORTH, AXIS_ORDER_NORTH_EAST);
        AXIS_ORDER = new WFSFactoryParam<String>(key, String.class, title, description, AXIS_ORDER_COMPLIANT, "options", options2, "level", "advanced");
        WFSDataStoreFactory.parametersInfo[14] = AXIS_ORDER;
        key = "WFSDataStoreFactory:AXIS_ORDER_FILTER";
        title = "Axis Order Filter";
        description = "Indicates axis order used by the remote WFS server for filters. It applies only to WFS 1.1.0 servers. Default is the same as AXIS_ORDER";
        options2 = Arrays.asList(AXIS_ORDER_COMPLIANT, AXIS_ORDER_EAST_NORTH, AXIS_ORDER_NORTH_EAST);
        AXIS_ORDER_FILTER = new WFSFactoryParam<Object>(key, String.class, title, description, null, "options", options2, "level", "advanced");
        WFSDataStoreFactory.parametersInfo[15] = AXIS_ORDER_FILTER;
        key = "WFSDataStoreFactory:OUTPUTFORMAT";
        title = "Outputformat";
        description = "This allows the user to specify an outputFormat, different from the default one.";
        OUTPUTFORMAT = new WFSFactoryParam<Object>(key, String.class, title, description, null, "advanced");
        WFSDataStoreFactory.parametersInfo[16] = OUTPUTFORMAT;
    }

    public static class WFSFactoryParam<T>
    extends DataAccessFactory.Param {
        private T defaultValue;

        public WFSFactoryParam(String key, Class<T> type, String title, String description) {
            this(key, (Class<Object>)type, title, description, null);
        }

        public WFSFactoryParam(String key, Class<T> type, String title, String description, T defaultValue) {
            super(key, (Class<?>)type, (InternationalString)new SimpleInternationalString(title), (InternationalString)new SimpleInternationalString(description), false, -1, -1, (Object)defaultValue, (Map<String, ?>)null);
            this.defaultValue = defaultValue;
        }

        public WFSFactoryParam(String key, Class<T> type, String title, String description, T defaultValue, String level) {
            this(key, type, title, description, defaultValue, "level", level);
            this.defaultValue = defaultValue;
        }

        public WFSFactoryParam(String key, Class<T> type, String title, String description, T defaultValue, Object ... metadata) {
            super(key, (Class<?>)type, (InternationalString)new SimpleInternationalString(title), (InternationalString)new SimpleInternationalString(description), false, -1, -1, (Object)defaultValue, (Map<String, ?>)new KVP(metadata));
            this.defaultValue = defaultValue;
        }

        public T lookUp(Map params) throws IOException {
            Object parameter = super.lookUp(params);
            return (T)(parameter == null ? this.defaultValue : parameter);
        }
    }
}

