/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import org.geotools.data.Transaction;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentState;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSLocalTransactionState;
import org.geotools.data.wfs.WFSRemoteTransactionState;

public class WFSContentState
extends ContentState {
    public WFSContentState(ContentEntry entry) {
        super(entry);
        this.transactionState = new WFSLocalTransactionState(this);
    }

    WFSContentState(WFSContentState wfsContentState) {
        super((ContentState)wfsContentState);
        this.transactionState = new WFSLocalTransactionState(this);
    }

    public WFSContentState copy() {
        return new WFSContentState(this);
    }

    WFSLocalTransactionState getLocalTransactionState() {
        return (WFSLocalTransactionState)this.transactionState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTransaction(Transaction tx) {
        super.setTransaction(tx);
        if (tx == Transaction.AUTO_COMMIT) return;
        Class<WFSRemoteTransactionState> clazz = WFSRemoteTransactionState.class;
        synchronized (WFSRemoteTransactionState.class) {
            WFSDataStore dataStore = (WFSDataStore)this.entry.getDataStore();
            WFSRemoteTransactionState remoteStateKeeper = (WFSRemoteTransactionState)tx.getState((Object)dataStore);
            if (remoteStateKeeper == null) {
                remoteStateKeeper = new WFSRemoteTransactionState(dataStore);
                tx.putState((Object)dataStore, remoteStateKeeper);
            }
            WFSLocalTransactionState localTransactionState = this.getLocalTransactionState();
            remoteStateKeeper.watch(localTransactionState.getState());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

