/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.util.logging.Logging;

public class InterpolationProperties {
    private static final Logger LOGGER = Logging.getLogger((String)InterpolationProperties.class.getPackage().getName());
    private static final Pattern PROPERTY_INTERPOLATION_PATTERN = Pattern.compile("\\$\\{(.+?)\\}");
    protected Properties theProperties;

    public InterpolationProperties(Properties theProperties) {
        this.theProperties = theProperties;
    }

    public InterpolationProperties(String identifier) {
        this(InterpolationProperties.loadProperties(identifier));
    }

    public InterpolationProperties() {
        this(new Properties());
    }

    public void setProperty(String propName, String value) {
        this.theProperties.setProperty(propName, value);
    }

    public String getProperty(String propName) {
        return this.theProperties.getProperty(propName);
    }

    public String interpolate(String input) {
        String result = input;
        Matcher matcher = PROPERTY_INTERPOLATION_PATTERN.matcher(result);
        while (matcher.find()) {
            String propertyName = matcher.group(1);
            String propertyValue = (String)this.theProperties.get(propertyName);
            if (propertyValue == null) {
                throw new RuntimeException("Interpolation failed for missing property " + propertyName);
            }
            result = result.replace(matcher.group(), propertyValue).trim();
            matcher.reset(result);
        }
        return result;
    }

    protected static Properties loadProperties(String identifier) {
        String propertiesName = identifier + ".properties";
        Properties properties = new Properties();
        String propertiesFileName = System.getProperty(propertiesName);
        if (propertiesFileName == null) {
            String propertiesResourceName = "/" + propertiesName;
            InputStream stream = InterpolationProperties.class.getResourceAsStream(propertiesResourceName);
            if (stream != null) {
                try {
                    LOGGER.info("Loading properties from classpath resource " + propertiesResourceName);
                    properties.load(new BufferedInputStream(stream));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error loading properties from classpath resource " + propertiesResourceName, e);
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (Exception e) {}
                }
            }
        } else {
            File propertiesFile = new File(propertiesFileName).getAbsoluteFile();
            try {
                propertiesFile = propertiesFile.getCanonicalFile();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "An error occurred while trying to construct the canonical path for properties file " + propertiesFile.toString(), e);
            }
            InputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(propertiesFile));
                LOGGER.info("Loading properties file " + propertiesFile.toString());
                properties.load(stream);
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading properties file " + propertiesFile.toString(), e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    public static String readAll(InputStream input) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        StringBuffer buffer = new StringBuffer();
        while (true) {
            String line;
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (line == null) break;
            buffer.append(line);
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

