/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.data.joining.JoiningQuery;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.jdbc.JDBCFeatureReader;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.PrimaryKeyFIDValidator;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class JoiningJDBCFeatureSource
extends JDBCFeatureSource {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.jdbc.JoiningJDBCFeatureSource");
    private static final String TEMP_FILTER_ALIAS = "temp_alias_used_for_filter";
    public static final String FOREIGN_ID = "FOREIGN_ID";
    public static final String PRIMARY_KEY = "PARENT_TABLE_PKEY";

    public JoiningJDBCFeatureSource(JDBCFeatureSource featureSource) throws IOException {
        super(featureSource);
    }

    public JoiningJDBCFeatureSource(JDBCFeatureStore featureStore) throws IOException {
        super(featureStore.delegate);
    }

    protected void encodeGeometryColumn(GeometryDescriptor gatt, String typeName, StringBuffer sql, Hints hints) throws SQLException {
        StringBuffer temp = new StringBuffer();
        this.getDataStore().encodeGeometryColumn(gatt, temp, hints);
        StringBuffer originalColumnName = new StringBuffer();
        this.getDataStore().dialect.encodeColumnName(gatt.getLocalName(), originalColumnName);
        StringBuffer replaceColumnName = new StringBuffer();
        this.encodeColumnName(gatt.getLocalName(), typeName, replaceColumnName, hints);
        sql.append(temp.toString().replaceAll(originalColumnName.toString(), replaceColumnName.toString()));
    }

    protected void sort(String typeName, String alias, SortBy[] sort, Set<String> orderByFields, StringBuffer sql) throws IOException, SQLException {
        for (int i = 0; i < sort.length; ++i) {
            if (SortBy.NATURAL_ORDER.equals(sort[i]) || SortBy.REVERSE_ORDER.equals(sort[i])) {
                throw new IOException("Cannot do natural order in joining queries");
            }
            StringBuffer mySql = new StringBuffer();
            if (alias != null) {
                this.encodeColumnName2(sort[i].getPropertyName().getPropertyName(), alias, mySql, null);
            } else {
                this.encodeColumnName(sort[i].getPropertyName().getPropertyName(), typeName, mySql, null);
            }
            if (mySql.toString().isEmpty() || !orderByFields.add(mySql.toString())) continue;
            if (orderByFields.size() > 1) {
                sql.append(", ");
            }
            sql.append(mySql);
            if (sort[i].getSortOrder() == SortOrder.DESCENDING) {
                sql.append(" DESC");
                continue;
            }
            sql.append(" ASC");
        }
        if (sort.length == 0) {
            PrimaryKey joinKey = null;
            SimpleFeatureType joinFeatureType = this.getDataStore().getSchema(typeName);
            try {
                joinKey = this.getDataStore().getPrimaryKey(joinFeatureType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (PrimaryKeyColumn col : joinKey.getColumns()) {
                StringBuffer mySql = new StringBuffer();
                if (alias != null) {
                    this.encodeColumnName2(col.getName(), alias, mySql, null);
                } else {
                    this.encodeColumnName(col.getName(), typeName, mySql, null);
                }
                if (mySql.toString().isEmpty() || !orderByFields.add(mySql.toString())) continue;
                if (orderByFields.size() > 1) {
                    sql.append(", ");
                }
                sql.append(mySql);
                sql.append(" ASC");
            }
        }
    }

    protected void addMultiValuedSort(String tableName, Set<String> orderByFields, JoiningQuery.QueryJoin join, StringBuffer sql) throws IOException, FilterToSQLException, SQLException {
        StringBuffer field2 = new StringBuffer();
        this.encodeColumnName(join.getForeignKeyName().toString(), join.getJoiningTypeName(), field2, null);
        StringBuffer field1 = new StringBuffer();
        this.encodeColumnName(join.getJoiningKeyName().toString(), tableName, field1, null);
        if (orderByFields.add(field1.toString()) && orderByFields.add(field2.toString())) {
            if (sql.length() > 0) {
                sql.append(", ");
            }
            sql.append(" CASE WHEN ");
            sql.append(field2);
            sql.append(" = ");
            sql.append(field1);
            sql.append(" THEN 0 ELSE 1 END ASC");
        }
    }

    protected void sort(JoiningQuery query, StringBuffer sql, String[] aliases, Set<String> pkColumnNames) throws IOException, SQLException, FilterToSQLException {
        int j;
        LinkedHashSet<String> orderByFields = new LinkedHashSet<String>();
        StringBuffer joinOrders = new StringBuffer();
        int n = j = query.getQueryJoins() == null ? -1 : query.getQueryJoins().size() - 1;
        while (j >= -1) {
            SortBy[] sort;
            JoiningQuery.QueryJoin join = j < 0 ? null : query.getQueryJoins().get(j);
            SortBy[] sortByArray = sort = j < 0 ? query.getSortBy() : join.getSortBy();
            if (sort != null) {
                if (j < 0) {
                    this.sort(query.getTypeName(), null, sort, orderByFields, joinOrders);
                    if (query.getQueryJoins() != null && query.getQueryJoins().size() > 0) {
                        this.addMultiValuedSort(query.getTypeName(), orderByFields, query.getQueryJoins().get(0), joinOrders);
                    }
                    if (joinOrders.length() > 0) {
                        sql.append(" ORDER BY ");
                        sql.append(joinOrders);
                    }
                    if (!pkColumnNames.isEmpty()) {
                        for (String pk : pkColumnNames) {
                            StringBuffer pkSql = new StringBuffer();
                            this.encodeColumnName(pk, query.getTypeName(), pkSql, null);
                            if (pkSql.toString().isEmpty() || !orderByFields.add(pkSql.toString())) continue;
                            sql.append(", ");
                            sql.append(pkSql);
                        }
                    }
                } else {
                    if (aliases != null && aliases[j] != null) {
                        this.sort(join.getJoiningTypeName(), aliases[j], sort, orderByFields, joinOrders);
                    } else {
                        this.sort(join.getJoiningTypeName(), null, sort, orderByFields, joinOrders);
                    }
                    if (query.getQueryJoins().size() > j + 1) {
                        this.addMultiValuedSort(join.getJoiningTypeName(), orderByFields, query.getQueryJoins().get(j + 1), joinOrders);
                    }
                }
            }
            --j;
        }
    }

    public void encodeColumnName(String colName, String typeName, StringBuffer sql, Hints hints) throws SQLException {
        this.getDataStore().encodeTableName(typeName, sql, hints);
        sql.append(".");
        this.getDataStore().dialect.encodeColumnName(colName, sql);
    }

    public void encodeColumnName2(String colName, String typeName, StringBuffer sql, Hints hints) throws SQLException {
        this.getDataStore().dialect.encodeTableName(typeName, sql);
        sql.append(".");
        this.getDataStore().dialect.encodeColumnName(colName, sql);
    }

    protected FilterToSQL createFilterToSQL(SimpleFeatureType ft) {
        if (this.getDataStore().getSQLDialect() instanceof PreparedStatementSQLDialect) {
            return this.getDataStore().createPreparedFilterToSQL(ft);
        }
        return this.getDataStore().createFilterToSQL(ft);
    }

    protected static String createAlias(String typeName, Set<String> tableNames) {
        String alias = typeName;
        if (typeName.length() > 20) {
            typeName = typeName.substring(0, 20);
        }
        int index = 0;
        while (tableNames.contains(alias)) {
            alias = typeName + "_" + ++index;
        }
        return alias;
    }

    /*
     * Unable to fully structure code
     */
    protected String selectSQL(SimpleFeatureType featureType, JoiningQuery query, AtomicReference<PreparedFilterToSQL> toSQLref) throws IOException, SQLException, FilterToSQLException {
        joinClause = new StringBuffer();
        tableNames = new HashSet<String>();
        curTypeName = lastTypeName = featureType.getTypeName();
        aliases = null;
        tableNames.add(lastTypeName);
        alias = null;
        if (query.getQueryJoins() != null) {
            aliases = new String[query.getQueryJoins().size()];
            for (i = 0; i < query.getQueryJoins().size(); ++i) {
                join = query.getQueryJoins().get(i);
                joinClause.append(" INNER JOIN ");
                toSQL1 = this.createFilterToSQL(this.getDataStore().getSchema(lastTypeName));
                toSQL2 = this.createFilterToSQL(this.getDataStore().getSchema(join.getJoiningTypeName()));
                if (tableNames.contains(join.getJoiningTypeName())) {
                    aliases[i] = alias = JoiningJDBCFeatureSource.createAlias(join.getJoiningTypeName(), tableNames);
                    this.getDataStore().encodeTableName(join.getJoiningTypeName(), joinClause, query.getHints());
                    joinClause.append(" ");
                    this.getDataStore().dialect.encodeTableName(alias, joinClause);
                    joinClause.append(" ON ( ");
                    toSQL2.setFieldEncoder((FilterToSQL.FieldEncoder)new JoiningFieldEncoder(alias));
                    joinClause.append(toSQL2.encodeToString(join.getForeignKeyName()));
                } else {
                    aliases[i] = null;
                    this.getDataStore().encodeTableName(join.getJoiningTypeName(), joinClause, query.getHints());
                    joinClause.append(" ON ( ");
                    toSQL2.setFieldEncoder((FilterToSQL.FieldEncoder)new JoiningFieldEncoder(join.getJoiningTypeName()));
                    joinClause.append(toSQL2.encodeToString(join.getForeignKeyName()));
                }
                joinClause.append(" = ");
                fromTypeName = curTypeName;
                toSQL1.setFieldEncoder((FilterToSQL.FieldEncoder)new JoiningFieldEncoder(fromTypeName));
                joinClause.append(toSQL1.encodeToString(join.getJoiningKeyName()));
                joinClause.append(") ");
                lastTypeName = join.getJoiningTypeName();
                curTypeName = aliases[i] == null ? lastTypeName : aliases[i];
                tableNames.add(curTypeName);
            }
        }
        sql = new StringBuffer();
        sql.append("SELECT ");
        key = null;
        try {
            key = this.getDataStore().getPrimaryKey(featureType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        pkColumnNames = new HashSet<String>();
        for (PrimaryKeyColumn col : key.getColumns()) {
            colName = col.getName();
            this.encodeColumnName(colName, featureType.getTypeName(), sql, query.getHints());
            sql.append(",");
            pkColumnNames.add(colName);
        }
        lastPkColumnNames = pkColumnNames;
        for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
            columnName = att.getLocalName();
            if (pkColumnNames.contains(columnName)) continue;
            if (att instanceof GeometryDescriptor) {
                this.encodeGeometryColumn((GeometryDescriptor)att, featureType.getTypeName(), sql, query.getHints());
                this.getDataStore().dialect.encodeColumnAlias(columnName, sql);
            } else {
                this.encodeColumnName(columnName, featureType.getTypeName(), sql, query.getHints());
            }
            sql.append(",");
        }
        if (query.getQueryJoins() != null && query.getQueryJoins().size() > 0) {
            for (i = 0; i < query.getQueryJoins().size(); ++i) {
                ids = query.getQueryJoins().get(i).getIds();
                for (j = 0; j < ids.size(); ++j) {
                    if (aliases[i] != null) {
                        this.getDataStore().dialect.encodeColumnName(aliases[i], query.getQueryJoins().get(i).getIds().get(j), sql);
                    } else {
                        this.encodeColumnName(query.getQueryJoins().get(i).getIds().get(j), query.getQueryJoins().get(i).getJoiningTypeName(), sql, query.getHints());
                    }
                    sql.append(" ").append("FOREIGN_ID_" + i + "_" + j).append(",");
                }
                if (!ids.isEmpty()) continue;
                joinKey = null;
                joinTypeName = query.getQueryJoins().get(i).getJoiningTypeName();
                joinFeatureType = this.getDataStore().getSchema(joinTypeName);
                try {
                    joinKey = this.getDataStore().getPrimaryKey(joinFeatureType);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (!joinKey.getColumns().isEmpty()) {
                    lastPkColumnNames.clear();
                }
                j = 0;
                for (PrimaryKeyColumn col : joinKey.getColumns()) {
                    if (aliases[i] != null) {
                        this.getDataStore().dialect.encodeColumnName(aliases[i], col.getName(), sql);
                    } else {
                        this.encodeColumnName(col.getName(), joinTypeName, sql, query.getHints());
                    }
                    query.getQueryJoins().get(i).addId(col.getName());
                    sql.append(" ").append("FOREIGN_ID_" + i + "_" + j).append(",");
                    ++j;
                    lastPkColumnNames.add(col.getName());
                }
            }
        }
        if (!query.hasIdColumn() && !pkColumnNames.isEmpty()) {
            pkIndex = 0;
            for (String pk : pkColumnNames) {
                this.encodeColumnName(pk, featureType.getTypeName(), sql, query.getHints());
                sql.append(" ").append("PARENT_TABLE_PKEY").append("_").append(pkIndex).append(",");
                ++pkIndex;
            }
        }
        sql.setLength(sql.length() - 1);
        sql.append(" FROM ");
        this.getDataStore().encodeTableName(featureType.getTypeName(), sql, query.getHints());
        toSQL = null;
        filter = query.getFilter();
        sql.append(joinClause);
        isRootFeature = query.getQueryJoins() == null || query.getQueryJoins().size() == 0;
        pagingApplied = false;
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            try {
                lastSortBy = null;
                if (!query.isSubset()) {
                    lastSortBy = query.getQueryJoins() == null || query.getQueryJoins().size() == 0 ? query.getSortBy() : query.getQueryJoins().get(query.getQueryJoins().size() - 1).getSortBy();
                }
                v0 = lastTableName = isRootFeature != false ? query.getTypeName() : query.getQueryJoins().get(query.getQueryJoins().size() - 1).getJoiningTypeName();
                lastTableAlias = isRootFeature != false ? query.getTypeName() : (aliases[query.getQueryJoins().size() - 1] == null ? lastTableName : aliases[query.getQueryJoins().size() - 1]);
                toSQL = this.createFilterToSQL(this.getDataStore().getSchema(lastTableName));
                ids = new ArrayList<String>();
                if (isRootFeature && query.isDenormalised()) {
                    pagingApplied = this.applyPaging(query, sql, pkColumnNames, featureType.getTypeName(), featureType.getTypeName(), tableNames, toSQL, filter, ids);
                }
                if (!isRootFeature) {
                    lastJoin = query.getQueryJoins().get(query.getQueryJoins().size() - 1);
                    pagingApplied = this.applyPaging(lastJoin, sql, pkColumnNames, lastTableName, lastTableAlias, tableNames, toSQL, filter, ids);
                }
                if (!(lastSortBy == null || lastSortBy.length <= 0 && lastPkColumnNames.isEmpty())) {
                    sortBySQL = new StringBuffer();
                    sortBySQL.append(" INNER JOIN ( SELECT DISTINCT ");
                    hasSortBy = false;
                    for (i = 0; i < lastSortBy.length; ++i) {
                        if (ids.contains(lastSortBy[i].getPropertyName().toString())) continue;
                        this.getDataStore().dialect.encodeColumnName(null, lastSortBy[i].getPropertyName().getPropertyName(), sortBySQL);
                        if (i < lastSortBy.length - 1) {
                            sortBySQL.append(",");
                        }
                        sortBySQL.append(" FROM ");
                        this.getDataStore().encodeTableName(lastTableName, sortBySQL, query.getHints());
                        sortBySQL.append(" ").append(toSQL.encodeToString(filter));
                        sortBySQL.append(" ) ");
                        this.getDataStore().dialect.encodeTableName("temp_alias_used_for_filter", sortBySQL);
                        sortBySQL.append(" ON ( ");
                        this.encodeColumnName2(lastSortBy[i].getPropertyName().getPropertyName(), lastTableAlias, sortBySQL, null);
                        sortBySQL.append(" = ");
                        this.encodeColumnName2(lastSortBy[i].getPropertyName().getPropertyName(), "temp_alias_used_for_filter", sortBySQL, null);
                        if (i < lastSortBy.length - 1) {
                            sortBySQL.append(" AND ");
                        }
                        hasSortBy = true;
                    }
                    if (lastSortBy.length == 0) {
                        i = 0;
                        for (String pk : lastPkColumnNames) {
                            if (ids.contains(pk)) continue;
                            this.getDataStore().dialect.encodeColumnName(null, pk, sortBySQL);
                            if (i < lastPkColumnNames.size() - 1) {
                                sortBySQL.append(",");
                            }
                            sortBySQL.append(" FROM ");
                            this.getDataStore().encodeTableName(lastTableName, sortBySQL, query.getHints());
                            sortBySQL.append(" ").append(toSQL.encodeToString(filter));
                            sortBySQL.append(" ) ");
                            this.getDataStore().dialect.encodeTableName("temp_alias_used_for_filter", sortBySQL);
                            sortBySQL.append(" ON ( ");
                            this.encodeColumnName2(pk, lastTableAlias, sortBySQL, null);
                            sortBySQL.append(" = ");
                            this.encodeColumnName2(pk, "temp_alias_used_for_filter", sortBySQL, null);
                            if (i < lastPkColumnNames.size() - 1) {
                                sortBySQL.append(" AND ");
                            }
                            ++i;
                            hasSortBy = true;
                        }
                    }
                    if (!hasSortBy) ** GOTO lbl221
                    sql.append(sortBySQL).append(" ) ");
                }
                if (pagingApplied) ** GOTO lbl221
                toSQL.setFieldEncoder((FilterToSQL.FieldEncoder)new JoiningFieldEncoder(curTypeName));
                sql.append(" ").append(toSQL.encodeToString(filter));
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException(e);
            }
        } else {
            if (isRootFeature && query.isDenormalised()) {
                pagingApplied = this.applyPaging(query, sql, pkColumnNames, featureType.getTypeName(), featureType.getTypeName(), tableNames, null, null, null);
            }
            if (!isRootFeature) {
                lastJoin = query.getQueryJoins().get(query.getQueryJoins().size() - 1);
                lastTableAlias = aliases[query.getQueryJoins().size() - 1] == null ? lastJoin.getJoiningTypeName() : aliases[query.getQueryJoins().size() - 1];
                pagingApplied = this.applyPaging(lastJoin, sql, pkColumnNames, lastJoin.getJoiningTypeName(), lastTableAlias, tableNames, null, null, null);
            }
        }
lbl221:
        // 7 sources

        this.sort(query, sql, aliases, pkColumnNames);
        if (!pagingApplied) {
            this.getDataStore().applyLimitOffset(sql, (Query)query);
        }
        if (toSQLref != null && toSQL instanceof PreparedFilterToSQL) {
            toSQLref.set((PreparedFilterToSQL)toSQL);
        }
        return sql.toString();
    }

    private boolean applyPaging(JoiningQuery query, StringBuffer sql, Set<String> pkColumnNames, String typeName, String alias, Set<String> tableNames, FilterToSQL filterToSQL, Filter filter, Collection<String> allIds) throws SQLException, FilterToSQLException, IOException {
        Collection<Object> ids = Collections.emptyList();
        if (this.getDataStore().dialect.isLimitOffsetSupported()) {
            int startIndex = query.getStartIndex() == null ? 0 : query.getStartIndex();
            int maxFeatures = query.getMaxFeatures();
            if (startIndex > 0 || maxFeatures < 1000000) {
                ids = !query.getIds().isEmpty() ? query.getIds() : pkColumnNames;
                for (String string : ids) {
                    sql.append(" INNER JOIN (");
                    StringBuffer topIds = new StringBuffer();
                    topIds.append("SELECT DISTINCT ");
                    StringBuffer idSQL = new StringBuffer();
                    this.encodeColumnName(string, typeName, idSQL, query.getHints());
                    topIds.append(idSQL);
                    SortBy[] sort = query.getSortBy();
                    LinkedHashSet<String> orderByFields = new LinkedHashSet<String>();
                    StringBuffer sortSQL = new StringBuffer();
                    if (sort != null) {
                        this.sort(typeName, null, sort, orderByFields, sortSQL);
                    }
                    if (!orderByFields.contains(idSQL.toString())) {
                        sortSQL.append(idSQL);
                    }
                    for (String orderBy : orderByFields) {
                        if (idSQL.toString().equals(orderBy)) continue;
                        topIds.append(", ").append(orderBy);
                    }
                    topIds.append(" FROM ");
                    this.getDataStore().encodeTableName(typeName, topIds, query.getHints());
                    if (filter != null) {
                        filterToSQL.setFieldEncoder((FilterToSQL.FieldEncoder)new JoiningFieldEncoder(typeName));
                        topIds.append(" ").append(filterToSQL.encodeToString(filter));
                    }
                    topIds.append(" ORDER BY ");
                    topIds.append(sortSQL);
                    this.getDataStore().dialect.applyLimitOffset(topIds, maxFeatures, startIndex);
                    sql.append(topIds);
                    sql.append(") ");
                    String newAlias = JoiningJDBCFeatureSource.createAlias(typeName, tableNames);
                    tableNames.add(newAlias);
                    this.getDataStore().dialect.encodeTableName(newAlias, sql);
                    sql.append(" ON (");
                    this.getDataStore().dialect.encodeColumnName(alias, string, sql);
                    sql.append(" = ");
                    this.getDataStore().dialect.encodeColumnName(newAlias, string, sql);
                    sql.append(" ) ");
                }
            }
        }
        if (!ids.isEmpty()) {
            if (allIds != null) {
                allIds.addAll(ids);
            }
            return true;
        }
        return false;
    }

    protected PreparedStatement selectSQLPS(SimpleFeatureType featureType, JoiningQuery query, Connection cx) throws SQLException, IOException, FilterToSQLException {
        AtomicReference<PreparedFilterToSQL> toSQLref = new AtomicReference<PreparedFilterToSQL>();
        String sql = this.selectSQL(featureType, query, toSQLref);
        LOGGER.fine(sql);
        PreparedStatement ps = cx.prepareStatement(sql, 1003, 1007);
        ps.setFetchSize(this.getDataStore().fetchSize);
        if (toSQLref.get() != null) {
            this.getDataStore().setPreparedFilterValues(ps, toSQLref.get(), 0, cx);
        }
        return ps;
    }

    Filter[] splitFilter(Filter original) {
        Filter[] split = new Filter[2];
        if (original != null) {
            PostPreProcessFilterSplittingVisitor splitter = new PostPreProcessFilterSplittingVisitor(this.getDataStore().getFilterCapabilities(), null, null);
            original.accept((FilterVisitor)splitter, null);
            split[0] = splitter.getFilterPre();
            split[1] = splitter.getFilterPost();
        }
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        visitor.setFIDValidator((SimplifyingFilterVisitor.FIDValidator)new PrimaryKeyFIDValidator((JDBCFeatureSource)this));
        split[0] = (Filter)split[0].accept((FilterVisitor)visitor, null);
        split[1] = (Filter)split[1].accept((FilterVisitor)visitor, null);
        return split;
    }

    protected SimpleFeatureType getFeatureType(SimpleFeatureType origType, JoiningQuery query) throws IOException {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.init(origType);
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        if (query.getQueryJoins() != null) {
            for (int i = 0; i < query.getQueryJoins().size(); ++i) {
                if (query.getQueryJoins().get(i).getIds().isEmpty()) {
                    PrimaryKey joinKey = null;
                    String joinTypeName = query.getQueryJoins().get(i).getJoiningTypeName();
                    SimpleFeatureType joinFeatureType = this.getDataStore().getSchema(joinTypeName);
                    try {
                        joinKey = this.getDataStore().getPrimaryKey(joinFeatureType);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    int j = 0;
                    for (PrimaryKeyColumn col : joinKey.getColumns()) {
                        query.getQueryJoins().get(i).addId(col.getName());
                        ab.setBinding(String.class);
                        builder.add(ab.buildDescriptor(new NameImpl(FOREIGN_ID) + "_" + i + "_" + j, ab.buildType()));
                        ++j;
                    }
                    continue;
                }
                for (int j = 0; j < query.getQueryJoins().get(i).getIds().size(); ++j) {
                    ab.setBinding(String.class);
                    builder.add(ab.buildDescriptor(new NameImpl(FOREIGN_ID) + "_" + i + "_" + 0, ab.buildType()));
                }
            }
        }
        if (!query.hasIdColumn()) {
            PrimaryKey key = null;
            try {
                key = this.getDataStore().getPrimaryKey(origType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (int j = 0; j < key.getColumns().size(); ++j) {
                ab.setBinding(String.class);
                builder.add(ab.buildDescriptor("PARENT_TABLE_PKEY_" + j, ab.buildType()));
            }
        }
        return builder.buildFeatureType();
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getJoiningReaderInternal(JoiningQuery query) throws IOException {
        JDBCFeatureReader reader;
        Filter[] split = this.splitFilter(query.getFilter());
        Filter preFilter = split[0];
        Filter postFilter = split[1];
        if (postFilter != null && postFilter != Filter.INCLUDE) {
            throw new IllegalArgumentException("Postfilters not allowed in Joining Queries");
        }
        JoiningQuery preQuery = new JoiningQuery(query);
        preQuery.setFilter(preFilter);
        SimpleFeatureType querySchema = query.getPropertyNames() == Query.ALL_NAMES ? this.getSchema() : SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.getSchema(), (String[])query.getPropertyNames());
        SimpleFeatureType fullSchema = query.hasIdColumn() && query.getQueryJoins() == null ? querySchema : this.getFeatureType(querySchema, query);
        Connection cx = this.getDataStore().getConnection(this.getState());
        try {
            SQLDialect dialect;
            if (this.getState().getTransaction() == Transaction.AUTO_COMMIT) {
                cx.setAutoCommit(false);
            }
            if ((dialect = this.getDataStore().getSQLDialect()) instanceof PreparedStatementSQLDialect) {
                PreparedStatement ps = this.selectSQLPS(querySchema, preQuery, cx);
                reader = new JDBCFeatureReader(ps, cx, (JDBCFeatureSource)this, fullSchema, query.getHints());
            } else {
                String sql = this.selectSQL(querySchema, preQuery, null);
                this.getDataStore().getLogger().fine(sql);
                reader = new JDBCFeatureReader(sql, cx, (JDBCFeatureSource)this, fullSchema, query.getHints());
            }
        }
        catch (Exception e) {
            this.getDataStore().closeSafe(cx);
            throw (IOException)new IOException().initCause(e);
        }
        return reader;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        if (query instanceof JoiningQuery) {
            return this.getJoiningReaderInternal((JoiningQuery)query);
        }
        return super.getReaderInternal(query);
    }

    protected Query resolvePropertyNames(Query query) {
        return query;
    }

    protected Query joinQuery(Query query) {
        if (this.query == null) {
            return query;
        }
        if (query instanceof JoiningQuery) {
            JoiningQuery jQuery = new JoiningQuery(super.joinQuery(query));
            for (String id : ((JoiningQuery)query).getIds()) {
                jQuery.addId(id);
            }
            jQuery.setQueryJoins(((JoiningQuery)query).getQueryJoins());
            return jQuery;
        }
        return super.joinQuery(query);
    }

    protected class JoiningFieldEncoder
    implements FilterToSQL.FieldEncoder {
        private String tableName;

        public JoiningFieldEncoder(String tableName) {
            this.tableName = tableName;
        }

        public String encode(String s) {
            StringBuffer buf = new StringBuffer();
            JoiningJDBCFeatureSource.this.getDataStore().dialect.encodeTableName(this.tableName, buf);
            buf.append(".");
            buf.append(s);
            return buf.toString();
        }
    }
}

