/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import java.util.List;
import org.geotools.data.complex.xml.XmlXpathFilterData;
import org.geotools.factory.Hints;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.util.XmlXpathUtilites;
import org.xml.sax.helpers.NamespaceSupport;

public class XmlXPathPropertyAccessorFactory
implements PropertyAccessorFactory {
    public static Hints.Key NAMESPACE_SUPPORT = new Hints.Key(NamespaceSupport.class);

    public PropertyAccessor createPropertyAccessor(Class type, String xpath, Class target, Hints hints) {
        if (XmlXpathFilterData.class.isAssignableFrom(type)) {
            return new XmlXPathPropertyAcessor();
        }
        return null;
    }

    static class XmlXPathPropertyAcessor
    implements PropertyAccessor {
        XmlXPathPropertyAcessor() {
        }

        public boolean canHandle(Object object, String xpath, Class target) {
            return xpath != null && !"".equals(xpath.trim());
        }

        public Object get(Object object, String xpath, Class target) {
            XmlXpathFilterData xmlResponse = (XmlXpathFilterData)object;
            String indexXpath = this.createIndexedXpath(xmlResponse, xpath);
            List<String> ls = XmlXpathUtilites.getXPathValues(xmlResponse.getNamespaces(), indexXpath, xmlResponse.getDoc());
            if (ls != null && !ls.isEmpty()) {
                return ls.get(0);
            }
            return null;
        }

        public void set(Object object, String xpath, Object value, Class target) throws IllegalAttributeException {
            throw new UnsupportedOperationException("Do not support updating.");
        }

        private String createIndexedXpath(XmlXpathFilterData xmlResponse, String xpathString) {
            String itemXpath = xmlResponse.getItemXpath();
            String unindexedXpath = XmlXpathUtilites.removeIndexes(itemXpath);
            int position = xpathString.indexOf(unindexedXpath);
            if (position != 0) {
                throw new RuntimeException("xpath passed in does not begin with itemXpath/n xpathString =" + xpathString + "/n itemXpath =" + itemXpath);
            }
            StringBuffer sb = new StringBuffer(itemXpath);
            int count = xmlResponse.getCount();
            if (count > -1) {
                sb.append("[" + xmlResponse.getCount() + "]");
            }
            sb.append(xpathString.substring(unindexedXpath.length()));
            return sb.toString();
        }
    }
}

