/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.util.Converters;
import org.geotools.util.SoftValueHashMap;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class VocabFunction
implements Function {
    private final List<Expression> parameters;
    private final Literal fallback;
    public static final FunctionName NAME = new FunctionNameImpl("Vocab", new String[]{"expr", "vocab"});
    static Map<String, Properties> cache = Collections.synchronizedMap(new SoftValueHashMap());

    public VocabFunction() {
        this(new ArrayList<Expression>(), null);
    }

    public VocabFunction(List<Expression> parameters, Literal fallback) {
        this.parameters = parameters;
        this.fallback = fallback;
    }

    public String getName() {
        return NAME.getName();
    }

    public FunctionName getFunctionName() {
        return NAME;
    }

    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, Object.class);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        Expression expr = this.parameters.get(0);
        Expression vocab = this.parameters.get(1);
        String key = (String)expr.evaluate(object, String.class);
        String urn = (String)vocab.evaluate(object, String.class);
        Properties lookup = VocabFunction.lookup(urn);
        if (lookup == null) {
            throw new RuntimeException("Unable to resolve lookup table " + urn);
        }
        return (T)Converters.convert((Object)lookup.get(key), context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Properties lookup(String urn) {
        if (cache.containsKey(urn)) {
            Properties properties = cache.get(urn);
            if (properties != null) return properties;
            throw new RuntimeException("Could not find file for lookup table " + urn);
        }
        Properties properties = new Properties();
        File file = new File(urn);
        if (file.exists()) {
            InputStream input = null;
            try {
                input = new BufferedInputStream(new FileInputStream(file));
                properties.load(input);
                return properties;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Could not find file for lookup table " + urn);
            }
            catch (IOException e) {
                throw new RuntimeException("Difficulty parsing lookup table " + urn);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        cache.put(urn, null);
        return null;
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }
}

