/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultVerticalCRS;
import org.geotools.referencing.cs.DefaultVerticalCS;
import org.geotools.referencing.datum.DefaultVerticalDatum;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.parameter.Parameter;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.VerticalDatum;

public class ToLineStringFunction
implements Function {
    private final List<Expression> parameters;
    private final Literal fallback;
    private static final String USAGE = "Usage: toLineString(srsName, point 1, point 2)";
    public static final FunctionName NAME = new FunctionNameImpl("toLineString", FunctionNameImpl.parameter((String)"return", LineString.class), new Parameter[]{FunctionNameImpl.parameter((String)"parameter", String.class, (int)1, (int)1), FunctionNameImpl.parameter((String)"parameter", Double.class, (int)2, (int)3)});

    public ToLineStringFunction() {
        this(new ArrayList<Expression>(), null);
    }

    public ToLineStringFunction(List<Expression> parameters, Literal fallback) {
        this.parameters = parameters;
        this.fallback = fallback;
    }

    public String getName() {
        return NAME.getName();
    }

    public FunctionName getFunctionName() {
        return NAME;
    }

    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, LineString.class);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        if (this.parameters.size() != 3 || this.parameters.get(0) == null || this.parameters.get(1) == null || this.parameters.get(2) == null) {
            throw new IllegalArgumentException("Invalid parameters for toLineString function: " + this.parameters.toString() + ". " + USAGE);
        }
        Object srs = this.parameters.get(0).evaluate(object, String.class);
        String srsName = String.valueOf(srs);
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.decode((String)srsName);
        }
        catch (NoSuchAuthorityCodeException e) {
            crs = new DefaultVerticalCRS(srsName, (VerticalDatum)DefaultVerticalDatum.GEOIDAL, (VerticalCS)DefaultVerticalCS.DEPTH);
        }
        catch (FactoryException e) {
            crs = new DefaultVerticalCRS(srsName, (VerticalDatum)DefaultVerticalDatum.GEOIDAL, (VerticalCS)DefaultVerticalCS.DEPTH);
        }
        if (crs == null) {
            crs = new DefaultVerticalCRS(srsName, (VerticalDatum)DefaultVerticalDatum.GEOIDAL, (VerticalCS)DefaultVerticalCS.DEPTH);
        }
        LineString linestring = null;
        Object pointOne = this.parameters.get(1).evaluate(object, String.class);
        Object pointTwo = this.parameters.get(2).evaluate(object, String.class);
        String stringOne = String.valueOf(pointOne);
        String stringTwo = String.valueOf(pointTwo);
        try {
            double dblOne = Double.parseDouble(stringOne);
            double dblTwo = Double.parseDouble(stringTwo);
            GeometryFactory geomFactory = new GeometryFactory();
            Coordinate[] points = new Coordinate[]{new Coordinate(dblOne, Double.NaN, Double.NaN), new Coordinate(dblTwo, Double.NaN, Double.NaN)};
            linestring = geomFactory.createLineString(points);
            linestring.setUserData((Object)crs);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Error converting the parameters for toLineString function: " + this.parameters.toString() + ". " + USAGE, e);
        }
        return (T)linestring;
    }
}

