/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.ArrayList;
import java.util.Collection;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.ValidatingFeatureFactoryImpl;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.GmlObjectId;
import org.opengis.filter.identity.Identifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class AppSchemaFeatureFactoryImpl
extends ValidatingFeatureFactoryImpl {
    public Attribute createAttribute(Object value, AttributeDescriptor descriptor, String id) {
        return new AttributeImpl(value, descriptor, (Identifier)this.buildSafeGmlObjectId(id));
    }

    public GeometryAttribute createGeometryAttribute(Object value, GeometryDescriptor descriptor, String id, CoordinateReferenceSystem crs) {
        if (crs != null && !crs.equals(descriptor.getCoordinateReferenceSystem())) {
            GeometryType origType = descriptor.getType();
            GeometryTypeImpl geomType = new GeometryTypeImpl(origType.getName(), origType.getBinding(), crs, origType.isIdentified(), origType.isAbstract(), origType.getRestrictions(), origType.getSuper(), origType.getDescription());
            geomType.getUserData().putAll(origType.getUserData());
            descriptor = new GeometryDescriptorImpl((GeometryType)geomType, descriptor.getName(), descriptor.getMinOccurs(), descriptor.getMaxOccurs(), descriptor.isNillable(), descriptor.getDefaultValue());
            descriptor.getUserData().putAll(descriptor.getUserData());
        }
        return new GeometryAttributeImpl(value, descriptor, (Identifier)this.buildSafeGmlObjectId(id));
    }

    public ComplexAttribute createComplexAttribute(Collection value, AttributeDescriptor descriptor, String id) {
        return new ComplexAttributeImpl(this.buildCollectionIfNull(value), descriptor, (Identifier)this.buildSafeGmlObjectId(id));
    }

    public ComplexAttribute createComplexAttribute(Collection value, ComplexType type, String id) {
        return new ComplexAttributeImpl(this.buildCollectionIfNull(value), type, (Identifier)this.buildSafeGmlObjectId(id));
    }

    public Feature createFeature(Collection value, AttributeDescriptor descriptor, String id) {
        return new FeatureImpl(this.buildCollectionIfNull(value), descriptor, this.buildSafeFeatureId(id));
    }

    public Feature createFeature(Collection value, FeatureType type, String id) {
        return new FeatureImpl(this.buildCollectionIfNull(value), type, this.buildSafeFeatureId(id));
    }

    private GmlObjectId buildSafeGmlObjectId(String id) {
        if (id == null) {
            return null;
        }
        return this.ff.gmlObjectId(id);
    }

    private FeatureId buildSafeFeatureId(String id) {
        if (id == null) {
            return null;
        }
        return this.ff.featureId(id);
    }

    private Collection<Property> buildCollectionIfNull(Collection<Property> value) {
        if (value == null) {
            return new ArrayList<Property>();
        }
        return value;
    }
}

