/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.data.complex.ComplexFeatureConstants;
import org.geotools.data.complex.config.NonFeatureTypeProxy;
import org.geotools.data.complex.filter.XPathUtil;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AppSchemaAttributeBuilder;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.Types;
import org.geotools.feature.ValidatingFeatureFactoryImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.ComplexFeatureTypeFactoryImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.feature.type.UniqueNameFeatureTypeFactoryImpl;
import org.geotools.gml3.GML;
import org.geotools.util.logging.Logging;
import org.geotools.xs.XSSchema;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.PropertyType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.Attributes;

public class XPath
extends XPathUtil {
    private static final Logger LOGGER = Logging.getLogger((String)XPath.class.getPackage().getName());
    private FilterFactory FF;
    private FeatureFactory featureFactory;
    private CoordinateReferenceSystem crs;
    private FeatureTypeFactory descriptorFactory;

    public XPath() {
        this.FF = CommonFactoryFinder.getFilterFactory(null);
        this.featureFactory = new ValidatingFeatureFactoryImpl();
        this.descriptorFactory = new UniqueNameFeatureTypeFactoryImpl();
    }

    public XPath(FilterFactory ff, FeatureFactory featureFactory) {
        this.setFilterFactory(ff);
        this.setFeatureFactory(featureFactory);
    }

    public void setFilterFactory(FilterFactory ff) {
        this.FF = ff;
    }

    public void setCRS(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public void setFeatureFactory(FeatureFactory featureFactory) {
        this.featureFactory = featureFactory;
    }

    public Attribute set(Attribute att, XPathUtil.StepList xpath, Object value, String id, AttributeType targetNodeType, boolean isXlinkRef, Expression sourceExpression) {
        return this.set(att, xpath, value, id, targetNodeType, isXlinkRef, null, sourceExpression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Attribute set(Attribute att, XPathUtil.StepList xpath, Object value, String id, AttributeType targetNodeType, boolean isXlinkRef, AttributeDescriptor targetDescriptor, Expression sourceExpression) {
        XPathUtil.Step rootStep;
        QName stepName;
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.entering("XPath", "set", new Object[]{att, xpath, value, id, targetNodeType});
        }
        XPathUtil.StepList steps = new XPathUtil.StepList(xpath);
        Attribute parent = att;
        Name rootName = null;
        AttributeDescriptor parentDescriptor = parent.getDescriptor();
        if (parentDescriptor != null && Types.equals((Name)(rootName = parentDescriptor.getName()), (QName)(stepName = (rootStep = (XPathUtil.Step)steps.get(0)).getName()))) {
            if (steps.size() > 1) {
                steps.remove(0);
            } else {
                if (Types.isSimpleContentType((PropertyType)parent.getType())) {
                    return this.setSimpleContentValue(parent, value);
                }
                if (Types.isGeometryType(parent.getType())) {
                    ComplexFeatureTypeFactoryImpl typeFactory = new ComplexFeatureTypeFactoryImpl();
                    GeometryType geomType = parent.getType() instanceof GeometryType ? (GeometryType)parent.getType() : (GeometryType)((NonFeatureTypeProxy)parent.getType()).getSubject();
                    GeometryDescriptor geomDescriptor = typeFactory.createGeometryDescriptor(geomType, rootName, parentDescriptor.getMinOccurs(), parentDescriptor.getMaxOccurs(), parentDescriptor.isNillable(), parentDescriptor.getDefaultValue());
                    GeometryAttributeImpl geom = new GeometryAttributeImpl(value, geomDescriptor, null);
                    ArrayList<GeometryAttributeImpl> geomAtts = new ArrayList<GeometryAttributeImpl>();
                    geomAtts.add(geom);
                    parent.setValue(geomAtts);
                    return geom;
                }
            }
        }
        Iterator stepsIterator = steps.iterator();
        while (stepsIterator.hasNext()) {
            XPathUtil.Step currStep = (XPathUtil.Step)stepsIterator.next();
            AttributeDescriptor currStepDescriptor = null;
            boolean isLastStep = !stepsIterator.hasNext();
            QName stepName2 = currStep.getName();
            Name attributeName = Types.toName((QName)stepName2);
            AttributeType _parentType = parent.getType();
            if (_parentType.getName().equals((Object)XSSchema.ANYTYPE_TYPE.getName()) && targetDescriptor != null) {
                currStepDescriptor = targetDescriptor;
            } else {
                ComplexType parentType = (ComplexType)_parentType;
                if (!isLastStep || targetNodeType == null) {
                    String prefixedStepName;
                    PropertyName name;
                    Attribute child;
                    currStepDescriptor = null == attributeName.getNamespaceURI() ? (AttributeDescriptor)Types.findDescriptor((ComplexType)parentType, (String)attributeName.getLocalPart()) : (AttributeDescriptor)Types.findDescriptor((ComplexType)parentType, (Name)attributeName);
                    if (currStepDescriptor == null && (child = (Attribute)(name = this.FF.property(prefixedStepName = currStep.toString())).evaluate((Object)parent)) != null) {
                        currStepDescriptor = child.getDescriptor();
                    }
                } else {
                    AttributeDescriptor actualDescriptor = null == attributeName.getNamespaceURI() ? (AttributeDescriptor)Types.findDescriptor((ComplexType)parentType, (String)attributeName.getLocalPart()) : (AttributeDescriptor)Types.findDescriptor((ComplexType)parentType, (Name)attributeName);
                    if (actualDescriptor != null) {
                        int minOccurs = actualDescriptor.getMinOccurs();
                        int maxOccurs = actualDescriptor.getMaxOccurs();
                        boolean nillable = actualDescriptor.isNillable();
                        if (actualDescriptor instanceof GeometryDescriptor) {
                            if (!Geometry.class.isAssignableFrom(targetNodeType.getBinding())) throw new IllegalArgumentException("Can't set targetNodeType: " + targetNodeType.toString() + " for attribute mapping: " + attributeName + " as it is not a Geometry type!");
                            if (!(targetNodeType instanceof GeometryType)) {
                                targetNodeType = new GeometryTypeImpl(targetNodeType.getName(), targetNodeType.getBinding(), this.crs != null ? this.crs : ((GeometryDescriptor)actualDescriptor).getCoordinateReferenceSystem(), targetNodeType.isIdentified(), targetNodeType.isAbstract(), targetNodeType.getRestrictions(), targetNodeType.getSuper(), targetNodeType.getDescription());
                            }
                            currStepDescriptor = this.descriptorFactory.createGeometryDescriptor((GeometryType)targetNodeType, attributeName, minOccurs, maxOccurs, nillable, null);
                        } else {
                            currStepDescriptor = this.descriptorFactory.createAttributeDescriptor(targetNodeType, attributeName, minOccurs, maxOccurs, nillable, null);
                        }
                    }
                }
                if (currStepDescriptor == null) {
                    StringBuffer parentAtts = new StringBuffer();
                    Collection properties = parentType.getDescriptors();
                    Iterator it = properties.iterator();
                    while (it.hasNext()) {
                        PropertyDescriptor desc = (PropertyDescriptor)it.next();
                        Name name = desc.getName();
                        parentAtts.append(name.getNamespaceURI());
                        parentAtts.append("#");
                        parentAtts.append(name.getLocalPart());
                        if (!it.hasNext()) continue;
                        parentAtts.append(", ");
                    }
                    throw new IllegalArgumentException(currStep + " is not a valid location path for type " + parentType.getName() + ". " + currStep + " ns: " + currStep.getName().getNamespaceURI() + ", " + parentType.getName().getLocalPart() + " properties: " + parentAtts);
                }
            }
            if (isLastStep) {
                if (currStepDescriptor != null) return this.setLeafAttribute(currStepDescriptor, currStep, id, value, parent, targetNodeType, isXlinkRef);
                throw new IllegalArgumentException(currStep + " is not a valid location path for type " + _parentType.getName());
            }
            int index = currStep.isIndexed() ? currStep.getIndex() : -1;
            parent = this.setValue(currStepDescriptor, null, new ArrayList(), index, parent, null, isXlinkRef);
        }
        throw new IllegalStateException();
    }

    private Attribute setSimpleContentValue(Attribute attribute, Object value) {
        Property simpleContent = null;
        if (attribute instanceof ComplexAttribute) {
            simpleContent = ((ComplexAttribute)attribute).getProperty(ComplexFeatureConstants.SIMPLE_CONTENT);
        }
        if (simpleContent == null) {
            ArrayList<Property> contents = new ArrayList<Property>();
            simpleContent = this.buildSimpleContent(attribute.getType(), value);
            contents.add(simpleContent);
            ArrayList<ComplexAttributeImpl> nestedAttContents = new ArrayList<ComplexAttributeImpl>();
            ComplexAttributeImpl nestedAtt = new ComplexAttributeImpl(contents, attribute.getDescriptor(), attribute.getIdentifier());
            nestedAttContents.add(nestedAtt);
            attribute.setValue(nestedAttContents);
            return nestedAtt;
        }
        AttributeType simpleContentType = XPath.getSimpleContentType((AttributeType)simpleContent.getType());
        Object convertedValue = this.FF.literal(value).evaluate(value, simpleContentType.getBinding());
        simpleContent.setValue(convertedValue);
        return attribute;
    }

    private Attribute setLeafAttribute(AttributeDescriptor currStepDescriptor, XPathUtil.Step currStep, String id, Object value, Attribute parent, AttributeType targetNodeType, boolean isXlinkRef) {
        int index = currStep.isIndexed() ? currStep.getIndex() : -1;
        Attribute attribute = this.setValue(currStepDescriptor, id, value, index, parent, targetNodeType, isXlinkRef);
        return attribute;
    }

    private Attribute setValue(AttributeDescriptor descriptor, String id, Object value, int index, Attribute parent, AttributeType targetNodeType, boolean isXlinkRef) {
        Object convertedValue = null;
        Map simpleContentProperties = null;
        if (this.isFeatureChainedSimpleContent(descriptor, value)) {
            List<Property> nestedPropList = this.getSimpleContentList(value);
            if (!nestedPropList.isEmpty()) {
                Property nestedProp = nestedPropList.iterator().next();
                convertedValue = Types.isGeometryType(descriptor.getType()) || nestedProp.getName().equals((Object)descriptor.getName()) ? nestedProp.getValue() : nestedPropList;
                simpleContentProperties = nestedProp.getUserData();
            }
        } else {
            convertedValue = this.convertValue(descriptor, value);
        }
        Attribute leafAttribute = null;
        Name attributeName = descriptor.getName();
        if (!isXlinkRef && parent instanceof ComplexAttribute) {
            Collection currStepValue = ((ComplexAttribute)parent).getProperties(attributeName);
            if (currStepValue instanceof Collection) {
                ArrayList values = new ArrayList(currStepValue);
                if (!values.isEmpty()) {
                    if (this.isEmpty(convertedValue)) {
                        if (index > -1) {
                            int valueIndex = 1;
                            for (Attribute stepValue : values) {
                                Object mappedIndex = stepValue.getUserData().get("MAPPED_ATTRIBUTE_INDEX");
                                if (mappedIndex == null) {
                                    mappedIndex = valueIndex;
                                }
                                if (index == Integer.parseInt(String.valueOf(mappedIndex))) {
                                    leafAttribute = stepValue;
                                }
                                ++valueIndex;
                            }
                        } else {
                            leafAttribute = (Attribute)values.get(values.size() - 1);
                        }
                    } else {
                        for (Attribute stepValue : values) {
                            boolean sameIndex = true;
                            if (index > -1 && stepValue.getUserData().containsKey("MAPPED_ATTRIBUTE_INDEX")) {
                                boolean bl = sameIndex = index == Integer.parseInt(String.valueOf(stepValue.getUserData().get("MAPPED_ATTRIBUTE_INDEX")));
                            }
                            if (!sameIndex || !stepValue.getValue().equals(convertedValue)) continue;
                            leafAttribute = stepValue;
                        }
                    }
                }
            } else if (currStepValue instanceof Attribute) {
                leafAttribute = (Attribute)currStepValue;
            } else if (currStepValue != null) {
                throw new IllegalStateException("Unknown addressed object. Xpath:" + attributeName + ", addressed: " + currStepValue.getClass().getName() + " [" + currStepValue.toString() + "]");
            }
        }
        if (leafAttribute == null) {
            AppSchemaAttributeBuilder builder = new AppSchemaAttributeBuilder(this.featureFactory);
            if (this.crs != null) {
                builder.setCRS(this.crs);
            }
            builder.setDescriptor(parent.getDescriptor());
            builder.setType(parent.getType());
            leafAttribute = targetNodeType != null ? (parent.getType().getName().equals((Object)XSSchema.ANYTYPE_TYPE.getName()) ? builder.addAnyTypeValue(convertedValue, targetNodeType, descriptor, id) : builder.add(id, convertedValue, attributeName, targetNodeType)) : (descriptor.getType().getName().equals((Object)XSSchema.ANYTYPE_TYPE.getName()) && (value == null || value instanceof Collection && ((Collection)value).isEmpty()) ? builder.addComplexAnyTypeAttribute(convertedValue, descriptor, id) : builder.add(id, convertedValue, attributeName));
            if (index > -1) {
                leafAttribute.getUserData().put("MAPPED_ATTRIBUTE_INDEX", index);
            }
            ArrayList<Attribute> newValue = new ArrayList<Attribute>();
            newValue.addAll((Collection)parent.getValue());
            newValue.add(leafAttribute);
            parent.setValue(newValue);
        }
        if (!this.isEmpty(convertedValue)) {
            leafAttribute.setValue(convertedValue);
        }
        if (simpleContentProperties != null) {
            this.mergeClientProperties(leafAttribute, simpleContentProperties);
        }
        return leafAttribute;
    }

    private List<Property> getSimpleContentList(Object value) {
        if (value == null || !(value instanceof Collection)) {
            return null;
        }
        Collection list = (Collection)value;
        if (list.size() != 1) {
            throw new IllegalArgumentException("Expecting only 1 feature in the list!");
        }
        Object f = list.iterator().next();
        if (!(f instanceof Feature)) {
            throw new IllegalArgumentException("Expecting a feature!");
        }
        Feature feature = (Feature)f;
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Property prop : feature.getProperties()) {
            if (ComplexFeatureConstants.FEATURE_CHAINING_LINK_NAME.equals((Object)prop.getName())) continue;
            properties.add(prop);
        }
        return properties;
    }

    private void mergeClientProperties(Attribute leafAttribute, Map<Object, Object> simpleContentProperties) {
        Map origData = leafAttribute.getUserData();
        for (Object key : simpleContentProperties.keySet()) {
            if (key.equals(Attributes.class)) {
                Map inputMap = (Map)simpleContentProperties.get(key);
                if (origData.containsKey(Attributes.class)) {
                    Map existingMap = (Map)origData.get(key);
                    for (Object mapKey : inputMap.keySet()) {
                        if (existingMap.containsKey(mapKey)) continue;
                        existingMap.put(mapKey, inputMap.get(mapKey));
                    }
                    continue;
                }
                origData.put(Attributes.class, inputMap);
                continue;
            }
            if (origData.containsKey(key)) continue;
            origData.put(key, simpleContentProperties.get(key));
        }
    }

    private boolean isFeatureChainedSimpleContent(AttributeDescriptor descriptor, Object value) {
        Name featureName;
        Object f;
        Collection list;
        boolean isFeatureChainedSimpleContent = false;
        if (value != null && value instanceof Collection && !(list = (Collection)value).isEmpty() && (f = list.iterator().next()) instanceof Feature && ((Feature)f).getProperty(featureName = ((Feature)f).getDescriptor().getName()) != null) {
            isFeatureChainedSimpleContent = true;
        }
        return isFeatureChainedSimpleContent;
    }

    private boolean isEmpty(Object convertedValue) {
        if (convertedValue == null) {
            return true;
        }
        return convertedValue instanceof Collection && ((Collection)convertedValue).isEmpty();
    }

    private Object convertValue(AttributeDescriptor descriptor, Object value) {
        AttributeType type = descriptor.getType();
        Class binding = type.getBinding();
        if (type instanceof ComplexType && binding == Collection.class) {
            if (!(value instanceof Collection)) {
                if (Types.isSimpleContentType((PropertyType)type)) {
                    ArrayList<Attribute> list = new ArrayList<Attribute>();
                    if (value == null && !descriptor.isNillable()) {
                        return list;
                    }
                    list.add(this.buildSimpleContent(type, value));
                    return list;
                }
            } else {
                return value;
            }
        }
        if (binding == String.class && value instanceof Collection) {
            String collectionString = value.toString();
            return collectionString.substring(1, collectionString.length() - 1);
        }
        return this.FF.literal(value).evaluate(value, binding);
    }

    static AttributeType getSimpleContentType(AttributeType type) {
        Class binding = type.getBinding();
        if (binding == Collection.class) {
            return XPath.getSimpleContentType(type.getSuper());
        }
        return type;
    }

    Attribute buildSimpleContent(AttributeType type, Object value) {
        AttributeType simpleContentType = XPath.getSimpleContentType(type);
        Object convertedValue = this.FF.literal(value).evaluate(value, XPath.getSimpleContentType(type).getBinding());
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl(simpleContentType, ComplexFeatureConstants.SIMPLE_CONTENT, 1, 1, true, (Object)null);
        return new AttributeImpl(convertedValue, (AttributeDescriptor)descriptor, null);
    }

    public boolean isComplexType(XPathUtil.StepList attrXPath, AttributeDescriptor featureType) {
        PropertyName attExp = this.FF.property(attrXPath.toString());
        Object type = attExp.evaluate((Object)featureType);
        if (type == null) {
            type = attExp.evaluate((Object)featureType);
            throw new IllegalArgumentException("path not found: " + (Object)((Object)attrXPath));
        }
        AttributeDescriptor node = (AttributeDescriptor)type;
        return node.getType() instanceof ComplexType;
    }

    public static boolean isId(XPathUtil.Step step) {
        return step.isXmlAttribute() && step.getName().equals(GML.id);
    }
}

