/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import java.util.List;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.complex.filter.XPathUtil;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;

public class ComplexFilterSplitter
extends PostPreProcessFilterSplittingVisitor {
    private FeatureTypeMapping mappings;

    public ComplexFilterSplitter(FilterCapabilities fcs, FeatureTypeMapping mappings) {
        super(fcs, null, null);
        this.mappings = mappings;
    }

    public Object visit(Id filter, Object notUsed) {
        CapabilitiesExpressionVisitor visitor = new CapabilitiesExpressionVisitor();
        this.mappings.getFeatureIdExpression().accept((ExpressionVisitor)visitor, null);
        if (visitor.isCapable()) {
            super.visit(filter, notUsed);
        } else {
            this.postStack.push(filter);
        }
        return null;
    }

    public Object visit(PropertyName expression, Object notUsed) {
        XPathUtil.StepList exprSteps = XPath.steps(this.mappings.getTargetFeature(), expression.getPropertyName(), this.mappings.getNamespaces());
        if (exprSteps.containsPredicate()) {
            this.postStack.push(expression);
            return null;
        }
        List<Expression> matchingMappings = this.mappings.findMappingsFor(exprSteps, false);
        if (matchingMappings.isEmpty()) {
            this.postStack.push(expression);
            return null;
        }
        for (Expression expr : matchingMappings) {
            if (expr == null) {
                this.postStack.push(expression);
                return null;
            }
            CapabilitiesExpressionVisitor visitor = new CapabilitiesExpressionVisitor();
            expr.accept((ExpressionVisitor)visitor, null);
            if (visitor.isCapable()) continue;
            this.postStack.push(expression);
            return null;
        }
        return super.visit(expression, notUsed);
    }

    public class CapabilitiesExpressionVisitor
    implements ExpressionVisitor {
        protected boolean capable = true;

        public boolean isCapable() {
            return this.capable;
        }

        public Object visit(NilExpression expr, Object extraData) {
            return null;
        }

        public Object visit(Add expr, Object extraData) {
            this.visitMathExpression((BinaryExpression)expr);
            return null;
        }

        public Object visit(Subtract expr, Object extraData) {
            this.visitMathExpression((BinaryExpression)expr);
            return null;
        }

        public Object visit(Divide expr, Object extraData) {
            this.visitMathExpression((BinaryExpression)expr);
            return null;
        }

        public Object visit(Multiply expr, Object extraData) {
            this.visitMathExpression((BinaryExpression)expr);
            return null;
        }

        public Object visit(Function expr, Object extraData) {
            for (int i = 0; i < expr.getParameters().size(); ++i) {
                ((Expression)expr.getParameters().get(i)).accept((ExpressionVisitor)this, null);
            }
            this.capable = this.capable && ComplexFilterSplitter.this.fcs.supports(expr.getClass());
            return null;
        }

        public Object visit(Literal expr, Object extraData) {
            return null;
        }

        public Object visit(PropertyName expr, Object extraData) {
            return null;
        }

        private void visitMathExpression(BinaryExpression expression) {
            expression.getExpression1().accept((ExpressionVisitor)this, null);
            expression.getExpression2().accept((ExpressionVisitor)this, null);
            this.capable = this.capable && ComplexFilterSplitter.this.fcs.supports(expression.getClass());
        }
    }
}

