/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.data.complex.config.EmfComplexFeatureReader;
import org.geotools.gml3.v3_2.GML;
import org.geotools.gml3.v3_2.GMLConfiguration;
import org.geotools.xml.AppSchemaConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.SchemaIndex;
import org.geotools.xml.Schemas;

public class EmfAppSchemaReader
extends EmfComplexFeatureReader {
    private static final Map<QName, Class<? extends Configuration>> SUPPORTED_GML_KNOWN_TYPE_TO_CONFIGURATION_MAP = new LinkedHashMap<QName, Class<? extends Configuration>>(){
        {
            this.put(org.geotools.gml3.GML.AbstractFeatureType, org.geotools.gml3.GMLConfiguration.class);
            this.put(GML.AbstractFeatureType, GMLConfiguration.class);
        }
    };

    private EmfAppSchemaReader() {
    }

    public static EmfAppSchemaReader newInstance() {
        return new EmfAppSchemaReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration findGmlConfiguration(AppSchemaConfiguration configuration) {
        block9: {
            SchemaIndex index = null;
            index = Schemas.findSchemas((Configuration)configuration);
            for (QName name : SUPPORTED_GML_KNOWN_TYPE_TO_CONFIGURATION_MAP.keySet()) {
                XSDTypeDefinition type = index.getTypeDefinition(name);
                if (type == null) continue;
                try {
                    Configuration configuration2 = SUPPORTED_GML_KNOWN_TYPE_TO_CONFIGURATION_MAP.get(name).newInstance();
                    return configuration2;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            for (XSDSchema schema : index.getSchemas()) {
                String ns = schema.getTargetNamespace();
                if (ns == null || !ns.startsWith("http://www.opengis.net/gml")) continue;
                throw new RuntimeException("Unsupported GML version for schema at " + configuration.getSchemaLocation());
            }
            break block9;
            finally {
                if (index != null) {
                    index.destroy();
                }
            }
        }
        return null;
    }
}

