/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.data.complex.config.FeatureTypeRegistry;
import org.geotools.data.complex.config.FeatureTypeRegistryHelper;
import org.geotools.feature.Types;
import org.geotools.feature.type.ComplexFeatureTypeFactoryImpl;
import org.geotools.gml3.smil.SMIL20LANGSchema;
import org.geotools.gml3.smil.SMIL20Schema;
import org.geotools.gml3.v3_2.GML;
import org.geotools.gml3.v3_2.GMLConfiguration;
import org.geotools.gml3.v3_2.GMLSchema;
import org.geotools.gml3.v3_2.gco.GCOSchema;
import org.geotools.gml3.v3_2.gmd.GMDSchema;
import org.geotools.gml3.v3_2.gmx.GMXSchema;
import org.geotools.gml3.v3_2.gsr.GSRSchema;
import org.geotools.gml3.v3_2.gss.GSSSchema;
import org.geotools.gml3.v3_2.gts.GTSSchema;
import org.geotools.xml.Configuration;
import org.geotools.xml.Schemas;
import org.geotools.xs.XS;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;
import org.xml.sax.helpers.NamespaceSupport;

public class AppSchemaFeatureTypeRegistry
extends FeatureTypeRegistry {
    public AppSchemaFeatureTypeRegistry() {
        this(null);
    }

    public AppSchemaFeatureTypeRegistry(NamespaceSupport namespaces) {
        super((FeatureTypeFactory)new ComplexFeatureTypeFactoryImpl(), namespaces == null ? new GMLHandler(null) : new GMLHandler(namespaces.getURI("gml")));
    }

    @Override
    protected void onCreateFoundationTypes() {
        SMIL20Schema schema = new SMIL20Schema();
        this.importSchema((Schema)schema);
        schema = new SMIL20LANGSchema();
        this.importSchema((Schema)schema);
        schema = new org.geotools.gml3.GMLSchema();
        this.importSchema((Schema)schema);
        schema = new GMLSchema();
        this.importSchema((Schema)schema);
        schema = new GCOSchema();
        this.importSchema((Schema)schema);
        schema = new GMDSchema();
        this.importSchema((Schema)schema);
        schema = new GMXSchema();
        this.importSchema((Schema)schema);
        schema = new GSRSchema();
        this.importSchema((Schema)schema);
        schema = new GSSSchema();
        this.importSchema((Schema)schema);
        schema = new GTSSchema();
        this.importSchema((Schema)schema);
        this.addSchemas(Schemas.findSchemas((Configuration)new org.geotools.gml3.GMLConfiguration()));
        this.addSchemas(Schemas.findSchemas((Configuration)new GMLConfiguration()));
    }

    private static boolean isBasedOn(XSDTypeDefinition typeDefinition, String superNS) {
        XSDTypeDefinition baseType;
        while ((baseType = typeDefinition.getBaseType()) != null) {
            String targetNamespace = baseType.getTargetNamespace();
            String name = baseType.getName();
            if ("http://www.w3.org/2001/XMLSchema".equals(targetNamespace) && XS.ANYTYPE.getLocalPart().equals(name)) {
                return false;
            }
            if (superNS.equals(targetNamespace)) {
                return true;
            }
            typeDefinition = baseType;
        }
        return false;
    }

    private static boolean isDerivedFrom(XSDTypeDefinition typeDefinition, QName baseTypeName) {
        return AppSchemaFeatureTypeRegistry.isDerivedFrom(typeDefinition, Types.toTypeName((QName)baseTypeName));
    }

    private static boolean isDerivedFrom(XSDTypeDefinition typeDefinition, Name superTypeName) {
        XSDTypeDefinition baseType;
        String superNS = superTypeName.getNamespaceURI();
        String superName = superTypeName.getLocalPart();
        while ((baseType = typeDefinition.getBaseType()) != null) {
            String targetNamespace = baseType.getTargetNamespace();
            String name = baseType.getName();
            if ("http://www.w3.org/2001/XMLSchema".equals(targetNamespace) && XS.ANYTYPE.getLocalPart().equals(name)) {
                return false;
            }
            if (superNS.equals(targetNamespace) && superName.equals(name)) {
                return true;
            }
            typeDefinition = baseType;
        }
        return false;
    }

    private static class GMLHandler
    implements FeatureTypeRegistryHelper {
        String namespace;

        public GMLHandler(String uri) {
            this.namespace = uri != null ? uri : "";
        }

        public QName getAbstractFeatureType() {
            if (this.namespace.equals("http://www.opengis.net/gml/3.2")) {
                return GML.AbstractFeatureType;
            }
            return org.geotools.gml3.GML.AbstractFeatureType;
        }

        public QName getAbstractGeometryType() {
            if (this.namespace.equals("http://www.opengis.net/gml/3.2")) {
                return GML.AbstractGeometryType;
            }
            return org.geotools.gml3.GML.AbstractGeometryType;
        }

        public String getNameSpace() {
            if (this.namespace.equals("http://www.opengis.net/gml/3.2")) {
                return "http://www.opengis.net/gml/3.2";
            }
            return "http://www.opengis.net/gml";
        }

        public QName getId() {
            if (this.namespace.equals("http://www.opengis.net/gml/3.2")) {
                return GML.id;
            }
            return org.geotools.gml3.GML.id;
        }

        public void setEmptyNamespace(XSDTypeDefinition typeDefinition) {
            if (this.namespace.isEmpty()) {
                if (AppSchemaFeatureTypeRegistry.isBasedOn(typeDefinition, "http://www.opengis.net/gml/3.2")) {
                    this.namespace = "http://www.opengis.net/gml/3.2";
                } else if (AppSchemaFeatureTypeRegistry.isBasedOn(typeDefinition, "http://www.opengis.net/gml")) {
                    this.namespace = "http://www.opengis.net/gml";
                }
            }
        }

        @Override
        public boolean isFeatureType(XSDTypeDefinition typeDefinition) {
            this.setEmptyNamespace(typeDefinition);
            return AppSchemaFeatureTypeRegistry.isDerivedFrom(typeDefinition, this.getAbstractFeatureType());
        }

        @Override
        public boolean isGeometryType(XSDTypeDefinition typeDefinition) {
            this.setEmptyNamespace(typeDefinition);
            return AppSchemaFeatureTypeRegistry.isDerivedFrom(typeDefinition, this.getAbstractGeometryType());
        }

        @Override
        public boolean isIdentifiable(XSDComplexTypeDefinition typeDefinition) {
            EList attributeUses = typeDefinition.getAttributeUses();
            String idAttName = this.getId().getLocalPart();
            for (XSDAttributeUse use : attributeUses) {
                XSDAttributeUseCategory useCategory = use.getUse();
                XSDAttributeDeclaration idAtt = use.getAttributeDeclaration();
                String targetNamespace = idAtt.getTargetNamespace();
                String name = idAtt.getName();
                if (!this.getNameSpace().equals(targetNamespace) || !idAttName.equals(name) || !XSDAttributeUseCategory.REQUIRED_LITERAL.equals((Object)useCategory)) continue;
                return true;
            }
            return false;
        }
    }
}

