/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AttributeCreateOrderList;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.PathAttributeList;
import org.geotools.data.complex.filter.XPathUtil;
import org.geotools.data.complex.xml.XmlFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.LiteralExpressionImpl;
import org.opengis.feature.Attribute;
import org.opengis.feature.Feature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.PropertyName;
import org.xml.sax.helpers.NamespaceSupport;

public class XmlFeatureTypeMapping
extends FeatureTypeMapping {
    private static final String XPATH_SEPARATOR = "/";
    private static final String XPATH_PROPERTY_SEPARATOR = "/@";
    private static final String XPATH_LEFT_INDEX_BRACKET = "[";
    private static final String XPATH_RIGHT_INDEX_BRACKET = "]";
    private static final String AS_XPATH_FUNCTION = "asXpath";
    private Map<String, Expression> mapping = new HashMap<String, Expression>();
    private AttributeCreateOrderList attOrderedTypeList = null;
    private Map<String, AttributeMapping> indexAttributeList;
    AttributeMapping rootAttribute;
    private int index = 1;
    private FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    List<AttributeMapping> setterAttributes = new ArrayList<AttributeMapping>();
    PathAttributeList elements;
    protected String itemXpath;

    public XmlFeatureTypeMapping() {
        super(null, null, new LinkedList<AttributeMapping>(), new NamespaceSupport());
    }

    public XmlFeatureTypeMapping(FeatureSource source, AttributeDescriptor target, List<AttributeMapping> mappings, NamespaceSupport namespaces, String itemXpath) {
        super((FeatureSource<? extends FeatureType, ? extends Feature>)source, target, mappings, namespaces);
        this.itemXpath = itemXpath;
        this.elements = new PathAttributeList();
        ((XmlFeatureSource)source).setItemXpath(itemXpath);
        try {
            this.populateFeatureData();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error occured when trying to create attribute mappings", ex);
        }
    }

    public List<Expression> getExpressionsIgnoreIndex(XPathUtil.StepList targetPath) {
        ArrayList<Expression> mappings = new ArrayList<Expression>();
        String path = targetPath.toString();
        Set<String> c = this.mapping.keySet();
        for (String listPath : c) {
            String unindexedListPath = this.removeIndexFromPath(listPath);
            if (!path.equals(unindexedListPath)) continue;
            mappings.add(this.mapping.get(listPath));
        }
        if (mappings.isEmpty()) {
            for (AttributeMapping att : this.setterAttributes) {
                String listPath = att.getTargetXPath().toString();
                String unindexedListPath = this.removeIndexFromPath(listPath);
                if (!path.equals(unindexedListPath)) continue;
                mappings.add(att.getSourceExpression());
            }
        }
        return mappings;
    }

    private String removeIndexFromPath(String inputPath) {
        String tempPath = inputPath;
        while (tempPath.contains(XPATH_LEFT_INDEX_BRACKET)) {
            int leftIndex = tempPath.indexOf(XPATH_LEFT_INDEX_BRACKET);
            int rightIndex = tempPath.indexOf(XPATH_RIGHT_INDEX_BRACKET, leftIndex);
            String leftTempPath = tempPath.substring(0, leftIndex);
            String rightTempPath = tempPath.substring(rightIndex + 1);
            tempPath = leftTempPath + rightTempPath;
        }
        return tempPath;
    }

    @Override
    public List<AttributeMapping> getAttributeMappingsByExpression(Expression sourceExpression) {
        List<AttributeMapping> mappings = Collections.emptyList();
        for (AttributeMapping attMapping : this.attributeMappings) {
            if (!sourceExpression.equals(attMapping.getSourceExpression())) continue;
            if (mappings.size() == 0) {
                mappings = new ArrayList<AttributeMapping>(2);
            }
            mappings.add(attMapping);
        }
        return mappings;
    }

    public AttributeMapping getAttributeMappingByLabel(String label) {
        for (AttributeMapping attMapping : this.attributeMappings) {
            if (!label.equals(attMapping.getLabel())) continue;
            return attMapping;
        }
        return null;
    }

    public AttributeMapping getStringMapping(XPathUtil.StepList exactPath) {
        for (AttributeMapping attMapping : this.attributeMappings) {
            if (!exactPath.equals((Object)attMapping.getTargetXPath())) continue;
            return attMapping;
        }
        return null;
    }

    public void populateFeatureData() throws IOException {
        List<AttributeMapping> attMap = this.getAttributeMappings();
        if (this.attOrderedTypeList == null) {
            this.initialiseAttributeLists(attMap);
        }
        String xpath = this.rootAttribute.getInstanceXpath() == null ? this.itemXpath : this.itemXpath + XPATH_SEPARATOR + this.rootAttribute.getInstanceXpath();
        this.elements.put(this.rootAttribute.getLabel(), xpath, null);
        Expression idExpression = this.rootAttribute.getIdentifierExpression();
        if (!idExpression.equals(Expression.NIL)) {
            Object id = !(idExpression instanceof Function) && this.rootAttribute.getInstanceXpath() != null ? this.ff.property(this.rootAttribute.getInstanceXpath() + XPATH_SEPARATOR + idExpression) : idExpression;
            this.mapping.put("@gml:id", (Expression)id);
        }
        Iterator<AttributeMapping> it = this.attOrderedTypeList.iterator();
        this.addComplexAttributes(this.elements, it);
        this.addSetterAttributes(this.elements);
        ++this.index;
        this.removeAllRelativePaths();
    }

    private void addComplexAttributes(PathAttributeList elements, Iterator<AttributeMapping> it) {
        while (it.hasNext()) {
            AttributeMapping attMapping = it.next();
            Expression sourceExpression = attMapping.getIdentifierExpression();
            List<PathAttributeList.Pair> ls = elements.get(attMapping.getParentLabel());
            if (ls == null) continue;
            for (int i = 0; i < ls.size(); ++i) {
                PathAttributeList.Pair parentAttribute = ls.get(i);
                String instancePath = attMapping.getInstanceXpath();
                int count = 1;
                String countXpath = parentAttribute.getXpath();
                if (instancePath != null) {
                    countXpath = countXpath + XPATH_SEPARATOR + instancePath;
                }
                for (int j = 0; j < count; ++j) {
                    String bracketIndex = "";
                    String xpath = instancePath == null ? parentAttribute.getXpath() + XPATH_SEPARATOR + sourceExpression.toString() : parentAttribute.getXpath() + XPATH_SEPARATOR + instancePath + "" + XPATH_SEPARATOR + sourceExpression.toString();
                    String label = this.getFullQueryPath(attMapping);
                    this.mapping.put(label + XPATH_PROPERTY_SEPARATOR + "gml:id", (Expression)this.ff.property(xpath));
                    XPathUtil.StepList sl = attMapping.getTargetXPath();
                    this.setPathIndex(j, sl);
                    Attribute subFeature = null;
                    elements.put(attMapping.getLabel(), countXpath + "", subFeature);
                }
            }
        }
    }

    private void addSetterAttributes(PathAttributeList elements) {
        for (AttributeMapping attMapping : this.setterAttributes) {
            List<PathAttributeList.Pair> ls = elements.get(attMapping.getParentLabel());
            if (ls == null) continue;
            for (int i = 0; i < ls.size(); ++i) {
                PathAttributeList.Pair parentPair = ls.get(i);
                Expression sourceExpression = attMapping.getSourceExpression();
                String prefix = parentPair.getXpath();
                Expression usedXpath = this.getValue(prefix, sourceExpression, attMapping);
                String label = this.getFullQueryPath(attMapping);
                this.mapping.put(label, usedXpath);
                if (usedXpath instanceof PropertyName) {
                    this.addClientProperties(attMapping, usedXpath.toString(), label);
                    continue;
                }
                this.addClientProperties(attMapping, prefix, label);
            }
        }
    }

    private void addClientProperties(AttributeMapping attMapping, String prefix, String label) {
        Map<Name, Expression> clientProperties = attMapping.getClientProperties();
        if (clientProperties.size() != 0) {
            for (Map.Entry<Name, Expression> entry : clientProperties.entrySet()) {
                Name propName = entry.getKey();
                Expression propExpr = entry.getValue();
                Expression xPath = this.getValue(prefix, propExpr, attMapping);
                this.mapping.put(label + XPATH_PROPERTY_SEPARATOR + this.getPropertyNameXpath(propName), xPath);
            }
        }
    }

    private String getPropertyNameXpath(Name propName) {
        String xpath;
        String namespaceUri = propName.getNamespaceURI();
        if (namespaceUri != null) {
            String namespace = this.namespaces.getPrefix(namespaceUri);
            xpath = namespace + propName.getSeparator() + propName.getLocalPart();
        } else {
            xpath = propName.getLocalPart();
        }
        return xpath;
    }

    private void setPathIndex(int j, XPathUtil.StepList sl) {
        if (j > 0) {
            XPathUtil.Step st = (XPathUtil.Step)sl.get(sl.size() - 1);
            XPathUtil.Step st2 = new XPathUtil.Step(st.getName(), j + 1, st.isXmlAttribute());
            sl.remove(sl.size() - 1);
            sl.add(st2);
        }
    }

    protected Expression getValue(String xpathPrefix, Expression node, AttributeMapping mapping) {
        Object value = null;
        if (node instanceof Function) {
            Function func = (Function)node;
            Expression exp = this.getAsXpathExpression(func, mapping);
            value = exp != null ? exp : func;
        } else if (node instanceof LiteralExpressionImpl) {
            value = node;
        } else {
            String expressionValue = node.toString();
            value = xpathPrefix.length() > 0 ? this.ff.property(xpathPrefix + XPATH_SEPARATOR + expressionValue) : node;
        }
        return value;
    }

    private Expression getAsXpathExpression(Function func, AttributeMapping mapping) {
        if (func.getName().equals(AS_XPATH_FUNCTION)) {
            String prefix;
            Expression queryXpath = (Expression)func.getParameters().get(0);
            String parentLabel = mapping.getParentLabel();
            if (parentLabel == null) {
                prefix = this.elements.getPath(this.rootAttribute.getLabel());
            } else {
                prefix = this.elements.getPath(parentLabel);
                String instancePath = mapping.getInstanceXpath();
                if (instancePath != null) {
                    prefix = prefix + XPATH_SEPARATOR + instancePath;
                }
            }
            PropertyName fullXpath = this.ff.property(prefix + XPATH_SEPARATOR + queryXpath);
            return fullXpath;
        }
        List params = func.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            Expression expr;
            Expression param = (Expression)params.get(i);
            if (!(param instanceof Function) || (expr = this.getAsXpathExpression((Function)param, mapping)) == null) continue;
            func.getParameters().remove(i);
            func.getParameters().add(expr);
        }
        return null;
    }

    private void initialiseAttributeLists(List<AttributeMapping> mappings) {
        for (AttributeMapping attMapping : mappings) {
            if (attMapping.getLabel() == null || attMapping.getParentLabel() != null || attMapping.getTargetNodeInstance() != null) continue;
            this.rootAttribute = attMapping;
            break;
        }
        this.attOrderedTypeList = new AttributeCreateOrderList(this.rootAttribute.getLabel());
        this.indexAttributeList = new HashMap<String, AttributeMapping>();
        this.indexAttributeList.put(this.rootAttribute.getLabel(), this.rootAttribute);
        for (AttributeMapping attMapping : mappings) {
            if (attMapping.getLabel() == null) {
                this.setterAttributes.add(attMapping);
                continue;
            }
            if (attMapping.getParentLabel() == null) continue;
            this.attOrderedTypeList.put(attMapping);
            this.indexAttributeList.put(attMapping.getLabel(), attMapping);
        }
    }

    protected void setClientProperties(Attribute target, Object source, Map<Name, Expression> clientProperties) {
        if (clientProperties.size() == 0) {
            return;
        }
        HashMap<Name, String> targetAttributes = new HashMap<Name, String>();
        for (Map.Entry<Name, Expression> entry : clientProperties.entrySet()) {
            Name propName = entry.getKey();
            Expression propExpr = entry.getValue();
            String propValue = null;
            if (propValue != null) {
                List ls = (List)((Object)propValue);
                propValue = ls.size() != 0 ? ls.get(0) : "";
            }
            targetAttributes.put(propName, propValue);
        }
    }

    private String getFullQueryPath(AttributeMapping attMapping) {
        return attMapping.getTargetXPath().toString();
    }

    private void removeAllRelativePaths() {
        Set<String> c = this.mapping.keySet();
        for (String key : c) {
            Expression xPath = this.mapping.get(key);
            PropertyName xPath2 = this.removeRelativePaths(xPath);
            if (xPath.toString().equals(xPath2.toString())) continue;
            this.mapping.put(key, (Expression)xPath2);
        }
    }

    private PropertyName removeRelativePaths(Expression xPath) {
        int slashPos;
        String xPathTemp = xPath.toString();
        int NOT_FOUND = -1;
        String RELATIVE_PATH = "/../";
        int i = xPathTemp.indexOf("/../");
        while (i != -1 && (slashPos = xPathTemp.lastIndexOf(XPATH_SEPARATOR, i - 1)) != -1) {
            String left = xPathTemp.substring(0, slashPos + 1);
            String right = xPathTemp.substring(i + "/../".length());
            xPathTemp = left + right;
            i = xPathTemp.indexOf("/../");
        }
        return this.ff.property(xPathTemp);
    }

    @Override
    public List<Expression> findMappingsFor(XPathUtil.StepList propertyName, boolean includeNestedMappings) {
        List<Expression> expressions = null;
        if (!propertyName.toString().contains(XPATH_LEFT_INDEX_BRACKET)) {
            expressions = this.getExpressionsIgnoreIndex(propertyName);
        } else {
            expressions = new ArrayList<Expression>(1);
            AttributeMapping mapping = this.getStringMapping(propertyName);
            if (mapping != null) {
                expressions.add(mapping.getSourceExpression());
            }
        }
        return expressions;
    }
}

