/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.util.NoSuchElementException;
import org.geotools.data.complex.IMappingFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.Feature;
import org.opengis.filter.Filter;

public class PostFilteringMappingFeatureIterator
implements IMappingFeatureIterator {
    protected FeatureIterator<Feature> delegate;
    protected Feature next;
    protected Filter filter;
    protected int maxFeatures;
    protected int count = 0;

    public PostFilteringMappingFeatureIterator(FeatureIterator<Feature> iterator, Filter filter, int maxFeatures, int offset) {
        this.delegate = iterator;
        this.filter = filter;
        this.maxFeatures = maxFeatures;
        for (int startIndex = -1; startIndex < offset; ++startIndex) {
            this.next = this.getFilteredNext();
        }
    }

    public void close() {
        this.delegate.close();
    }

    protected Feature getFilteredNext() {
        while (this.delegate.hasNext() && this.count < this.maxFeatures) {
            Feature feature = this.delegate.next();
            try {
                if (!this.filter.evaluate((Object)feature)) continue;
                return feature;
            }
            catch (NullPointerException nullPointerException) {
            }
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Feature next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        ++this.count;
        Feature current = this.next;
        this.next = this.getFilteredNext();
        return current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

