/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.awt.RenderingHints;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Set;
import org.geotools.data.DataAccess;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.MappingFeatureCollection;
import org.geotools.data.joining.JoiningQuery;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCFeatureStore;
import org.opengis.feature.Feature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public class MappingFeatureSource
implements FeatureSource<FeatureType, Feature> {
    private AppSchemaDataAccess store;
    private FeatureTypeMapping mapping;

    public MappingFeatureSource(AppSchemaDataAccess store, FeatureTypeMapping mapping) {
        this.store = store;
        this.mapping = mapping;
    }

    public void addFeatureListener(FeatureListener listener) {
        throw new UnsupportedOperationException();
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this.store.getBounds(this.namedQuery((Filter)Filter.INCLUDE, Integer.MAX_VALUE));
    }

    private Query namedQuery(Filter filter, int countLimit) {
        return this.namedQuery(filter, countLimit, false);
    }

    private Query namedQuery(Filter filter, int countLimit, Hints hints) {
        return this.namedQuery(filter, countLimit, false, hints);
    }

    private Query namedQuery(Filter filter, int countLimit, boolean isJoining) {
        return this.namedQuery(filter, countLimit, isJoining, null);
    }

    private Query namedQuery(Filter filter, int countLimit, boolean isJoining, Hints hints) {
        JoiningQuery query;
        JoiningQuery joiningQuery = query = isJoining ? new JoiningQuery() : new Query();
        if (this.getName().getNamespaceURI() != null) {
            try {
                query.setNamespace(new URI(this.getName().getNamespaceURI()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        query.setTypeName(this.getName().getLocalPart());
        query.setFilter(filter);
        query.setMaxFeatures(countLimit);
        query.setHints(hints);
        return query;
    }

    private Query namedQuery(Query query) {
        Query namedQuery = this.namedQuery(query.getFilter(), query.getMaxFeatures(), query instanceof JoiningQuery);
        namedQuery.setProperties(query.getProperties());
        namedQuery.setCoordinateSystem(query.getCoordinateSystem());
        namedQuery.setCoordinateSystemReproject(query.getCoordinateSystemReproject());
        namedQuery.setHandle(query.getHandle());
        namedQuery.setMaxFeatures(query.getMaxFeatures());
        namedQuery.setStartIndex(query.getStartIndex());
        namedQuery.setSortBy(query.getSortBy());
        namedQuery.setHints(query.getHints());
        if (query instanceof JoiningQuery) {
            ((JoiningQuery)namedQuery).setQueryJoins(((JoiningQuery)query).getQueryJoins());
        }
        return namedQuery;
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        Query namedQuery = this.namedQuery(query);
        return this.store.getBounds(namedQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(Query query) throws IOException {
        int count = 0;
        Query namedQuery = this.namedQuery(query);
        FeatureSource mappedSource = this.mapping.getSource();
        if (!(mappedSource instanceof JDBCFeatureSource) && !(mappedSource instanceof JDBCFeatureStore)) {
            count = this.store.getCount(namedQuery);
        }
        if (count >= 0) {
            return count;
        }
        int featureCount = 0;
        try (FeatureIterator features = null;){
            features = this.getFeatures(namedQuery).features();
            while (features.hasNext()) {
                ++featureCount;
                features.next();
            }
        }
        return featureCount;
    }

    public DataAccess<FeatureType, Feature> getDataStore() {
        return this.store;
    }

    public FeatureType getSchema() {
        return (FeatureType)this.mapping.getTargetFeature().getType();
    }

    public AttributeDescriptor getTargetFeature() {
        return this.mapping.getTargetFeature();
    }

    public FeatureTypeMapping getMapping() {
        return this.mapping;
    }

    public FeatureCollection<FeatureType, Feature> getFeatures(Query query) throws IOException {
        return new MappingFeatureCollection(this.store, this.mapping, this.namedQuery(query));
    }

    public FeatureCollection<FeatureType, Feature> getFeatures(Filter filter) throws IOException {
        return new MappingFeatureCollection(this.store, this.mapping, this.namedQuery(filter, Integer.MAX_VALUE));
    }

    public FeatureCollection<FeatureType, Feature> getFeatures(Filter filter, Hints hints) throws IOException {
        return new MappingFeatureCollection(this.store, this.mapping, this.namedQuery(filter, Integer.MAX_VALUE, hints));
    }

    public FeatureCollection<FeatureType, Feature> getFeatures() throws IOException {
        return new MappingFeatureCollection(this.store, this.mapping, this.namedQuery((Filter)Filter.INCLUDE, Integer.MAX_VALUE));
    }

    public void removeFeatureListener(FeatureListener listener) {
        throw new UnsupportedOperationException("this is a read only feature source");
    }

    public ResourceInfo getInfo() {
        throw new UnsupportedOperationException();
    }

    public Name getName() {
        Name name = this.mapping.getTargetFeature().getName();
        return name;
    }

    public Set<RenderingHints.Key> getSupportedHints() {
        return Collections.emptySet();
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.mapping.getSource().getQueryCapabilities();
    }
}

