/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.IMappingFeatureIterator;
import org.geotools.data.complex.MappingFeatureIteratorFactory;
import org.geotools.data.complex.XmlFeatureTypeMapping;
import org.geotools.data.complex.XmlMappingFeatureIterator;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

public class MappingFeatureCollection
implements FeatureCollection<FeatureType, Feature> {
    private final AppSchemaDataAccess store;
    private final FeatureTypeMapping mapping;
    private final Query query;
    private Filter unrolledFilter = null;

    public MappingFeatureCollection(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query) {
        this.store = store;
        this.mapping = mapping;
        this.query = query;
    }

    public void setUnrolledFilter(Filter unrolledFilter) {
        this.unrolledFilter = unrolledFilter;
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        DataUtilities.visit((FeatureCollection)this, (FeatureVisitor)visitor, (ProgressListener)progress);
    }

    public boolean add(Feature obj) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection<? extends Feature> collection) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(FeatureCollection<? extends FeatureType, ? extends Feature> resource) {
        throw new UnsupportedOperationException();
    }

    public void addListener(CollectionListener listener) throws NullPointerException {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void close(FeatureIterator<Feature> close) {
        close.close();
    }

    public void close(Iterator<Feature> close) {
        ((IMappingFeatureIterator)close).close();
    }

    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection<?> o) {
        throw new UnsupportedOperationException();
    }

    public FeatureIterator<Feature> features() {
        try {
            return MappingFeatureIteratorFactory.getInstance(this.store, this.mapping, this.query, this.unrolledFilter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public XmlMappingFeatureIterator features(String xpath, String value) throws IOException {
        return new XmlMappingFeatureIterator(this.store, this.mapping, this.query, xpath, value);
    }

    public ReferencedEnvelope getBounds() {
        try (FeatureIterator<Feature> features = this.features();){
            Envelope newBBox = new Envelope();
            while (features.hasNext()) {
                Feature feature = features.next();
                Geometry geometry = feature.getDefaultGeometryProperty() != null ? (Geometry)feature.getDefaultGeometryProperty().getValue() : null;
                if (geometry == null) continue;
                Envelope internal = geometry.getEnvelopeInternal();
                newBBox.expandToInclude(internal);
            }
            ReferencedEnvelope referencedEnvelope = ReferencedEnvelope.reference((Envelope)newBBox);
            return referencedEnvelope;
        }
    }

    public String getID() {
        return null;
    }

    public FeatureType getSchema() {
        return (FeatureType)this.mapping.getTargetFeature().getType();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator<Feature> iterator() {
        try {
            return MappingFeatureIteratorFactory.getInstance(this.store, this.mapping, this.query, this.unrolledFilter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void purge() {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public void removeListener(CollectionListener listener) throws NullPointerException {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return 0;
    }

    public FeatureCollection<FeatureType, Feature> sort(SortBy order) {
        throw new UnsupportedOperationException();
    }

    public boolean isXmlCollection() {
        return this.mapping instanceof XmlFeatureTypeMapping;
    }

    public FeatureCollection<FeatureType, Feature> subCollection(Filter filter) {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    public <O> O[] toArray(O[] a) {
        throw new UnsupportedOperationException();
    }

    public Query getQuery() {
        return this.query;
    }
}

