/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.MappingFeatureSource;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.complex.filter.XPathUtil;
import org.geotools.data.joining.JoiningNestedAttributeMapping;
import org.geotools.feature.Types;
import org.geotools.gml3.GML;
import org.opengis.feature.Feature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;
import org.xml.sax.helpers.NamespaceSupport;

public class FeatureTypeMapping {
    private FeatureSource<? extends FeatureType, ? extends Feature> source;
    private AttributeDescriptor target;
    List<AttributeMapping> attributeMappings;
    NamespaceSupport namespaces;
    private Name mappingName;
    private Expression featureFidMapping;
    private boolean isDenormalised;

    public FeatureTypeMapping() {
        this(null, null, new LinkedList<AttributeMapping>(), new NamespaceSupport(), false);
    }

    public FeatureTypeMapping(FeatureSource<? extends FeatureType, ? extends Feature> source, AttributeDescriptor target, List<AttributeMapping> mappings, NamespaceSupport namespaces) {
        this(source, target, mappings, namespaces, false);
    }

    public FeatureTypeMapping(FeatureSource<? extends FeatureType, ? extends Feature> source, AttributeDescriptor target, List<AttributeMapping> mappings, NamespaceSupport namespaces, boolean isDenormalised) {
        this.source = source;
        this.target = target;
        this.attributeMappings = new LinkedList<AttributeMapping>(mappings);
        this.namespaces = namespaces;
        this.isDenormalised = isDenormalised;
        for (AttributeMapping attMapping : this.attributeMappings) {
            XPathUtil.StepList targetXPath = attMapping.getTargetXPath();
            if (targetXPath.size() > 1) continue;
            XPathUtil.Step step = (XPathUtil.Step)targetXPath.get(0);
            QName stepName = step.getName();
            if (!Types.equals((Name)target.getName(), (QName)stepName)) continue;
            this.featureFidMapping = attMapping.getIdentifierExpression();
            break;
        }
        if (this.featureFidMapping == null) {
            this.featureFidMapping = Expression.NIL;
        }
    }

    public List<AttributeMapping> getAttributeMappings() {
        return Collections.unmodifiableList(this.attributeMappings);
    }

    public List<NestedAttributeMapping> getNestedMappings() {
        ArrayList<NestedAttributeMapping> mappings = new ArrayList<NestedAttributeMapping>();
        for (AttributeMapping mapping : this.attributeMappings) {
            if (!(mapping instanceof NestedAttributeMapping)) continue;
            mappings.add((NestedAttributeMapping)mapping);
        }
        return mappings;
    }

    public Expression getFeatureIdExpression() {
        return this.featureFidMapping;
    }

    public List<AttributeMapping> getAttributeMappingsIgnoreIndex(XPathUtil.StepList targetPath) {
        ArrayList<AttributeMapping> mappings = new ArrayList<AttributeMapping>();
        for (AttributeMapping attMapping : this.attributeMappings) {
            if (!targetPath.equalsIgnoreIndex(attMapping.getTargetXPath())) continue;
            mappings.add(attMapping);
        }
        return mappings;
    }

    public List<AttributeMapping> getAttributeMappingsByExpression(Expression sourceExpression) {
        ArrayList<AttributeMapping> mappings = new ArrayList<AttributeMapping>();
        for (AttributeMapping attMapping : this.attributeMappings) {
            if (!sourceExpression.equals(attMapping.getSourceExpression())) continue;
            mappings.add(attMapping);
        }
        return mappings;
    }

    public AttributeMapping getAttributeMapping(XPathUtil.StepList exactPath) {
        for (AttributeMapping attMapping : this.attributeMappings) {
            if (!exactPath.equals((Object)attMapping.getTargetXPath())) continue;
            return attMapping;
        }
        return null;
    }

    public NamespaceSupport getNamespaces() {
        return this.namespaces;
    }

    public void setTargetFeature(AttributeDescriptor feature) {
        this.target = feature;
    }

    public AttributeDescriptor getTargetFeature() {
        return this.target;
    }

    public FeatureSource getSource() {
        return this.source;
    }

    public FeatureTypeMapping getUnderlyingComplexMapping() {
        if (this.source instanceof MappingFeatureSource) {
            return ((MappingFeatureSource)this.source).getMapping();
        }
        return null;
    }

    public void setName(Name name) {
        this.mappingName = name;
    }

    public Name getMappingName() {
        return this.mappingName;
    }

    public List<AttributeMapping> getIsListMappings() {
        ArrayList<AttributeMapping> mappings = new ArrayList<AttributeMapping>();
        for (AttributeMapping attMapping : this.attributeMappings) {
            if (!attMapping.isList()) continue;
            mappings.add(attMapping);
        }
        return mappings;
    }

    public List<Expression> findMappingsFor(XPathUtil.StepList propertyName, boolean includeNestedMappings) {
        XPathUtil.Step clientPropertyStep;
        List<AttributeMapping> candidates;
        if (!propertyName.toString().contains("[")) {
            candidates = this.getAttributeMappingsIgnoreIndex(propertyName);
        } else {
            candidates = new ArrayList<AttributeMapping>();
            AttributeMapping mapping = this.getAttributeMapping(propertyName);
            if (mapping != null) {
                candidates.add(mapping);
            }
        }
        List<Expression> expressions = this.getExpressions(candidates, includeNestedMappings);
        if (candidates.size() == 0 && propertyName.size() > 0 && (clientPropertyStep = (XPathUtil.Step)propertyName.get(propertyName.size() - 1)).isXmlAttribute()) {
            FeatureTypeMapping inputMapping;
            XPathUtil.StepList parentPath;
            Name clientPropertyName = Types.toTypeName((QName)clientPropertyStep.getName());
            if (propertyName.size() == 1) {
                parentPath = XPath.rootElementSteps(this.target, this.namespaces);
            } else {
                parentPath = new XPathUtil.StepList(propertyName);
                parentPath.remove(parentPath.size() - 1);
            }
            candidates = this.getAttributeMappingsIgnoreIndex(parentPath);
            expressions = this.getClientPropertyExpressions(candidates, clientPropertyName, parentPath);
            if (expressions.isEmpty() && (inputMapping = this.getUnderlyingComplexMapping()) != null) {
                return this.getClientPropertyExpressions(inputMapping.getAttributeMappingsIgnoreIndex(parentPath), clientPropertyName, parentPath);
            }
        }
        return expressions;
    }

    private List<Expression> getClientPropertyExpressions(List attributeMappings, Name clientPropertyName, XPathUtil.StepList parentPath) {
        ArrayList<Expression> clientPropertyExpressions = new ArrayList<Expression>(attributeMappings.size());
        for (AttributeMapping attMapping : attributeMappings) {
            if (attMapping instanceof JoiningNestedAttributeMapping) {
                clientPropertyExpressions.add(null);
                continue;
            }
            Map<Name, Expression> clientProperties = attMapping.getClientProperties();
            if (Types.equals((Name)clientPropertyName, (QName)GML.id)) {
                clientPropertyExpressions.add(attMapping.getIdentifierExpression());
                continue;
            }
            if (!clientProperties.containsKey(clientPropertyName)) continue;
            Expression propertyExpression = clientProperties.get(clientPropertyName);
            clientPropertyExpressions.add(propertyExpression);
        }
        return clientPropertyExpressions;
    }

    private List getExpressions(List attributeMappings, boolean includeNestedMappings) {
        ArrayList<Expression> expressions = new ArrayList<Expression>(attributeMappings.size());
        for (AttributeMapping mapping : attributeMappings) {
            if (mapping instanceof JoiningNestedAttributeMapping && !includeNestedMappings) {
                expressions.add(null);
                continue;
            }
            Expression sourceExpression = mapping.getSourceExpression();
            if (Expression.NIL.equals(sourceExpression)) continue;
            expressions.add(sourceExpression);
        }
        return expressions;
    }

    public boolean isDenormalised() {
        return this.isDenormalised;
    }

    public void setDenormalised(boolean isDenormalised) {
        this.isDenormalised = isDenormalised;
    }
}

