/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.complex.AttributeMapping;

public class AttributeCreateOrderList {
    private String rootLabel;
    private Map<String, List<AttributeMapping>> childrenList = new HashMap<String, List<AttributeMapping>>();

    public AttributeCreateOrderList(String rootLabel) {
        this.rootLabel = rootLabel;
        ArrayList newAttMapping = new ArrayList();
        this.childrenList.put(rootLabel, newAttMapping);
    }

    public boolean put(AttributeMapping attMapping) {
        List<Object> newAttMapping;
        String parentLabel = attMapping.getParentLabel();
        if (attMapping.getLabel() == null || parentLabel == null) {
            return false;
        }
        if (attMapping.getLabel().equals(parentLabel)) {
            throw new IllegalArgumentException("Parents label same as label!");
        }
        if (this.childrenList.containsKey(parentLabel)) {
            newAttMapping = this.childrenList.get(parentLabel);
        } else {
            newAttMapping = new ArrayList();
            this.childrenList.put(parentLabel, newAttMapping);
        }
        newAttMapping.add(attMapping);
        return true;
    }

    public Iterator<AttributeMapping> iterator() {
        return new InnerClass();
    }

    public void setRootLabel(String rootLabel) {
        this.rootLabel = rootLabel;
    }

    class InnerClass
    implements Iterator<AttributeMapping> {
        boolean isInitialised = false;
        boolean isHasNextBeenCalled = false;
        private Iterator<AttributeMapping> currentListIterator;
        private Set<String> unprocessedTreeNodes = new HashSet(AttributeCreateOrderList.access$000(AttributeCreateOrderList.this).keySet());
        private Set<String> returnedUnprocessedNodes = new HashSet<String>();

        InnerClass() {
        }

        @Override
        public boolean hasNext() {
            this.isHasNextBeenCalled = true;
            if (!this.isInitialised) {
                this.initialise();
            }
            if (this.currentListIterator.hasNext()) {
                return true;
            }
            if (this.unprocessedTreeNodes.isEmpty()) {
                return false;
            }
            this.getNextList();
            return true;
        }

        @Override
        public AttributeMapping next() {
            if (!this.isHasNextBeenCalled) {
                throw new IllegalStateException("next method called without hasNext being called first.");
            }
            this.isHasNextBeenCalled = false;
            AttributeMapping next = this.currentListIterator.next();
            this.returnedUnprocessedNodes.add(next.getLabel());
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }

        private void initialise() {
            this.isInitialised = true;
            List currentList = (List)AttributeCreateOrderList.this.childrenList.get(AttributeCreateOrderList.this.rootLabel);
            this.currentListIterator = currentList.iterator();
            this.unprocessedTreeNodes.remove(AttributeCreateOrderList.this.rootLabel);
        }

        private void getNextList() {
            if (this.returnedUnprocessedNodes.isEmpty()) {
                throw new IllegalStateException("Please check your mapping file. No attribute found for parentLabel: '" + this.unprocessedTreeNodes.toString() + "' or root label has no matching children.");
            }
            Iterator<String> it = this.returnedUnprocessedNodes.iterator();
            boolean listFound = false;
            String element = null;
            while (it.hasNext() && !listFound) {
                element = it.next();
                if (this.unprocessedTreeNodes.contains(element)) {
                    listFound = true;
                    this.unprocessedTreeNodes.remove(element);
                    it.remove();
                    continue;
                }
                it.remove();
            }
            if (!listFound) {
                throw new IllegalStateException("Error in tree structure.  No created elements link to unprocessed children elements");
            }
            List currentList = (List)AttributeCreateOrderList.this.childrenList.get(element);
            this.currentListIterator = currentList.iterator();
        }
    }
}

