/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.DataAccess;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.MappingFeatureSource;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.config.NonFeatureTypeProxy;
import org.geotools.data.complex.filter.UnmappingFilterVisitor;
import org.geotools.data.complex.filter.UnmappingFilterVisitorFactory;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.complex.filter.XPathUtil;
import org.geotools.data.joining.JoiningQuery;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.Types;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.SortByImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JoiningJDBCFeatureSource;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class AppSchemaDataAccess
implements DataAccess<FeatureType, Feature> {
    private static final Logger LOGGER = Logging.getLogger((String)AppSchemaDataAccess.class.getPackage().getName());
    private Map<Name, FeatureTypeMapping> mappings = new LinkedHashMap<Name, FeatureTypeMapping>();
    private FilterFactory2 filterFac = CommonFactoryFinder.getFilterFactory2(null);

    public AppSchemaDataAccess(Set<FeatureTypeMapping> mappings) throws IOException {
        try {
            for (FeatureTypeMapping mapping : mappings) {
                Name name = mapping.getMappingName();
                if (name == null) {
                    name = mapping.getTargetFeature().getName();
                }
                if (this.mappings.containsKey(name) || DataAccessRegistry.hasName(name)) {
                    throw new DataSourceException("Duplicate mappingName or targetElement across FeatureTypeMapping instances detected.\nThey have to be unique, or app-schema doesn't know which one to get.\nPlease check your mapping file(s) with mappingName or targetElement of: " + name);
                }
                this.mappings.put(name, mapping);
                AttributeType type = mapping.getTargetFeature().getType();
                if (type instanceof FeatureType) continue;
                new NonFeatureTypeProxy(type, mapping);
            }
        }
        catch (RuntimeException e) {
            for (FeatureTypeMapping mapping : mappings) {
                mapping.getSource().getDataStore().dispose();
            }
            throw e;
        }
        this.register();
    }

    protected void register() {
        DataAccessRegistry.register(this);
    }

    public Name[] getTypeNames() throws IOException {
        Name[] typeNames = new Name[this.mappings.size()];
        int i = 0;
        for (FeatureTypeMapping mapping : this.mappings.values()) {
            typeNames[i] = mapping.getTargetFeature().getName();
            ++i;
        }
        return typeNames;
    }

    public FeatureType getSchema(Name typeName) throws IOException {
        return (FeatureType)this.getMappingByElement(typeName).getTargetFeature().getType();
    }

    public FeatureTypeMapping getMappingByName(Name typeName) throws IOException {
        FeatureTypeMapping mapping = this.mappings.get(typeName);
        if (mapping == null) {
            throw new DataSourceException(typeName + " not found. Available: " + this.mappings.keySet().toString());
        }
        return mapping;
    }

    public FeatureTypeMapping getMappingByElement(Name typeName) throws IOException {
        for (FeatureTypeMapping mapping : this.mappings.values()) {
            if (!mapping.getTargetFeature().getName().equals((Object)typeName)) continue;
            return mapping;
        }
        ArrayList<String> availables = new ArrayList<String>();
        for (FeatureTypeMapping mapping : this.mappings.values()) {
            availables.add(mapping.getTargetFeature().getName().toString());
        }
        throw new DataSourceException(typeName + " not found. Available: " + availables.toString());
    }

    public boolean hasName(Name name) {
        return this.mappings.containsKey(name);
    }

    public boolean hasElement(Name typeName) {
        for (FeatureTypeMapping mapping : this.mappings.values()) {
            if (!mapping.getTargetFeature().getName().equals((Object)typeName)) continue;
            return true;
        }
        return false;
    }

    protected ReferencedEnvelope getBounds(Query query) throws IOException {
        FeatureTypeMapping mapping = this.getMappingByElement(this.getName(query));
        Query unmappedQuery = this.unrollQuery(query, mapping);
        return mapping.getSource().getBounds(unmappedQuery);
    }

    protected int getCount(Query targetQuery) throws IOException {
        FeatureTypeMapping mapping = this.getMappingByElement(this.getName(targetQuery));
        Object mappedSource = mapping.getSource();
        if (mappedSource instanceof JDBCFeatureSource) {
            mappedSource = new JoiningJDBCFeatureSource((JDBCFeatureSource)mappedSource);
        } else if (mappedSource instanceof JDBCFeatureStore) {
            mappedSource = new JoiningJDBCFeatureSource((JDBCFeatureStore)mappedSource);
        }
        Query unmappedQuery = this.unrollQuery(targetQuery, mapping);
        return mappedSource.getCount(unmappedQuery);
    }

    private Name getName(Query query) {
        if (query.getNamespace() == null) {
            return Types.typeName((String)query.getTypeName());
        }
        return Types.typeName((String)query.getNamespace().toString(), (String)query.getTypeName());
    }

    protected Filter getUnsupportedFilter(String typeName, Filter filter) {
        return Filter.INCLUDE;
    }

    public Query unrollQuery(Query query, FeatureTypeMapping mapping) {
        Query unrolledQuery = Query.ALL;
        FeatureSource source = mapping.getSource();
        if (!Query.ALL.equals((Object)query)) {
            Filter complexFilter = query.getFilter();
            Filter unrolledFilter = AppSchemaDataAccess.unrollFilter(complexFilter, mapping);
            Object includeProps = query.getHints().get((Object)Query.INCLUDE_MANDATORY_PROPS);
            List<PropertyName> propNames = this.getSurrogatePropertyNames(query.getProperties(), mapping, includeProps instanceof Boolean && (Boolean)includeProps != false);
            Query newQuery = new Query();
            String name = source.getName().getLocalPart();
            newQuery.setTypeName(name);
            newQuery.setFilter(unrolledFilter);
            newQuery.setProperties(propNames);
            newQuery.setCoordinateSystem(query.getCoordinateSystem());
            newQuery.setCoordinateSystemReproject(query.getCoordinateSystemReproject());
            newQuery.setHandle(query.getHandle());
            newQuery.setMaxFeatures(query.getMaxFeatures());
            newQuery.setStartIndex(query.getStartIndex());
            ArrayList<SortByImpl> sort = new ArrayList<SortByImpl>();
            if (query.getSortBy() != null) {
                for (SortBy sortBy : query.getSortBy()) {
                    for (Expression expr : this.unrollProperty(sortBy.getPropertyName(), mapping)) {
                        if (expr == null) continue;
                        FilterAttributeExtractor extractor = new FilterAttributeExtractor();
                        expr.accept((ExpressionVisitor)extractor, null);
                        for (String att : extractor.getAttributeNameSet()) {
                            sort.add(new SortByImpl(this.filterFac.property(att), sortBy.getSortOrder()));
                        }
                    }
                }
            }
            if (query instanceof JoiningQuery) {
                FilterAttributeExtractor extractor = new FilterAttributeExtractor();
                mapping.getFeatureIdExpression().accept((ExpressionVisitor)extractor, null);
                if (!Expression.NIL.equals(mapping.getFeatureIdExpression()) && !(mapping.getFeatureIdExpression() instanceof Literal) && extractor.getAttributeNameSet().isEmpty()) {
                    String ns = mapping.namespaces.getPrefix(mapping.getTargetFeature().getName().getNamespaceURI());
                    String separator = mapping.getTargetFeature().getName().getSeparator();
                    String typeName = mapping.getTargetFeature().getLocalName();
                    throw new UnsupportedOperationException(String.format("idExpression '%s' for targetElement '%s%s%s' cannot be translated into SQL, therefore is not supported with joining!\nPlease make sure idExpression is mapped into existing database fields, and only use functions that are supported by your database.\nIf this cannot be helped, you can turn off joining in app-schema.properties file.", mapping.getFeatureIdExpression(), ns, separator, typeName));
                }
                JoiningQuery jQuery = new JoiningQuery(newQuery);
                jQuery.setDenormalised(((JoiningQuery)query).isDenormalised());
                jQuery.setQueryJoins(((JoiningQuery)query).getQueryJoins());
                jQuery.setSubset(((JoiningQuery)query).isSubset());
                for (String att : extractor.getAttributeNameSet()) {
                    sort.add(new SortByImpl(this.filterFac.property(att), SortOrder.ASCENDING));
                    jQuery.addId(att);
                }
                unrolledQuery = jQuery;
            } else {
                unrolledQuery = newQuery;
            }
            unrolledQuery.setSortBy(sort.toArray(new SortBy[sort.size()]));
        }
        return unrolledQuery;
    }

    protected static boolean matchProperty(XPathUtil.StepList requestedProperty, XPathUtil.StepList target) {
        int minSize = Math.min(requestedProperty.size(), target.size());
        for (int i = 0; i < minSize; ++i) {
            if (((XPathUtil.Step)target.get(i)).getName().equals(((XPathUtil.Step)requestedProperty.get(i)).getName())) continue;
            return false;
        }
        return true;
    }

    protected static boolean matchProperty(String requestedProperty, XPathUtil.StepList target) {
        return ((XPathUtil.Step)target.get(0)).getName().getLocalPart().equals(requestedProperty);
    }

    private List<PropertyName> getSurrogatePropertyNames(List<PropertyName> requestedProperties, FeatureTypeMapping mapping, boolean includeMandatory) {
        ArrayList propNames = null;
        AttributeDescriptor targetDescriptor = mapping.getTargetFeature();
        if (requestedProperties != null && requestedProperties.size() > 0) {
            FeatureType mappedType;
            requestedProperties = new ArrayList<PropertyName>(requestedProperties);
            HashSet<PropertyName> requestedSurrogateProperties = new HashSet<PropertyName>();
            List<AttributeMapping> attMappings = mapping.getAttributeMappings();
            requestedProperties.add(this.filterFac.property(mapping.getTargetFeature().getName()));
            try {
                mappedType = mapping.getSource().getSchema();
            }
            catch (UnsupportedOperationException e) {
                mappedType = null;
            }
            for (AttributeMapping entry : attMappings) {
                PropertyName targetProp;
                Object descr;
                XPathUtil.StepList targetSteps = entry.getTargetXPath();
                boolean addThis = false;
                if (includeMandatory && (descr = (targetProp = this.filterFac.property(targetSteps.toString(), mapping.getNamespaces())).evaluate((Object)targetDescriptor.getType())) instanceof PropertyDescriptor && ((PropertyDescriptor)descr).getMinOccurs() >= 1) {
                    addThis = true;
                }
                if (!addThis) {
                    for (PropertyName requestedProperty : requestedProperties) {
                        XPathUtil.StepList requestedPropertySteps = requestedProperty.getNamespaceContext() == null ? XPath.steps(targetDescriptor, requestedProperty.getPropertyName(), mapping.getNamespaces()) : XPath.steps(targetDescriptor, requestedProperty.getPropertyName(), requestedProperty.getNamespaceContext());
                        if (!(requestedPropertySteps == null ? AppSchemaDataAccess.matchProperty(requestedProperty.getPropertyName(), targetSteps) : AppSchemaDataAccess.matchProperty(requestedPropertySteps, targetSteps))) continue;
                        addThis = true;
                        break;
                    }
                }
                if (!addThis) continue;
                Expression sourceExpression = entry.getSourceExpression();
                Expression idExpression = entry.getIdentifierExpression();
                Collection<Expression> clientProperties = entry.getClientProperties().values();
                FilterAttributeExtractor extractor = new FilterAttributeExtractor();
                sourceExpression.accept((ExpressionVisitor)extractor, null);
                idExpression.accept((ExpressionVisitor)extractor, null);
                if (entry instanceof NestedAttributeMapping) {
                    Expression linkFieldExpression = ((NestedAttributeMapping)entry).nestedFeatureType;
                    linkFieldExpression.accept((ExpressionVisitor)extractor, null);
                }
                Iterator<Expression> it = clientProperties.iterator();
                while (it.hasNext()) {
                    it.next().accept((ExpressionVisitor)extractor, null);
                }
                Set exprAtts = extractor.getAttributeNameSet();
                for (String mappedAtt : exprAtts) {
                    if (mappedAtt.equals("Expression.NIL")) continue;
                    if (mappedType == null) {
                        requestedSurrogateProperties.add(this.filterFac.property(mappedAtt));
                        continue;
                    }
                    PropertyName propExpr = this.filterFac.property(mappedAtt);
                    Object object = propExpr.evaluate((Object)mappedType);
                    AttributeDescriptor mappedAttribute = (AttributeDescriptor)object;
                    if (mappedAttribute != null) {
                        requestedSurrogateProperties.add(this.filterFac.property(mappedAtt));
                        continue;
                    }
                    LOGGER.info("mapped type does not contains property " + mappedAtt);
                }
                LOGGER.fine("adding atts needed for : " + exprAtts);
            }
            propNames = new ArrayList(requestedSurrogateProperties);
        }
        return propNames;
    }

    private List<Expression> unrollProperty(PropertyName property, FeatureTypeMapping mapping) {
        AttributeDescriptor targetDescriptor = mapping.getTargetFeature();
        XPathUtil.StepList propertySteps = XPath.steps(targetDescriptor, property.getPropertyName(), mapping.getNamespaces());
        return mapping.findMappingsFor(propertySteps, true);
    }

    public static Filter unrollFilter(Filter complexFilter, FeatureTypeMapping mapping) {
        UnmappingFilterVisitor visitor = UnmappingFilterVisitorFactory.getInstance(mapping);
        Filter unrolledFilter = (Filter)complexFilter.accept((FilterVisitor)visitor, null);
        return unrolledFilter;
    }

    public void dispose() {
        DataAccessRegistry.unregister(this);
        for (FeatureTypeMapping mapping : this.mappings.values()) {
            mapping.getSource().getDataStore().dispose();
        }
        this.mappings.clear();
    }

    public ServiceInfo getInfo() {
        throw new UnsupportedOperationException();
    }

    public List<Name> getNames() {
        LinkedList<Name> names = new LinkedList<Name>();
        names.addAll(this.mappings.keySet());
        return names;
    }

    public void createSchema(FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FeatureSource<FeatureType, Feature> getFeatureSource(Name typeName) throws IOException {
        return new MappingFeatureSource(this, this.getMappingByElement(typeName));
    }

    public void updateSchema(Name typeName, FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void removeSchema(Name typeName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FeatureSource<FeatureType, Feature> getFeatureSourceByName(Name typeName) throws IOException {
        return new MappingFeatureSource(this, this.getMappingByName(typeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feature findFeature(FeatureId id, Hints hints) throws IOException {
        for (Map.Entry<Name, FeatureTypeMapping> mapping : this.mappings.entrySet()) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            Id filter = this.filterFac.id(new FeatureId[]{id});
            FeatureCollection<FeatureType, Feature> fCollection = new MappingFeatureSource(this, mapping.getValue()).getFeatures((Filter)filter, hints);
            try (FeatureIterator iterator = fCollection.features();){
                if (!iterator.hasNext()) continue;
                Feature feature = iterator.next();
                return feature;
            }
        }
        return null;
    }
}

