/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf.utilities;

import it.geosolutions.imageio.stream.AccessibleStream;
import it.geosolutions.imageio.stream.input.URIImageInputStream;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayShort;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.jni.netcdf.Nc4Iosp;

public class NetCDFUtilities {
    public static final String NETCDF4_MIMETYPE = "application/x-netcdf4";
    public static final String NETCDF3_MIMETYPE = "application/x-netcdf";
    public static final String NETCDF = "NetCDF";
    public static final String NETCDF4 = "NetCDF4";
    public static final String NETCDF_4C = "NetCDF-4C";
    public static final String NETCDF_3 = "NetCDF-3";
    private static final Logger LOGGER;
    private static final Set<String> UNSUPPORTED_DIMENSIONS;
    private static boolean IS_GRIB_AVAILABLE;
    private static boolean IS_NC4_LIBRARY_AVAILABLE;
    public static final String EXTERNAL_DATA_DIR;
    private static final String NETCDF_DATA_DIR = "NETCDF_DATA_DIR";
    public static final String FILL_VALUE = "_FillValue";
    public static final String MISSING_VALUE = "missing_value";
    public static final String LOWER_LEFT_LONGITUDE = "lower_left_longitude";
    public static final String LOWER_LEFT_LATITUDE = "lower_left_latitude";
    public static final String UPPER_RIGHT_LONGITUDE = "upper_right_longitude";
    public static final String UPPER_RIGHT_LATITUDE = "upper_right_latitude";
    public static final String COORDSYS = "latLonCoordSys";
    public static final String Y = "y";
    public static final String Y_COORD_PROJ = "y coordinate of projection";
    public static final String Y_PROJ_COORD = "projection_y_coordinate";
    public static final String X = "x";
    public static final String X_COORD_PROJ = "x coordinate of projection";
    public static final String X_PROJ_COORD = "projection_x_coordinate";
    public static final String LATITUDE = "latitude";
    public static final String LAT = "lat";
    public static final String LONGITUDE = "longitude";
    public static final String LON = "lon";
    public static final String DEPTH = "depth";
    public static final String ZETA = "z";
    public static final String BOUNDS = "bounds";
    private static final String BNDS = "bnds";
    public static final String HEIGHT = "height";
    public static final String TIME = "time";
    public static final String POSITIVE = "positive";
    public static final String UNITS = "units";
    public static final String NAME = "name";
    public static final String LONG_NAME = "long_name";
    public static final String ELEVATION_DIM;
    public static final String TIME_DIM;
    public static final String STANDARD_NAME = "standard_name";
    public static final String DESCRIPTION = "description";
    public static final String M = "m";
    public static final String BOUNDS_SUFFIX = "_bnds";
    public static final String LON_UNITS = "degrees_east";
    public static final String LAT_UNITS = "degrees_north";
    public static final String NO_COORDS = "NoCoords";
    public static final String TIME_ORIGIN = "seconds since 1970-01-01 00:00:00 UTC";
    public static final long START_TIME;
    public static final String BOUNDARY_DIMENSION = "nv";
    public static final TimeZone UTC;
    public static final String GRID_MAPPING = "grid_mapping";
    public static final String GRID_MAPPING_NAME = "grid_mapping_name";
    public static final String COORDINATE_AXIS_TYPE = "_CoordinateAxisType";
    public static final String CONVENTIONS = "Conventions";
    public static final String COORD_SYS_BUILDER = "_CoordSysBuilder";
    public static final String COORD_SYS_BUILDER_CONVENTION = "ucar.nc2.dataset.conv.CF1Convention";
    public static final String COORDINATE_TRANSFORM_TYPE = "_CoordinateTransformType";
    public static final String SPATIAL_REF = "spatial_ref";
    public static final String GEO_TRANSFORM = "GeoTransform";
    static final Set<String> EXCLUDED_ATTRIBUTES;
    public static final int X_DIMENSION = 1;
    public static final int Y_DIMENSION = 2;
    public static final int Z_DIMENSION = 3;
    public static final Set<DataType> VALID_TYPES;
    public static final String NC4_ERROR_MESSAGE = "Native NetCDF C library is not available. Unable to handle NetCDF4 files on input/output.\nPlease make sure to add the paht of the Native NetCDF C libraries to the PATH environment variable\n if you want to support NetCDF4-Classic files";

    private NetCDFUtilities() {
    }

    static boolean isLatLon(String bandName) {
        return bandName.equalsIgnoreCase(LON) || bandName.equalsIgnoreCase(LAT);
    }

    public static boolean isValidDir(File file) {
        String dir = file.getAbsolutePath();
        if (!file.exists()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("The specified NETCDF_DATA_DIR property doesn't refer to an existing folder. Please check the path: " + dir);
            }
            return false;
        }
        if (!file.isDirectory()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("The specified NETCDF_DATA_DIR property doesn't refer to a directory. Please check the path: " + dir);
            }
            return false;
        }
        if (!file.canWrite()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("The specified NETCDF_DATA_DIR property refers to a directory which can't be written. Please check the path and the permissions for: " + dir);
            }
            return false;
        }
        return true;
    }

    public static int getZDimensionLength(Variable var) {
        int rank = var.getRank();
        if (rank > 2) {
            return var.getDimension(rank - 3).getLength();
        }
        return 0;
    }

    public static int getRawDataType(VariableIF variable) {
        VariableDS ds = (VariableDS)variable;
        DataType type = ds.getOriginalDataType();
        return NetCDFUtilities.transcodeNetCDFDataType(type, variable.isUnsigned());
    }

    public static int transcodeNetCDFDataType(DataType type, boolean unsigned) {
        if (DataType.BOOLEAN.equals((Object)type) || DataType.BYTE.equals((Object)type)) {
            return 0;
        }
        if (DataType.CHAR.equals((Object)type)) {
            return 1;
        }
        if (DataType.SHORT.equals((Object)type)) {
            return unsigned ? 1 : 2;
        }
        if (DataType.INT.equals((Object)type)) {
            return 3;
        }
        if (DataType.FLOAT.equals((Object)type)) {
            return 4;
        }
        if (DataType.LONG.equals((Object)type) || DataType.DOUBLE.equals((Object)type)) {
            return 5;
        }
        return 32;
    }

    public static boolean isVariableAccepted(Variable var, CheckType checkType) {
        if (var instanceof CoordinateAxis1D) {
            return false;
        }
        if (checkType == CheckType.NOSCALARS) {
            List dimensions = var.getDimensions();
            if (dimensions.size() < 2) {
                return false;
            }
            DataType dataType = var.getDataType();
            if (dataType == DataType.CHAR) {
                return false;
            }
            return NetCDFUtilities.isVariableAccepted(var.getFullName(), CheckType.NONE);
        }
        if (checkType == CheckType.ONLYGEOGRIDS) {
            List dimensions = var.getDimensions();
            if (dimensions.size() < 2) {
                return false;
            }
            int twoDimensionalCoordinates = 0;
            for (Dimension dimension : dimensions) {
                String dimName = dimension.getFullName();
                Group group = dimension.getGroup();
                if (group == null) {
                    return false;
                }
                Variable dimVariable = group.findVariable(dimName);
                if (dimVariable == null) {
                    return false;
                }
                if (!(dimVariable instanceof CoordinateAxis1D)) continue;
                CoordinateAxis1D axis = (CoordinateAxis1D)dimVariable;
                AxisType axisType = axis.getAxisType();
                if (axisType == null) {
                    return false;
                }
                switch (axisType) {
                    case GeoX: 
                    case GeoY: 
                    case Lat: 
                    case Lon: {
                        ++twoDimensionalCoordinates;
                        break;
                    }
                }
            }
            if (twoDimensionalCoordinates < 2) {
                return false;
            }
            DataType dataType = var.getDataType();
            if (dataType == DataType.CHAR) {
                return false;
            }
            return NetCDFUtilities.isVariableAccepted(var.getFullName(), CheckType.NONE);
        }
        return NetCDFUtilities.isVariableAccepted(var.getFullName(), checkType);
    }

    public static boolean isVariableAccepted(String name, CheckType checkType) {
        if (checkType == CheckType.NONE) {
            return true;
        }
        return !name.equalsIgnoreCase(LATITUDE) && !name.equalsIgnoreCase(LONGITUDE) && !name.equalsIgnoreCase(LON) && !name.equalsIgnoreCase(LAT) && !name.equalsIgnoreCase(TIME) && !name.equalsIgnoreCase(DEPTH) && !name.equalsIgnoreCase(ZETA) && !name.equalsIgnoreCase(HEIGHT) && !name.toLowerCase().contains(COORDSYS.toLowerCase()) && !name.endsWith(BOUNDS) && !name.endsWith(BNDS) && !UNSUPPORTED_DIMENSIONS.contains(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetcdfDataset getDataset(Object input) throws IOException {
        NetcdfDataset dataset = null;
        if (input instanceof File) {
            File file = (File)input;
            if (file.isDirectory()) throw new IllegalArgumentException("Error occurred during NetCDF file reading: The input file is a Directory.");
            return NetcdfDataset.acquireDataset((String)file.getPath(), null);
        }
        if (input instanceof String) {
            File file = new File((String)input);
            if (file.isDirectory()) throw new IllegalArgumentException("Error occurred during NetCDF file reading: The input file is a Directory.");
            return NetcdfDataset.acquireDataset((String)file.getPath(), null);
        }
        if (input instanceof URL) {
            URL tempURL = (URL)input;
            String protocol = tempURL.getProtocol();
            if (protocol.equalsIgnoreCase("file")) {
                File file = ImageIOUtilities.urlToFile((URL)tempURL);
                if (file.isDirectory()) throw new IllegalArgumentException("Error occurred during NetCDF file reading: The input file is a Directory.");
                return NetcdfDataset.acquireDataset((String)file.getPath(), null);
            }
            if (protocol.equalsIgnoreCase("http")) return NetcdfDataset.acquireDataset((String)tempURL.toExternalForm(), null);
            if (!protocol.equalsIgnoreCase("dods")) return dataset;
            return NetcdfDataset.acquireDataset((String)tempURL.toExternalForm(), null);
        }
        if (input instanceof URIImageInputStream) {
            URIImageInputStream uriInStream = (URIImageInputStream)input;
            return NetcdfDataset.acquireDataset((String)uriInStream.getUri().toString(), null);
        }
        if (!(input instanceof AccessibleStream)) return dataset;
        AccessibleStream stream = (AccessibleStream)input;
        if (!stream.getBinding().isAssignableFrom(File.class)) throw new IllegalArgumentException("Error occurred during NetCDF file reading: The input file is a Directory.");
        File file = (File)((AccessibleStream)input).getTarget();
        if (file.isDirectory()) return dataset;
        return NetcdfDataset.acquireDataset((String)file.getPath(), null);
    }

    public static File getFile(Object input) throws IOException {
        AccessibleStream stream;
        File guessedFile = null;
        if (input instanceof File) {
            guessedFile = (File)input;
        } else if (input instanceof String) {
            guessedFile = new File((String)input);
        } else if (input instanceof URL) {
            URL tempURL = (URL)input;
            String protocol = tempURL.getProtocol();
            if (protocol.equalsIgnoreCase("file")) {
                guessedFile = ImageIOUtilities.urlToFile((URL)tempURL);
            }
        } else if (input instanceof URIImageInputStream) {
            URIImageInputStream uriInStream = (URIImageInputStream)input;
            String uri = uriInStream.getUri().toString();
            guessedFile = new File(uri);
        } else if (input instanceof AccessibleStream && (stream = (AccessibleStream)input).getBinding().isAssignableFrom(File.class)) {
            guessedFile = (File)((AccessibleStream)input).getTarget();
        }
        if (guessedFile.exists() && !guessedFile.isDirectory()) {
            return guessedFile;
        }
        return null;
    }

    public static Format getAxisFormat(AxisType type, String prototype) {
        if (!type.equals((Object)AxisType.Time)) {
            return NumberFormat.getNumberInstance(Locale.CANADA);
        }
        char dateSeparator = '-';
        boolean yearLast = false;
        boolean namedMonth = false;
        boolean addT = false;
        boolean appendZ = false;
        int dateLength = 0;
        if (prototype != null) {
            char c;
            int field = 1;
            int digitCount = 0;
            int length = prototype.length();
            for (int i = 0; i < length && !Character.isWhitespace(c = prototype.charAt(i)); ++i) {
                if (Character.isDigit(c)) {
                    ++digitCount;
                    ++dateLength;
                    continue;
                }
                if (field == 2 && Character.isLetter(c)) {
                    namedMonth = true;
                    continue;
                }
                if (field == 1) {
                    dateSeparator = c;
                    ++dateLength;
                }
                if (c == 'T') {
                    addT = true;
                }
                if (c == 'Z' && i == length - 1) {
                    appendZ = true;
                }
                digitCount = 0;
                ++field;
            }
            if (digitCount >= 4) {
                yearLast = true;
            }
        }
        String pattern = null;
        if (yearLast) {
            pattern = namedMonth ? "dd-MMM-yyyy" : "dd-MM-yyyy";
        } else {
            String string = pattern = namedMonth ? "yyyy-MMM-dd" : "yyyy-MM-dd";
            if (dateLength < 10) {
                pattern = pattern.substring(0, dateLength);
            }
        }
        pattern = pattern.replace('-', dateSeparator);
        int lastColon = prototype.lastIndexOf(":");
        if (lastColon != -1) {
            pattern = pattern + (addT ? "'T'" : " ");
            pattern = pattern + (prototype != null && lastColon >= 16 ? "HH:mm:ss" : "HH:mm");
        }
        pattern = pattern + (appendZ ? "'Z'" : "");
        SimpleDateFormat format = new SimpleDateFormat(pattern, Locale.CANADA);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    public static CheckType getCheckType(NetcdfDataset dataset) {
        CheckType ct = CheckType.UNSET;
        if (dataset != null) {
            ct = CheckType.ONLYGEOGRIDS;
        }
        return ct;
    }

    public static SimpleFeatureType createFeatureType(String schemaName, String schemaDef, CoordinateReferenceSystem crs) {
        SimpleFeatureType indexSchema = null;
        if (schemaDef == null) {
            throw new IllegalArgumentException("Unable to create feature type from null definition!");
        }
        schemaDef = schemaDef.trim();
        try {
            indexSchema = DataUtilities.createType((String)schemaName, (String)schemaDef);
            indexSchema = DataUtilities.createSubType((SimpleFeatureType)indexSchema, (String[])DataUtilities.attributeNames((SimpleFeatureType)indexSchema), (CoordinateReferenceSystem)crs);
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            indexSchema = null;
        }
        return indexSchema;
    }

    public static boolean isGribAvailable() {
        return IS_GRIB_AVAILABLE;
    }

    public static boolean isNC4CAvailable() {
        return IS_NC4_LIBRARY_AVAILABLE;
    }

    public static Set<String> getUnsupportedDimensions() {
        return Collections.unmodifiableSet(UNSUPPORTED_DIMENSIONS);
    }

    public static Number getNodata(Variable var) {
        if (var != null) {
            List attributes = var.getAttributes();
            for (Attribute attribute : attributes) {
                String fullName = attribute.getFullName();
                if (!fullName.equalsIgnoreCase(FILL_VALUE) && !fullName.equalsIgnoreCase(MISSING_VALUE)) continue;
                return attribute.getNumericValue();
            }
        }
        return null;
    }

    public static DataType getNetCDFDataType(String classDataType) {
        if (NetCDFUtilities.isATime(classDataType)) {
            return DataType.DOUBLE;
        }
        if (classDataType.endsWith("Integer")) {
            return DataType.INT;
        }
        if (classDataType.endsWith("Double")) {
            return DataType.DOUBLE;
        }
        if (classDataType.endsWith("String")) {
            return DataType.STRING;
        }
        return DataType.STRING;
    }

    public static DataType transcodeImageDataType(int dataType) {
        switch (dataType) {
            case 0: {
                return DataType.BYTE;
            }
            case 2: {
                return DataType.SHORT;
            }
            case 3: {
                return DataType.INT;
            }
            case 5: {
                return DataType.DOUBLE;
            }
            case 4: {
                return DataType.FLOAT;
            }
        }
        throw new IllegalArgumentException("Invalid input data type:" + dataType);
    }

    public static final boolean isATime(String classDataType) {
        return classDataType.endsWith("Timestamp") || classDataType.endsWith("Date");
    }

    public static Array getArray(int[] dimensions, DataType varDataType) {
        if (dimensions == null) {
            throw new IllegalArgumentException("Illegal dimensions");
        }
        int nDims = dimensions.length;
        switch (nDims) {
            case 6: {
                if (varDataType == DataType.FLOAT) {
                    return new ArrayFloat.D6(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4], dimensions[5]);
                }
                if (varDataType == DataType.DOUBLE) {
                    return new ArrayDouble.D6(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4], dimensions[5]);
                }
                if (varDataType == DataType.BYTE) {
                    return new ArrayByte.D6(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4], dimensions[5]);
                }
                if (varDataType == DataType.SHORT) {
                    return new ArrayShort.D6(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4], dimensions[5]);
                }
                if (varDataType == DataType.INT) {
                    return new ArrayInt.D6(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4], dimensions[5]);
                }
                throw new IllegalArgumentException("unsupported Datatype");
            }
            case 5: {
                if (varDataType == DataType.FLOAT) {
                    return new ArrayFloat.D5(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4]);
                }
                if (varDataType == DataType.DOUBLE) {
                    return new ArrayDouble.D5(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4]);
                }
                if (varDataType == DataType.BYTE) {
                    return new ArrayByte.D5(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4]);
                }
                if (varDataType == DataType.SHORT) {
                    return new ArrayShort.D5(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4]);
                }
                if (varDataType == DataType.INT) {
                    return new ArrayInt.D5(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4]);
                }
                throw new IllegalArgumentException("unsupported Datatype");
            }
            case 4: {
                if (varDataType == DataType.FLOAT) {
                    return new ArrayFloat.D4(dimensions[0], dimensions[1], dimensions[2], dimensions[3]);
                }
                if (varDataType == DataType.DOUBLE) {
                    return new ArrayDouble.D4(dimensions[0], dimensions[1], dimensions[2], dimensions[3]);
                }
                if (varDataType == DataType.BYTE) {
                    return new ArrayByte.D4(dimensions[0], dimensions[1], dimensions[2], dimensions[3]);
                }
                if (varDataType == DataType.SHORT) {
                    return new ArrayShort.D4(dimensions[0], dimensions[1], dimensions[2], dimensions[3]);
                }
                if (varDataType == DataType.INT) {
                    return new ArrayInt.D4(dimensions[0], dimensions[1], dimensions[2], dimensions[3]);
                }
                throw new IllegalArgumentException("unsupported Datatype");
            }
            case 3: {
                if (varDataType == DataType.FLOAT) {
                    return new ArrayFloat.D3(dimensions[0], dimensions[1], dimensions[2]);
                }
                if (varDataType == DataType.DOUBLE) {
                    return new ArrayDouble.D3(dimensions[0], dimensions[1], dimensions[2]);
                }
                if (varDataType == DataType.BYTE) {
                    return new ArrayByte.D3(dimensions[0], dimensions[1], dimensions[2]);
                }
                if (varDataType == DataType.SHORT) {
                    return new ArrayShort.D3(dimensions[0], dimensions[1], dimensions[2]);
                }
                if (varDataType == DataType.INT) {
                    return new ArrayInt.D3(dimensions[0], dimensions[1], dimensions[2]);
                }
                throw new IllegalArgumentException("unsupported Datatype");
            }
            case 2: {
                if (varDataType == DataType.FLOAT) {
                    return new ArrayFloat.D2(dimensions[0], dimensions[1]);
                }
                if (varDataType == DataType.DOUBLE) {
                    return new ArrayDouble.D2(dimensions[0], dimensions[1]);
                }
                if (varDataType == DataType.BYTE) {
                    return new ArrayByte.D2(dimensions[0], dimensions[1]);
                }
                if (varDataType == DataType.SHORT) {
                    return new ArrayShort.D2(dimensions[0], dimensions[1]);
                }
                if (varDataType == DataType.INT) {
                    return new ArrayInt.D2(dimensions[0], dimensions[1]);
                }
                throw new IllegalArgumentException("unsupported Datatype");
            }
            case 1: {
                if (varDataType == DataType.FLOAT) {
                    return new ArrayFloat.D1(dimensions[0]);
                }
                if (varDataType == DataType.DOUBLE) {
                    return new ArrayDouble.D1(dimensions[0]);
                }
                if (varDataType == DataType.BYTE) {
                    return new ArrayByte.D1(dimensions[0]);
                }
                if (varDataType == DataType.SHORT) {
                    return new ArrayShort.D1(dimensions[0]);
                }
                if (varDataType == DataType.INT) {
                    return new ArrayInt.D1(dimensions[0]);
                }
                throw new IllegalArgumentException("unsupported Datatype");
            }
        }
        throw new IllegalArgumentException("Unable to create a proper array unsupported Datatype");
    }

    public static Number transcodeNumber(DataType type, Number value) {
        if (DataType.DOUBLE.equals((Object)type)) {
            return value.doubleValue();
        }
        if (DataType.FLOAT.equals((Object)type)) {
            return Float.valueOf(value.floatValue());
        }
        if (DataType.LONG.equals((Object)type)) {
            return value.longValue();
        }
        if (DataType.INT.equals((Object)type)) {
            return value.intValue();
        }
        if (DataType.SHORT.equals((Object)type)) {
            return value.shortValue();
        }
        if (DataType.BYTE.equals((Object)type)) {
            return value.byteValue();
        }
        throw new IllegalArgumentException("Unsupported type or value: type = " + type.toString() + " value = " + value);
    }

    static {
        String dir;
        File file;
        LOGGER = Logger.getLogger(NetCDFUtilities.class.toString());
        ELEVATION_DIM = ImageMosaicFormat.ELEVATION.getName().toString();
        TIME_DIM = ImageMosaicFormat.TIME.getName().toString();
        EXCLUDED_ATTRIBUTES = new HashSet<String>();
        VALID_TYPES = new HashSet<DataType>(12);
        GregorianCalendar calendar = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
        UTC = TimeZone.getTimeZone("UTC");
        calendar.setTimeZone(UTC);
        START_TIME = calendar.getTimeInMillis();
        EXCLUDED_ATTRIBUTES.add(UNITS);
        EXCLUDED_ATTRIBUTES.add(LONG_NAME);
        EXCLUDED_ATTRIBUTES.add(DESCRIPTION);
        EXCLUDED_ATTRIBUTES.add(STANDARD_NAME);
        NetcdfDataset.setDefaultEnhanceMode(EnumSet.of(NetcdfDataset.Enhance.CoordSystems));
        UNSUPPORTED_DIMENSIONS = new HashSet<String>();
        UNSUPPORTED_DIMENSIONS.add("OSEQD");
        VALID_TYPES.add(DataType.BOOLEAN);
        VALID_TYPES.add(DataType.BYTE);
        VALID_TYPES.add(DataType.SHORT);
        VALID_TYPES.add(DataType.INT);
        VALID_TYPES.add(DataType.LONG);
        VALID_TYPES.add(DataType.FLOAT);
        VALID_TYPES.add(DataType.DOUBLE);
        String externalDir = System.getProperty(NETCDF_DATA_DIR);
        String finalDir = null;
        if (externalDir != null && NetCDFUtilities.isValidDir(file = new File(dir = externalDir))) {
            finalDir = dir;
        }
        EXTERNAL_DATA_DIR = finalDir;
        try {
            Class.forName("ucar.nc2.grib.collection.GribIosp");
            Class.forName("org.geotools.coverage.io.grib.GribUtilities");
            IS_GRIB_AVAILABLE = true;
        }
        catch (ClassNotFoundException cnf) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No Grib library found on classpath. GRIB will not be supported");
            }
            IS_GRIB_AVAILABLE = false;
        }
        IS_NC4_LIBRARY_AVAILABLE = Nc4Iosp.isClibraryPresent();
        if (!IS_NC4_LIBRARY_AVAILABLE && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(NC4_ERROR_MESSAGE);
        }
    }

    public static enum CheckType {
        NONE,
        UNSET,
        NOSCALARS,
        ONLYGEOGRIDS;

    }

    public static enum Axis {
        X,
        Y,
        Z,
        T;

    }
}

