/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf.cv;

import java.io.IOException;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.imageio.netcdf.cv.CoordinateVariable;
import org.geotools.imageio.netcdf.utilities.NetCDFCRSUtilities;
import org.geotools.imageio.netcdf.utilities.NetCDFTimeUtilities;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;
import ucar.nc2.Attribute;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;

class TimeCoordinateVariable
extends CoordinateVariable<Date> {
    private static final Logger LOGGER = Logger.getLogger(TimeCoordinateVariable.class.toString());
    private final TimeBuilder timeBuilder;
    private TemporalCRS temporalCRS;

    public TimeCoordinateVariable(CoordinateAxis1D coordinateAxis) {
        super(Date.class, coordinateAxis);
        this.timeBuilder = new TimeBuilder(coordinateAxis);
    }

    @Override
    public Date getMinimum() throws IOException {
        return this.timeBuilder.buildTime(0);
    }

    @Override
    public Date getMaximum() throws IOException {
        return this.timeBuilder.buildTime(this.timeBuilder.getNumTimes() - 1);
    }

    @Override
    public Date read(int index) throws IndexOutOfBoundsException {
        return this.timeBuilder.buildTime(index);
    }

    @Override
    public List<Date> read() throws IndexOutOfBoundsException {
        return new AbstractList<Date>(){

            @Override
            public Date get(int index) {
                return TimeCoordinateVariable.this.timeBuilder.buildTime(index);
            }

            @Override
            public int size() {
                return TimeCoordinateVariable.this.timeBuilder.getNumTimes();
            }
        };
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        if (this.temporalCRS == null) {
            TimeCoordinateVariable timeCoordinateVariable = this;
            synchronized (timeCoordinateVariable) {
                this.temporalCRS = NetCDFCRSUtilities.buildTemporalCrs((CoordinateAxis)this.coordinateAxis);
            }
        }
        return this.temporalCRS;
    }

    private static class TimeBuilder {
        String units;
        String origin;
        Date epoch;
        CoordinateAxis1D axis1D;
        int baseTimeUnits;

        public TimeBuilder(CoordinateAxis1D axis) {
            this.axis1D = axis;
            this.units = axis.getUnitsString();
            this.origin = null;
            String[] unitsParts = this.units.split("(?i)\\s+since\\s+");
            if (unitsParts.length == 2) {
                this.units = unitsParts[0].trim();
                this.origin = unitsParts[1].trim();
            } else {
                Attribute attribute = axis.findAttribute("time_origin");
                if (attribute != null) {
                    this.origin = attribute.getStringValue();
                }
            }
            this.baseTimeUnits = NetCDFTimeUtilities.getTimeUnits(this.units, null);
            if (this.baseTimeUnits == -1) {
                throw new IllegalArgumentException("Couldn't determine time units from unit string '" + this.units + "'");
            }
            if (this.origin != null) {
                this.origin = NetCDFTimeUtilities.trimFractionalPart(this.origin);
                this.origin = NetCDFTimeUtilities.checkDateDigits(this.origin);
                try {
                    this.epoch = (Date)NetCDFUtilities.getAxisFormat(AxisType.Time, this.origin).parseObject(this.origin);
                }
                catch (ParseException e) {
                    LOGGER.warning("Error while parsing time Axis. Skip setting the TemporalExtent from coordinateAxis");
                }
            }
        }

        public Date buildTime(int timeIndex) {
            if (this.epoch != null) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(this.epoch);
                ((Calendar)cal).setTimeZone(NetCDFTimeUtilities.UTC_TIMEZONE);
                double coordValue = this.axis1D.getCoordValue(timeIndex);
                long vi = (long)Math.floor(coordValue);
                double vd = coordValue - (double)vi;
                NetCDFTimeUtilities.addTimeUnit((Calendar)cal, this.baseTimeUnits, vi);
                if (vd != 0.0) {
                    NetCDFTimeUtilities.addTimeUnit((Calendar)cal, NetCDFTimeUtilities.getTimeUnits(this.units, vd), NetCDFTimeUtilities.getTimeSubUnitsValue(this.units, vd));
                }
                return cal.getTime();
            }
            return null;
        }

        public int getNumTimes() {
            return this.axis1D.getShape(0);
        }
    }
}

