/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf.cv;

import java.io.IOException;
import java.util.AbstractList;
import java.util.List;
import org.geotools.imageio.netcdf.cv.CoordinateVariable;
import org.geotools.imageio.netcdf.utilities.NetCDFCRSUtilities;
import org.geotools.util.Converter;
import org.geotools.util.NumericConverterFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import ucar.nc2.Attribute;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;

class NumericCoordinateVariable<T extends Number>
extends CoordinateVariable<T> {
    private double scaleFactor = Double.NaN;
    private double offsetFactor = Double.NaN;
    private Converter converter;
    private CoordinateReferenceSystem crs;
    private static final NumericConverterFactory CONVERTER_FACTORY = new NumericConverterFactory();

    public NumericCoordinateVariable(Class<T> binding, CoordinateAxis1D coordinateAxis) {
        super(binding, coordinateAxis);
        Attribute offsetFactor;
        if (!coordinateAxis.isNumeric()) {
            throw new IllegalArgumentException("Unable to process non numeric coordinate variable: " + coordinateAxis.toString());
        }
        Attribute scaleFactor = coordinateAxis.findAttribute("scale_factor");
        if (scaleFactor != null) {
            this.scaleFactor = scaleFactor.getNumericValue().doubleValue();
        }
        if ((offsetFactor = coordinateAxis.findAttribute("offset")) != null) {
            this.offsetFactor = offsetFactor.getNumericValue().doubleValue();
        }
        this.converter = CONVERTER_FACTORY.createConverter(Double.class, this.binding, null);
    }

    @Override
    public T getMinimum() throws IOException {
        try {
            return (T)((Number)this.converter.convert((Object)this.coordinateAxis.getMinValue(), this.binding));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public T getMaximum() throws IOException {
        try {
            return (T)((Number)this.converter.convert((Object)this.coordinateAxis.getMaxValue(), this.binding));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public T read(int index) throws IndexOutOfBoundsException {
        if ((long)index >= this.coordinateAxis.getSize()) {
            throw new IndexOutOfBoundsException("index >= " + this.coordinateAxis.getSize());
        }
        double val = this.handleValues(index);
        try {
            return (T)((Number)this.converter.convert((Object)val, this.binding));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private double handleValues(int index) {
        double val = this.coordinateAxis.getCoordValue(index);
        if (!Double.isNaN(this.scaleFactor)) {
            val *= this.scaleFactor;
        }
        if (!Double.isNaN(this.offsetFactor)) {
            val += this.offsetFactor;
        }
        return val;
    }

    @Override
    public List<T> read() throws IndexOutOfBoundsException {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                double val = NumericCoordinateVariable.this.handleValues(index);
                try {
                    return (Number)NumericCoordinateVariable.this.converter.convert((Object)val, NumericCoordinateVariable.this.binding);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int size() {
                return NumericCoordinateVariable.this.coordinateAxis.getShape()[0];
            }
        };
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        if (this.crs == null) {
            NumericCoordinateVariable numericCoordinateVariable = this;
            synchronized (numericCoordinateVariable) {
                AxisType axisType = this.coordinateAxis.getAxisType();
                switch (axisType) {
                    case GeoZ: 
                    case Height: 
                    case Pressure: {
                        String axisName = this.getName();
                        if (!NetCDFCRSUtilities.VERTICAL_AXIS_NAMES.contains(axisName)) break;
                        this.crs = NetCDFCRSUtilities.buildVerticalCrs((CoordinateAxis)this.coordinateAxis);
                    }
                }
            }
        }
        return this.crs;
    }
}

