/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf.cv;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.imageio.netcdf.cv.NumericCoordinateVariable;
import org.geotools.imageio.netcdf.cv.TimeCoordinateVariable;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis1D;

public abstract class CoordinateVariable<T> {
    private static final Logger LOGGER = Logging.getLogger(CoordinateVariable.class);
    protected final Class<T> binding;
    protected final CoordinateAxis1D coordinateAxis;

    public static Class<?> suggestBinding(CoordinateAxis1D coordinateAxis) {
        Utilities.ensureNonNull((String)"coordinateAxis", (Object)coordinateAxis);
        AxisType axisType = coordinateAxis.getAxisType();
        switch (axisType) {
            case GeoX: 
            case GeoY: 
            case GeoZ: 
            case Height: 
            case Lat: 
            case Lon: 
            case Pressure: 
            case Spectral: {
                DataType dataType = coordinateAxis.getDataType();
                Attribute scaleFactor = coordinateAxis.findAttribute("scale_factor");
                Attribute offsetFactor = coordinateAxis.findAttribute("offset");
                if (scaleFactor != null || offsetFactor != null) {
                    return Double.class;
                }
                switch (dataType) {
                    case DOUBLE: {
                        return Double.class;
                    }
                    case BYTE: {
                        return Byte.class;
                    }
                    case FLOAT: {
                        return Float.class;
                    }
                    case INT: {
                        return Integer.class;
                    }
                    case LONG: {
                        return Long.class;
                    }
                    case SHORT: {
                        return Short.class;
                    }
                }
                break;
            }
            case Time: 
            case RunTime: {
                LOGGER.log(Level.FINE, "Date mapping for axis:" + coordinateAxis.toString());
                return Date.class;
            }
        }
        LOGGER.log(Level.FINE, "Unable to find mapping for axis:" + coordinateAxis.toString());
        return null;
    }

    public static CoordinateVariable<?> create(CoordinateAxis1D coordinateAxis) {
        Utilities.ensureNonNull((String)"coordinateAxis", (Object)coordinateAxis);
        if (!coordinateAxis.isNumeric()) {
            throw new IllegalArgumentException("Unable to process non numeric coordinate variable: " + coordinateAxis.toString());
        }
        AxisType axisType = coordinateAxis.getAxisType();
        switch (axisType) {
            case GeoX: 
            case GeoY: 
            case GeoZ: 
            case Height: 
            case Lat: 
            case Lon: 
            case Pressure: 
            case Spectral: {
                return new NumericCoordinateVariable(CoordinateVariable.suggestBinding(coordinateAxis), coordinateAxis);
            }
            case Time: 
            case RunTime: {
                return new TimeCoordinateVariable(coordinateAxis);
            }
        }
        throw new IllegalArgumentException("Unsupported axis type: " + axisType + " for coordinate variable: " + coordinateAxis.toStringDebug());
    }

    public CoordinateVariable(Class<T> binding, CoordinateAxis1D coordinateAxis) {
        Utilities.ensureNonNull((String)"coordinateAxis", (Object)coordinateAxis);
        Utilities.ensureNonNull((String)"binding", binding);
        this.binding = binding;
        this.coordinateAxis = coordinateAxis;
    }

    public Class<T> getType() {
        return this.binding;
    }

    public String getUnit() {
        return this.coordinateAxis.getUnitsString();
    }

    public CoordinateAxis1D unwrap() {
        return this.coordinateAxis;
    }

    public AxisType getAxisType() {
        return this.coordinateAxis.getAxisType();
    }

    public String getName() {
        return this.coordinateAxis.getShortName();
    }

    public long getSize() throws IOException {
        return this.coordinateAxis.getSize();
    }

    public boolean isRegular() {
        return this.coordinateAxis.isRegular();
    }

    public double getIncrement() {
        return this.coordinateAxis.getIncrement();
    }

    public double getStart() {
        return this.coordinateAxis.getStart();
    }

    public abstract boolean isNumeric();

    public abstract T getMinimum() throws IOException;

    public abstract T getMaximum() throws IOException;

    public abstract T read(int var1) throws IndexOutOfBoundsException;

    public abstract List<T> read() throws IndexOutOfBoundsException;

    public String toString() {
        try {
            return "CoordinateVariable [binding=" + this.binding + ", coordinateAxis=" + this.coordinateAxis + ", getType()=" + this.getType() + ", getUnit()=" + this.getUnit() + ", getAxisType()=" + this.getAxisType() + ", getName()=" + this.getName() + ", getSize()=" + this.getSize() + ", isRegular()=" + this.isRegular() + ", getIncrement()=" + this.getIncrement() + ", getStart()=" + this.getStart() + ", isNumeric()=" + this.isNumeric() + ", getMinimum()=" + this.getMinimum() + ", getMaximum()=" + this.getMaximum() + "]";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }
}

