/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BandedSampleModel;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.DefaultDimensionDescriptor;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.io.CoverageSource;
import org.geotools.coverage.io.CoverageSourceDescriptor;
import org.geotools.coverage.io.RasterLayout;
import org.geotools.coverage.io.catalog.CoverageSlicesCatalog;
import org.geotools.coverage.io.range.impl.DefaultFieldType;
import org.geotools.coverage.io.range.impl.DefaultRangeType;
import org.geotools.coverage.io.util.DateRangeComparator;
import org.geotools.coverage.io.util.DateRangeTreeSet;
import org.geotools.coverage.io.util.DoubleRangeTreeSet;
import org.geotools.coverage.io.util.NumberRangeComparator;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.factory.GeoTools;
import org.geotools.feature.NameImpl;
import org.geotools.gce.imagemosaic.catalog.index.Indexer;
import org.geotools.gce.imagemosaic.catalog.index.SchemaType;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.imageio.netcdf.NetCDFImageReader;
import org.geotools.imageio.netcdf.Slice2DIndex;
import org.geotools.imageio.netcdf.cv.CoordinateVariable;
import org.geotools.imageio.netcdf.utilities.NetCDFCRSUtilities;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.geometry.BoundingBox;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.util.InternationalString;
import org.opengis.util.ProgressListener;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public class VariableAdapter
extends CoverageSourceDescriptor {
    final VariableDS variableDS;
    private CoordinateSystem coordinateSystem;
    private NetCDFImageReader reader;
    private int numBands;
    private int rank;
    private SampleModel sampleModel;
    private int numberOfSlices;
    private int width;
    private int height;
    private CoordinateReferenceSystem coordinateReferenceSystem;
    private int[] shape;
    private Name coverageName;
    private SimpleFeatureType indexSchema;
    private static final Logger LOGGER = Logging.getLogger(VariableAdapter.class);
    private static final int FIRST_ATTRIBUTE_INDEX = 2;

    private void init() throws Exception {
        this.initSpatialElements();
        this.initRange();
        this.initSlicesInfo();
    }

    private void initSlicesInfo() throws Exception {
        this.shape = this.variableDS.getShape();
        switch (this.shape.length) {
            case 2: {
                this.numberOfSlices = 1;
                break;
            }
            case 3: {
                this.numberOfSlices = this.shape[0];
                break;
            }
            case 4: {
                this.numberOfSlices = 0 + this.shape[0] * this.shape[1];
                break;
            }
            default: {
                if (!LOGGER.isLoggable(Level.WARNING)) break;
                LOGGER.warning("Ignoring variable: " + this.getName() + " with shape length: " + this.shape.length);
            }
        }
    }

    private void initSpatialElements() throws Exception {
        ArrayList<DimensionDescriptor> dimensions = new ArrayList<DimensionDescriptor>();
        List<CoordinateVariable<?>> otherAxes = this.initCRS(dimensions);
        this.initSpatialDomain();
        this.addAdditionalDomain(otherAxes, dimensions);
        this.setDimensionDescriptors(dimensions);
        if (this.reader.ancillaryFileManager.isImposedSchema()) {
            this.updateDimensions(this.getDimensionDescriptors());
        }
    }

    private void updateDimensions(List<DimensionDescriptor> dimensionDescriptors) throws IOException {
        Map<Name, String> mapping = this.reader.ancillaryFileManager.variablesMap;
        Set<Name> keys = mapping.keySet();
        String varName = this.getName();
        for (Name key : keys) {
            String origName = mapping.get(key);
            if (!origName.equalsIgnoreCase(varName)) continue;
            String coverageName = key.getLocalPart();
            Indexer.Coverages.Coverage coverage = this.reader.ancillaryFileManager.coveragesMapping.get(coverageName);
            SchemaType schema = coverage.getSchema();
            if (schema == null) break;
            String schName = schema.getName();
            CoverageSlicesCatalog catalog = this.reader.getCatalog();
            if (catalog == null) break;
            SimpleFeatureType schemaType = null;
            try {
                if (schName != null) {
                    schemaType = catalog.getSchema(schName);
                }
            }
            catch (IOException e) {
                schemaType = catalog.getSchema(coverageName);
            }
            if (schemaType != null) {
                this.updateMapping(schemaType, dimensionDescriptors);
                this.indexSchema = schemaType;
                break;
            }
            throw new IllegalStateException("Unable to find the table for this coverage: " + coverageName);
        }
    }

    public void updateMapping(SimpleFeatureType indexSchema, List<DimensionDescriptor> descriptors) throws IOException {
        Map<String, String> dimensionsMapping = this.reader.dimensionsMapping;
        Set<String> keys = dimensionsMapping.keySet();
        int indexAttribute = 2;
        String currentDimName = NetCDFUtilities.TIME_DIM;
        if (keys.contains(currentDimName) && this.remapAttribute(indexSchema, currentDimName, indexAttribute, descriptors, dimensionsMapping)) {
            ++indexAttribute;
        }
        if (keys.contains(currentDimName = NetCDFUtilities.ELEVATION_DIM) && this.remapAttribute(indexSchema, currentDimName, indexAttribute, descriptors, dimensionsMapping)) {
            ++indexAttribute;
        }
    }

    private boolean remapAttribute(SimpleFeatureType indexSchema, String currentDimName, int indexAttribute, List<DimensionDescriptor> descriptors, Map<String, String> dimensionsMapping) {
        int numAttributes = indexSchema.getAttributeCount();
        if (numAttributes <= indexAttribute) {
            return false;
        }
        AttributeDescriptor attributeDescriptor = indexSchema.getDescriptor(indexAttribute);
        for (DimensionDescriptor descriptor : descriptors) {
            if (!descriptor.getName().toUpperCase().equalsIgnoreCase(currentDimName)) continue;
            String updatedAttribute = attributeDescriptor.getLocalName();
            if (!updatedAttribute.equals(((DefaultDimensionDescriptor)descriptor).getStartAttribute())) {
                ((DefaultDimensionDescriptor)descriptor).setStartAttribute(updatedAttribute);
                dimensionsMapping.put(currentDimName, updatedAttribute);
            }
            return true;
        }
        return false;
    }

    private List<CoordinateVariable<?>> initCRS(List<DimensionDescriptor> dimensions) throws IllegalArgumentException, RuntimeException, IOException, IllegalStateException {
        this.coordinateSystem = NetCDFCRSUtilities.getCoordinateSystem(this.variableDS);
        if (this.coordinateSystem == null) {
            throw new IllegalArgumentException("Provided CoordinateSystem is null");
        }
        this.coordinateSystem = new CoordinateSystemAdapter(this.coordinateSystem);
        this.coordinateReferenceSystem = NetCDFCRSUtilities.WGS84;
        ArrayList otherAxes = new ArrayList();
        block5: for (CoordinateAxis axis : this.coordinateSystem.getCoordinateAxes()) {
            CoordinateVariable<?> cv = this.reader.coordinatesVariables.get(axis.getShortName());
            if (cv == null) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("Unable to find a coordinate variable for " + axis.getFullName());
                continue;
            }
            switch (cv.getAxisType()) {
                case Time: 
                case RunTime: {
                    this.initTemporalDomain(cv, dimensions);
                    continue block5;
                }
                case GeoZ: 
                case Height: 
                case Pressure: {
                    String axisName = cv.getName();
                    if (NetCDFCRSUtilities.VERTICAL_AXIS_NAMES.contains(axisName)) {
                        this.initVerticalDomain(cv, dimensions);
                        continue block5;
                    }
                    otherAxes.add(cv);
                    continue block5;
                }
                case GeoX: 
                case GeoY: 
                case Lat: 
                case Lon: {
                    continue block5;
                }
            }
            otherAxes.add(cv);
        }
        return otherAxes;
    }

    private void initVerticalDomain(CoordinateVariable<?> cv, List<DimensionDescriptor> dimensions) throws IOException {
        this.setHasVerticalDomain(true);
        UnidataVerticalDomain verticalDomain = new UnidataVerticalDomain(cv);
        this.setVerticalDomain(verticalDomain);
        dimensions.add((DimensionDescriptor)new DefaultDimensionDescriptor("ELEVATION", cv.getUnit(), CoverageUtilities.UCUM.ELEVATION_UNITS.getSymbol(), cv.getName(), null));
    }

    private void initTemporalDomain(CoordinateVariable<?> cv, List<DimensionDescriptor> dimensions) throws IOException {
        if (!cv.getType().equals(Date.class)) {
            throw new IllegalArgumentException("Unable to init temporal domani from CoordinateVariable that does not bind to Date");
        }
        if (!(cv.getCoordinateReferenceSystem() instanceof TemporalCRS)) {
            throw new IllegalArgumentException("Unable to init temporal domani from CoordinateVariable that does not have a TemporalCRS");
        }
        this.setHasTemporalDomain(true);
        UnidataTemporalDomain temporalDomain = new UnidataTemporalDomain(cv);
        this.setTemporalDomain(temporalDomain);
        dimensions.add((DimensionDescriptor)new DefaultDimensionDescriptor("TIME", CoverageUtilities.UCUM.TIME_UNITS.getName(), CoverageUtilities.UCUM.TIME_UNITS.getSymbol(), cv.getName(), null));
    }

    private void initSpatialDomain() throws Exception {
        UnidataSpatialDomain spatialDomain = new UnidataSpatialDomain();
        this.setSpatialDomain(spatialDomain);
        spatialDomain.setCoordinateReferenceSystem(this.coordinateReferenceSystem);
        spatialDomain.setReferencedEnvelope(this.reader.boundingBox);
        spatialDomain.setGridGeometry(this.getGridGeometry());
    }

    private void initRange() {
        this.rank = this.variableDS.getRank();
        this.width = this.variableDS.getDimension(this.rank - 1).getLength();
        this.height = this.variableDS.getDimension(this.rank - 2).getLength();
        this.numBands = this.rank > 2 ? this.variableDS.getDimension(2).getLength() : 1;
        int bufferType = NetCDFUtilities.getRawDataType((VariableIF)this.variableDS);
        this.sampleModel = new BandedSampleModel(bufferType, this.width, this.height, 1);
        String description = this.variableDS.getDescription();
        if (description == null) {
            description = "";
        }
        StringBuilder sb = new StringBuilder();
        HashSet<SampleDimension> sampleDims = new HashSet<SampleDimension>();
        sampleDims.add((SampleDimension)new GridSampleDimension((CharSequence)(description + ":sd"), (Category[])null, null));
        SimpleInternationalString desc = null;
        if (description != null && !description.isEmpty()) {
            desc = new SimpleInternationalString(description);
        }
        DefaultFieldType fieldType = new DefaultFieldType((Name)new NameImpl(this.getName()), (InternationalString)desc, sampleDims);
        sb.append(!description.isEmpty() ? description.toString() + "," : description);
        DefaultRangeType range = new DefaultRangeType(this.getName(), description, fieldType);
        this.setRangeType(range);
    }

    private void addAdditionalDomain(List<CoordinateVariable<?>> otherAxes, List<DimensionDescriptor> dimensions) {
        if (otherAxes == null || otherAxes.isEmpty()) {
            return;
        }
        ArrayList<CoverageSource.AdditionalDomain> additionalDomains = new ArrayList<CoverageSource.AdditionalDomain>(otherAxes.size());
        this.setAdditionalDomains(additionalDomains);
        for (CoordinateVariable<?> cv : otherAxes) {
            try {
                UnidataAdditionalDomain domain = new UnidataAdditionalDomain(cv);
                additionalDomains.add(domain);
                dimensions.add((DimensionDescriptor)new DefaultDimensionDescriptor(cv.getName(), "FIXME_UNIT", "FIXME_UNITSYMBOL", cv.getName(), null));
                this.setHasAdditionalDomains(true);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    protected GridGeometry2D getGridGeometry() throws IOException {
        int[] low = new int[2];
        int[] high = new int[2];
        double[] origin = new double[2];
        double scaleX = Double.POSITIVE_INFINITY;
        double scaleY = Double.POSITIVE_INFINITY;
        block4: for (CoordinateVariable<?> cv : this.reader.coordinatesVariables.values()) {
            if (!cv.isNumeric()) continue;
            AxisType axisType = cv.getAxisType();
            switch (axisType) {
                case GeoX: 
                case Lon: {
                    double vv;
                    int k;
                    double v;
                    int j;
                    low[0] = 0;
                    high[0] = (int)cv.getSize();
                    if (cv.isRegular()) {
                        origin[0] = cv.getStart();
                        scaleX = cv.getIncrement();
                        break;
                    }
                    int valuesLength = (int)cv.getSize();
                    double min = ((Number)cv.getMinimum()).doubleValue();
                    double max = ((Number)cv.getMaximum()).doubleValue();
                    if (!Double.isNaN(min) && !Double.isNaN(max)) {
                        origin[0] = min;
                        scaleX = (max - min) / (double)valuesLength;
                        break;
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Axis values contains NaN; finding first valid values");
                    }
                    for (j = 0; j < valuesLength; ++j) {
                        v = ((Number)cv.read(j)).doubleValue();
                        if (Double.isNaN(v)) continue;
                        for (k = valuesLength; k > j; --k) {
                            vv = ((Number)cv.read(k)).doubleValue();
                            if (Double.isNaN(vv)) continue;
                            origin[0] = v;
                            scaleX = (vv - v) / (double)valuesLength;
                        }
                    }
                    continue block4;
                }
                case GeoY: 
                case Lat: {
                    double vv;
                    int k;
                    double v;
                    int j;
                    low[1] = 0;
                    high[1] = (int)cv.getSize();
                    if (cv.isRegular()) {
                        if (cv.getIncrement() > 0.0) {
                            scaleY = -cv.getIncrement();
                            origin[1] = cv.getStart() - scaleY * (double)(high[1] - 1);
                            break;
                        }
                        scaleY = cv.getIncrement();
                        origin[1] = cv.getStart();
                        break;
                    }
                    int valuesLength = (int)cv.getSize();
                    double min = ((Number)cv.getMinimum()).doubleValue();
                    double max = ((Number)cv.getMaximum()).doubleValue();
                    if (!Double.isNaN(min) && !Double.isNaN(max)) {
                        scaleY = -(max - min) / (double)valuesLength;
                        origin[1] = max;
                        break;
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Axis values contains NaN; finding first valid values");
                    }
                    for (j = 0; j < valuesLength; ++j) {
                        v = ((Number)cv.read(j)).doubleValue();
                        if (Double.isNaN(v)) continue;
                        for (k = valuesLength; k > j; --k) {
                            vv = ((Number)cv.read(k)).doubleValue();
                            if (Double.isNaN(vv)) continue;
                            origin[1] = v;
                            scaleY = -(vv - v) / (double)valuesLength;
                        }
                    }
                    continue block4;
                }
            }
        }
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, scaleY, origin[0], origin[1]);
        GridEnvelope2D gridRange = new GridEnvelope2D(low[0], low[1], high[0] - low[0], high[1] - low[1]);
        LinearTransform raster2Model = ProjectiveTransform.create((AffineTransform)at);
        return new GridGeometry2D((GridEnvelope)gridRange, PixelInCell.CELL_CENTER, (MathTransform)raster2Model, this.coordinateReferenceSystem, GeoTools.getDefaultHints());
    }

    public int getNumBands() {
        return this.numBands;
    }

    public int getRank() {
        return this.rank;
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public VariableAdapter(NetCDFImageReader reader, Name coverageName, VariableDS variable) throws Exception {
        this.variableDS = variable;
        this.reader = reader;
        this.coverageName = coverageName;
        this.setName(variable.getFullName());
        this.init();
    }

    @Override
    public UnidataSpatialDomain getSpatialDomain() {
        return (UnidataSpatialDomain)super.getSpatialDomain();
    }

    @Override
    public UnidataTemporalDomain getTemporalDomain() {
        return (UnidataTemporalDomain)super.getTemporalDomain();
    }

    @Override
    public UnidataVerticalDomain getVerticalDomain() {
        return (UnidataVerticalDomain)super.getVerticalDomain();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getZIndex(int index) {
        if (this.rank > 2) {
            if (this.rank == 3) {
                return index;
            }
            if (this.rank == 4) {
                return index % NetCDFUtilities.getZDimensionLength((Variable)this.variableDS);
            }
            throw new IllegalStateException("Unable to handle more than 4 dimensions");
        }
        return -1;
    }

    public int getTIndex(int index) {
        if (this.rank > 2) {
            if (this.rank == 3) {
                return index;
            }
            return (int)Math.ceil(index / NetCDFUtilities.getZDimensionLength((Variable)this.variableDS));
        }
        return -1;
    }

    public int getNumberOfSlices() {
        return this.numberOfSlices;
    }

    public int[] getShape() {
        return this.shape;
    }

    public void getFeatures(int startIndex, int limit, ListFeatureCollection collection) {
        boolean hasVerticalAxis = this.coordinateSystem.hasVerticalAxis();
        SimpleFeatureType indexSchema = collection.getSchema();
        int bandDimension = this.rank - 3;
        int slicesNum = this.getNumberOfSlices();
        if (startIndex > slicesNum) {
            throw new IllegalArgumentException("The paging start index can't be higher than the number of available slices");
        }
        int lastIndex = startIndex + limit;
        if (lastIndex > slicesNum) {
            lastIndex = slicesNum;
        }
        String varName = this.variableDS.getFullName();
        for (int imageIndex = startIndex; imageIndex < lastIndex; ++imageIndex) {
            int zIndex = -1;
            int tIndex = -1;
            block4: for (int i = 0; i < this.rank; ++i) {
                switch (this.rank - i) {
                    case 1: 
                    case 2: {
                        continue block4;
                    }
                    default: {
                        if (i == bandDimension && hasVerticalAxis) {
                            zIndex = this.getZIndex(imageIndex);
                            continue block4;
                        }
                        tIndex = this.getTIndex(imageIndex);
                    }
                }
            }
            Slice2DIndex variableIndex = new Slice2DIndex(tIndex, zIndex, varName);
            this.reader.ancillaryFileManager.addSlice(variableIndex);
            SimpleFeature feature = this.createFeature((Variable)this.variableDS, this.coverageName.toString(), tIndex, zIndex, this.coordinateSystem, imageIndex, indexSchema);
            collection.add(feature);
        }
    }

    private SimpleFeature createFeature(Variable variable, String coverageName, int tIndex, int zIndex, CoordinateSystem cs, int imageIndex, SimpleFeatureType indexSchema) {
        Date date = this.getTimeValueByIndex(variable, tIndex, cs);
        Number verticalValue = this.getVerticalValueByIndex(variable, zIndex, cs);
        int dimSize = variable.getDimensions().size();
        SimpleFeature feature = DataUtilities.template((SimpleFeatureType)indexSchema);
        feature.setAttribute("the_geom", (Object)NetCDFCRSUtilities.GEOM_FACTORY.toGeometry((Envelope)this.reader.boundingBox));
        feature.setAttribute("imageindex", (Object)imageIndex);
        String timeAttribute = null;
        if (date != null) {
            timeAttribute = this.getTimeAttribute(cs);
            feature.setAttribute(timeAttribute, (Object)date);
        }
        String elevationCVName = this.reader.dimensionsMapping.get(NetCDFUtilities.ELEVATION_DIM);
        if (!Double.isNaN(verticalValue.doubleValue())) {
            List descriptors = indexSchema.getAttributeDescriptors();
            String attribute = null;
            for (AttributeDescriptor descriptor : descriptors) {
                if (!descriptor.getLocalName().equalsIgnoreCase(elevationCVName)) continue;
                attribute = elevationCVName;
                break;
            }
            if (attribute == null) {
                String attrib = null;
                for (int i = 0; i < dimSize; ++i) {
                    attrib = variable.getDimension(i).getShortName();
                    if (attrib.equalsIgnoreCase(timeAttribute)) continue;
                    attribute = attrib;
                    break;
                }
            }
            feature.setAttribute(attribute, (Object)verticalValue);
        }
        return feature;
    }

    private String getTimeAttribute(CoordinateSystem cs) {
        CoordinateAxis timeAxis = cs.getTaxis();
        String name = timeAxis.getFullName();
        String timeAttribute = this.reader.dimensionsMapping.get(name.toUpperCase());
        if (timeAttribute == null) {
            timeAttribute = this.reader.dimensionsMapping.get(NetCDFUtilities.TIME_DIM);
        }
        return timeAttribute;
    }

    private Number getVerticalValueByIndex(Variable variable, int zIndex, CoordinateSystem cs) {
        double ve = Double.NaN;
        if (cs != null && cs.hasVerticalAxis()) {
            int rank = variable.getRank();
            Dimension verticalDimension = variable.getDimension(rank - 3);
            return (Number)this.reader.coordinatesVariables.get(verticalDimension.getFullName()).read(zIndex);
        }
        return ve;
    }

    private Date getTimeValueByIndex(Variable variable, int timeIndex, CoordinateSystem cs) {
        if (cs != null && cs.hasTimeAxis()) {
            int rank = variable.getRank();
            Dimension temporalDimension = variable.getDimension(rank - ((cs.hasVerticalAxis() ? 3 : 2) + 1));
            return (Date)this.reader.coordinatesVariables.get(temporalDimension.getFullName()).read(timeIndex);
        }
        return null;
    }

    static class CoordinateSystemAdapter
    extends CoordinateSystem {
        private CoordinateSystem cs;
        private final boolean vertical;

        CoordinateSystemAdapter(CoordinateSystem cs) {
            this.cs = cs;
            if (cs.hasVerticalAxis()) {
                this.vertical = true;
            } else {
                Set<String> unsupported = NetCDFUtilities.getUnsupportedDimensions();
                boolean present = false;
                for (String dimension : unsupported) {
                    if (!cs.containsAxis(dimension)) continue;
                    present = true;
                    break;
                }
                this.vertical = present;
            }
        }

        public boolean hasVerticalAxis() {
            return this.vertical;
        }

        public boolean hasTimeAxis() {
            return this.cs.hasTimeAxis();
        }

        public CoordinateAxis getTaxis() {
            return this.cs.getTaxis();
        }

        public List<CoordinateAxis> getCoordinateAxes() {
            return this.cs.getCoordinateAxes();
        }
    }

    public class UnidataAdditionalDomain
    extends CoverageSource.AdditionalDomain {
        private final Set<Object> domainExtent = new TreeSet<Object>();
        private final Set<Object> globalDomainExtent = new TreeSet<Object>(new Comparator<Object>(){
            private NumberRangeComparator numberRangeComparator = new NumberRangeComparator();
            private DateRangeComparator dateRangeComparator = new DateRangeComparator();

            @Override
            public int compare(Object o1, Object o2) {
                boolean o1IsDateRange = true;
                boolean o2IsDateRange = true;
                if (o1 instanceof NumberRange) {
                    o1IsDateRange = false;
                } else if (!(o1 instanceof DateRange)) {
                    throw new ClassCastException(o1.getClass() + " is not an known range type");
                }
                if (o2 instanceof NumberRange) {
                    o2IsDateRange = false;
                } else if (!(o2 instanceof DateRange)) {
                    throw new ClassCastException(o2.getClass() + " is not an known range type");
                }
                if (o1IsDateRange && o2IsDateRange) {
                    return this.dateRangeComparator.compare((DateRange)o1, (DateRange)o2);
                }
                if (!o1IsDateRange && !o2IsDateRange) {
                    return this.numberRangeComparator.compare((Range<? extends Number>)((NumberRange)o1), (Range<? extends Number>)((NumberRange)o2));
                }
                throw new ClassCastException("Incompatible range types: " + o1.getClass() + " is not the same as " + o2.getClass());
            }

            @Override
            public boolean equals(Object o) {
                return false;
            }
        });
        private final String name;
        private final CoverageSource.DomainType type;
        final CoordinateVariable<?> adaptee;

        UnidataAdditionalDomain(CoordinateVariable<?> adaptee) throws IOException {
            this.adaptee = adaptee;
            this.name = adaptee.getName();
            Class<?> type = adaptee.getType();
            if (Date.class.isAssignableFrom(type)) {
                this.type = CoverageSource.DomainType.DATE;
                this.globalDomainExtent.add(new DateRange((Date)adaptee.getMinimum(), (Date)adaptee.getMaximum()));
            } else if (Number.class.isAssignableFrom(type)) {
                this.type = CoverageSource.DomainType.NUMBER;
                this.globalDomainExtent.add(new NumberRange(Double.class, (Number)((Number)adaptee.getMinimum()).doubleValue(), (Number)((Number)adaptee.getMaximum()).doubleValue()));
            } else {
                throw new UnsupportedOperationException("Unsupported CoordinateVariable:" + adaptee.toString());
            }
            this.domainExtent.addAll(adaptee.read());
        }

        @Override
        public Set<Object> getElements(boolean overall, ProgressListener listener) throws IOException {
            if (overall) {
                return this.globalDomainExtent;
            }
            return this.domainExtent;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public CoverageSource.DomainType getType() {
            return this.type;
        }

        public Set<Object> getDomainExtent() {
            return this.domainExtent;
        }
    }

    public class UnidataVerticalDomain
    extends CoverageSource.VerticalDomain {
        final CoordinateVariable<? extends Number> adaptee;

        UnidataVerticalDomain(CoordinateVariable<?> cv) {
            if (!Number.class.isAssignableFrom(cv.getType())) {
                throw new IllegalArgumentException("Unable to wrap a non Number CoordinateVariable:" + cv.toString());
            }
            this.adaptee = cv;
        }

        public SortedSet<NumberRange<Double>> getVerticalExtent() {
            NumberRange global;
            CoordinateVariable<? extends Number> verticalDimension = this.adaptee;
            try {
                global = NumberRange.create((double)verticalDimension.getMinimum().doubleValue(), (double)verticalDimension.getMaximum().doubleValue());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            DoubleRangeTreeSet globalVerticalExtent = new DoubleRangeTreeSet();
            globalVerticalExtent.add(global);
            return globalVerticalExtent;
        }

        @Override
        public SortedSet<? extends NumberRange<Double>> getVerticalElements(boolean overall, ProgressListener listener) throws IOException {
            if (overall) {
                TreeSet<Range<? extends Number>> extent = new TreeSet<Range<? extends Number>>(new NumberRangeComparator());
                for (Number number : this.adaptee.read()) {
                    double doubleValue = number.doubleValue();
                    extent.add((Range<? extends Number>)NumberRange.create((double)doubleValue, (double)doubleValue));
                }
                return extent;
            }
            return this.getVerticalExtent();
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return this.adaptee.getCoordinateReferenceSystem();
        }
    }

    public class UnidataTemporalDomain
    extends CoverageSource.TemporalDomain {
        final CoordinateVariable<Date> adaptee;

        UnidataTemporalDomain(CoordinateVariable<?> adaptee) {
            if (!Date.class.isAssignableFrom(adaptee.getType())) {
                throw new IllegalArgumentException("Unable to wrap non temporal CoordinateVariable:" + adaptee.toString());
            }
            this.adaptee = adaptee;
        }

        public SortedSet<DateRange> getTemporalExtent() {
            try {
                Date startTime = this.adaptee.getMinimum();
                Date endTime = this.adaptee.getMaximum();
                DateRange global = new DateRange(startTime, endTime);
                DateRangeTreeSet globalTemporalExtent = new DateRangeTreeSet();
                globalTemporalExtent.add(global);
                return globalTemporalExtent;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public SortedSet<? extends DateRange> getTemporalElements(boolean overall, ProgressListener listener) throws IOException {
            if (overall) {
                TreeSet<DateRange> extent = new TreeSet<DateRange>(new DateRangeComparator());
                for (Date dd : this.adaptee.read()) {
                    extent.add(new DateRange(dd, dd));
                }
                return extent;
            }
            return this.getTemporalExtent();
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return this.adaptee.getCoordinateReferenceSystem();
        }
    }

    public class UnidataSpatialDomain
    extends CoverageSource.SpatialDomain {
        private CoordinateReferenceSystem coordinateReferenceSystem;
        private ReferencedEnvelope referencedEnvelope;
        private GridGeometry2D gridGeometry;

        public ReferencedEnvelope getReferencedEnvelope() {
            return this.referencedEnvelope;
        }

        public void setReferencedEnvelope(ReferencedEnvelope referencedEnvelope) {
            this.referencedEnvelope = referencedEnvelope;
        }

        public GridGeometry2D getGridGeometry() {
            return this.gridGeometry;
        }

        public double[] getFullResolution() {
            AffineTransform gridToCRS = (AffineTransform)this.gridGeometry.getGridToCRS();
            return CoverageUtilities.getResolution((AffineTransform)gridToCRS);
        }

        public void setGridGeometry(GridGeometry2D gridGeometry) {
            this.gridGeometry = gridGeometry;
        }

        public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
            this.coordinateReferenceSystem = coordinateReferenceSystem;
        }

        @Override
        public Set<? extends BoundingBox> getSpatialElements(boolean overall, ProgressListener listener) throws IOException {
            return Collections.singleton(this.referencedEnvelope);
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem2D() {
            return this.coordinateReferenceSystem;
        }

        @Override
        public MathTransform2D getGridToWorldTransform(ProgressListener listener) throws IOException {
            return this.gridGeometry.getGridToCRS2D(PixelOrientation.CENTER);
        }

        @Override
        public Set<? extends RasterLayout> getRasterElements(boolean overall, ProgressListener listener) throws IOException {
            Rectangle bounds = this.gridGeometry.getGridRange2D().getBounds();
            return Collections.singleton(new RasterLayout(bounds));
        }
    }
}

