/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf;

import it.geosolutions.imageio.stream.eraf.EnhancedRandomAccessFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.List;
import org.geotools.util.Utilities;

public class Slice2DIndex {
    public static final int DEFAULT_INDEX = -1;
    private int tIndex = -1;
    private int zIndex = -1;
    private final String variableName;

    public Slice2DIndex(String variableName) {
        this(-1, -1, variableName);
    }

    public Slice2DIndex(int tIndex, int zIndex, String variableName) {
        Utilities.ensureNonNull((String)"variableName", (Object)variableName);
        this.tIndex = tIndex;
        this.zIndex = zIndex;
        this.variableName = variableName;
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public int getTIndex() {
        return this.tIndex;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String toString() {
        return "UnidataVariableIndex [tIndex=" + this.tIndex + ", zIndex=" + this.zIndex + ", variableName=" + this.variableName + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.tIndex;
        result = 31 * result + (this.variableName == null ? 0 : this.variableName.hashCode());
        result = 31 * result + this.zIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Slice2DIndex other = (Slice2DIndex)obj;
        if (this.tIndex != other.tIndex) {
            return false;
        }
        if (this.variableName == null ? other.variableName != null : !this.variableName.equals(other.variableName)) {
            return false;
        }
        return this.zIndex == other.zIndex;
    }

    public static class Slice2DIndexManager {
        private static final long ADDRESS_SIZE = 8L;
        private static long ADDRESS_POSITION = 4L;
        private EnhancedRandomAccessFile raf;
        private File file;
        private int numberOfRecords;

        public Slice2DIndexManager(File file) {
            this.file = file;
        }

        public void open() throws IOException {
            this.raf = new EnhancedRandomAccessFile(this.file, "r");
            this.raf.setByteOrder(ByteOrder.BIG_ENDIAN);
            this.numberOfRecords = this.raf.readInt();
        }

        public Slice2DIndex getSlice2DIndex(int imageIndex) throws IOException {
            long addressPosition = ADDRESS_POSITION + (long)imageIndex * 8L;
            this.raf.seek(addressPosition);
            long dataPosition = this.raf.readLong();
            long endDataPosition = this.raf.readLong();
            this.raf.seek(dataPosition);
            int tIndex = this.raf.readInt();
            int zIndex = this.raf.readInt();
            int stringSize = (int)(endDataPosition - this.raf.getFilePointer());
            byte[] stringBytes = new byte[stringSize];
            this.raf.read(stringBytes);
            String varName = new String(stringBytes);
            return new Slice2DIndex(tIndex, zIndex, varName);
        }

        public void dispose() throws IOException {
            if (this.raf != null) {
                this.raf.close();
            }
        }

        public static void writeIndexFile(File file, List<Slice2DIndex> indexList) throws IOException {
            Slice2DIndexManager.writeIndexFile(file, indexList, 2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void writeIndexFile(File file, List<Slice2DIndex> indexList, int dimensions) throws IOException {
            try (RandomAccessFile raf = null;){
                raf = new RandomAccessFile(file, "rw");
                int size = indexList.size();
                raf.writeInt(size);
                long dataPosition = ADDRESS_POSITION + (long)(size + 1) * 8L;
                long[] pointer = new long[size];
                raf.seek(dataPosition);
                for (int i = 0; i < size; ++i) {
                    long pos;
                    Slice2DIndex slice2DIndex = indexList.get(i);
                    pointer[i] = pos = raf.getFilePointer();
                    raf.writeInt(slice2DIndex.getTIndex());
                    raf.writeInt(slice2DIndex.getZIndex());
                    raf.write(slice2DIndex.getVariableName().getBytes());
                }
                long dataEnd = raf.getFilePointer();
                raf.seek(ADDRESS_POSITION);
                for (long address : pointer) {
                    raf.writeLong(address);
                }
                raf.writeLong(dataEnd);
            }
        }

        public int getNumberOfRecords() throws IOException {
            return this.numberOfRecords;
        }
    }
}

