/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf;

import it.geosolutions.imageio.stream.AccessibleStream;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import it.geosolutions.imageio.stream.input.URIImageInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.geotools.data.DataUtilities;
import org.geotools.imageio.netcdf.NetCDFImageReader;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.util.logging.Logging;
import ucar.nc2.dataset.NetcdfDataset;

public class NetCDFImageReaderSpi
extends ImageReaderSpi {
    public static final Class<?>[] STANDARD_INPUT_TYPES = new Class[]{AccessibleStream.class, ImageInputStream.class, File.class, URL.class, URI.class};
    public static final String VENDOR_NAME = "GeoTools";
    private static final Logger LOGGER = Logging.getLogger(NetCDFImageReaderSpi.class);
    static final String[] suffixes;
    static final String[] formatNames;
    static final String[] MIMETypes;
    static final String version = "1.0";
    static final String readerCN = "it.geosolutions.imageio.plugins.netcdf.NetCDFImageReader";
    static final String[] wSN;
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName;
    static final String nativeStreamMetadataFormatClassName;
    static final String[] extraStreamMetadataFormatNames;
    static final String[] extraStreamMetadataFormatClassNames;
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName;
    static final String nativeImageMetadataFormatClassName;
    static final String[] extraImageMetadataFormatNames;
    static final String[] extraImageMetadataFormatClassNames;
    private static final String FORCE_OPEN_CHECK = "NETCDF_FORCE_OPEN_CHECK";
    private static boolean forceOpenCheck;

    public NetCDFImageReaderSpi() {
        super(VENDOR_NAME, version, formatNames, suffixes, MIMETypes, readerCN, STANDARD_INPUT_TYPES, wSN, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
        LOGGER.fine("NetCDFImageReaderSpi Constructor");
    }

    @Override
    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new NetCDFImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return new StringBuffer("NetCDF-CF Image Reader, version ").append(version).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        boolean canDecode = false;
        File input = null;
        if (source instanceof FileImageInputStreamExtImpl) {
            input = ((FileImageInputStreamExtImpl)source).getFile();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found a valid FileImageInputStream");
            }
        }
        if (source instanceof File) {
            input = (File)source;
        }
        if (source instanceof URIImageInputStream) {
            URIImageInputStream uriInStream = (URIImageInputStream)source;
            try {
                NetcdfDataset openDataset = NetcdfDataset.acquireDataset((String)uriInStream.getUri().toString(), null);
                openDataset.close();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        if (input != null) {
            NetcdfDataset file = null;
            FileImageInputStream fis = null;
            try {
                fis = new FileImageInputStream(input);
                byte[] b = new byte[4];
                fis.mark();
                fis.readFully(b);
                fis.reset();
                boolean cdfCheck = b[0] == 67 && b[1] == 68 && b[2] == 70;
                boolean hdf5Check = b[0] == -119 && b[1] == 72 && b[2] == 68;
                boolean gribCheck = b[0] == 71 && b[1] == 82 && b[2] == 73 && b[3] == 66;
                boolean isNetCDF = true;
                if (!(cdfCheck || hdf5Check || (gribCheck &= NetCDFUtilities.isGribAvailable()) || this.isNcML(input))) {
                    isNetCDF = false;
                }
                if (!isNetCDF && !forceOpenCheck) {
                    boolean bl = false;
                    return bl;
                }
                file = NetcdfDataset.acquireDataset((String)DataUtilities.fileToURL((File)input).toString(), null);
                if (file != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("File successfully opened");
                    }
                    canDecode = true;
                }
            }
            catch (IOException ioe) {
                canDecode = false;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable t) {}
                }
                if (file != null) {
                    file.close();
                }
            }
        }
        return canDecode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNcML(File input) throws IOException {
        StreamSource streamSource = new StreamSource(input);
        XMLStreamReader reader = null;
        try {
            reader = XMLInputFactory.newInstance().createXMLStreamReader(streamSource);
            reader.nextTag();
            if ("netcdf".equals(reader.getName().getLocalPart())) {
                boolean bl = true;
                return bl;
            }
        }
        catch (XMLStreamException e) {
        }
        catch (FactoryConfigurationError e) {
        }
        finally {
            if (reader != null) {
                if (streamSource.getInputStream() != null) {
                    streamSource.getInputStream().close();
                }
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {}
            }
        }
        return false;
    }

    static {
        wSN = new String[]{null};
        nativeStreamMetadataFormatName = null;
        nativeStreamMetadataFormatClassName = null;
        extraStreamMetadataFormatNames = new String[]{null};
        extraStreamMetadataFormatClassNames = new String[]{null};
        nativeImageMetadataFormatName = null;
        nativeImageMetadataFormatClassName = null;
        extraImageMetadataFormatNames = new String[]{null};
        extraImageMetadataFormatClassNames = new String[]{null};
        NetcdfDataset.setDefaultEnhanceMode(EnumSet.of(NetcdfDataset.Enhance.CoordSystems));
        ArrayList suffixesList = new ArrayList();
        Collections.addAll(suffixesList, "nc", "NC");
        ArrayList formatNamesList = new ArrayList();
        Collections.addAll(formatNamesList, "netcdf", "NetCDF", "NetCDF-3");
        ArrayList mimeTypesList = new ArrayList();
        Collections.addAll(mimeTypesList, "application/x-netcdf", "image/netcdf", "image/x-netcdf", "image/x-nc");
        if (NetCDFUtilities.isGribAvailable()) {
            Collections.addAll(suffixesList, "grib", "grb", "grb2");
            Collections.addAll(formatNamesList, "grib", "grib2", "GRIB", "GRIB2");
            Collections.addAll(mimeTypesList, "application/octet-stream");
        }
        if (NetCDFUtilities.isNC4CAvailable()) {
            Collections.addAll(formatNamesList, "NetCDF-4C", "NetCDF-4");
            Collections.addAll(mimeTypesList, "application/x-netcdf4");
        }
        suffixes = suffixesList.toArray(new String[suffixesList.size()]);
        formatNames = formatNamesList.toArray(new String[formatNamesList.size()]);
        MIMETypes = mimeTypesList.toArray(new String[mimeTypesList.size()]);
        forceOpenCheck = Boolean.getBoolean(FORCE_OPEN_CHECK);
    }
}

