/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf;

import it.geosolutions.imageio.stream.input.URIImageInputStream;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import org.apache.commons.io.FilenameUtils;
import org.geotools.coverage.grid.io.FileSetManager;
import org.geotools.coverage.io.catalog.CoverageSlicesCatalog;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.gce.imagemosaic.catalog.index.Indexer;
import org.geotools.gce.imagemosaic.catalog.index.SchemaType;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.imageio.GeoSpatialImageReader;
import org.geotools.imageio.netcdf.AncillaryFileManager;
import org.geotools.imageio.netcdf.Slice2DIndex;
import org.geotools.imageio.netcdf.VariableAdapter;
import org.geotools.imageio.netcdf.cv.CoordinateVariable;
import org.geotools.imageio.netcdf.utilities.NetCDFCRSUtilities;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;

public class NetCDFImageReader
extends GeoSpatialImageReader
implements FileSetManager {
    private static final int INTERNAL_INDEX_CREATION_PAGE_SIZE = 1000;
    private static final Logger LOGGER = Logging.getLogger((String)NetCDFImageReader.class.toString());
    AncillaryFileManager ancillaryFileManager;
    final List<Name> coverages = new ArrayList<Name>();
    private NetcdfDataset dataset;
    final Map<String, CoordinateVariable<?>> coordinatesVariables = new HashMap();
    private NetCDFUtilities.CheckType checkType = NetCDFUtilities.CheckType.UNSET;
    private final SoftValueHashMap<String, VariableAdapter> coverageSourceDescriptorsCache = new SoftValueHashMap();
    final Map<String, String> dimensionsMapping = new HashMap<String, String>();
    private File file;
    ReferencedEnvelope boundingBox;
    private boolean needsFlipping = false;

    public List<Name> getCoveragesNames() {
        return Collections.unmodifiableList(this.coverages);
    }

    @Override
    public int getCoveragesNumber() {
        return this.coverages.size();
    }

    public NetCDFImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    private NetcdfDataset extractDataset(Object input) throws IOException {
        URL tempURL;
        String protocol;
        NetcdfDataset dataset = null;
        if (input instanceof URIImageInputStream) {
            URIImageInputStream uriInStream = (URIImageInputStream)input;
            dataset = NetcdfDataset.acquireDataset((String)uriInStream.getUri().toString(), null);
        }
        if (input instanceof URL && ((protocol = (tempURL = (URL)input).getProtocol()).equalsIgnoreCase("http") || protocol.equalsIgnoreCase("dods"))) {
            dataset = NetcdfDataset.acquireDataset((String)tempURL.toExternalForm(), null);
        }
        if (dataset == null) {
            dataset = NetCDFUtilities.getDataset(input);
        }
        return dataset;
    }

    protected void setNumImages(int numImages) {
        if (numImages <= 0) {
            throw new IllegalArgumentException("Number of Images is negative: " + numImages);
        }
        if (this.numImages == -1) {
            this.numImages = numImages;
        }
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        VariableAdapter wrapper = this.getCoverageDescriptor(imageIndex);
        if (wrapper != null) {
            return wrapper.getHeight();
        }
        return -1;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>();
        VariableAdapter wrapper = this.getCoverageDescriptor(imageIndex);
        if (wrapper != null) {
            SampleModel sampleModel = wrapper.getSampleModel();
            ImageTypeSpecifier imageType = new ImageTypeSpecifier(ImageIOUtilities.createColorModel((SampleModel)sampleModel), sampleModel);
            l.add(imageType);
        }
        return l.iterator();
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        VariableAdapter wrapper = this.getCoverageDescriptor(imageIndex);
        if (wrapper != null) {
            return wrapper.getWidth();
        }
        return -1;
    }

    public Variable getVariableByName(String varName) {
        List varList = this.dataset.getVariables();
        for (Variable var : varList) {
            if (!var.getFullName().equals(varName)) continue;
            return var;
        }
        return null;
    }

    @Override
    public void reset() {
        super.setInput(null, false, false);
        this.dispose();
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (this.dataset != null) {
            this.reset();
        }
        try {
            this.dataset = this.extractDataset(input);
            this.file = NetCDFUtilities.getFile(input);
            if (this.file != null) {
                this.ancillaryFileManager = new AncillaryFileManager(this.file, this.getAuxiliaryFilesPath());
            }
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected int initIndex() throws InvalidRangeException, IOException {
        DefaultTransaction transaction = new DefaultTransaction("indexTransaction" + System.nanoTime());
        int numImages = 0;
        try {
            File sliceIndexFile = this.ancillaryFileManager.getSlicesIndexFile();
            this.initCatalog(sliceIndexFile.getParentFile(), FilenameUtils.removeExtension((String)FilenameUtils.getName((String)sliceIndexFile.getCanonicalPath())).replace(".", ""));
            List variables = this.dataset.getVariables();
            if (variables != null) {
                for (Variable var_ : variables) {
                    int features;
                    VariableDS variable;
                    String varName;
                    if (var_ == null || !(var_ instanceof VariableDS) || !this.ancillaryFileManager.acceptsVariable(varName = (variable = (VariableDS)var_).getFullName()) || !NetCDFUtilities.isVariableAccepted((Variable)variable, this.checkType)) continue;
                    Name coverageName = this.getCoverageName(varName);
                    CoordinateSystem cs = NetCDFCRSUtilities.getCoordinateSystem(variable);
                    SimpleFeatureType indexSchema = this.getIndexSchema(coverageName, cs);
                    VariableAdapter vaAdapter = this.getCoverageDescriptor(coverageName);
                    if (indexSchema == null) {
                        throw new IllegalStateException("Unable to created index schema for coverage:" + coverageName);
                    }
                    int variableImageStartIndex = numImages;
                    int numberOfSlices = vaAdapter.getNumberOfSlices();
                    numImages += numberOfSlices;
                    int startPagingIndex = 0;
                    int limit = 1000;
                    ListFeatureCollection collection = new ListFeatureCollection(indexSchema);
                    for (int writtenFeatures = 0; writtenFeatures < numberOfSlices; writtenFeatures += features) {
                        vaAdapter.getFeatures(startPagingIndex, 1000, collection);
                        if (variableImageStartIndex != 0) {
                            this.updateFeaturesIndex(collection, variableImageStartIndex);
                        }
                        if ((features = collection.size()) <= 0) continue;
                        CoverageSlicesCatalog catalog = this.getCatalog();
                        if (catalog != null) {
                            catalog.addGranules(indexSchema.getTypeName(), (SimpleFeatureCollection)collection, (Transaction)transaction);
                        }
                        collection.clear();
                        startPagingIndex += features;
                    }
                }
            }
            this.ancillaryFileManager.writeToDisk();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Committing changes to the DB");
            }
            transaction.commit();
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Rollback");
            }
            if (transaction != null) {
                transaction.rollback();
            }
            throw new IOException(e);
        }
        finally {
            try {
                if (transaction != null) {
                    transaction.close();
                }
            }
            catch (Throwable t) {}
        }
        return numImages;
    }

    private void updateFeaturesIndex(ListFeatureCollection collection, int offset) {
        SimpleFeatureIterator featuresIt = collection.features();
        SimpleFeature feature = null;
        while (featuresIt.hasNext()) {
            feature = (SimpleFeature)featuresIt.next();
            Integer index = (Integer)feature.getAttribute("imageindex");
            feature.setAttribute("imageindex", (Object)(index + offset));
        }
    }

    private void initMapping(List<CoordinateAxis> coordinateAxis) {
        for (CoordinateAxis axis : coordinateAxis) {
            CoordinateVariable<?> cv = this.coordinatesVariables.get(axis.getFullName());
            if (cv != null) {
                String name = cv.getName();
                switch (cv.getAxisType()) {
                    case GeoX: 
                    case GeoY: 
                    case Lat: 
                    case Lon: {
                        break;
                    }
                    case Height: 
                    case Pressure: 
                    case RadialElevation: 
                    case RadialDistance: 
                    case GeoZ: {
                        if (NetCDFCRSUtilities.VERTICAL_AXIS_NAMES.contains(name) && !this.dimensionsMapping.containsKey(NetCDFUtilities.ELEVATION_DIM)) {
                            this.dimensionsMapping.put(NetCDFUtilities.ELEVATION_DIM, name);
                            break;
                        }
                        this.dimensionsMapping.put(name.toUpperCase(), name);
                        break;
                    }
                    case Time: {
                        if (!this.dimensionsMapping.containsKey(NetCDFUtilities.TIME_DIM)) {
                            this.dimensionsMapping.put(NetCDFUtilities.TIME_DIM, name);
                            break;
                        }
                        this.dimensionsMapping.put(name.toUpperCase(), name);
                    }
                }
                continue;
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("Null coordinate variable: '" + axis.getFullName() + "' while processing input: " + this.getInput());
        }
    }

    private Name getCoverageName(String varName) {
        Name coverageName = this.ancillaryFileManager.getCoverageName(varName);
        if (coverageName == null) {
            this.ancillaryFileManager.addCoverage(varName);
            coverageName = new NameImpl(varName);
        }
        this.coverages.add(coverageName);
        return coverageName;
    }

    private void extractCoordinatesVariable() throws IOException {
        for (CoordinateAxis axis : this.dataset.getCoordinateAxes()) {
            if (axis instanceof CoordinateAxis1D && axis.getAxisType() != null && !"reftime".equalsIgnoreCase(axis.getFullName())) {
                this.coordinatesVariables.put(axis.getFullName(), CoordinateVariable.create((CoordinateAxis1D)axis));
                continue;
            }
            Set<String> unsupported = NetCDFUtilities.getUnsupportedDimensions();
            if (axis instanceof CoordinateAxis1D && unsupported.contains(axis.getFullName())) {
                axis.setAxisType(AxisType.GeoZ);
                this.coordinatesVariables.put(axis.getFullName(), CoordinateVariable.create((CoordinateAxis1D)axis));
                continue;
            }
            if ("time".equals(axis.getFullName())) {
                LOGGER.warning("Detected unparseable unit string in time axis: '" + axis.getUnitsString() + "'.");
                axis.setAxisType(AxisType.Time);
                this.coordinatesVariables.put(axis.getFullName(), CoordinateVariable.create((CoordinateAxis1D)axis));
                continue;
            }
            if ("reftime".equals(axis.getFullName())) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("Unable to support reftime which is not a CoordinateAxis1D");
                continue;
            }
            LOGGER.warning("Unsupported axis: " + axis + " in input: " + this.getInput() + " has been found");
        }
        this.initMapping(this.dataset.getCoordinateAxes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        SoftValueHashMap<String, VariableAdapter> softValueHashMap = this.coverageSourceDescriptorsCache;
        synchronized (softValueHashMap) {
            this.coverageSourceDescriptorsCache.clear();
        }
        super.dispose();
        this.checkType = NetCDFUtilities.CheckType.UNSET;
        this.coordinatesVariables.clear();
        this.numImages = -1;
        try {
            if (this.dataset != null) {
                this.dataset.close();
            }
            if (this.ancillaryFileManager != null) {
                this.ancillaryFileManager.dispose();
            }
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Errors closing NetCDF dataset." + e.getLocalizedMessage());
            }
        }
        finally {
            this.dataset = null;
            this.ancillaryFileManager = null;
        }
    }

    private void init() throws IOException {
        int numImages;
        block8: {
            numImages = 0;
            try {
                if (this.dataset != null) {
                    this.checkType = NetCDFUtilities.getCheckType(this.dataset);
                    this.extractCoordinatesVariable();
                    this.extractBBOX();
                    File slicesIndexFile = this.ancillaryFileManager.getSlicesIndexFile();
                    if (slicesIndexFile != null) {
                        if (slicesIndexFile.exists()) {
                            this.ancillaryFileManager.initSliceManager();
                            numImages = this.ancillaryFileManager.slicesIndexManager.getNumberOfRecords();
                            if (!this.ignoreMetadata) {
                                this.initCatalog(slicesIndexFile.getParentFile(), FilenameUtils.removeExtension((String)FilenameUtils.getName((String)slicesIndexFile.getCanonicalPath())).replace(".", ""));
                                this.coverages.addAll(this.ancillaryFileManager.getCoveragesNames());
                            }
                        }
                        if (numImages <= 0 || !slicesIndexFile.exists()) {
                            this.ancillaryFileManager.resetSliceManager();
                            numImages = this.initIndex();
                            this.ancillaryFileManager.initSliceManager();
                            numImages = this.ancillaryFileManager.slicesIndexManager.getNumberOfRecords();
                        }
                    } else {
                        numImages = this.initIndex();
                    }
                    break block8;
                }
                throw new IllegalArgumentException("No valid NetCDF dataset has been found");
            }
            catch (InvalidRangeException e) {
                throw new IllegalArgumentException("Exception occurred during NetCDF file parsing", e);
            }
        }
        this.setNumImages(numImages);
    }

    private void extractBBOX() throws IOException {
        double[] lon = new double[2];
        double[] lat = new double[2];
        int set = 0;
        for (CoordinateVariable<?> cv : this.coordinatesVariables.values()) {
            if (cv.isNumeric()) {
                AxisType type = cv.getAxisType();
                switch (type) {
                    case GeoY: 
                    case Lat: {
                        double incr;
                        double max;
                        double min;
                        if (cv.isRegular()) {
                            lat[0] = cv.getStart() - cv.getIncrement() / 2.0;
                            lat[1] = lat[0] + cv.getIncrement() * (double)cv.getSize();
                        } else {
                            min = ((Number)cv.getMinimum()).doubleValue();
                            max = ((Number)cv.getMaximum()).doubleValue();
                            incr = (max - min) / (double)(cv.getSize() - 1L);
                            lat[0] = min - incr / 2.0;
                            lat[1] = max + incr / 2.0;
                        }
                        this.needsFlipping = lat[1] > lat[0];
                        set = (byte)(set + 1);
                        break;
                    }
                    case GeoX: 
                    case Lon: {
                        double incr;
                        double max;
                        double min;
                        if (cv.isRegular()) {
                            lon[0] = cv.getStart() - cv.getIncrement() / 2.0;
                            lon[1] = lon[0] + cv.getIncrement() * (double)cv.getSize();
                        } else {
                            min = ((Number)cv.getMinimum()).doubleValue();
                            max = ((Number)cv.getMaximum()).doubleValue();
                            incr = (max - min) / (double)(cv.getSize() - 1L);
                            lon[0] = min - incr / 2.0;
                            lon[1] = max + incr / 2.0;
                        }
                        set = (byte)(set + 1);
                        break;
                    }
                }
            }
            if (set != 2) continue;
            break;
        }
        if (set != 2) {
            throw new IllegalStateException("Unable to create envelope for this dataset");
        }
        this.boundingBox = new ReferencedEnvelope(lon[0], lon[1], lat[0], lat[1], NetCDFCRSUtilities.WGS84);
    }

    protected IIOException netcdfFailure(Exception e) throws IOException {
        return new IIOException("Can't read file " + this.dataset.getLocation(), e);
    }

    public Slice2DIndex getSlice2DIndex(int imageIndex) throws IOException {
        return this.ancillaryFileManager.getSlice2DIndex(imageIndex);
    }

    protected VariableAdapter getCoverageDescriptor(int imageIndex) {
        block3: {
            this.checkImageIndex(imageIndex);
            try {
                Slice2DIndex slice2DIndex = this.getSlice2DIndex(imageIndex);
                if (slice2DIndex != null) {
                    return this.getCoverageDescriptor((Name)new NameImpl(slice2DIndex.getVariableName()));
                }
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VariableAdapter getCoverageDescriptor(Name name) {
        Utilities.ensureNonNull((String)"name", (Object)name);
        String name_ = name.toString();
        SoftValueHashMap<String, VariableAdapter> softValueHashMap = this.coverageSourceDescriptorsCache;
        synchronized (softValueHashMap) {
            VariableAdapter cd;
            if (this.coverageSourceDescriptorsCache.containsKey((Object)name_)) {
                return (VariableAdapter)this.coverageSourceDescriptorsCache.get((Object)name_);
            }
            try {
                String origName;
                String string = origName = this.ancillaryFileManager.variablesMap != null ? this.ancillaryFileManager.variablesMap.get(name) : null;
                if (origName == null) {
                    origName = name.getLocalPart();
                }
                cd = new VariableAdapter(this, name, (VariableDS)this.getVariableByName(origName));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.coverageSourceDescriptorsCache.put((Object)name_, (Object)cd);
            return cd;
        }
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        int[] dstBands;
        int strideY;
        int strideX;
        this.clearAbortRequest();
        Slice2DIndex slice2DIndex = this.getSlice2DIndex(imageIndex);
        String variableName = slice2DIndex.getVariableName();
        VariableAdapter wrapper = this.getCoverageDescriptor((Name)new NameImpl(variableName));
        if (param != null) {
            strideX = param.getSourceXSubsampling();
            strideY = param.getSourceYSubsampling();
            dstBands = param.getDestinationBands();
        } else {
            strideX = 1;
            strideY = 1;
            dstBands = null;
        }
        int width = wrapper.getWidth();
        int height = wrapper.getHeight();
        Rectangle srcRegion = new Rectangle();
        Rectangle destRegion = new Rectangle();
        NetCDFImageReader.computeRegions(param, width, height, null, srcRegion, destRegion);
        if (this.needsFlipping) {
            NetCDFImageReader.flipVertically(param, height, srcRegion);
        }
        int destWidth = destRegion.x + destRegion.width;
        int destHeight = destRegion.y + destRegion.height;
        LinkedList<Range> ranges = new LinkedList<Range>();
        try {
            int first = slice2DIndex.getTIndex();
            int length = 1;
            int stride = 1;
            if (first != -1) {
                ranges.add(new Range(first, first + length - 1, stride));
            }
            if ((first = slice2DIndex.getZIndex()) != -1) {
                ranges.add(new Range(first, first + length - 1, stride));
            }
            first = srcRegion.y;
            length = srcRegion.height;
            stride = strideY;
            ranges.add(new Range(first, first + length - 1, stride));
            first = srcRegion.x;
            length = srcRegion.width;
            stride = strideX;
            ranges.add(new Range(first, first + length - 1, stride));
        }
        catch (InvalidRangeException e) {
            throw this.netcdfFailure((Exception)((Object)e));
        }
        Section section = new Section(ranges);
        SampleModel sampleModel = wrapper.getSampleModel().createCompatibleSampleModel(destWidth, destHeight);
        ColorModel colorModel = ImageIOUtilities.createColorModel((SampleModel)sampleModel);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, new Point(0, 0));
        BufferedImage image = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
        CoordinateAxis axis = ((CoordinateSystem)wrapper.variableDS.getCoordinateSystems().get(0)).getLatAxis();
        boolean flipYAxis = false;
        try {
            Array yAxisStart = axis.read(new Section().appendRange(2));
            float y1 = yAxisStart.getFloat(0);
            float y2 = yAxisStart.getFloat(1);
            if (y2 > y1) {
                flipYAxis = true;
            }
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
        this.processImageStarted(imageIndex);
        boolean numDstBands = true;
        float toPercent = 100.0f;
        int type = raster.getSampleModel().getDataType();
        int xmin = destRegion.x;
        int ymin = destRegion.y;
        int xmax = destRegion.width + xmin;
        int ymax = destRegion.height + ymin;
        for (int zi = 0; zi < 1; ++zi) {
            Array array;
            int dstBand = dstBands == null ? zi : dstBands[zi];
            try {
                array = wrapper.variableDS.read(section);
            }
            catch (InvalidRangeException e) {
                throw this.netcdfFailure((Exception)((Object)e));
            }
            if (flipYAxis) {
                IndexIterator it = array.getIndexIterator();
                int y = ymax;
                while (--y >= ymin) {
                    block19: for (int x = xmin; x < xmax; ++x) {
                        switch (type) {
                            case 5: {
                                raster.setSample(x, y, dstBand, it.getDoubleNext());
                                continue block19;
                            }
                            case 4: {
                                raster.setSample(x, y, dstBand, it.getFloatNext());
                                continue block19;
                            }
                            case 0: {
                                byte b = it.getByteNext();
                                raster.setSample(x, y, dstBand, b);
                                continue block19;
                            }
                            default: {
                                raster.setSample(x, y, dstBand, it.getIntNext());
                            }
                        }
                    }
                }
            } else {
                switch (type) {
                    case 5: {
                        DoubleBuffer doubleBuffer = array.getDataAsByteBuffer().asDoubleBuffer();
                        double[] samples = new double[destRegion.width * destRegion.height];
                        doubleBuffer.get(samples);
                        raster.setSamples(xmin, ymin, destRegion.width, destRegion.height, dstBand, samples);
                        break;
                    }
                    case 4: {
                        float[] samples = new float[destRegion.width * destRegion.height];
                        FloatBuffer floatBuffer = array.getDataAsByteBuffer().asFloatBuffer();
                        floatBuffer.get(samples);
                        raster.setSamples(xmin, ymin, destRegion.width, destRegion.height, dstBand, samples);
                        break;
                    }
                    case 0: {
                        raster.setDataElements(xmin, ymin, destRegion.width, destRegion.height, array.getDataAsByteBuffer().array());
                        break;
                    }
                    case 3: {
                        IntBuffer intBuffer = array.getDataAsByteBuffer().asIntBuffer();
                        int[] intSamples = new int[destRegion.width * destRegion.height];
                        intBuffer.get(intSamples);
                        raster.setSamples(xmin, ymin, destRegion.width, destRegion.height, dstBand, intSamples);
                        break;
                    }
                    default: {
                        IndexIterator it = array.getIndexIterator();
                        for (int y = ymin; y < ymax; ++y) {
                            for (int x = xmin; x < xmax; ++x) {
                                raster.setSample(x, y, dstBand, it.getIntNext());
                            }
                        }
                    }
                }
            }
            if (this.abortRequested()) {
                this.processReadAborted();
                return image;
            }
            this.processImageProgress((float)zi * 100.0f);
        }
        this.processImageComplete();
        return image;
    }

    protected static void flipVertically(ImageReadParam param, int srcHeight, Rectangle srcRegion) {
        int spaceLeft = srcRegion.y;
        srcRegion.y = srcHeight - (srcRegion.y + srcRegion.height);
        if (param != null) {
            int offset = (srcRegion.height - 1) % param.getSourceYSubsampling();
            srcRegion.y += offset;
            if ((offset -= spaceLeft) > 0) {
                srcRegion.height -= offset;
            }
        }
    }

    private void forceSchemaCreation(SimpleFeatureType indexSchema) throws IOException {
        String typeName = indexSchema.getTypeName();
        CoverageSlicesCatalog catalog = this.getCatalog();
        if (typeName != null && catalog != null) {
            String[] typeNames = catalog.getTypeNames();
            if (typeNames != null) {
                for (String tn : typeNames) {
                    if (!tn.equalsIgnoreCase(typeName)) continue;
                    return;
                }
            }
            catalog.createType(indexSchema);
        }
    }

    public SimpleFeatureType getIndexSchema(Name coverageName, CoordinateSystem coordinateSystem) throws Exception {
        String schemaDef;
        String _coverageName = coverageName.toString();
        Indexer.Coverages.Coverage coverage = this.ancillaryFileManager.coveragesMapping.get(_coverageName);
        SchemaType schema = coverage.getSchema();
        String string = schemaDef = schema != null ? schema.getAttributes() : null;
        if (schema == null || schema.getAttributes() == null) {
            schemaDef = this.suggestSchemaFromCoordinateSystem(coverage, coordinateSystem);
            this.ancillaryFileManager.setSchema(coverage, coverage.getName(), schemaDef);
            schema = coverage.getSchema();
        }
        SimpleFeatureType indexSchema = NetCDFUtilities.createFeatureType(coverage.getName(), schemaDef, NetCDFCRSUtilities.WGS84);
        this.forceSchemaCreation(indexSchema);
        return indexSchema;
    }

    String suggestSchemaFromCoordinateSystem(Indexer.Coverages.Coverage coverage, CoordinateSystem cs) throws SchemaException {
        String schemaAttributes = "the_geom:Polygon,imageindex:Integer";
        block3: for (CoordinateAxis axis : cs.getCoordinateAxes()) {
            CoordinateVariable<?> cv = this.coordinatesVariables.get(axis.getFullName());
            if (cv == null) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("Unable to find a coordinate variable for " + axis.getFullName());
                continue;
            }
            String name = cv.getName();
            switch (cv.getAxisType()) {
                case GeoX: 
                case GeoY: 
                case Lat: 
                case Lon: {
                    continue block3;
                }
            }
            schemaAttributes = schemaAttributes + "," + name + ":" + cv.getType().getName();
        }
        return schemaAttributes;
    }

    public void addFile(String filePath) {
        this.ancillaryFileManager.addFile(filePath);
    }

    public List<String> list() {
        return this.ancillaryFileManager.list();
    }

    public void removeFile(String filePath) {
        this.ancillaryFileManager.removeFile(filePath);
    }

    public void purge() {
        this.getCatalog().dispose();
        this.ancillaryFileManager.purge();
    }
}

