/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf.cf;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.geotools.coverage.io.netcdf.cf.Alias;
import org.geotools.coverage.io.netcdf.cf.Entry;
import org.geotools.coverage.io.netcdf.cf.StandardNameTable;
import org.geotools.util.logging.Logging;

public class NetCDFCFParser {
    private Map<String, Entry> entriesMap;
    private Map<String, Alias> aliasMap;
    private Set<String> keys;
    private static JAXBContext context;
    private static final Logger LOGGER;

    public boolean hasEntryId(String id) {
        return this.entriesMap.containsKey(id);
    }

    public boolean hasAliasId(String id) {
        return this.aliasMap.containsKey(id);
    }

    public Entry getEntry(String id) {
        if (this.hasEntryId(id)) {
            return this.entriesMap.get(id);
        }
        return null;
    }

    public Set<String> getEntryIds() {
        return this.keys;
    }

    public Entry getEntryFromAlias(String id) {
        if (this.hasAliasId(id)) {
            Alias alias = this.aliasMap.get(id);
            Entry entryId = (Entry)alias.getEntryId();
            return entryId;
        }
        return null;
    }

    private NetCDFCFParser(Map<String, Entry> entriesMap, Map<String, Alias> aliasMap) {
        this.entriesMap = entriesMap;
        this.aliasMap = aliasMap;
        this.keys = new TreeSet<String>();
        this.keys.addAll(entriesMap.keySet());
        this.keys.addAll(aliasMap.keySet());
    }

    public static NetCDFCFParser unmarshallXml(File file) throws JAXBException {
        Unmarshaller unmarshaller = context.createUnmarshaller();
        StandardNameTable table = (StandardNameTable)unmarshaller.unmarshal(file);
        List<Entry> entries = table.getEntry();
        List<Alias> aliases = table.getAlias();
        HashMap<String, Entry> entriesMap = new HashMap<String, Entry>(entries.size());
        HashMap<String, Alias> aliasMap = new HashMap<String, Alias>(aliases.size());
        for (Entry entry : entries) {
            entriesMap.put(entry.getId(), entry);
        }
        for (Alias alias : aliases) {
            aliasMap.put(alias.getId(), alias);
        }
        return new NetCDFCFParser(entriesMap, aliasMap);
    }

    static {
        LOGGER = Logging.getLogger((String)NetCDFCFParser.class.toString());
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{StandardNameTable.class});
        }
        catch (JAXBException e) {
            LOGGER.severe(e.getLocalizedMessage());
        }
    }
}

