/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileCache;
import javax.media.jai.TileScheduler;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.io.CoverageReadRequest;
import org.geotools.coverage.io.CoverageResponse;
import org.geotools.coverage.io.SpatialRequestHelper;
import org.geotools.coverage.io.impl.DefaultGridCoverageResponse;
import org.geotools.coverage.io.netcdf.NetCDFRequest;
import org.geotools.coverage.io.range.FieldType;
import org.geotools.coverage.io.range.RangeType;
import org.geotools.data.DataSourceException;
import org.geotools.data.Query;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class NetCDFResponse
extends CoverageResponse {
    private static final double EPS = 1.0E-6;
    private static final double[] DEFAULT_BACKGROUND_VALUES = new double[]{0.0};
    private static final Logger LOGGER = Logging.getLogger(NetCDFResponse.class);
    private NetCDFRequest request;
    private static final GridCoverageFactory COVERAGE_FACTORY = new GridCoverageFactory();
    private GeneralEnvelope coverageEnvelope;
    private ReferencedEnvelope targetBBox;
    private Rectangle rasterBounds;
    private MathTransform2D finalGridToWorldCorner;
    private MathTransform2D finalWorldToGridCorner;
    private URL datasetURL;
    private ImageReadParam baseReadParameters = new ImageReadParam();
    private boolean oversampledRequest;
    private AffineTransform baseGridToWorld;
    private Hints hints;

    public NetCDFResponse(NetCDFRequest request) {
        this.request = request;
        CoverageReadRequest readRequest = request.originalRequest;
        this.setRequest(readRequest);
        this.datasetURL = (URL)request.source.reader.getInput();
    }

    public CoverageResponse createResponse() throws IOException {
        this.processRequest();
        return this;
    }

    private void processRequest() throws IOException {
        if (this.request.spatialRequestHelper.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Request is empty: " + this.request.toString());
            }
            return;
        }
        this.prepareParams();
        String timeFilterAttribute = null;
        String elevationFilterAttribute = null;
        CoverageReadRequest readRequest = (CoverageReadRequest)this.getRequest();
        RangeType rangeType = this.request.source.getRangeType(null);
        List<DimensionDescriptor> dimensionDescriptors = this.request.source.getDimensionDescriptors();
        for (DimensionDescriptor dimensionDescriptor : dimensionDescriptors) {
            if (dimensionDescriptor.getName().equalsIgnoreCase(NetCDFUtilities.ELEVATION_DIM)) {
                elevationFilterAttribute = dimensionDescriptor.getStartAttribute();
                continue;
            }
            if (!dimensionDescriptor.getName().equalsIgnoreCase(NetCDFUtilities.TIME_DIM)) continue;
            timeFilterAttribute = dimensionDescriptor.getStartAttribute();
        }
        SortedSet<DateRange> temporalSubset = readRequest.getTemporalSubset();
        Set<NumberRange<Double>> verticalSubset = readRequest.getVerticalSubset();
        RangeType requestedRange = readRequest.getRangeSubset();
        Set<FieldType> fieldTypes = requestedRange.getFieldTypes();
        Set<SampleDimension> sampleDims = null;
        for (FieldType fieldType : fieldTypes) {
            FieldType ft;
            Name name = fieldType.getName();
            sampleDims = fieldType.getSampleDimensions();
            if (rangeType == null || (ft = rangeType.getFieldType(name.getLocalPart())) == null) continue;
            sampleDims = ft.getSampleDimensions();
        }
        GridSampleDimension[] sampleDimensions = sampleDims.toArray(new GridSampleDimension[sampleDims.size()]);
        Set<Object> tempSubset = null;
        if (!temporalSubset.isEmpty()) {
            tempSubset = temporalSubset;
        } else {
            tempSubset = new HashSet();
            tempSubset.add(null);
        }
        Set<NumberRange<Double>> vertSubset = null;
        if (!verticalSubset.isEmpty()) {
            vertSubset = verticalSubset;
        } else {
            vertSubset = new HashSet<NumberRange<Double>>();
            vertSubset.add(null);
        }
        Map<String, Set<?>> domainsSubset = readRequest.getAdditionalDomainsSubset();
        Filter requestFilter = this.request.originalRequest.getFilter();
        for (DateRange dateRange : tempSubset) {
            for (NumberRange<Double> elevation : vertSubset) {
                Query query = new Query();
                this.createTimeElevationQuery(dateRange, elevation, query, requestFilter, timeFilterAttribute, elevationFilterAttribute);
                this.additionalParamsManagement(query, domainsSubset, dimensionDescriptors);
                query.setFilter((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.and(query.getFilter(), (Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.bbox((Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.property("the_geom"), (BoundingBox)this.targetBBox)));
                query.setTypeName(this.request.name);
                List<Integer> indexes = this.request.source.reader.getImageIndex(query);
                if (indexes == null || indexes.isEmpty()) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine(" No indexes found for this query: " + query.toString());
                    continue;
                }
                int imageIndex = indexes.get(0);
                RenderedImage image = this.loadRaster(this.baseReadParameters, imageIndex, this.targetBBox, this.finalWorldToGridCorner, this.hints);
                GridCoverage2D gridCoverage = this.prepareCoverage(image, sampleDimensions);
                if (gridCoverage == null) continue;
                DefaultGridCoverageResponse gcResponse = new DefaultGridCoverageResponse((GridCoverage)gridCoverage, dateRange, elevation);
                this.addResult(gcResponse);
            }
        }
        this.setStatus(CoverageResponse.Status.SUCCESS);
    }

    private void additionalParamsManagement(Query query, Map<String, Set<?>> domainsSubset, List<DimensionDescriptor> dimensionDescriptors) {
        if (domainsSubset.isEmpty()) {
            return;
        }
        Filter filter = query.getFilter();
        for (Map.Entry<String, Set<?>> entry : domainsSubset.entrySet()) {
            Set<?> values = entry.getValue();
            String attribute = null;
            for (DimensionDescriptor dim : dimensionDescriptors) {
                if (!dim.getName().toUpperCase().equalsIgnoreCase(entry.getKey())) continue;
                attribute = dim.getStartAttribute();
                break;
            }
            for (Object value : values) {
                if (value instanceof Range) {
                    throw new UnsupportedOperationException();
                }
                filter = FeatureUtilities.DEFAULT_FILTER_FACTORY.and(filter, (Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.equals((Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.property(attribute), (Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.literal(value)));
            }
        }
        query.setFilter(filter);
    }

    private void createTimeElevationQuery(DateRange time, NumberRange<Double> elevation, Query query, Filter requestFilter, String timeFilterAttribute, String elevationFilterAttribute) {
        NumberRange<Double> range;
        ArrayList<Object> filters = new ArrayList<Object>();
        if (time != null) {
            range = time;
            filters.add(FeatureUtilities.DEFAULT_FILTER_FACTORY.and((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.lessOrEqual((Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.property(timeFilterAttribute), (Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.literal((Object)range.getMaxValue())), (Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.greaterOrEqual((Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.property(timeFilterAttribute), (Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.literal((Object)range.getMinValue()))));
        }
        if (elevation != null) {
            range = elevation;
            filters.add(FeatureUtilities.DEFAULT_FILTER_FACTORY.and((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.lessOrEqual((Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.property(elevationFilterAttribute), (Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.literal((Object)range.getMaxValue())), (Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.greaterOrEqual((Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.property(elevationFilterAttribute), (Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.literal((Object)range.getMinValue()))));
        }
        if (requestFilter != null) {
            filters.add(requestFilter);
        }
        And filter = FeatureUtilities.DEFAULT_FILTER_FACTORY.and(filters);
        query.setFilter((Filter)filter);
    }

    private void prepareParams() throws DataSourceException {
        try {
            this.baseReadParameters = new ImageReadParam();
            this.performDecimation(this.baseReadParameters);
            this.initBBOX();
            this.initTransformations();
            this.initRasterBounds();
        }
        catch (Exception e) {
            throw new DataSourceException("Unable to create this mosaic", (Throwable)e);
        }
    }

    private void initRasterBounds() throws TransformException {
        GeneralEnvelope tempRasterBounds = CRS.transform((MathTransform)this.finalWorldToGridCorner, (org.opengis.geometry.Envelope)this.targetBBox);
        this.rasterBounds = tempRasterBounds.toRectangle2D().getBounds();
        if (this.rasterBounds.width == 0) {
            ++this.rasterBounds.width;
        }
        if (this.rasterBounds.height == 0) {
            ++this.rasterBounds.height;
        }
        if (this.oversampledRequest) {
            this.rasterBounds.grow(2, 2);
        }
    }

    private void initTransformations() throws Exception {
        SpatialRequestHelper.CoverageProperties properties = this.request.spatialRequestHelper.getCoverageProperties();
        this.baseGridToWorld = (AffineTransform)properties.getGridToWorld2D();
        double[] coverageFullResolution = properties.getFullResolution();
        double resX = coverageFullResolution[0];
        double resY = coverageFullResolution[1];
        double[] requestRes = this.request.spatialRequestHelper.getRequestedResolution();
        AffineTransform g2w = new AffineTransform(this.baseGridToWorld);
        g2w.concatenate(CoverageUtilities.CENTER_TO_CORNER);
        if (requestRes[0] < resX || requestRes[1] < resY) {
            this.oversampledRequest = true;
        } else {
            g2w.concatenate(AffineTransform.getScaleInstance(this.baseReadParameters.getSourceXSubsampling(), this.baseReadParameters.getSourceYSubsampling()));
        }
        this.finalGridToWorldCorner = new AffineTransform2D(g2w);
        this.finalWorldToGridCorner = this.finalGridToWorldCorner.inverse();
    }

    private void initBBOX() {
        BoundingBox cropBBOX = this.request.spatialRequestHelper.getCropBBox();
        this.targetBBox = cropBBOX != null ? ReferencedEnvelope.reference((BoundingBox)cropBBOX) : new ReferencedEnvelope((org.opengis.geometry.Envelope)this.coverageEnvelope);
    }

    private GridCoverage2D prepareCoverage(RenderedImage image, GridSampleDimension[] sampleDimensions) throws IOException {
        Map properties = null;
        return COVERAGE_FACTORY.create((CharSequence)this.request.name, image, new GridGeometry2D((GridEnvelope)new GridEnvelope2D(PlanarImage.wrapRenderedImage((RenderedImage)image).getBounds()), PixelInCell.CELL_CORNER, (MathTransform)this.finalGridToWorldCorner, this.targetBBox.getCoordinateReferenceSystem(), this.hints), sampleDimensions, null, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RenderedImage loadRaster(ImageReadParam imageReadParameters, int index, ReferencedEnvelope cropBBox, MathTransform2D mosaicWorldToGrid, Hints hints) throws IOException {
        if (LOGGER.isLoggable(Level.FINER)) {
            String name = Thread.currentThread().getName();
            LOGGER.finer("Thread:" + name + " Loading raster data for granuleDescriptor " + this.toString());
        }
        ImageReadParam readParameters = null;
        ReferencedEnvelope bbox = this.request.spatialRequestHelper.getCoverageProperties().getBbox();
        ReferencedEnvelope intersection = new ReferencedEnvelope(bbox.intersection((Envelope)cropBBox), cropBBox.getCoordinateReferenceSystem());
        if (intersection.isEmpty()) {
            if (!LOGGER.isLoggable(Level.FINE)) return null;
            LOGGER.fine("Got empty intersection for granule " + this.toString() + " with request " + this.request.toString() + " Resulting in no granule loaded: Empty result");
            return null;
        }
        try {
            Object extender;
            Object scheduler;
            Object cache;
            RenderedImage raster;
            int imageIndex = index;
            readParameters = imageReadParameters;
            AffineTransform gridToWorldTransform_ = new AffineTransform();
            gridToWorldTransform_.preConcatenate(CoverageUtilities.CENTER_TO_CORNER);
            gridToWorldTransform_.preConcatenate(this.baseGridToWorld);
            AffineTransform2D cropWorldToGrid = new AffineTransform2D(gridToWorldTransform_);
            cropWorldToGrid = (AffineTransform2D)cropWorldToGrid.inverse();
            Rectangle sourceArea = CRS.transform((MathTransform)cropWorldToGrid, (org.opengis.geometry.Envelope)intersection).toRectangle2D().getBounds();
            Rectangle initialArea = this.request.source.getSpatialDomain().getRasterElements(true, null).iterator().next().toRectangle();
            sourceArea = sourceArea.intersection(initialArea);
            if (sourceArea.isEmpty()) {
                if (!LOGGER.isLoggable(Level.FINE)) return null;
                LOGGER.fine("Got empty area for granuleDescriptor " + this.toString() + " with request " + this.request.toString() + " Resulting in no granule loaded: Empty result");
                return null;
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Loading level " + imageIndex + " with source region: " + sourceArea + " subsampling: " + readParameters.getSourceXSubsampling() + "," + readParameters.getSourceYSubsampling() + " for granule:" + this.datasetURL);
            }
            readParameters.setSourceRegion(sourceArea);
            try {
                raster = this.request.readType.read(readParameters, imageIndex, this.datasetURL, this.request.spatialRequestHelper.getCoverageProperties().getRasterArea(), this.request.source.reader, hints, false);
            }
            catch (Throwable e) {
                if (!LOGGER.isLoggable(Level.FINE)) return null;
                LOGGER.log(Level.FINE, "Unable to load raster for granuleDescriptor " + this.toString() + " with request " + this.request.toString() + " Resulting in no granule loaded: Empty result", e);
                return null;
            }
            sourceArea.setRect(readParameters.getSourceRegion());
            double decimationScaleX = 1.0 * (double)sourceArea.width / (double)raster.getWidth();
            double decimationScaleY = 1.0 * (double)sourceArea.height / (double)raster.getHeight();
            AffineTransform decimationScaleTranform = XAffineTransform.getScaleInstance((double)decimationScaleX, (double)decimationScaleY);
            AffineTransform afterDecimationTranslateTranform = XAffineTransform.getTranslateInstance((double)sourceArea.x, (double)sourceArea.y);
            AffineTransform finalRaster2Model = new AffineTransform(this.baseGridToWorld);
            finalRaster2Model.concatenate(CoverageUtilities.CENTER_TO_CORNER);
            if (!XAffineTransform.isIdentity((AffineTransform)afterDecimationTranslateTranform, (double)1.0E-6)) {
                finalRaster2Model.concatenate(afterDecimationTranslateTranform);
            }
            if (!XAffineTransform.isIdentity((AffineTransform)decimationScaleTranform, (double)1.0E-6)) {
                finalRaster2Model.concatenate(decimationScaleTranform);
            }
            finalRaster2Model.preConcatenate((AffineTransform)mosaicWorldToGrid);
            Interpolation interpolation = this.request.getInterpolation();
            Rectangle2D finalLayout = ImageUtilities.layoutHelper((RenderedImage)raster, (float)((float)finalRaster2Model.getScaleX()), (float)((float)finalRaster2Model.getScaleY()), (float)((float)finalRaster2Model.getTranslateX()), (float)((float)finalRaster2Model.getTranslateY()), (Interpolation)interpolation);
            if (finalLayout.isEmpty()) {
                if (!LOGGER.isLoggable(Level.INFO)) return null;
                LOGGER.info("Unable to create a granuleDescriptor " + this.toString() + " due to jai scale bug creating a null source area");
                return null;
            }
            RenderingHints localHints = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, interpolation instanceof InterpolationNearest ? Boolean.FALSE : Boolean.TRUE);
            if (hints != null && hints.containsKey((Object)JAI.KEY_TILE_CACHE) && (cache = hints.get((Object)JAI.KEY_TILE_CACHE)) != null && cache instanceof TileCache) {
                localHints.add(new RenderingHints(JAI.KEY_TILE_CACHE, (TileCache)cache));
            }
            if (hints != null && hints.containsKey((Object)JAI.KEY_TILE_SCHEDULER) && (scheduler = hints.get((Object)JAI.KEY_TILE_SCHEDULER)) != null && scheduler instanceof TileScheduler) {
                localHints.add(new RenderingHints(JAI.KEY_TILE_SCHEDULER, (TileScheduler)scheduler));
            }
            boolean addBorderExtender = true;
            if (hints != null && hints.containsKey((Object)JAI.KEY_BORDER_EXTENDER) && (extender = hints.get((Object)JAI.KEY_BORDER_EXTENDER)) != null && extender instanceof BorderExtender) {
                localHints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, (BorderExtender)extender));
                addBorderExtender = false;
            }
            if (addBorderExtender) {
                localHints.add(ImageUtilities.BORDER_EXTENDER_HINTS);
            }
            ImageWorker iw = new ImageWorker(raster);
            iw.setRenderingHints(localHints);
            iw.affine(finalRaster2Model, interpolation, DEFAULT_BACKGROUND_VALUES);
            return iw.getRenderedImage();
        }
        catch (IllegalStateException e) {
            if (!LOGGER.isLoggable(Level.WARNING)) return null;
            LOGGER.log(Level.WARNING, "Unable to load raster for granuleDescriptor " + this.toString() + " with request " + this.request.toString() + " Resulting in no granule loaded: Empty result", e);
            return null;
        }
        catch (NoninvertibleTransformException e) {
            if (!LOGGER.isLoggable(Level.WARNING)) return null;
            LOGGER.log(Level.WARNING, "Unable to load raster for granuleDescriptor " + this.toString() + " with request " + this.request.toString() + " Resulting in no granule loaded: Empty result", e);
            return null;
        }
        catch (TransformException e) {
            if (!LOGGER.isLoggable(Level.WARNING)) return null;
            LOGGER.log(Level.WARNING, "Unable to load raster for granuleDescriptor " + this.toString() + " with request " + this.request.toString() + " Resulting in no granule loaded: Empty result", e);
            return null;
        }
    }

    private void performDecimation(ImageReadParam readParameters) {
        double[] requestedResolution = this.request.spatialRequestHelper.getRequestedResolution();
        Rectangle coverageRasterArea = this.request.spatialRequestHelper.getCoverageProperties().getRasterArea();
        double[] fullResolution = this.request.spatialRequestHelper.getCoverageProperties().getFullResolution();
        Utilities.ensureNonNull((String)"readParameters", (Object)readParameters);
        if (requestedResolution == null) {
            readParameters.setSourceSubsampling(1, 1, 0, 0);
            return;
        }
        int rasterWidth = coverageRasterArea.width;
        int rasterHeight = coverageRasterArea.height;
        int subSamplingFactorX = (int)Math.floor(requestedResolution[0] / fullResolution[0]);
        int n = subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
        while (rasterWidth / subSamplingFactorX <= 0 && subSamplingFactorX >= 0) {
            --subSamplingFactorX;
        }
        subSamplingFactorX = subSamplingFactorX <= 0 ? 1 : subSamplingFactorX;
        int subSamplingFactorY = (int)Math.floor(requestedResolution[1] / fullResolution[1]);
        int n2 = subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
        while (rasterHeight / subSamplingFactorY <= 0 && subSamplingFactorY >= 0) {
            --subSamplingFactorY;
        }
        subSamplingFactorY = subSamplingFactorY <= 0 ? 1 : subSamplingFactorY;
        readParameters.setSourceSubsampling(subSamplingFactorX, subSamplingFactorY, 0, 0);
    }
}

