/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf;

import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import it.geosolutions.imageio.stream.input.URIImageInputStreamImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.geotools.coverage.io.CoverageAccess;
import org.geotools.coverage.io.Driver;
import org.geotools.coverage.io.FileDriver;
import org.geotools.coverage.io.impl.DefaultFileDriver;
import org.geotools.coverage.io.netcdf.NetCDFAccess;
import org.geotools.factory.Hints;
import org.geotools.imageio.netcdf.NetCDFImageReaderSpi;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.util.logging.Logging;
import org.opengis.util.ProgressListener;

public class NetCDFDriver
extends DefaultFileDriver
implements FileDriver,
Driver {
    private static final List<String> EXTENSIONS = NetCDFUtilities.isGribAvailable() ? Arrays.asList("nc", "grb", "grb2", "grib") : Arrays.asList("nc");
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.coverage.io.netcdf");
    static final ImageReaderSpi SPI;

    public NetCDFDriver() {
        super("NetCDF", "NetCDF Coverage Format", "NetCDF Coverage Format", null, EXTENSIONS, EnumSet.of(Driver.DriverCapabilities.CONNECT));
    }

    @Override
    public CoverageAccess connect(URL source, Map<String, Serializable> params, Hints hints, ProgressListener listener) throws IOException {
        return new NetCDFAccess((Driver)this, source, params, hints, listener);
    }

    @Override
    public CoverageAccess connect(Map<String, Serializable> params, Hints hints, ProgressListener listener) throws IOException {
        return new NetCDFAccess((Driver)this, null, params, hints, listener);
    }

    @Override
    public boolean isAvailable() {
        return NetCDFDriver.checkNetCDF();
    }

    public static boolean checkNetCDF() {
        boolean available = true;
        try {
            Class.forName("javax.media.jai.JAI");
            Class.forName("com.sun.media.jai.operator.ImageReadDescriptor");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("NetCDFDriver is available.");
            }
        }
        catch (ClassNotFoundException cnf) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("NetCDFDriver is not available.");
            }
            available = false;
        }
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean canConnect(URL url, Map<String, Serializable> params) {
        if (url == null) {
            return false;
        }
        ImageInputStream inputStream = null;
        Object source = null;
        try {
            if (url.getProtocol().equalsIgnoreCase("file")) {
                File file = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
                if (file.exists()) {
                    if (!file.canRead() || !file.isFile()) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("File cannot be read or it is a directory");
                        }
                        boolean bl = false;
                        return bl;
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Provided URL is a file");
                    }
                } else {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("File doesn't exist");
                    }
                    boolean bl = false;
                    return bl;
                }
                source = file;
            } else {
                if (url.getProtocol().toLowerCase().startsWith("http") || url.getProtocol().equalsIgnoreCase("dods")) {
                    URIImageInputStreamImpl uriInStream = new URIImageInputStreamImpl(url.toURI());
                    source = uriInStream;
                    if (!SPI.canDecodeInput(source)) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Unable to decode the inputStream");
                        }
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                if (url.getProtocol().equalsIgnoreCase("ftp")) {
                    source = url.openStream();
                } else {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Unsupported protocol");
                    }
                    boolean uriInStream = false;
                    return uriInStream;
                }
            }
            inputStream = (ImageInputStream)(source instanceof ImageInputStream ? source : (source instanceof File ? new FileImageInputStreamExtImpl((File)source) : ImageIO.createImageInputStream(source)));
            if (inputStream == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Unable to get an ImageInputStream");
                }
                boolean uriInStream = false;
                return uriInStream;
            }
            inputStream.mark();
            if (!SPI.canDecodeInput(inputStream)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Unable to decode the inputStream");
                }
                boolean uriInStream = false;
                return uriInStream;
            }
            boolean uriInStream = true;
            return uriInStream;
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            block74: {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {}
                }
                if (source != null && source instanceof InputStream) {
                    try {
                        ((InputStream)source).close();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block74;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    }

    static {
        NetCDFImageReaderSpi temp = null;
        if (NetCDFDriver.checkNetCDF()) {
            try {
                temp = new NetCDFImageReaderSpi();
            }
            catch (Throwable e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                temp = null;
            }
        }
        SPI = temp;
    }
}

