/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.jp2k;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.geotools.coverageio.jp2k.Utils;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.Logging;

enum ReadType {
    DIRECT_READ{

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        RenderedImage read(ImageReadParam readP, int imageIndex, File rasterFile, Rectangle readDimension, Dimension tileDimension, ImageReaderSpi spi) throws IOException {
            ImageInputStream inStream = null;
            ImageReader reader = null;
            try {
                inStream = Utils.getInputStream(rasterFile);
                if (inStream == null) {
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
                reader = spi.createReaderInstance();
                if (reader == null) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Unable to get reader for file " + rasterFile.getAbsolutePath());
                    }
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
                inStream.reset();
                reader.setInput(inStream);
                if (CoverageUtilities.checkEmptySourceRegion(readP, readDimension)) {
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "reading file: " + rasterFile.getAbsolutePath());
                }
                BufferedImage bufferedImage = reader.read(imageIndex, readP);
                return bufferedImage;
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Unable to compute source area for file " + rasterFile.getAbsolutePath(), e);
                }
                RenderedImage renderedImage = null;
                return renderedImage;
            }
            finally {
                try {
                    reader.dispose();
                }
                catch (Throwable t) {}
                try {
                    inStream.close();
                }
                catch (Throwable t) {}
            }
        }
    }
    ,
    JAI_IMAGEREAD{

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        RenderedImage read(ImageReadParam readP, int imageIndex, File rasterFile, Rectangle readDimension, Dimension tileDimension, ImageReaderSpi spi) throws IOException {
            RenderedOp raster;
            ImageInputStream inStream = null;
            ImageReader reader = null;
            try {
                inStream = Utils.getInputStream(rasterFile);
                if (inStream == null) {
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
                reader = spi.createReaderInstance();
                if (reader == null) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Unable to get reader for file " + rasterFile.getAbsolutePath());
                    }
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
                inStream.reset();
                reader.setInput(inStream);
                if (CoverageUtilities.checkEmptySourceRegion(readP, readDimension)) {
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Unable to compute source area for file " + rasterFile.getAbsolutePath(), e);
                }
                RenderedImage t = null;
                return t;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.dispose();
                    }
                }
                catch (Throwable t) {}
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (Throwable t) {}
            }
            ParameterBlock pbjImageRead = new ParameterBlock();
            pbjImageRead.add(rasterFile);
            pbjImageRead.add(imageIndex);
            pbjImageRead.add(false);
            pbjImageRead.add(false);
            pbjImageRead.add(false);
            pbjImageRead.add(null);
            pbjImageRead.add(null);
            pbjImageRead.add(readP);
            pbjImageRead.add(spi.createReaderInstance());
            if (tileDimension != null) {
                ImageLayout layout = new ImageLayout();
                layout.setTileWidth(tileDimension.width).setTileHeight(tileDimension.height);
                raster = JAI.create((String)"ImageRead", (ParameterBlock)pbjImageRead, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            } else {
                raster = JAI.create((String)"ImageRead", (ParameterBlock)pbjImageRead);
            }
            if (raster == null) return raster;
            raster.getWidth();
            return raster;
        }
    }
    ,
    JAI_IMAGEREAD_MT{

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        RenderedImage read(ImageReadParam readP, int imageIndex, File rasterFile, Rectangle readDimension, Dimension tileDimension, ImageReaderSpi spi) throws IOException {
            RenderedOp raster;
            ImageInputStream inStream = null;
            ImageReader reader = null;
            try {
                inStream = Utils.getInputStream(rasterFile);
                if (inStream == null) {
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
                reader = spi.createReaderInstance();
                if (reader == null) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Unable to get reader for file " + rasterFile.getAbsolutePath());
                    }
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
                inStream.reset();
                reader.setInput(inStream);
                if (CoverageUtilities.checkEmptySourceRegion(readP, readDimension)) {
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Unable to compute source area for file " + rasterFile.getAbsolutePath(), e);
                }
                RenderedImage t = null;
                return t;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.dispose();
                    }
                }
                catch (Throwable t) {}
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (Throwable t) {}
            }
            ParameterBlock pbjImageRead = new ParameterBlock();
            pbjImageRead.add(rasterFile);
            pbjImageRead.add(imageIndex);
            pbjImageRead.add(false);
            pbjImageRead.add(false);
            pbjImageRead.add(false);
            pbjImageRead.add(null);
            pbjImageRead.add(null);
            pbjImageRead.add(readP);
            pbjImageRead.add(spi.createReaderInstance());
            if (tileDimension != null) {
                ImageLayout layout = new ImageLayout();
                layout.setTileWidth(tileDimension.width).setTileHeight(tileDimension.height);
                raster = JAI.create((String)"ImageReadMT", (ParameterBlock)pbjImageRead, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            } else {
                raster = JAI.create((String)"ImageReadMT", (ParameterBlock)pbjImageRead);
            }
            if (raster == null) return raster;
            raster.getWidth();
            return raster;
        }
    }
    ,
    UNSPECIFIED{

        @Override
        RenderedImage read(ImageReadParam readP, int imageIndex, File rasterFile, Rectangle readDimension, Dimension tileDimension, ImageReaderSpi spi) throws IOException {
            throw new UnsupportedOperationException(Errors.format((int)205, (Object)"read"));
        }
    };

    private static final Logger LOGGER;

    static ReadType getDefault() {
        return JAI_IMAGEREAD;
    }

    abstract RenderedImage read(ImageReadParam var1, int var2, File var3, Rectangle var4, Dimension var5, ImageReaderSpi var6) throws IOException;

    static {
        LOGGER = Logging.getLogger(ReadType.class);
    }
}

