/*
 * Decompiled with CFR 0.152.
 */
package org.ochafik.util.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    static Pattern spacePattern;
    public static final String LINE_SEPARATOR;

    public static String htmlize(String text) {
        return text.startsWith("<?") || text.startsWith("<html>") ? text : "<html><body>" + text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "<br>") + "</body></html>";
    }

    public static List<String> explode(String s) {
        if (spacePattern == null) {
            spacePattern = Pattern.compile("\\s+");
        }
        return StringUtils.explode(s, spacePattern);
    }

    public static List<String> explode(String s, String sep) {
        StringTokenizer st = new StringTokenizer(s, sep);
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v;
    }

    public static String implode(double[] array, String separator) {
        StringBuffer out = new StringBuffer();
        boolean first = true;
        for (double v : array) {
            if (first) {
                first = false;
            } else {
                out.append(separator);
            }
            out.append(v);
        }
        return out.toString();
    }

    public static String implode(Object[] values) {
        return StringUtils.implode(values, (Object)", ");
    }

    public static String implode(Object[] values, Object separator) {
        return StringUtils.implode(Arrays.asList(values), separator);
    }

    public static final <T> String implode(Iterable<T> elements, Object separator) {
        String sepStr = separator.toString();
        StringBuilder out = new StringBuilder();
        boolean first = true;
        for (T s : elements) {
            if (s == null) continue;
            if (first) {
                first = false;
            } else {
                out.append(sepStr);
            }
            out.append(s);
        }
        return out.toString();
    }

    public static final String implode(Iterable<?> strings) {
        return StringUtils.implode(strings, (Object)", ");
    }

    public static final List<String> explode(String string, Pattern separator) {
        String s;
        int lastIndex = 0;
        int len = string.length();
        Matcher matcher = separator.matcher(string);
        LinkedList<String> ret = new LinkedList<String>();
        while (matcher.find()) {
            s = string.substring(lastIndex, matcher.start());
            if (s.length() > 0) {
                ret.add(s);
            }
            lastIndex = matcher.end();
        }
        s = string.substring(lastIndex, len);
        if (s.length() > 0) {
            ret.add(s);
        }
        return ret;
    }

    public static String replace(String pattern, String replace, String s) {
        return StringUtils.concatWithSeparator(StringUtils.explode(s, pattern).toArray(new String[0]), replace);
    }

    public static final String concat(String[] a) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            b.append(a[i]);
        }
        return b.toString();
    }

    public static final String concatln(String[] a) {
        StringBuffer b = new StringBuffer();
        int lenm = a.length - 1;
        for (int i = 0; i < lenm; ++i) {
            b.append(a[i]);
            b.append("\n");
        }
        if (lenm != -1) {
            b.append(a[lenm]);
        }
        return b.toString();
    }

    public static final String concatSpace(String[] a) {
        StringBuffer b = new StringBuffer();
        int lenm = a.length - 1;
        for (int i = 0; i < lenm; ++i) {
            b.append(a[i]);
            b.append(" ");
        }
        if (lenm != -1) {
            b.append(a[lenm]);
        }
        return b.toString();
    }

    public static final String concatWithSeparator(String[] a, String sep) {
        StringBuffer b = new StringBuffer();
        int lenm = a.length - 1;
        for (int i = 0; i < lenm; ++i) {
            b.append(a[i]);
            b.append(sep);
        }
        if (lenm != -1) {
            b.append(a[lenm]);
        }
        return b.toString();
    }

    public static final String javaEscape(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuffer b = new StringBuffer(len);
        block13: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    b.append("\\n");
                    continue block13;
                }
                case '\t': {
                    b.append("\\t");
                    continue block13;
                }
                case '\r': {
                    b.append("\\r");
                    continue block13;
                }
                case '\"': {
                    b.append("\"");
                    continue block13;
                }
                case '\\': {
                    b.append("\\\\");
                    continue block13;
                }
                default: {
                    if (c > '\u007f' || Character.isISOControl(c)) {
                        b.append("\\u");
                        String nb = Integer.toString(c, 16);
                        int nblen = nb.length();
                        switch (nblen) {
                            case 1: {
                                b.append(0);
                            }
                            case 2: {
                                b.append(0);
                            }
                            case 3: {
                                b.append(0);
                            }
                            case 4: {
                                b.append(nb);
                                continue block13;
                            }
                        }
                        throw new IllegalArgumentException("Should not happen !");
                    }
                    b.append(c);
                }
            }
        }
        return b.toString();
    }

    public static final String javaUnEscape(String s) {
        int len = s.length();
        StringBuffer b = new StringBuffer(len);
        block11: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                c = s.charAt(++i);
                switch (c) {
                    case 'n': {
                        b.append('\n');
                        continue block11;
                    }
                    case 'r': {
                        b.append('\r');
                        continue block11;
                    }
                    case 't': {
                        b.append('\t');
                        continue block11;
                    }
                    case '\\': {
                        b.append('\\');
                        continue block11;
                    }
                    case '\"': {
                        b.append('\"');
                        continue block11;
                    }
                    case '\'': {
                        b.append('\'');
                        continue block11;
                    }
                    case 'u': {
                        try {
                            String nb = s.substring(i + 1, i + 5);
                            int n = Integer.parseInt(nb, 16);
                            b.append((char)n);
                            i += 4;
                            continue block11;
                        }
                        catch (Exception ex) {
                            throw new IllegalArgumentException("Illegal unicode escaping in string \"" + s + "\" at index " + i, ex);
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown character: \"\\" + String.valueOf(c) + "...\"");
                    }
                }
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String capitalize(String string) {
        return string == null ? null : (string.length() == 0 ? "" : Character.toUpperCase(string.charAt(0)) + string.substring(1));
    }

    public static String capitalize(List<String> strings, String separator) {
        ArrayList<String> cap = new ArrayList<String>(strings.size());
        for (String s : strings) {
            cap.add(StringUtils.capitalize(s));
        }
        return StringUtils.implode(cap, (Object)separator);
    }

    public static String uncapitalize(String string) {
        return string.length() == 0 ? "" : Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
    }
}

