/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.util;

public class JNIUtils {
    public static String getNativeName(Class c) {
        return c.getName().replace('.', '/');
    }

    public static String getNativeSignature(Class c) {
        if (c.isPrimitive()) {
            if (c == Integer.TYPE) {
                return "I";
            }
            if (c == Long.TYPE) {
                return "J";
            }
            if (c == Short.TYPE) {
                return "S";
            }
            if (c == Byte.TYPE) {
                return "B";
            }
            if (c == Boolean.TYPE) {
                return "Z";
            }
            if (c == Double.TYPE) {
                return "D";
            }
            if (c == Float.TYPE) {
                return "F";
            }
            if (c == Character.TYPE) {
                return "C";
            }
            if (c == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("unexpected case");
        }
        if (c.isArray()) {
            return "[" + JNIUtils.getNativeSignature(c.getComponentType());
        }
        return "L" + JNIUtils.getNativeName(c) + ";";
    }
}

