/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.util;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytecodeAnalyzer {
    final List<String> fieldNames = new ArrayList<String>();
    final List<String> methodNames = new ArrayList<String>();
    final BytecodeAnalyzer parentAnalyzer;

    public BytecodeAnalyzer(Class c, Class recurseTo) throws IOException {
        this(c, recurseTo, EnumSet.allOf(Features.class));
    }

    public BytecodeAnalyzer(Class c, Class recurseTo, EnumSet<Features> features) throws IOException {
        this(c, BytecodeAnalyzer.readBytes(BytecodeAnalyzer.getClassResource(c).openStream(), true), recurseTo, features);
    }

    public BytecodeAnalyzer(Class c, byte[] bytecode, Class recurseTo, final EnumSet<Features> features) throws IOException {
        Class p;
        ClassReader r = new ClassReader(bytecode);
        EmptyVisitor v = new EmptyVisitor(){
            final boolean getFieldNames;
            final boolean getMethodNames;
            {
                this.getFieldNames = features.contains((Object)Features.FieldNames);
                this.getMethodNames = features.contains((Object)Features.MethodNames);
            }

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                if (this.getFieldNames) {
                    BytecodeAnalyzer.this.fieldNames.add(name);
                }
                return null;
            }

            public MethodVisitor visitMethod(int i, String name, String string1, String string2, String[] strings) {
                if (this.getMethodNames) {
                    BytecodeAnalyzer.this.methodNames.add(name);
                }
                return null;
            }
        };
        r.accept(v, 7);
        this.parentAnalyzer = recurseTo != c && (p = c.getSuperclass()) != null && p != recurseTo ? new BytecodeAnalyzer(p, recurseTo, features) : null;
    }

    static List<String> add(List<String> a, List<String> b) {
        ArrayList<String> ret = new ArrayList<String>(a.size() + b.size());
        ret.addAll(a);
        ret.addAll(b);
        return ret;
    }

    public List<String> getFieldNames() {
        if (this.parentAnalyzer != null) {
            return BytecodeAnalyzer.add(this.parentAnalyzer.getFieldNames(), this.fieldNames);
        }
        return this.fieldNames;
    }

    public List<String> getMethodNames() {
        if (this.parentAnalyzer != null) {
            return BytecodeAnalyzer.add(this.parentAnalyzer.getMethodNames(), this.methodNames);
        }
        return this.methodNames;
    }

    static URL getClassResource(Class c) throws FileNotFoundException {
        String n = c.getName();
        String p = n.replace('.', '/') + ".class";
        URL u = c.getClassLoader().getResource(p);
        if (u == null) {
            throw new FileNotFoundException("Resource '" + p + "'");
        }
        return u;
    }

    static byte[] readBytes(InputStream in, boolean close) throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((len = in.read(b)) > 0) {
            out.write(b, 0, len);
        }
        if (close) {
            in.close();
        }
        return out.toByteArray();
    }

    public static List<String> getFieldNames(Class c, Class recurseTo) throws IOException {
        return new BytecodeAnalyzer(c, recurseTo, EnumSet.of(Features.FieldNames)).getFieldNames();
    }

    public static List<String> getMethodNames(Class c, Class recurseTo) throws IOException {
        return new BytecodeAnalyzer(c, recurseTo, EnumSet.of(Features.MethodNames)).getMethodNames();
    }

    static class EmptyVisitor
    implements ClassVisitor {
        EmptyVisitor() {
        }

        public void visit(int i, int i1, String string, String string1, String string2, String[] strings) {
        }

        public void visitSource(String string, String string1) {
        }

        public void visitOuterClass(String string, String string1, String string2) {
        }

        public AnnotationVisitor visitAnnotation(String string, boolean bln) {
            return null;
        }

        public void visitAttribute(Attribute atrbt) {
        }

        public void visitInnerClass(String string, String string1, String string2, int i) {
        }

        public FieldVisitor visitField(int i, String string, String string1, String string2, Object o) {
            return null;
        }

        public MethodVisitor visitMethod(int i, String string, String string1, String string2, String[] strings) {
            return null;
        }

        public void visitEnd() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Features {
        FieldNames,
        MethodNames;

    }
}

