/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.demangling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bridj.CLong;
import org.bridj.NativeLibrary;
import org.bridj.demangling.Demangler;

public class GCC4Demangler
extends Demangler {
    private Map<String, Demangler.TypeRef> shortcuts = new HashMap<String, Demangler.TypeRef>();
    int nextShortcutId = -1;

    public GCC4Demangler(NativeLibrary library, String symbol) {
        super(library, symbol);
    }

    private String nextShortcutId() {
        int n;
        return (n = this.nextShortcutId++) == -1 ? "_" : Integer.toString(n, 36).toUpperCase() + "_";
    }

    private Demangler.TypeRef parseShortcutType() {
        char c;
        if (this.peekChar() == '_') {
            return this.shortcuts.get(Character.toString(this.consumeChar()));
        }
        String id = "";
        while ((c = this.peekChar()) != '_' && c != 'E' && c != '\u0000') {
            id = id + this.consumeChar();
        }
        if (c != 'E') {
            id = id + this.consumeChar();
        }
        if (id.equals("s")) {
            return GCC4Demangler.classType(StdString.class, new Class[0]);
        }
        Demangler.TypeRef res = this.shortcuts.get(id);
        return res;
    }

    private Demangler.TypeRef parsePointerType() throws Demangler.DemanglingException {
        Demangler.TypeRef pointed = this.parseType();
        Demangler.TypeRef res = GCC4Demangler.pointerType(pointed);
        String id = this.nextShortcutId();
        this.shortcuts.put(id, res);
        return res;
    }

    public Demangler.TemplateArg parseTemplateArg() throws Demangler.DemanglingException {
        if (this.consumeCharIf('L')) {
            char c;
            Demangler.TypeRef tr = this.parseType();
            StringBuffer b = new StringBuffer();
            while (Character.isDigit(c = this.peekChar())) {
                this.consumeChar();
                b.append(c);
            }
            this.expectChars('E');
            return new Demangler.Constant(Integer.parseInt(b.toString()));
        }
        return this.parseType();
    }

    public Demangler.TypeRef parseType() throws Demangler.DemanglingException {
        if (Character.isDigit(this.peekChar())) {
            Demangler.Ident name = this.parseIdent();
            String id = this.nextShortcutId();
            Demangler.TypeRef res = GCC4Demangler.simpleType(name);
            this.shortcuts.put(id, res);
            return res;
        }
        char c = this.consumeChar();
        switch (c) {
            case 'S': {
                return this.parseShortcutType();
            }
            case 'P': {
                return this.parsePointerType();
            }
            case 'F': {
                while (this.consumeChar() != 'E') {
                }
                return null;
            }
            case 'K': {
                return this.parseType();
            }
            case 'v': {
                return GCC4Demangler.classType(Void.TYPE, new Class[0]);
            }
            case 'a': 
            case 'c': 
            case 'h': {
                return GCC4Demangler.classType(Byte.TYPE, new Class[0]);
            }
            case 'b': {
                return GCC4Demangler.classType(Boolean.TYPE, new Class[0]);
            }
            case 'l': 
            case 'm': {
                return GCC4Demangler.classType(CLong.class, new Class[0]);
            }
            case 'x': 
            case 'y': {
                return GCC4Demangler.classType(Long.TYPE, new Class[0]);
            }
            case 'i': 
            case 'j': {
                return GCC4Demangler.classType(Integer.TYPE, new Class[0]);
            }
            case 's': 
            case 't': {
                return GCC4Demangler.classType(Short.TYPE, new Class[0]);
            }
            case 'f': {
                return GCC4Demangler.classType(Float.TYPE, new Class[0]);
            }
            case 'd': {
                return GCC4Demangler.classType(Double.TYPE, new Class[0]);
            }
            case 'z': {
                return GCC4Demangler.classType(Object[].class, new Class[0]);
            }
        }
        throw this.error("Unexpected type char '" + c + "'", -1);
    }

    String parseName() throws Demangler.DemanglingException {
        int len;
        char c;
        StringBuilder b = new StringBuilder();
        while (Character.isDigit(c = this.peekChar())) {
            this.consumeChar();
            b.append(c);
        }
        try {
            len = Integer.parseInt(b.toString());
        }
        catch (NumberFormatException ex) {
            throw this.error("Expected a number", 0);
        }
        b.setLength(0);
        for (int i = 0; i < len; ++i) {
            b.append(this.consumeChar());
        }
        return b.toString();
    }

    Demangler.Ident parseIdent() throws Demangler.DemanglingException {
        String n = this.parseName();
        ArrayList<Demangler.TemplateArg> args = new ArrayList<Demangler.TemplateArg>();
        if (this.consumeCharIf('I')) {
            while (!this.consumeCharIf('E')) {
                args.add(this.parseTemplateArg());
            }
        }
        return new Demangler.Ident(n, args.toArray(new Demangler.TemplateArg[args.size()]));
    }

    public Demangler.MemberRef parseSymbol() throws Demangler.DemanglingException {
        Demangler.MemberRef mr = new Demangler.MemberRef();
        if (!this.consumeCharIf('_')) {
            mr.setMemberName(new Demangler.Ident(this.str, new Demangler.TemplateArg[0]));
            return mr;
        }
        this.consumeCharIf('_');
        this.expectChars('Z');
        if (this.consumeCharIf('T')) {
            if (this.consumeCharIf('V')) {
                mr.setEnclosingType(new Demangler.ClassRef(this.parseIdent()));
                mr.setMemberName(Demangler.SpecialName.VFTable);
                return mr;
            }
            return null;
        }
        if (this.consumeCharsIf('d', 'l', 'P', 'v')) {
            mr.setMemberName(Demangler.SpecialName.Delete);
            return mr;
        }
        if (this.consumeCharsIf('d', 'a', 'P', 'v')) {
            mr.setMemberName(Demangler.SpecialName.DeleteArray);
            return mr;
        }
        if (this.consumeCharsIf('n', 'w', 'm')) {
            mr.setMemberName(Demangler.SpecialName.New);
            return mr;
        }
        if (this.consumeCharsIf('n', 'a', 'm')) {
            mr.setMemberName(Demangler.SpecialName.NewArray);
            return mr;
        }
        ArrayList<Demangler.Ident> ns = new ArrayList<Demangler.Ident>();
        if (this.consumeCharIf('N')) {
            do {
                ++this.nextShortcutId;
                ns.add(this.parseIdent());
            } while (Character.isDigit(this.peekChar()));
            --this.nextShortcutId;
            mr.setMemberName((Demangler.IdentLike)ns.remove(ns.size() - 1));
            if (!ns.isEmpty()) {
                Demangler.ClassRef parent = new Demangler.ClassRef((Demangler.Ident)ns.remove(ns.size() - 1));
                if (!ns.isEmpty()) {
                    parent.setEnclosingType(new Demangler.NamespaceRef(ns.toArray(new Demangler.Ident[ns.size()])));
                }
                mr.setEnclosingType(parent);
            } else {
                char c = this.peekChar();
                switch (c) {
                    case 'C': {
                        this.consumeChar();
                        mr.setEnclosingType(new Demangler.ClassRef((Demangler.Ident)mr.getMemberName()));
                        if (this.consumeCharIf('1')) {
                            mr.setMemberName(Demangler.SpecialName.Constructor);
                            break;
                        }
                        if (this.consumeCharIf('2')) {
                            mr.setMemberName(Demangler.SpecialName.SpecialConstructor);
                            break;
                        }
                        this.error("Unknown constructor type");
                        break;
                    }
                    case 'D': {
                        this.consumeChar();
                        mr.setEnclosingType(new Demangler.ClassRef((Demangler.Ident)mr.getMemberName()));
                        if (this.consumeCharIf('0')) {
                            mr.setMemberName(Demangler.SpecialName.DeletingDestructor);
                            break;
                        }
                        if (this.consumeCharIf('1')) {
                            mr.setMemberName(Demangler.SpecialName.Destructor);
                            break;
                        }
                        if (this.consumeCharIf('2')) {
                            mr.setMemberName(Demangler.SpecialName.SelfishDestructor);
                            break;
                        }
                        this.error("Unknown destructor type");
                    }
                }
            }
        } else {
            mr.setMemberName(this.parseIdent());
        }
        boolean isMethod = this.consumeCharIf('E');
        if (this.consumeCharIf('v')) {
            if (this.position < this.length) {
                this.error("Expected end of symbol", 0);
            }
            mr.paramTypes = new Demangler.TypeRef[0];
        } else {
            ArrayList<Demangler.TypeRef> paramTypes = new ArrayList<Demangler.TypeRef>();
            while (this.position < this.length) {
                paramTypes.add(this.parseType());
            }
            mr.paramTypes = paramTypes.toArray(new Demangler.TypeRef[paramTypes.size()]);
        }
        return mr;
    }

    public static class StdString {
    }
}

