/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.PointerIO;
import org.bridj.TypedPointer;

interface CallIO {
    public Object newInstance(long var1);

    public void checkArg(Object var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GenericPointerHandler
    implements CallIO {
        Type targetType;
        PointerIO pointerIO;

        public GenericPointerHandler(Type targetType) {
            this.targetType = targetType;
            this.pointerIO = PointerIO.getInstance(targetType);
        }

        @Override
        public Pointer<?> newInstance(long address) {
            return Pointer.pointerToAddress(address, this.pointerIO);
        }

        @Override
        public void checkArg(Object ptr) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NativeObjectHandler
    implements CallIO {
        Class<? extends NativeObject> nativeClass;
        Type nativeType;

        public NativeObjectHandler(Class<? extends NativeObject> type, Type t) {
            this.nativeClass = type;
            this.nativeType = t;
        }

        @Override
        public NativeObject newInstance(long address) {
            return Pointer.pointerToAddress(address).getNativeObject(this.nativeClass);
        }

        @Override
        public void checkArg(Object ptr) {
            if (ptr == null) {
                throw new IllegalArgumentException("Native object of type " + this.nativeClass.getName() + " passed by value cannot be given a null value !");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypedPointerIO
    implements CallIO {
        Class<? extends TypedPointer> type;
        Constructor<?> constructor;

        public TypedPointerIO(Class<? extends TypedPointer> type) {
            this.type = type;
            try {
                this.constructor = type.getConstructor(Long.TYPE);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to create " + CallIO.class.getName() + " for type " + type.getName(), ex);
            }
        }

        @Override
        public Pointer<?> newInstance(long address) {
            try {
                return (Pointer)this.constructor.newInstance(address);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to instantiate pointer of type " + this.type.getName(), ex);
            }
        }

        @Override
        public void checkArg(Object ptr) {
            this.type.cast(ptr);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Utils {
        public static CallIO createPointerCallIOToTargetType(Type targetType) {
            return new GenericPointerHandler(targetType);
        }

        public static CallIO createPointerCallIO(Type type) {
            return Utils.createPointerCallIO(org.bridj.util.Utils.getClass(type), type);
        }

        public static CallIO createPointerCallIO(Class<?> cl, Type type) {
            if (cl == Pointer.class) {
                return Utils.createPointerCallIOToTargetType(org.bridj.util.Utils.getUniqueParameterizedTypeParameter(type));
            }
            assert (TypedPointer.class.isAssignableFrom(cl));
            return new TypedPointerIO(cl);
        }
    }
}

