/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import android.app.Application;
import android.content.pm.ApplicationInfo;
import android.os.Environment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bridj.AndroidClassDefiner;
import org.bridj.ClassDefiner;
import org.bridj.NativeLibrary;
import org.bridj.Platform;
import org.bridj.PlatformSupport;

public class AndroidSupport
extends PlatformSupport {
    private volatile Application app;
    volatile AndroidClassDefiner classDefiner;

    AndroidSupport() {
    }

    synchronized void setApp(Application application) {
        if (this.app != null && application != null && this.app != application) {
            throw new IllegalArgumentException("Android Application has already been set to a different value : " + this.app);
        }
        this.app = application;
    }

    public static void setApplication(Application application) {
        ((AndroidSupport)PlatformSupport.getInstance()).setApp(application);
    }

    String adviseToSetApp() {
        return this.app == null ? "" : "Please use AndroidSupport.setApplication(Application). ";
    }

    synchronized File getCacheDir() throws FileNotFoundException {
        File cacheDir = null;
        if (this.app != null) {
            cacheDir = this.app.getCacheDir();
        }
        if (cacheDir == null || !cacheDir.isDirectory() || !cacheDir.canWrite()) {
            throw new FileNotFoundException("Failed to find the cache directory. " + this.adviseToSetApp());
        }
        return cacheDir;
    }

    public synchronized ClassDefiner getClassDefiner(ClassDefiner defaultDefiner, ClassLoader parentClassLoader) {
        if (this.classDefiner == null) {
            try {
                this.classDefiner = new AndroidClassDefiner(this.getCacheDir(), parentClassLoader);
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to instantiate the Android class definer : " + ex, ex);
            }
        }
        return this.classDefiner;
    }

    String getLibFileName(String libName) {
        return "lib" + libName + ".so";
    }

    synchronized File getNativeLibraryDir(String someBundledNativeLibraryName) throws FileNotFoundException {
        File f = null;
        if (this.app != null) {
            try {
                f = (File)ApplicationInfo.class.getField("nativeLibraryDir").get(this.app.getApplicationInfo());
            }
            catch (Throwable th) {
                // empty catch block
            }
        }
        if (f == null) {
            String someKnownResource = "lib/armeabi/" + this.getLibFileName(someBundledNativeLibraryName);
            f = new File(this.getApplicationDataDir(someKnownResource), "lib");
        }
        if (f != null && f.isDirectory()) {
            return f;
        }
        throw new FileNotFoundException("Failed to get the native library directory " + (f != null ? "(" + f + " is not a directory). " : ". ") + this.adviseToSetApp());
    }

    synchronized File getApplicationDataDir(String someKnownResource) throws FileNotFoundException {
        if (this.app != null) {
            return new File(this.app.getApplicationInfo().dataDir);
        }
        return new File(new File(Environment.getDataDirectory(), "data"), this.getPackageName(someKnownResource));
    }

    public synchronized NativeLibrary loadNativeLibrary(String name) throws FileNotFoundException {
        File f = new File(this.getNativeLibraryDir(name), this.getLibFileName(name));
        if (f.exists()) {
            return NativeLibrary.load(f == null ? name : f.toString());
        }
        throw new RuntimeException("File not found : " + f);
    }

    synchronized String getPackageName(String someKnownResource) throws FileNotFoundException {
        if (this.app != null) {
            return this.app.getPackageName();
        }
        URL resource = Platform.getClassLoader().getResource(someKnownResource);
        if (resource == null) {
            throw new FileNotFoundException("Resource does not exist : " + someKnownResource);
        }
        return AndroidSupport.getAndroidPackageNameFromResourceURL(resource.toString());
    }

    static String getAndroidPackageNameFromResourceURL(String url) {
        Pattern p = Pattern.compile("jar:file:/data/[^/]+/([^/]*?)\\.apk!.*");
        Matcher m = p.matcher(url);
        String packageName = null;
        if (!m.matches()) {
            p = Pattern.compile("jar:file:/.*?/([^/]+)/pkg\\.apk!.*");
            m = p.matcher(url);
        }
        if (m.matches() && (packageName = m.group(1)).matches(".*?-\\d+")) {
            int i = packageName.lastIndexOf("-");
            packageName = packageName.substring(0, i);
        }
        return packageName;
    }
}

