/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.sld.bindings.SLD;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.util.InternationalString;
import org.picocontainer.MutablePicoContainer;

public class SLDStyledLayerDescriptorBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;

    public SLDStyledLayerDescriptorBinding(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    public QName getTarget() {
        return SLD.STYLEDLAYERDESCRIPTOR;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return StyledLayerDescriptor.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        InternationalString intString;
        StyledLayerDescriptor sld = this.styleFactory.createStyledLayerDescriptor();
        if (node.hasChild("Name")) {
            sld.setName((String)node.getChildValue("Name"));
        }
        if (node.hasChild("Title")) {
            intString = (InternationalString)node.getChildValue("Title");
            sld.setTitle(intString.toString());
        }
        if (node.hasChild("Abstract")) {
            intString = (InternationalString)node.getChildValue("Abstract");
            sld.setAbstract(intString.toString());
        }
        StyledLayer[] layers = null;
        if (node.hasChild(NamedLayer.class)) {
            List namedLayers = node.getChildValues(NamedLayer.class);
            layers = namedLayers.toArray(new StyledLayer[namedLayers.size()]);
        } else if (node.hasChild(UserLayer.class)) {
            List userLayers = node.getChildValues(UserLayer.class);
            layers = userLayers.toArray(new StyledLayer[userLayers.size()]);
        }
        sld.setStyledLayers(layers);
        return sld;
    }
}

