/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.ogr.OGR;
import org.geotools.data.ogr.OGRDataStore;
import org.geotools.data.ogr.OGRDirectFeatureWriter;
import org.geotools.data.ogr.OGRFeatureSource;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

class OGRFeatureStore
extends ContentFeatureStore {
    OGRFeatureSource delegate;
    OGR ogr;

    public OGRFeatureStore(ContentEntry entry, Query query, OGR ogr) {
        super(entry, query);
        this.delegate = new OGRFeatureSource(entry, query, ogr);
        this.ogr = ogr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(Query query, int flags) throws IOException {
        Object dataSource = null;
        Object layer = null;
        boolean cleanup = true;
        try {
            String typeName = this.getEntry().getTypeName();
            dataSource = this.getDataStore().openOGRDataSource(true);
            layer = this.getDataStore().openOGRLayer(dataSource, typeName);
            FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.delegate.getReaderInternal(dataSource, layer, query);
            GeometryFactory gf = this.delegate.getGeometryFactory(query);
            OGRDirectFeatureWriter result = new OGRDirectFeatureWriter(dataSource, layer, reader, this.getSchema(), gf, this.ogr);
            cleanup = false;
            OGRDirectFeatureWriter oGRDirectFeatureWriter = result;
            if (cleanup) {
                this.ogr.LayerRelease(layer);
                this.ogr.DataSourceRelease(dataSource);
            }
            return oGRDirectFeatureWriter;
        }
        catch (Throwable throwable) {
            if (cleanup) {
                this.ogr.LayerRelease(layer);
                this.ogr.DataSourceRelease(dataSource);
            }
            throw throwable;
        }
    }

    @Override
    public OGRDataStore getDataStore() {
        return this.delegate.getDataStore();
    }

    @Override
    public Transaction getTransaction() {
        return this.delegate.getTransaction();
    }

    @Override
    public ResourceInfo getInfo() {
        return this.delegate.getInfo();
    }

    @Override
    public QueryCapabilities getQueryCapabilities() {
        return this.delegate.getQueryCapabilities();
    }

    @Override
    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        return this.delegate.getBoundsInternal(query);
    }

    @Override
    protected int getCountInternal(Query query) throws IOException {
        return this.delegate.getCountInternal(query);
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return this.delegate.getReaderInternal(query);
    }

    @Override
    protected SimpleFeatureType buildFeatureType() throws IOException {
        return this.delegate.buildFeatureType();
    }

    @Override
    public ContentEntry getEntry() {
        return this.delegate.getEntry();
    }

    @Override
    public Name getName() {
        return this.delegate.getName();
    }

    @Override
    public ContentState getState() {
        return this.delegate.getState();
    }

    @Override
    public void setTransaction(Transaction transaction) {
        super.setTransaction(transaction);
        if (this.delegate.getTransaction() != transaction) {
            this.delegate.setTransaction(transaction);
        }
    }

    @Override
    protected boolean canFilter() {
        return this.delegate.canFilter();
    }

    @Override
    protected boolean canSort() {
        return this.delegate.canSort();
    }

    @Override
    protected boolean canRetype() {
        return this.delegate.canRetype();
    }

    @Override
    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return this.delegate.handleVisitor(query, visitor);
    }
}

