/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.ogr.OGR;
import org.geotools.data.ogr.OGRDataStore;
import org.geotools.util.logging.Logging;

public abstract class OGRDataStoreFactory
implements DataStoreFactorySpi {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geotools.data.ogr");
    public static final DataAccessFactory.Param OGR_NAME = new DataAccessFactory.Param("DatasourceName", String.class, "Name of the file, or data source to try and open", true);
    public static final DataAccessFactory.Param OGR_DRIVER_NAME = new DataAccessFactory.Param("DriverName", String.class, "Name of the OGR driver to be used. Required to create a new data source, optional when opening an existing one", false);
    public static final DataAccessFactory.Param NAMESPACEP = new DataAccessFactory.Param("namespace", URI.class, "uri to a the namespace", false);
    private Map liveStores = new HashMap();

    protected abstract OGR createOGR();

    public boolean canProcess(Map params) {
        boolean accept = false;
        String ogrName = null;
        String ogrDriver = null;
        try {
            ogrName = (String)OGR_NAME.lookUp(params);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            ogrDriver = (String)OGR_DRIVER_NAME.lookUp(params);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        accept = this.canProcess(ogrName, ogrDriver);
        return accept;
    }

    public DataStore createDataStore(Map params) throws IOException {
        DataStore ds = null;
        if (!this.liveStores.containsKey(params)) {
            Object url = null;
            try {
                ds = this.createNewDataStore(params);
                this.liveStores.put(params, ds);
            }
            catch (MalformedURLException mue) {
                throw new DataSourceException("Unable to attatch datastore to " + url, mue);
            }
        } else {
            ds = (DataStore)this.liveStores.get(params);
        }
        return ds;
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        OGRDataStore ds = null;
        String ogrName = (String)OGR_NAME.lookUp(params);
        String ogrDriver = (String)OGR_DRIVER_NAME.lookUp(params);
        URI namespace = (URI)NAMESPACEP.lookUp(params);
        ds = new OGRDataStore(ogrName, ogrDriver, namespace, this.createOGR());
        return ds;
    }

    @Override
    public String getDisplayName() {
        return "OGR";
    }

    @Override
    public String getDescription() {
        return "Uses OGR as a data source";
    }

    @Override
    public final boolean isAvailable() {
        return this.isAvailable(true);
    }

    public final boolean isAvailable(boolean handleError) {
        try {
            return this.doIsAvailable();
        }
        catch (Throwable t) {
            if (handleError) {
                LOGGER.log(Level.FINE, "Error initializing GDAL/OGR library", t);
                return false;
            }
            throw new RuntimeException(t);
        }
    }

    protected abstract boolean doIsAvailable() throws Throwable;

    @Override
    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{OGR_NAME, OGR_DRIVER_NAME, NAMESPACEP};
    }

    public boolean canProcess(String ogrName, String driverName) {
        OGR ogr = this.createOGR();
        Object dataset = ogr.OpenShared(ogrName, 0);
        if (dataset != null) {
            ogr.DataSourceRelease(dataset);
            return true;
        }
        if (driverName != null) {
            try {
                Object driver = ogr.GetDriverByName(driverName);
                if (driver != null) {
                    return true;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Error loading driver", e);
            }
        }
        return false;
    }

    public Set<String> getAvailableDrivers() {
        OGR ogr = this.createOGR();
        int count = ogr.GetDriverCount();
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < count; ++i) {
            Object driver = ogr.GetDriver(i);
            String name = ogr.DriverGetName(driver);
            result.add(name);
        }
        return result;
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

