/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.geotools.data.DataSourceException;
import org.geotools.data.Query;
import org.geotools.data.ogr.FeatureMapper;
import org.geotools.data.ogr.FeatureTypeMapper;
import org.geotools.data.ogr.GeometryMapper;
import org.geotools.data.ogr.OGR;
import org.geotools.data.ogr.OGRFeatureSource;
import org.geotools.data.ogr.OGRFeatureStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;

public class OGRDataStore
extends ContentDataStore {
    OGR ogr;
    String ogrSourceName;
    String ogrDriver;

    public OGRDataStore(String ogrName, String ogrDriver, URI namespace, OGR ogr) {
        if (namespace != null) {
            this.setNamespaceURI(namespace.toString());
        }
        this.ogrSourceName = ogrName;
        this.ogrDriver = ogrDriver;
        this.ogr = ogr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Name> createTypeNames() throws IOException {
        Object dataSource = null;
        Object layer = null;
        try {
            dataSource = this.openOGRDataSource(false);
            ArrayList<Name> result = new ArrayList<Name>();
            int count = this.ogr.DataSourceGetLayerCount(dataSource);
            for (int i = 0; i < count; ++i) {
                layer = this.ogr.DataSourceGetLayer(dataSource, i);
                String name = this.ogr.LayerGetName(layer);
                if (name != null) {
                    result.add(new NameImpl(this.getNamespaceURI(), name));
                }
                this.ogr.LayerRelease(layer);
            }
            ArrayList<Name> arrayList = result;
            this.ogr.DataSourceRelease(dataSource);
            this.ogr.LayerRelease(layer);
            return arrayList;
        }
        catch (IOException e) {
            this.LOGGER.log(Level.FINE, "Error looking up type names", e);
            List<Name> list = Collections.emptyList();
            return list;
        }
        finally {
            this.ogr.DataSourceRelease(dataSource);
            this.ogr.LayerRelease(layer);
        }
    }

    Object openOGRDataSource(boolean update) throws IOException {
        int mode;
        Object ds = null;
        int n = mode = update ? 1 : 0;
        if (this.ogrDriver != null) {
            Object driver = this.ogr.GetDriverByName(this.ogrDriver);
            if (driver == null) {
                throw new IOException("Could not find a driver named " + driver);
            }
            ds = this.ogr.DriverOpen(driver, this.ogrSourceName, mode);
            if (ds == null) {
                throw new IOException("OGR could not open '" + this.ogrSourceName + "' in " + (update ? "read-write" : "read-only") + " mode with driver " + this.ogrDriver);
            }
        } else {
            ds = this.ogr.OpenShared(this.ogrSourceName, mode);
            if (ds == null) {
                throw new IOException("OGR could not open '" + this.ogrSourceName + "' in " + (update ? "read-write" : "read-only") + " mode");
            }
        }
        return ds;
    }

    Object openOGRLayer(Object dataSource, String layerName) throws IOException {
        Object layer = this.ogr.DataSourceGetLayerByName(dataSource, layerName);
        if (layer == null) {
            throw new IOException("OGR could not find layer '" + layerName + "'");
        }
        return layer;
    }

    @Override
    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        if (this.supportsInPlaceWrite(entry.getTypeName())) {
            return new OGRFeatureStore(entry, Query.ALL, this.ogr);
        }
        return new OGRFeatureSource(entry, Query.ALL, this.ogr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsInPlaceWrite(String typeName) throws IOException {
        boolean bl;
        Object l;
        Object ds;
        block9: {
            ds = null;
            l = null;
            try {
                ds = this.ogr.Open(this.ogrSourceName, 1);
                if (ds != null) break block9;
                boolean bl2 = false;
                if (l != null) {
                    this.ogr.LayerRelease(l);
                }
                if (ds != null) {
                    this.ogr.DataSourceRelease(ds);
                }
                return bl2;
            }
            catch (Throwable throwable) {
                if (l != null) {
                    this.ogr.LayerRelease(l);
                }
                if (ds != null) {
                    this.ogr.DataSourceRelease(ds);
                }
                throw throwable;
            }
        }
        l = this.openOGRLayer(ds, typeName);
        boolean canDelete = this.ogr.LayerCanDeleteFeature(l);
        boolean canWriteRandom = this.ogr.LayerCanWriteRandom(l);
        boolean canWriteSequential = this.ogr.LayerCanWriteSequential(l);
        boolean bl3 = bl = canDelete && canWriteRandom && canWriteSequential;
        if (l != null) {
            this.ogr.LayerRelease(l);
        }
        if (ds != null) {
            this.ogr.DataSourceRelease(ds);
        }
        return bl;
    }

    @Override
    public void createSchema(SimpleFeatureType schema) throws IOException {
        this.createSchema(schema, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(SimpleFeatureType schema, boolean approximateFields, String[] options) throws IOException {
        Object dataSource = null;
        Object layer = null;
        try {
            dataSource = this.openOrCreateDataSource(options, dataSource);
            FeatureTypeMapper mapper = new FeatureTypeMapper(this.ogr);
            layer = this.createNewLayer(schema, dataSource, options, mapper);
            Object driver = this.ogr.DataSourceGetDriver(dataSource);
            String driverName = this.ogr.DriverGetName(driver);
            this.ogr.DriverRelease(driver);
            if (!(driverName.equalsIgnoreCase("georss") || driverName.equalsIgnoreCase("gpx") || driverName.equalsIgnoreCase("sosi") || this.ogr.LayerCanCreateField(layer))) {
                throw new DataSourceException("OGR reports it's not possible to create fields on this layer");
            }
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                AttributeDescriptor ad = schema.getDescriptor(i);
                if (ad == schema.getGeometryDescriptor()) continue;
                Object fieldDefinition = mapper.getOGRFieldDefinition(ad);
                this.ogr.LayerCreateField(layer, fieldDefinition, approximateFields ? 1 : 0);
            }
            this.ogr.LayerSyncToDisk(layer);
            this.ogr.LayerRelease(layer);
            this.ogr.DataSourceRelease(dataSource);
        }
        catch (Throwable throwable) {
            this.ogr.LayerRelease(layer);
            this.ogr.DataSourceRelease(dataSource);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(SimpleFeatureCollection data, boolean approximateFields, String[] options) throws IOException {
        Object dataSource = null;
        Object layer = null;
        SimpleFeatureType schema = (SimpleFeatureType)data.getSchema();
        try {
            dataSource = this.openOrCreateDataSource(options, dataSource);
            FeatureTypeMapper mapper = new FeatureTypeMapper(this.ogr);
            layer = this.createNewLayer(schema, dataSource, options, mapper);
            Object driver = this.ogr.DataSourceGetDriver(dataSource);
            String driverName = this.ogr.DriverGetName(driver);
            this.ogr.DriverRelease(driver);
            if (!(driverName.equalsIgnoreCase("georss") || driverName.equalsIgnoreCase("gpx") || driverName.equalsIgnoreCase("sosi") || this.ogr.LayerCanCreateField(layer))) {
                throw new DataSourceException("OGR reports it's not possible to create fields on this layer");
            }
            HashMap<String, String> nameMap = new HashMap<String, String>();
            int j = 0;
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                AttributeDescriptor ad = schema.getDescriptor(i);
                if (ad == schema.getGeometryDescriptor()) continue;
                Object fieldDefinition = mapper.getOGRFieldDefinition(ad);
                this.ogr.LayerCreateField(layer, fieldDefinition, approximateFields ? 1 : 0);
                String newName = this.ogr.FieldGetName(fieldDefinition);
                nameMap.put(newName, ad.getLocalName());
                ++j;
            }
            Object layerDefinition = this.ogr.LayerGetLayerDefn(layer);
            HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
            int count = this.ogr.LayerGetFieldCount(layerDefinition);
            for (int i = 0; i < count; ++i) {
                Object fd = this.ogr.LayerGetFieldDefn(layerDefinition, i);
                String newName = this.ogr.FieldGetName(fd);
                if (newName == null) continue;
                String oldName = (String)nameMap.get(newName);
                if (oldName == null) {
                    oldName = (String)nameMap.get(newName.toLowerCase());
                }
                if (oldName == null) {
                    oldName = (String)nameMap.get(newName.toUpperCase());
                }
                for (int j2 = 0; j2 < schema.getAttributeCount(); ++j2) {
                    if (!schema.getDescriptor(j2).getLocalName().equals(oldName)) continue;
                    indexMap.put(j2, i);
                }
            }
            GeometryMapper.WKB geomMapper = new GeometryMapper.WKB(new GeometryFactory(), this.ogr);
            SimpleFeatureIterator features = data.features();
            while (features.hasNext()) {
                SimpleFeature feature = (SimpleFeature)features.next();
                Object ogrFeature = this.ogr.LayerNewFeature(layerDefinition);
                for (int i = 0; i < schema.getAttributeCount(); ++i) {
                    Object value = feature.getAttribute(i);
                    if (value instanceof Geometry) {
                        Object geometry = ((GeometryMapper)geomMapper).parseGTGeometry((Geometry)value);
                        this.ogr.FeatureSetGeometryDirectly(ogrFeature, geometry);
                        continue;
                    }
                    int ogrIndex = (Integer)indexMap.get(i);
                    FeatureMapper.setFieldValue(layerDefinition, ogrFeature, ogrIndex, value, this.ogr);
                }
                this.ogr.CheckError(this.ogr.LayerCreateFeature(layer, ogrFeature));
                this.ogr.FeatureDestroy(ogrFeature);
            }
            this.ogr.LayerSyncToDisk(layer);
            this.ogr.LayerRelease(layer);
            this.ogr.DataSourceRelease(dataSource);
        }
        catch (Throwable throwable) {
            this.ogr.LayerRelease(layer);
            this.ogr.DataSourceRelease(dataSource);
            throw throwable;
        }
    }

    private Object createNewLayer(SimpleFeatureType schema, Object dataSource, String[] options, FeatureTypeMapper mapper) throws IOException, DataSourceException {
        GeometryDescriptor geomType = schema.getGeometryDescriptor();
        long ogrGeomType = mapper.getOGRGeometryType(geomType);
        Object spatialReference = mapper.getSpatialReference(geomType.getCoordinateReferenceSystem());
        Object layer = this.ogr.DataSourceCreateLayer(dataSource, schema.getTypeName(), spatialReference, ogrGeomType, options);
        if (layer == null) {
            throw new DataSourceException("Could not create the OGR layer: " + this.ogr.GetLastErrorMsg());
        }
        return layer;
    }

    private Object openOrCreateDataSource(String[] options, Object dataSource) throws IOException, DataSourceException {
        try {
            dataSource = this.openOGRDataSource(true);
        }
        catch (IOException e) {
            if (this.ogrDriver != null) {
                Object driver = this.ogr.GetDriverByName(this.ogrDriver);
                dataSource = this.ogr.DriverCreateDataSource(driver, this.ogrSourceName, options);
                this.ogr.DriverRelease(driver);
                if (dataSource == null) {
                    throw new IOException("Could not create OGR data source with driver " + this.ogrDriver + " and options " + options);
                }
            }
            throw new DataSourceException("Driver not provided, and could not open data source neither");
        }
        return dataSource;
    }
}

