/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.CachedResultSetMetaData;
import com.mysql.jdbc.CallableStatement;
import com.mysql.jdbc.CharsetMapping;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.ConnectionLifecycleInterceptor;
import com.mysql.jdbc.ConnectionPropertiesImpl;
import com.mysql.jdbc.Constants;
import com.mysql.jdbc.DatabaseMetaData;
import com.mysql.jdbc.EscapeProcessor;
import com.mysql.jdbc.EscapeProcessorResult;
import com.mysql.jdbc.ExceptionInterceptor;
import com.mysql.jdbc.Extension;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.IterateBlock;
import com.mysql.jdbc.LicenseConfiguration;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MySQLConnection;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.MysqlSavepoint;
import com.mysql.jdbc.NamedPipeSocketFactory;
import com.mysql.jdbc.NoSubInterceptorWrapper;
import com.mysql.jdbc.NonRegisteringDriver;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ProfilerEventHandlerFactory;
import com.mysql.jdbc.ReflectiveStatementInterceptorAdapter;
import com.mysql.jdbc.ResultSetInternalMethods;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.ServerPreparedStatement;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.SocketFactory;
import com.mysql.jdbc.SocketMetadata;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.StatementImpl;
import com.mysql.jdbc.StatementInterceptor;
import com.mysql.jdbc.StatementInterceptorV2;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.TimeUtil;
import com.mysql.jdbc.UpdatableResultSet;
import com.mysql.jdbc.Util;
import com.mysql.jdbc.V1toV2StatementInterceptorAdapter;
import com.mysql.jdbc.log.Log;
import com.mysql.jdbc.log.LogFactory;
import com.mysql.jdbc.log.NullLogger;
import com.mysql.jdbc.profiler.ProfilerEvent;
import com.mysql.jdbc.profiler.ProfilerEventHandler;
import com.mysql.jdbc.util.LRUCache;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TreeMap;

public class ConnectionImpl
extends ConnectionPropertiesImpl
implements MySQLConnection {
    private static final String JDBC_LOCAL_CHARACTER_SET_RESULTS = "jdbc.local.character_set_results";
    private MySQLConnection proxy = null;
    private static final Object CHARSET_CONVERTER_NOT_AVAILABLE_MARKER = new Object();
    public static Map charsetMap;
    protected static final String DEFAULT_LOGGER_CLASS = "com.mysql.jdbc.log.StandardLogger";
    private static final int HISTOGRAM_BUCKETS = 20;
    private static final String LOGGER_INSTANCE_NAME = "MySQL";
    private static Map mapTransIsolationNameToValue;
    private static final Log NULL_LOGGER;
    private static Map roundRobinStatsMap;
    private static final Map serverCollationByUrl;
    private static final Map serverConfigByUrl;
    private long queryTimeCount;
    private double queryTimeSum;
    private double queryTimeSumSquares;
    private double queryTimeMean;
    private transient Timer cancelTimer;
    private List connectionLifecycleInterceptors;
    private static final Constructor JDBC_4_CONNECTION_CTOR;
    private static final int DEFAULT_RESULT_SET_TYPE = 1003;
    private static final int DEFAULT_RESULT_SET_CONCURRENCY = 1007;
    private static final Random random;
    private boolean autoCommit = true;
    private Map cachedPreparedStatementParams;
    private String characterSetMetadata = null;
    private String characterSetResultsOnServer = null;
    private Map charsetConverterMap = new HashMap(CharsetMapping.getNumberOfCharsetsConfigured());
    private Map charsetToNumBytesMap;
    private long connectionCreationTimeMillis = 0L;
    private long connectionId;
    private String database = null;
    private java.sql.DatabaseMetaData dbmd = null;
    private TimeZone defaultTimeZone;
    private ProfilerEventHandler eventSink;
    private Throwable forceClosedReason;
    private boolean hasIsolationLevels = false;
    private boolean hasQuotedIdentifiers = false;
    private String host = null;
    private String[] indexToCharsetMapping = CharsetMapping.INDEX_TO_CHARSET;
    private transient MysqlIO io = null;
    private boolean isClientTzUTC = false;
    private boolean isClosed = true;
    private boolean isInGlobalTx = false;
    private boolean isRunningOnJDK13 = false;
    private int isolationLevel = 2;
    private boolean isServerTzUTC = false;
    private long lastQueryFinishedTime = 0L;
    private transient Log log = NULL_LOGGER;
    private long longestQueryTimeMs = 0L;
    private boolean lowerCaseTableNames = false;
    private long masterFailTimeMillis = 0L;
    private long maximumNumberTablesAccessed = 0L;
    private boolean maxRowsChanged = false;
    private long metricsLastReportedMs;
    private long minimumNumberTablesAccessed = Long.MAX_VALUE;
    private String myURL = null;
    private boolean needsPing = false;
    private int netBufferLength = 16384;
    private boolean noBackslashEscapes = false;
    private long numberOfPreparedExecutes = 0L;
    private long numberOfPrepares = 0L;
    private long numberOfQueriesIssued = 0L;
    private long numberOfResultSetsCreated = 0L;
    private long[] numTablesMetricsHistBreakpoints;
    private int[] numTablesMetricsHistCounts;
    private long[] oldHistBreakpoints = null;
    private int[] oldHistCounts = null;
    private Map openStatements;
    private LRUCache parsedCallableStatementCache;
    private boolean parserKnowsUnicode = false;
    private String password = null;
    private long[] perfMetricsHistBreakpoints;
    private int[] perfMetricsHistCounts;
    private Throwable pointOfOrigin;
    private int port = 3306;
    protected Properties props = null;
    private boolean readInfoMsg = false;
    private boolean readOnly = false;
    protected LRUCache resultSetMetadataCache;
    private TimeZone serverTimezoneTZ = null;
    private Map serverVariables = null;
    private long shortestQueryTimeMs = Long.MAX_VALUE;
    private Map statementsUsingMaxRows;
    private double totalQueryTimeMs = 0.0;
    private boolean transactionsSupported = false;
    private Map typeMap;
    private boolean useAnsiQuotes = false;
    private String user = null;
    private boolean useServerPreparedStmts = false;
    private LRUCache serverSideStatementCheckCache;
    private LRUCache serverSideStatementCache;
    private Calendar sessionCalendar;
    private Calendar utcCalendar;
    private String origHostToConnectTo;
    private int origPortToConnectTo;
    private String origDatabaseToConnectTo;
    private String errorMessageEncoding = "Cp1252";
    private boolean usePlatformCharsetConverters;
    private boolean hasTriedMasterFlag = false;
    private String statementComment = null;
    private boolean storesLowerCaseTableName;
    private List statementInterceptors;
    private boolean requiresEscapingEncoder;
    private String hostPortPair;
    private boolean usingCachedConfig = false;
    private int autoIncrementIncrement = 0;
    private ExceptionInterceptor exceptionInterceptor;

    public String getHost() {
        return this.host;
    }

    public boolean isProxySet() {
        return this.proxy != null;
    }

    public void setProxy(MySQLConnection proxy) {
        this.proxy = proxy;
    }

    private MySQLConnection getProxy() {
        return this.proxy != null ? this.proxy : this;
    }

    public MySQLConnection getLoadBalanceSafeProxy() {
        return this.getProxy();
    }

    protected static SQLException appendMessageToException(SQLException sqlEx, String messageToAppend, ExceptionInterceptor interceptor) {
        String origMessage = sqlEx.getMessage();
        String sqlState = sqlEx.getSQLState();
        int vendorErrorCode = sqlEx.getErrorCode();
        StringBuffer messageBuf = new StringBuffer(origMessage.length() + messageToAppend.length());
        messageBuf.append(origMessage);
        messageBuf.append(messageToAppend);
        SQLException sqlExceptionWithNewMessage = SQLError.createSQLException(messageBuf.toString(), sqlState, vendorErrorCode, interceptor);
        try {
            Method getStackTraceMethod = null;
            Method setStackTraceMethod = null;
            Object theStackTraceAsObject = null;
            Class<?> stackTraceElementClass = Class.forName("java.lang.StackTraceElement");
            Class<?> stackTraceElementArrayClass = Array.newInstance(stackTraceElementClass, new int[]{0}).getClass();
            getStackTraceMethod = Throwable.class.getMethod("getStackTrace", new Class[0]);
            setStackTraceMethod = Throwable.class.getMethod("setStackTrace", stackTraceElementArrayClass);
            if (getStackTraceMethod != null && setStackTraceMethod != null) {
                theStackTraceAsObject = getStackTraceMethod.invoke((Object)sqlEx, new Object[0]);
                setStackTraceMethod.invoke((Object)sqlExceptionWithNewMessage, theStackTraceAsObject);
            }
        }
        catch (NoClassDefFoundError noClassDefFound) {
        }
        catch (NoSuchMethodException noSuchMethodEx) {
        }
        catch (Throwable catchAll) {
            // empty catch block
        }
        return sqlExceptionWithNewMessage;
    }

    public synchronized Timer getCancelTimer() {
        if (this.cancelTimer == null) {
            boolean createdNamedTimer = false;
            try {
                Constructor ctr = Timer.class.getConstructor(String.class, Boolean.TYPE);
                this.cancelTimer = (Timer)ctr.newInstance("MySQL Statement Cancellation Timer", Boolean.TRUE);
                createdNamedTimer = true;
            }
            catch (Throwable t) {
                createdNamedTimer = false;
            }
            if (!createdNamedTimer) {
                this.cancelTimer = new Timer(true);
            }
        }
        return this.cancelTimer;
    }

    protected static Connection getInstance(String hostToConnectTo, int portToConnectTo, Properties info, String databaseToConnectTo, String url) throws SQLException {
        if (!Util.isJdbc4()) {
            return new ConnectionImpl(hostToConnectTo, portToConnectTo, info, databaseToConnectTo, url);
        }
        return (Connection)Util.handleNewInstance(JDBC_4_CONNECTION_CTOR, new Object[]{hostToConnectTo, portToConnectTo, info, databaseToConnectTo, url}, null);
    }

    private static synchronized int getNextRoundRobinHostIndex(String url, List hostList) {
        int indexRange = hostList.size();
        int index = random.nextInt(indexRange);
        return index;
    }

    private static boolean nullSafeCompare(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        return s1 != null && s1.equals(s2);
    }

    protected ConnectionImpl() {
    }

    protected ConnectionImpl(String hostToConnectTo, int portToConnectTo, Properties info, String databaseToConnectTo, String url) throws SQLException {
        this.charsetToNumBytesMap = new HashMap();
        this.connectionCreationTimeMillis = System.currentTimeMillis();
        this.pointOfOrigin = new Throwable();
        if (databaseToConnectTo == null) {
            databaseToConnectTo = "";
        }
        this.origHostToConnectTo = hostToConnectTo;
        this.origPortToConnectTo = portToConnectTo;
        this.origDatabaseToConnectTo = databaseToConnectTo;
        try {
            Blob.class.getMethod("truncate", Long.TYPE);
            this.isRunningOnJDK13 = false;
        }
        catch (NoSuchMethodException nsme) {
            this.isRunningOnJDK13 = true;
        }
        this.sessionCalendar = new GregorianCalendar();
        this.utcCalendar = new GregorianCalendar();
        this.utcCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.log = LogFactory.getLogger(this.getLogger(), LOGGER_INSTANCE_NAME, this.getExceptionInterceptor());
        this.defaultTimeZone = Util.getDefaultTimeZone();
        this.isClientTzUTC = "GMT".equalsIgnoreCase(this.defaultTimeZone.getID());
        this.openStatements = new HashMap();
        if (NonRegisteringDriver.isHostPropertiesList(hostToConnectTo)) {
            Properties hostSpecificProps = NonRegisteringDriver.expandHostKeyValues(hostToConnectTo);
            Enumeration<?> propertyNames = hostSpecificProps.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = propertyNames.nextElement().toString();
                String propertyValue = hostSpecificProps.getProperty(propertyName);
                info.setProperty(propertyName, propertyValue);
            }
        } else if (hostToConnectTo == null) {
            this.host = "localhost";
            this.hostPortPair = this.host + ":" + portToConnectTo;
        } else {
            this.host = hostToConnectTo;
            this.hostPortPair = hostToConnectTo.indexOf(":") == -1 ? this.host + ":" + portToConnectTo : this.host;
        }
        this.port = portToConnectTo;
        this.database = databaseToConnectTo;
        this.myURL = url;
        this.user = info.getProperty("user");
        this.password = info.getProperty("password");
        if (this.user == null || this.user.equals("")) {
            this.user = "";
        }
        if (this.password == null) {
            this.password = "";
        }
        this.props = info;
        this.initializeDriverProperties(info);
        try {
            this.dbmd = this.getMetaData(false, false);
            this.initializeSafeStatementInterceptors();
            this.createNewIO(false);
            this.unSafeStatementInterceptors();
        }
        catch (SQLException ex) {
            this.cleanup(ex);
            throw ex;
        }
        catch (Exception ex) {
            this.cleanup(ex);
            StringBuffer mesg = new StringBuffer(128);
            if (!this.getParanoid()) {
                mesg.append("Cannot connect to MySQL server on ");
                mesg.append(this.host);
                mesg.append(":");
                mesg.append(this.port);
                mesg.append(".\n\n");
                mesg.append("Make sure that there is a MySQL server ");
                mesg.append("running on the machine/port you are trying ");
                mesg.append("to connect to and that the machine this software is running on ");
                mesg.append("is able to connect to this host/port (i.e. not firewalled). ");
                mesg.append("Also make sure that the server has not been started with the --skip-networking ");
                mesg.append("flag.\n\n");
            } else {
                mesg.append("Unable to connect to database.");
            }
            SQLException sqlEx = SQLError.createSQLException(mesg.toString(), "08S01", this.getExceptionInterceptor());
            sqlEx.initCause(ex);
            throw sqlEx;
        }
    }

    public void unSafeStatementInterceptors() throws SQLException {
        ArrayList<StatementInterceptorV2> unSafedStatementInterceptors = new ArrayList<StatementInterceptorV2>(this.statementInterceptors.size());
        for (int i = 0; i < this.statementInterceptors.size(); ++i) {
            NoSubInterceptorWrapper wrappedInterceptor = (NoSubInterceptorWrapper)this.statementInterceptors.get(i);
            unSafedStatementInterceptors.add(wrappedInterceptor.getUnderlyingInterceptor());
        }
        this.statementInterceptors = unSafedStatementInterceptors;
        if (this.io != null) {
            this.io.setStatementInterceptors(this.statementInterceptors);
        }
    }

    public void initializeSafeStatementInterceptors() throws SQLException {
        this.isClosed = false;
        List unwrappedInterceptors = Util.loadExtensions(this, this.props, this.getStatementInterceptors(), "MysqlIo.BadStatementInterceptor", this.getExceptionInterceptor());
        this.statementInterceptors = new ArrayList(unwrappedInterceptors.size());
        for (int i = 0; i < unwrappedInterceptors.size(); ++i) {
            Object interceptor = unwrappedInterceptors.get(i);
            if (interceptor instanceof StatementInterceptor) {
                if (ReflectiveStatementInterceptorAdapter.getV2PostProcessMethod(interceptor.getClass()) != null) {
                    this.statementInterceptors.add(new NoSubInterceptorWrapper(new ReflectiveStatementInterceptorAdapter((StatementInterceptor)interceptor)));
                    continue;
                }
                this.statementInterceptors.add(new NoSubInterceptorWrapper(new V1toV2StatementInterceptorAdapter((StatementInterceptor)interceptor)));
                continue;
            }
            this.statementInterceptors.add(new NoSubInterceptorWrapper((StatementInterceptorV2)interceptor));
        }
    }

    public List getStatementInterceptorsInstances() {
        return this.statementInterceptors;
    }

    private void addToHistogram(int[] histogramCounts, long[] histogramBreakpoints, long value, int numberOfTimes, long currentLowerBound, long currentUpperBound) {
        if (histogramCounts == null) {
            this.createInitialHistogram(histogramBreakpoints, currentLowerBound, currentUpperBound);
        } else {
            for (int i = 0; i < 20; ++i) {
                if (histogramBreakpoints[i] < value) continue;
                int n = i;
                histogramCounts[n] = histogramCounts[n] + numberOfTimes;
                break;
            }
        }
    }

    private void addToPerformanceHistogram(long value, int numberOfTimes) {
        this.checkAndCreatePerformanceHistogram();
        this.addToHistogram(this.perfMetricsHistCounts, this.perfMetricsHistBreakpoints, value, numberOfTimes, this.shortestQueryTimeMs == Long.MAX_VALUE ? 0L : this.shortestQueryTimeMs, this.longestQueryTimeMs);
    }

    private void addToTablesAccessedHistogram(long value, int numberOfTimes) {
        this.checkAndCreateTablesAccessedHistogram();
        this.addToHistogram(this.numTablesMetricsHistCounts, this.numTablesMetricsHistBreakpoints, value, numberOfTimes, this.minimumNumberTablesAccessed == Long.MAX_VALUE ? 0L : this.minimumNumberTablesAccessed, this.maximumNumberTablesAccessed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void buildCollationMapping() throws SQLException {
        block28: {
            block27: {
                SQLException sqlE22;
                ResultSet results;
                java.sql.Statement stmt;
                block26: {
                    int highestIndex;
                    if (!this.versionMeetsMinimum(4, 1, 0)) break block27;
                    TreeMap<Integer, Object> sortedCollationMap = null;
                    if (this.getCacheServerConfiguration()) {
                        Map map = serverConfigByUrl;
                        synchronized (map) {
                            sortedCollationMap = (TreeMap)serverCollationByUrl.get(this.getURL());
                        }
                    }
                    stmt = null;
                    results = null;
                    if (sortedCollationMap == null) {
                        Object charsetName;
                        sortedCollationMap = new TreeMap<Integer, Object>();
                        stmt = this.getMetadataSafeStatement();
                        results = stmt.executeQuery("SHOW COLLATION");
                        while (results.next()) {
                            charsetName = results.getString(2);
                            Integer charsetIndex = results.getInt(3);
                            sortedCollationMap.put(charsetIndex, charsetName);
                        }
                        if (this.getCacheServerConfiguration()) {
                            charsetName = serverConfigByUrl;
                            synchronized (charsetName) {
                                serverCollationByUrl.put(this.getURL(), sortedCollationMap);
                            }
                        }
                    }
                    if (CharsetMapping.INDEX_TO_CHARSET.length > (highestIndex = ((Integer)sortedCollationMap.lastKey()).intValue())) {
                        highestIndex = CharsetMapping.INDEX_TO_CHARSET.length;
                    }
                    this.indexToCharsetMapping = new String[highestIndex + 1];
                    for (int i = 0; i < CharsetMapping.INDEX_TO_CHARSET.length; ++i) {
                        this.indexToCharsetMapping[i] = CharsetMapping.INDEX_TO_CHARSET[i];
                    }
                    for (Map.Entry indexEntry : sortedCollationMap.entrySet()) {
                        String mysqlCharsetName = (String)indexEntry.getValue();
                        this.indexToCharsetMapping[((Integer)indexEntry.getKey()).intValue()] = CharsetMapping.getJavaEncodingForMysqlEncoding(mysqlCharsetName, this);
                    }
                    Object var9_14 = null;
                    if (results == null) break block26;
                    try {
                        results.close();
                    }
                    catch (SQLException sqlE22) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlE22) {}
                }
                break block28;
                {
                    catch (SQLException e) {
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    SQLException sqlE22;
                    Object var9_15 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (SQLException sqlE22) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sqlE22) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            this.indexToCharsetMapping = CharsetMapping.INDEX_TO_CHARSET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canHandleAsServerPreparedStatement(String sql) throws SQLException {
        if (sql == null || sql.length() == 0) {
            return true;
        }
        if (!this.useServerPreparedStmts) {
            return false;
        }
        if (this.getCachePreparedStatements()) {
            LRUCache lRUCache = this.serverSideStatementCheckCache;
            synchronized (lRUCache) {
                Boolean flag = (Boolean)this.serverSideStatementCheckCache.get(sql);
                if (flag != null) {
                    return flag;
                }
                boolean canHandle = this.canHandleAsServerPreparedStatementNoCache(sql);
                if (sql.length() < this.getPreparedStatementCacheSqlLimit()) {
                    this.serverSideStatementCheckCache.put(sql, canHandle ? Boolean.TRUE : Boolean.FALSE);
                }
                return canHandle;
            }
        }
        return this.canHandleAsServerPreparedStatementNoCache(sql);
    }

    private boolean canHandleAsServerPreparedStatementNoCache(String sql) throws SQLException {
        if (StringUtils.startsWithIgnoreCaseAndNonAlphaNumeric(sql, "CALL")) {
            return false;
        }
        boolean canHandleAsStatement = true;
        if (!this.versionMeetsMinimum(5, 0, 7) && (StringUtils.startsWithIgnoreCaseAndNonAlphaNumeric(sql, "SELECT") || StringUtils.startsWithIgnoreCaseAndNonAlphaNumeric(sql, "DELETE") || StringUtils.startsWithIgnoreCaseAndNonAlphaNumeric(sql, "INSERT") || StringUtils.startsWithIgnoreCaseAndNonAlphaNumeric(sql, "UPDATE") || StringUtils.startsWithIgnoreCaseAndNonAlphaNumeric(sql, "REPLACE"))) {
            int limitStart;
            int currentPos = 0;
            int statementLength = sql.length();
            int lastPosToLook = statementLength - 7;
            boolean allowBackslashEscapes = !this.noBackslashEscapes;
            char quoteChar = this.useAnsiQuotes ? (char)'\"' : '\'';
            boolean foundLimitWithPlaceholder = false;
            block0: while (currentPos < lastPosToLook && (limitStart = StringUtils.indexOfIgnoreCaseRespectQuotes(currentPos, sql, "LIMIT ", quoteChar, allowBackslashEscapes)) != -1) {
                char c;
                for (currentPos = limitStart + 7; currentPos < statementLength && (Character.isDigit(c = sql.charAt(currentPos)) || Character.isWhitespace(c) || c == ',' || c == '?'); ++currentPos) {
                    if (c != '?') continue;
                    foundLimitWithPlaceholder = true;
                    continue block0;
                }
            }
            canHandleAsStatement = !foundLimitWithPlaceholder;
        } else if (StringUtils.startsWithIgnoreCaseAndWs(sql, "CREATE TABLE")) {
            canHandleAsStatement = false;
        } else if (StringUtils.startsWithIgnoreCaseAndWs(sql, "DO")) {
            canHandleAsStatement = false;
        } else if (StringUtils.startsWithIgnoreCaseAndWs(sql, "SET")) {
            canHandleAsStatement = false;
        }
        return canHandleAsStatement;
    }

    public void changeUser(String userName, String newPassword) throws SQLException {
        if (userName == null || userName.equals("")) {
            userName = "";
        }
        if (newPassword == null) {
            newPassword = "";
        }
        this.io.changeUser(userName, newPassword, this.database);
        this.user = userName;
        this.password = newPassword;
        if (this.versionMeetsMinimum(4, 1, 0)) {
            this.configureClientCharacterSet(true);
        }
        this.setSessionVariables();
        this.setupServerForTruncationChecks();
    }

    private boolean characterSetNamesMatches(String mysqlEncodingName) {
        return mysqlEncodingName != null && mysqlEncodingName.equalsIgnoreCase((String)this.serverVariables.get("character_set_client")) && mysqlEncodingName.equalsIgnoreCase((String)this.serverVariables.get("character_set_connection"));
    }

    private void checkAndCreatePerformanceHistogram() {
        if (this.perfMetricsHistCounts == null) {
            this.perfMetricsHistCounts = new int[20];
        }
        if (this.perfMetricsHistBreakpoints == null) {
            this.perfMetricsHistBreakpoints = new long[20];
        }
    }

    private void checkAndCreateTablesAccessedHistogram() {
        if (this.numTablesMetricsHistCounts == null) {
            this.numTablesMetricsHistCounts = new int[20];
        }
        if (this.numTablesMetricsHistBreakpoints == null) {
            this.numTablesMetricsHistBreakpoints = new long[20];
        }
    }

    public void checkClosed() throws SQLException {
        if (this.isClosed) {
            this.throwConnectionClosedException();
        }
    }

    public void throwConnectionClosedException() throws SQLException {
        StringBuffer messageBuf = new StringBuffer("No operations allowed after connection closed.");
        SQLException ex = SQLError.createSQLException(messageBuf.toString(), "08003", this.getExceptionInterceptor());
        if (this.forceClosedReason != null) {
            ex.initCause(this.forceClosedReason);
        }
        throw ex;
    }

    private void checkServerEncoding() throws SQLException {
        SingleByteCharsetConverter converter;
        if (this.getUseUnicode() && this.getEncoding() != null) {
            return;
        }
        String serverEncoding = (String)this.serverVariables.get("character_set");
        if (serverEncoding == null) {
            serverEncoding = (String)this.serverVariables.get("character_set_server");
        }
        String mappedServerEncoding = null;
        if (serverEncoding != null) {
            mappedServerEncoding = CharsetMapping.getJavaEncodingForMysqlEncoding(serverEncoding.toUpperCase(Locale.ENGLISH), this);
        }
        if (!this.getUseUnicode() && mappedServerEncoding != null && (converter = this.getCharsetConverter(mappedServerEncoding)) != null) {
            this.setUseUnicode(true);
            this.setEncoding(mappedServerEncoding);
            return;
        }
        if (serverEncoding != null) {
            if (mappedServerEncoding == null && Character.isLowerCase(serverEncoding.charAt(0))) {
                char[] ach = serverEncoding.toCharArray();
                ach[0] = Character.toUpperCase(serverEncoding.charAt(0));
                this.setEncoding(new String(ach));
            }
            if (mappedServerEncoding == null) {
                throw SQLError.createSQLException("Unknown character encoding on server '" + serverEncoding + "', use 'characterEncoding=' property " + " to provide correct mapping", "01S00", this.getExceptionInterceptor());
            }
            try {
                StringUtils.getBytes("abc", mappedServerEncoding);
                this.setEncoding(mappedServerEncoding);
                this.setUseUnicode(true);
            }
            catch (UnsupportedEncodingException UE) {
                throw SQLError.createSQLException("The driver can not map the character encoding '" + this.getEncoding() + "' that your server is using " + "to a character encoding your JVM understands. You " + "can specify this mapping manually by adding \"useUnicode=true\" " + "as well as \"characterEncoding=[an_encoding_your_jvm_understands]\" " + "to your JDBC URL.", "0S100", this.getExceptionInterceptor());
            }
        }
    }

    private void checkTransactionIsolationLevel() throws SQLException {
        Integer intTI;
        String txIsolationName = null;
        txIsolationName = this.versionMeetsMinimum(4, 0, 3) ? "tx_isolation" : "transaction_isolation";
        String s = (String)this.serverVariables.get(txIsolationName);
        if (s != null && (intTI = (Integer)mapTransIsolationNameToValue.get(s)) != null) {
            this.isolationLevel = intTI;
        }
    }

    public void abortInternal() throws SQLException {
        if (this.io != null) {
            try {
                this.io.forceClose();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.io = null;
        }
        this.isClosed = true;
    }

    private void cleanup(Throwable whyCleanedUp) {
        try {
            if (this.io != null && !this.isClosed()) {
                this.realClose(false, false, false, whyCleanedUp);
            } else if (this.io != null) {
                this.io.forceClose();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.isClosed = true;
    }

    public void clearHasTriedMaster() {
        this.hasTriedMasterFlag = false;
    }

    public void clearWarnings() throws SQLException {
    }

    public java.sql.PreparedStatement clientPrepareStatement(String sql) throws SQLException {
        return this.clientPrepareStatement(sql, 1003, 1007);
    }

    public java.sql.PreparedStatement clientPrepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        java.sql.PreparedStatement pStmt = this.clientPrepareStatement(sql);
        ((PreparedStatement)pStmt).setRetrieveGeneratedKeys(autoGenKeyIndex == 1);
        return pStmt;
    }

    public java.sql.PreparedStatement clientPrepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.clientPrepareStatement(sql, resultSetType, resultSetConcurrency, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.PreparedStatement clientPrepareStatement(String sql, int resultSetType, int resultSetConcurrency, boolean processEscapeCodesIfNeeded) throws SQLException {
        this.checkClosed();
        String nativeSql = processEscapeCodesIfNeeded && this.getProcessEscapeCodesForPrepStmts() ? this.nativeSQL(sql) : sql;
        PreparedStatement pStmt = null;
        if (this.getCachePreparedStatements()) {
            Map map = this.cachedPreparedStatementParams;
            synchronized (map) {
                PreparedStatement.ParseInfo pStmtInfo = (PreparedStatement.ParseInfo)this.cachedPreparedStatementParams.get(nativeSql);
                if (pStmtInfo == null) {
                    pStmt = PreparedStatement.getInstance(this.getLoadBalanceSafeProxy(), nativeSql, this.database);
                    PreparedStatement.ParseInfo parseInfo = pStmt.getParseInfo();
                    if (parseInfo.statementLength < this.getPreparedStatementCacheSqlLimit()) {
                        if (this.cachedPreparedStatementParams.size() >= this.getPreparedStatementCacheSize()) {
                            Iterator oldestIter = this.cachedPreparedStatementParams.keySet().iterator();
                            long lruTime = Long.MAX_VALUE;
                            String oldestSql = null;
                            while (oldestIter.hasNext()) {
                                String sqlKey = (String)oldestIter.next();
                                PreparedStatement.ParseInfo lruInfo = (PreparedStatement.ParseInfo)this.cachedPreparedStatementParams.get(sqlKey);
                                if (lruInfo.lastUsed >= lruTime) continue;
                                lruTime = lruInfo.lastUsed;
                                oldestSql = sqlKey;
                            }
                            if (oldestSql != null) {
                                this.cachedPreparedStatementParams.remove(oldestSql);
                            }
                        }
                        this.cachedPreparedStatementParams.put(nativeSql, pStmt.getParseInfo());
                    }
                } else {
                    pStmtInfo.lastUsed = System.currentTimeMillis();
                    pStmt = new PreparedStatement(this.getLoadBalanceSafeProxy(), nativeSql, this.database, pStmtInfo);
                }
            }
        } else {
            pStmt = PreparedStatement.getInstance(this.getLoadBalanceSafeProxy(), nativeSql, this.database);
        }
        pStmt.setResultSetType(resultSetType);
        pStmt.setResultSetConcurrency(resultSetConcurrency);
        return pStmt;
    }

    public java.sql.PreparedStatement clientPrepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        PreparedStatement pStmt = (PreparedStatement)this.clientPrepareStatement(sql);
        pStmt.setRetrieveGeneratedKeys(autoGenKeyIndexes != null && autoGenKeyIndexes.length > 0);
        return pStmt;
    }

    public java.sql.PreparedStatement clientPrepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        PreparedStatement pStmt = (PreparedStatement)this.clientPrepareStatement(sql);
        pStmt.setRetrieveGeneratedKeys(autoGenKeyColNames != null && autoGenKeyColNames.length > 0);
        return pStmt;
    }

    public java.sql.PreparedStatement clientPrepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.clientPrepareStatement(sql, resultSetType, resultSetConcurrency, true);
    }

    public synchronized void close() throws SQLException {
        if (this.connectionLifecycleInterceptors != null) {
            new IterateBlock(this.connectionLifecycleInterceptors.iterator()){

                void forEach(Object each) throws SQLException {
                    ((ConnectionLifecycleInterceptor)each).close();
                }
            }.doForAll();
        }
        this.realClose(true, true, false, null);
    }

    private void closeAllOpenStatements() throws SQLException {
        SQLException postponedException = null;
        if (this.openStatements != null) {
            ArrayList currentlyOpenStatements = new ArrayList();
            Iterator iter = this.openStatements.keySet().iterator();
            while (iter.hasNext()) {
                currentlyOpenStatements.add(iter.next());
            }
            int numStmts = currentlyOpenStatements.size();
            for (int i = 0; i < numStmts; ++i) {
                StatementImpl stmt = (StatementImpl)currentlyOpenStatements.get(i);
                try {
                    stmt.realClose(false, true);
                    continue;
                }
                catch (SQLException sqlEx) {
                    postponedException = sqlEx;
                }
            }
            if (postponedException != null) {
                throw postponedException;
            }
        }
    }

    private void closeStatement(java.sql.Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            stmt = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void commit() throws SQLException {
        block10: {
            block11: {
                block9: {
                    this.checkClosed();
                    try {
                        try {
                            if (this.connectionLifecycleInterceptors != null) {
                                IterateBlock iter = new IterateBlock(this.connectionLifecycleInterceptors.iterator()){

                                    void forEach(Object each) throws SQLException {
                                        if (!((ConnectionLifecycleInterceptor)each).commit()) {
                                            this.stopIterating = true;
                                        }
                                    }
                                };
                                iter.doForAll();
                                if (!iter.fullIteration()) {
                                    Object var3_3 = null;
                                    break block9;
                                }
                            }
                            if (this.autoCommit && !this.getRelaxAutoCommit()) {
                                throw SQLError.createSQLException("Can't call commit when autocommit=true", this.getExceptionInterceptor());
                            }
                            if (!this.transactionsSupported) break block10;
                            if (this.getUseLocalTransactionState() && this.versionMeetsMinimum(5, 0, 0) && !this.io.inTransactionOnServer()) {
                                break block11;
                            }
                            this.execSQL(null, "commit", -1, null, 1003, 1007, false, this.database, null, false);
                            break block10;
                        }
                        catch (SQLException sqlException) {
                            if (!"08S01".equals(sqlException.getSQLState())) throw sqlException;
                            throw SQLError.createSQLException("Communications link failure during commit(). Transaction resolution unknown.", "08007", this.getExceptionInterceptor());
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_6 = null;
                        this.needsPing = this.getReconnectAtTxEnd();
                        throw throwable;
                    }
                }
                this.needsPing = this.getReconnectAtTxEnd();
                return;
            }
            Object var3_4 = null;
            this.needsPing = this.getReconnectAtTxEnd();
            return;
        }
        Object var3_5 = null;
        this.needsPing = this.getReconnectAtTxEnd();
    }

    private void configureCharsetProperties() throws SQLException {
        if (this.getEncoding() != null) {
            try {
                String testString = "abc";
                StringUtils.getBytes(testString, this.getEncoding());
            }
            catch (UnsupportedEncodingException UE) {
                String oldEncoding = this.getEncoding();
                this.setEncoding(CharsetMapping.getJavaEncodingForMysqlEncoding(oldEncoding, this));
                if (this.getEncoding() == null) {
                    throw SQLError.createSQLException("Java does not support the MySQL character encoding  encoding '" + oldEncoding + "'.", "01S00", this.getExceptionInterceptor());
                }
                try {
                    String testString = "abc";
                    StringUtils.getBytes(testString, this.getEncoding());
                }
                catch (UnsupportedEncodingException encodingEx) {
                    throw SQLError.createSQLException("Unsupported character encoding '" + this.getEncoding() + "'.", "01S00", this.getExceptionInterceptor());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean configureClientCharacterSet(boolean dontCheckServerMatch) throws SQLException {
        String realJavaEncoding = this.getEncoding();
        boolean characterSetAlreadyConfigured = false;
        try {
            if (this.versionMeetsMinimum(4, 1, 0)) {
                characterSetAlreadyConfigured = true;
                this.setUseUnicode(true);
                this.configureCharsetProperties();
                realJavaEncoding = this.getEncoding();
                try {
                    String serverEncodingToSet;
                    if (this.props != null && this.props.getProperty("com.mysql.jdbc.faultInjection.serverCharsetIndex") != null) {
                        this.io.serverCharsetIndex = Integer.parseInt(this.props.getProperty("com.mysql.jdbc.faultInjection.serverCharsetIndex"));
                    }
                    if ((serverEncodingToSet = CharsetMapping.INDEX_TO_CHARSET[this.io.serverCharsetIndex]) == null || serverEncodingToSet.length() == 0) {
                        if (realJavaEncoding != null) {
                            this.setEncoding(realJavaEncoding);
                        } else {
                            throw SQLError.createSQLException("Unknown initial character set index '" + this.io.serverCharsetIndex + "' received from server. Initial client character set can be forced via the 'characterEncoding' property.", "S1000", this.getExceptionInterceptor());
                        }
                    }
                    if (this.versionMeetsMinimum(4, 1, 0) && "ISO8859_1".equalsIgnoreCase(serverEncodingToSet)) {
                        serverEncodingToSet = "Cp1252";
                    }
                    this.setEncoding(serverEncodingToSet);
                }
                catch (ArrayIndexOutOfBoundsException outOfBoundsEx) {
                    if (realJavaEncoding != null) {
                        this.setEncoding(realJavaEncoding);
                    }
                    throw SQLError.createSQLException("Unknown initial character set index '" + this.io.serverCharsetIndex + "' received from server. Initial client character set can be forced via the 'characterEncoding' property.", "S1000", this.getExceptionInterceptor());
                }
                if (this.getEncoding() == null) {
                    this.setEncoding("ISO8859_1");
                }
                if (this.getUseUnicode()) {
                    String mysqlEncodingName;
                    if (realJavaEncoding != null) {
                        if (realJavaEncoding.equalsIgnoreCase("UTF-8") || realJavaEncoding.equalsIgnoreCase("UTF8")) {
                            boolean utf8mb4Supported = this.versionMeetsMinimum(5, 5, 2);
                            boolean useutf8mb4 = false;
                            if (utf8mb4Supported) {
                                boolean bl = useutf8mb4 = this.io.serverCharsetIndex == 45;
                            }
                            if (!this.getUseOldUTF8Behavior()) {
                                if (dontCheckServerMatch || !this.characterSetNamesMatches("utf8") || utf8mb4Supported && !this.characterSetNamesMatches("utf8mb4")) {
                                    this.execSQL(null, "SET NAMES " + (useutf8mb4 ? "utf8mb4" : "utf8"), -1, null, 1003, 1007, false, this.database, null, false);
                                }
                            } else {
                                this.execSQL(null, "SET NAMES latin1", -1, null, 1003, 1007, false, this.database, null, false);
                            }
                            this.setEncoding(realJavaEncoding);
                        } else {
                            mysqlEncodingName = CharsetMapping.getMysqlEncodingForJavaEncoding(realJavaEncoding.toUpperCase(Locale.ENGLISH), this);
                            if (mysqlEncodingName != null && (dontCheckServerMatch || !this.characterSetNamesMatches(mysqlEncodingName))) {
                                this.execSQL(null, "SET NAMES " + mysqlEncodingName, -1, null, 1003, 1007, false, this.database, null, false);
                            }
                            this.setEncoding(realJavaEncoding);
                        }
                    } else if (this.getEncoding() != null) {
                        mysqlEncodingName = CharsetMapping.getMysqlEncodingForJavaEncoding(this.getEncoding().toUpperCase(Locale.ENGLISH), this);
                        if (this.getUseOldUTF8Behavior()) {
                            mysqlEncodingName = "latin1";
                        }
                        if (dontCheckServerMatch || !this.characterSetNamesMatches(mysqlEncodingName)) {
                            this.execSQL(null, "SET NAMES " + mysqlEncodingName, -1, null, 1003, 1007, false, this.database, null, false);
                        }
                        realJavaEncoding = this.getEncoding();
                    }
                }
                String onServer = null;
                boolean isNullOnServer = false;
                if (this.serverVariables != null) {
                    onServer = (String)this.serverVariables.get("character_set_results");
                    boolean bl = isNullOnServer = onServer == null || "NULL".equalsIgnoreCase(onServer) || onServer.length() == 0;
                }
                if (this.getCharacterSetResults() == null) {
                    if (!isNullOnServer) {
                        this.execSQL(null, "SET character_set_results = NULL", -1, null, 1003, 1007, false, this.database, null, false);
                        if (!this.usingCachedConfig) {
                            this.serverVariables.put(JDBC_LOCAL_CHARACTER_SET_RESULTS, null);
                        }
                    } else if (!this.usingCachedConfig) {
                        this.serverVariables.put(JDBC_LOCAL_CHARACTER_SET_RESULTS, onServer);
                    }
                } else {
                    if (this.getUseOldUTF8Behavior()) {
                        this.execSQL(null, "SET NAMES latin1", -1, null, 1003, 1007, false, this.database, null, false);
                    }
                    String charsetResults = this.getCharacterSetResults();
                    String mysqlEncodingName = null;
                    mysqlEncodingName = "UTF-8".equalsIgnoreCase(charsetResults) || "UTF8".equalsIgnoreCase(charsetResults) ? "utf8" : CharsetMapping.getMysqlEncodingForJavaEncoding(charsetResults.toUpperCase(Locale.ENGLISH), this);
                    if (!mysqlEncodingName.equalsIgnoreCase((String)this.serverVariables.get("character_set_results"))) {
                        StringBuffer setBuf = new StringBuffer("SET character_set_results = ".length() + mysqlEncodingName.length());
                        setBuf.append("SET character_set_results = ").append(mysqlEncodingName);
                        this.execSQL(null, setBuf.toString(), -1, null, 1003, 1007, false, this.database, null, false);
                        if (!this.usingCachedConfig) {
                            this.serverVariables.put(JDBC_LOCAL_CHARACTER_SET_RESULTS, mysqlEncodingName);
                        }
                    } else if (!this.usingCachedConfig) {
                        this.serverVariables.put(JDBC_LOCAL_CHARACTER_SET_RESULTS, onServer);
                    }
                }
                if (this.getConnectionCollation() != null) {
                    StringBuffer setBuf = new StringBuffer("SET collation_connection = ".length() + this.getConnectionCollation().length());
                    setBuf.append("SET collation_connection = ").append(this.getConnectionCollation());
                    this.execSQL(null, setBuf.toString(), -1, null, 1003, 1007, false, this.database, null, false);
                }
            } else {
                realJavaEncoding = this.getEncoding();
            }
            Object var10_16 = null;
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            this.setEncoding(realJavaEncoding);
            throw throwable;
        }
        this.setEncoding(realJavaEncoding);
        try {
            CharsetEncoder enc = Charset.forName(this.getEncoding()).newEncoder();
            CharBuffer cbuf = CharBuffer.allocate(1);
            ByteBuffer bbuf = ByteBuffer.allocate(1);
            cbuf.put("\u00a5");
            cbuf.position(0);
            enc.encode(cbuf, bbuf, true);
            if (bbuf.get(0) == 92) {
                this.requiresEscapingEncoder = true;
            } else {
                cbuf.clear();
                bbuf.clear();
                cbuf.put("\u20a9");
                cbuf.position(0);
                enc.encode(cbuf, bbuf, true);
                if (bbuf.get(0) == 92) {
                    this.requiresEscapingEncoder = true;
                }
            }
        }
        catch (UnsupportedCharsetException ucex) {
            try {
                byte[] bbuf = StringUtils.getBytes("\u00a5", this.getEncoding());
                if (bbuf[0] == 92) {
                    this.requiresEscapingEncoder = true;
                } else {
                    bbuf = StringUtils.getBytes("\u20a9", this.getEncoding());
                    if (bbuf[0] == 92) {
                        this.requiresEscapingEncoder = true;
                    }
                }
            }
            catch (UnsupportedEncodingException ueex) {
                throw SQLError.createSQLException("Unable to use encoding: " + this.getEncoding(), "S1000", ueex, this.getExceptionInterceptor());
            }
        }
        return characterSetAlreadyConfigured;
    }

    private void configureTimezone() throws SQLException {
        String configuredTimeZoneOnServer = (String)this.serverVariables.get("timezone");
        if (configuredTimeZoneOnServer == null && "SYSTEM".equalsIgnoreCase(configuredTimeZoneOnServer = (String)this.serverVariables.get("time_zone"))) {
            configuredTimeZoneOnServer = (String)this.serverVariables.get("system_time_zone");
        }
        String canoncicalTimezone = this.getServerTimezone();
        if ((this.getUseTimezone() || !this.getUseLegacyDatetimeCode()) && configuredTimeZoneOnServer != null) {
            if (canoncicalTimezone == null || StringUtils.isEmptyOrWhitespaceOnly(canoncicalTimezone)) {
                try {
                    canoncicalTimezone = TimeUtil.getCanoncialTimezone(configuredTimeZoneOnServer, this.getExceptionInterceptor());
                    if (canoncicalTimezone == null) {
                        throw SQLError.createSQLException("Can't map timezone '" + configuredTimeZoneOnServer + "' to " + " canonical timezone.", "S1009", this.getExceptionInterceptor());
                    }
                }
                catch (IllegalArgumentException iae) {
                    throw SQLError.createSQLException(iae.getMessage(), "S1000", this.getExceptionInterceptor());
                }
            }
        } else {
            canoncicalTimezone = this.getServerTimezone();
        }
        if (canoncicalTimezone != null && canoncicalTimezone.length() > 0) {
            this.serverTimezoneTZ = TimeZone.getTimeZone(canoncicalTimezone);
            if (!canoncicalTimezone.equalsIgnoreCase("GMT") && this.serverTimezoneTZ.getID().equals("GMT")) {
                throw SQLError.createSQLException("No timezone mapping entry for '" + canoncicalTimezone + "'", "S1009", this.getExceptionInterceptor());
            }
            this.isServerTzUTC = "GMT".equalsIgnoreCase(this.serverTimezoneTZ.getID());
        }
    }

    private void createInitialHistogram(long[] breakpoints, long lowerBound, long upperBound) {
        double bucketSize = ((double)upperBound - (double)lowerBound) / 20.0 * 1.25;
        if (bucketSize < 1.0) {
            bucketSize = 1.0;
        }
        for (int i = 0; i < 20; ++i) {
            breakpoints[i] = lowerBound;
            lowerBound = (long)((double)lowerBound + bucketSize);
        }
    }

    public synchronized void createNewIO(boolean isForReconnect) throws SQLException {
        Properties mergedProps = this.exposeAsProperties(this.props);
        if (!this.getHighAvailability()) {
            this.connectOneTryOnly(isForReconnect, mergedProps);
            return;
        }
        this.connectWithRetries(isForReconnect, mergedProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectWithRetries(boolean isForReconnect, Properties mergedProps) throws SQLException {
        double timeout = this.getInitialTimeout();
        boolean connectionGood = false;
        Exception connectionException = null;
        for (int attemptCount = 0; attemptCount < this.getMaxReconnects() && !connectionGood; ++attemptCount) {
            try {
                String oldCatalog;
                boolean oldReadOnly;
                int oldIsolationLevel;
                boolean oldAutoCommit;
                if (this.io != null) {
                    this.io.forceClose();
                }
                this.coreConnect(mergedProps);
                this.pingInternal(false, 0);
                ConnectionImpl connectionImpl = this;
                synchronized (connectionImpl) {
                    this.connectionId = this.io.getThreadId();
                    this.isClosed = false;
                    oldAutoCommit = this.getAutoCommit();
                    oldIsolationLevel = this.isolationLevel;
                    oldReadOnly = this.isReadOnly();
                    oldCatalog = this.getCatalog();
                    this.io.setStatementInterceptors(this.statementInterceptors);
                }
                this.initializePropsFromServer();
                if (isForReconnect) {
                    this.setAutoCommit(oldAutoCommit);
                    if (this.hasIsolationLevels) {
                        this.setTransactionIsolation(oldIsolationLevel);
                    }
                    this.setCatalog(oldCatalog);
                    this.setReadOnly(oldReadOnly);
                }
                connectionGood = true;
                break;
            }
            catch (Exception EEE) {
                connectionException = EEE;
                connectionGood = false;
                if (connectionGood) break;
                if (attemptCount <= 0) continue;
                try {
                    Thread.sleep((long)timeout * 1000L);
                }
                catch (InterruptedException IE) {
                    // empty catch block
                }
                continue;
            }
        }
        if (!connectionGood) {
            SQLException chainedEx = SQLError.createSQLException(Messages.getString("Connection.UnableToConnectWithRetries", new Object[]{this.getMaxReconnects()}), "08001", this.getExceptionInterceptor());
            chainedEx.initCause(connectionException);
            throw chainedEx;
        }
        if (this.getParanoid() && !this.getHighAvailability()) {
            this.password = null;
            this.user = null;
        }
        if (isForReconnect) {
            Iterator statementIter = this.openStatements.values().iterator();
            Stack serverPreparedStatements = null;
            while (statementIter.hasNext()) {
                Object statementObj = statementIter.next();
                if (!(statementObj instanceof ServerPreparedStatement)) continue;
                if (serverPreparedStatements == null) {
                    serverPreparedStatements = new Stack();
                }
                serverPreparedStatements.add(statementObj);
            }
            if (serverPreparedStatements != null) {
                while (!serverPreparedStatements.isEmpty()) {
                    ((ServerPreparedStatement)serverPreparedStatements.pop()).rePrepare();
                }
            }
        }
    }

    private void coreConnect(Properties mergedProps) throws SQLException, IOException {
        int newPort = 3306;
        String newHost = "localhost";
        String protocol = mergedProps.getProperty("PROTOCOL");
        if (protocol != null) {
            if ("tcp".equalsIgnoreCase(protocol)) {
                newHost = this.normalizeHost(mergedProps.getProperty("HOST"));
                newPort = this.parsePortNumber(mergedProps.getProperty("PORT", "3306"));
            } else if ("pipe".equalsIgnoreCase(protocol)) {
                this.setSocketFactoryClassName(NamedPipeSocketFactory.class.getName());
                String path = mergedProps.getProperty("PATH");
                if (path != null) {
                    mergedProps.setProperty("namedPipePath", path);
                }
            } else {
                newHost = this.normalizeHost(mergedProps.getProperty("HOST"));
                newPort = this.parsePortNumber(mergedProps.getProperty("PORT", "3306"));
            }
        } else {
            String[] parsedHostPortPair = NonRegisteringDriver.parseHostPortPair(this.hostPortPair);
            newHost = parsedHostPortPair[0];
            newHost = this.normalizeHost(newHost);
            if (parsedHostPortPair[1] != null) {
                newPort = this.parsePortNumber(parsedHostPortPair[1]);
            }
        }
        this.port = newPort;
        this.host = newHost;
        this.io = new MysqlIO(newHost, newPort, mergedProps, this.getSocketFactoryClassName(), this.getProxy(), this.getSocketTimeout(), this.largeRowSizeThreshold.getValueAsInt());
        this.io.doHandshake(this.user, this.password, this.database);
    }

    private String normalizeHost(String host) {
        if (host == null || StringUtils.isEmptyOrWhitespaceOnly(host)) {
            return "localhost";
        }
        return host;
    }

    private int parsePortNumber(String portAsString) throws SQLException {
        int portNumber = 3306;
        try {
            portNumber = Integer.parseInt(portAsString);
        }
        catch (NumberFormatException nfe) {
            throw SQLError.createSQLException("Illegal connection port value '" + portAsString + "'", "01S00", this.getExceptionInterceptor());
        }
        return portNumber;
    }

    private void connectOneTryOnly(boolean isForReconnect, Properties mergedProps) throws SQLException {
        Exception connectionNotEstablishedBecause = null;
        try {
            this.coreConnect(mergedProps);
            this.connectionId = this.io.getThreadId();
            this.isClosed = false;
            boolean oldAutoCommit = this.getAutoCommit();
            int oldIsolationLevel = this.isolationLevel;
            boolean oldReadOnly = this.isReadOnly();
            String oldCatalog = this.getCatalog();
            this.io.setStatementInterceptors(this.statementInterceptors);
            this.initializePropsFromServer();
            if (isForReconnect) {
                this.setAutoCommit(oldAutoCommit);
                if (this.hasIsolationLevels) {
                    this.setTransactionIsolation(oldIsolationLevel);
                }
                this.setCatalog(oldCatalog);
                this.setReadOnly(oldReadOnly);
            }
            return;
        }
        catch (Exception EEE) {
            if (this.io != null) {
                this.io.forceClose();
            }
            connectionNotEstablishedBecause = EEE;
            if (EEE instanceof SQLException) {
                throw (SQLException)EEE;
            }
            SQLException chainedEx = SQLError.createSQLException(Messages.getString("Connection.UnableToConnect"), "08001", this.getExceptionInterceptor());
            chainedEx.initCause(connectionNotEstablishedBecause);
            throw chainedEx;
        }
    }

    private synchronized void createPreparedStatementCaches() {
        int cacheSize = this.getPreparedStatementCacheSize();
        this.cachedPreparedStatementParams = new HashMap(cacheSize);
        if (this.getUseServerPreparedStmts()) {
            this.serverSideStatementCheckCache = new LRUCache(cacheSize);
            this.serverSideStatementCache = new LRUCache(cacheSize){

                protected boolean removeEldestEntry(Map.Entry eldest) {
                    if (this.maxElements <= 1) {
                        return false;
                    }
                    boolean removeIt = super.removeEldestEntry(eldest);
                    if (removeIt) {
                        ServerPreparedStatement ps = (ServerPreparedStatement)eldest.getValue();
                        ps.isCached = false;
                        ps.setClosed(false);
                        try {
                            ps.close();
                        }
                        catch (SQLException sqlEx) {
                            // empty catch block
                        }
                    }
                    return removeIt;
                }
            };
        }
    }

    public java.sql.Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        StatementImpl stmt = new StatementImpl(this.getLoadBalanceSafeProxy(), this.database);
        stmt.setResultSetType(resultSetType);
        stmt.setResultSetConcurrency(resultSetConcurrency);
        return stmt;
    }

    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.getPedantic() && resultSetHoldability != 1) {
            throw SQLError.createSQLException("HOLD_CUSRORS_OVER_COMMIT is only supported holdability level", "S1009", this.getExceptionInterceptor());
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    public void dumpTestcaseQuery(String query) {
        System.err.println(query);
    }

    public Connection duplicate() throws SQLException {
        return new ConnectionImpl(this.origHostToConnectTo, this.origPortToConnectTo, this.props, this.origDatabaseToConnectTo, this.myURL);
    }

    public ResultSetInternalMethods execSQL(StatementImpl callingStatement, String sql, int maxRows, Buffer packet, int resultSetType, int resultSetConcurrency, boolean streamResults, String catalog, Field[] cachedMetadata) throws SQLException {
        return this.execSQL(callingStatement, sql, maxRows, packet, resultSetType, resultSetConcurrency, streamResults, catalog, cachedMetadata, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized ResultSetInternalMethods execSQL(StatementImpl callingStatement, String sql, int maxRows, Buffer packet, int resultSetType, int resultSetConcurrency, boolean streamResults, String catalog, Field[] cachedMetadata, boolean isBatch) throws SQLException {
        ResultSetInternalMethods encoding2;
        long queryStartTime;
        block22: {
            ResultSetInternalMethods resultSetInternalMethods;
            block21: {
                queryStartTime = 0L;
                int endOfQueryPacketPosition = 0;
                if (packet != null) {
                    endOfQueryPacketPosition = packet.getPosition();
                }
                if (this.getGatherPerformanceMetrics()) {
                    queryStartTime = System.currentTimeMillis();
                }
                this.lastQueryFinishedTime = 0L;
                if (this.getHighAvailability() && (this.autoCommit || this.getAutoReconnectForPools()) && this.needsPing && !isBatch) {
                    try {
                        this.pingInternal(false, 0);
                        this.needsPing = false;
                    }
                    catch (Exception Ex) {
                        this.createNewIO(true);
                    }
                }
                try {
                    try {
                        if (packet == null) {
                            String encoding2 = null;
                            if (this.getUseUnicode()) {
                                encoding2 = this.getEncoding();
                            }
                            resultSetInternalMethods = this.io.sqlQueryDirect(callingStatement, sql, encoding2, null, maxRows, resultSetType, resultSetConcurrency, streamResults, catalog, cachedMetadata);
                            Object var18_22 = null;
                            break block21;
                        }
                        encoding2 = this.io.sqlQueryDirect(callingStatement, null, null, packet, maxRows, resultSetType, resultSetConcurrency, streamResults, catalog, cachedMetadata);
                        break block22;
                    }
                    catch (SQLException sqlE) {
                        if (this.getDumpQueriesOnException()) {
                            String extractedSql = this.extractSqlFromPacket(sql, packet, endOfQueryPacketPosition);
                            StringBuffer messageBuf = new StringBuffer(extractedSql.length() + 32);
                            messageBuf.append("\n\nQuery being executed when exception was thrown:\n");
                            messageBuf.append(extractedSql);
                            messageBuf.append("\n\n");
                            sqlE = ConnectionImpl.appendMessageToException(sqlE, messageBuf.toString(), this.getExceptionInterceptor());
                        }
                        if (this.getHighAvailability()) {
                            this.needsPing = true;
                            throw sqlE;
                        }
                        String sqlState = sqlE.getSQLState();
                        if (sqlState == null) throw sqlE;
                        if (!sqlState.equals("08S01")) throw sqlE;
                        this.cleanup(sqlE);
                        throw sqlE;
                    }
                    catch (Exception ex) {
                        if (this.getHighAvailability()) {
                            this.needsPing = true;
                        } else if (ex instanceof IOException) {
                            this.cleanup(ex);
                        }
                        SQLException sqlEx = SQLError.createSQLException(Messages.getString("Connection.UnexpectedException"), "S1000", this.getExceptionInterceptor());
                        sqlEx.initCause(ex);
                        throw sqlEx;
                    }
                }
                catch (Throwable throwable) {
                    Object var18_24 = null;
                    if (this.getMaintainTimeStats()) {
                        this.lastQueryFinishedTime = System.currentTimeMillis();
                    }
                    if (!this.getGatherPerformanceMetrics()) throw throwable;
                    long queryTime = System.currentTimeMillis() - queryStartTime;
                    this.registerQueryExecutionTime(queryTime);
                    throw throwable;
                }
            }
            if (this.getMaintainTimeStats()) {
                this.lastQueryFinishedTime = System.currentTimeMillis();
            }
            if (!this.getGatherPerformanceMetrics()) return resultSetInternalMethods;
            long queryTime = System.currentTimeMillis() - queryStartTime;
            this.registerQueryExecutionTime(queryTime);
            return resultSetInternalMethods;
        }
        Object var18_23 = null;
        if (this.getMaintainTimeStats()) {
            this.lastQueryFinishedTime = System.currentTimeMillis();
        }
        if (!this.getGatherPerformanceMetrics()) return encoding2;
        long queryTime = System.currentTimeMillis() - queryStartTime;
        this.registerQueryExecutionTime(queryTime);
        return encoding2;
    }

    public String extractSqlFromPacket(String possibleSqlQuery, Buffer queryPacket, int endOfQueryPacketPosition) throws SQLException {
        String extractedSql = null;
        if (possibleSqlQuery != null) {
            if (possibleSqlQuery.length() > this.getMaxQuerySizeToLog()) {
                StringBuffer truncatedQueryBuf = new StringBuffer(possibleSqlQuery.substring(0, this.getMaxQuerySizeToLog()));
                truncatedQueryBuf.append(Messages.getString("MysqlIO.25"));
                extractedSql = truncatedQueryBuf.toString();
            } else {
                extractedSql = possibleSqlQuery;
            }
        }
        if (extractedSql == null) {
            int extractPosition = endOfQueryPacketPosition;
            boolean truncated = false;
            if (endOfQueryPacketPosition > this.getMaxQuerySizeToLog()) {
                extractPosition = this.getMaxQuerySizeToLog();
                truncated = true;
            }
            extractedSql = StringUtils.toString(queryPacket.getByteBuffer(), 5, extractPosition - 5);
            if (truncated) {
                extractedSql = extractedSql + Messages.getString("MysqlIO.25");
            }
        }
        return extractedSql;
    }

    protected void finalize() throws Throwable {
        this.cleanup(null);
        super.finalize();
    }

    public StringBuffer generateConnectionCommentBlock(StringBuffer buf) {
        buf.append("/* conn id ");
        buf.append(this.getId());
        buf.append(" clock: ");
        buf.append(System.currentTimeMillis());
        buf.append(" */ ");
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveStatementCount() {
        if (this.openStatements != null) {
            Map map = this.openStatements;
            synchronized (map) {
                return this.openStatements.size();
            }
        }
        return 0;
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public Calendar getCalendarInstanceForSessionOrNew() {
        if (this.getDynamicCalendars()) {
            return Calendar.getInstance();
        }
        return this.getSessionLockedCalendar();
    }

    public synchronized String getCatalog() throws SQLException {
        return this.database;
    }

    public synchronized String getCharacterSetMetadata() {
        return this.characterSetMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleByteCharsetConverter getCharsetConverter(String javaEncodingName) throws SQLException {
        if (javaEncodingName == null) {
            return null;
        }
        if (this.usePlatformCharsetConverters) {
            return null;
        }
        SingleByteCharsetConverter converter = null;
        Map map = this.charsetConverterMap;
        synchronized (map) {
            Object asObject = this.charsetConverterMap.get(javaEncodingName);
            if (asObject == CHARSET_CONVERTER_NOT_AVAILABLE_MARKER) {
                return null;
            }
            converter = (SingleByteCharsetConverter)asObject;
            if (converter == null) {
                try {
                    converter = SingleByteCharsetConverter.getInstance(javaEncodingName, this);
                    if (converter == null) {
                        this.charsetConverterMap.put(javaEncodingName, CHARSET_CONVERTER_NOT_AVAILABLE_MARKER);
                    } else {
                        this.charsetConverterMap.put(javaEncodingName, converter);
                    }
                }
                catch (UnsupportedEncodingException unsupEncEx) {
                    this.charsetConverterMap.put(javaEncodingName, CHARSET_CONVERTER_NOT_AVAILABLE_MARKER);
                    converter = null;
                }
            }
        }
        return converter;
    }

    public String getCharsetNameForIndex(int charsetIndex) throws SQLException {
        String charsetName = null;
        if (this.getUseOldUTF8Behavior()) {
            return this.getEncoding();
        }
        if (charsetIndex != -1) {
            try {
                charsetName = this.indexToCharsetMapping[charsetIndex];
                if (("sjis".equalsIgnoreCase(charsetName) || "MS932".equalsIgnoreCase(charsetName)) && CharsetMapping.isAliasForSjis(this.getEncoding())) {
                    charsetName = this.getEncoding();
                }
            }
            catch (ArrayIndexOutOfBoundsException outOfBoundsEx) {
                throw SQLError.createSQLException("Unknown character set index for field '" + charsetIndex + "' received from server.", "S1000", this.getExceptionInterceptor());
            }
            if (charsetName == null) {
                charsetName = this.getEncoding();
            }
        } else {
            charsetName = this.getEncoding();
        }
        return charsetName;
    }

    public TimeZone getDefaultTimeZone() {
        return this.defaultTimeZone;
    }

    public String getErrorMessageEncoding() {
        return this.errorMessageEncoding;
    }

    public int getHoldability() throws SQLException {
        return 2;
    }

    public long getId() {
        return this.connectionId;
    }

    public synchronized long getIdleFor() {
        if (this.lastQueryFinishedTime == 0L) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long idleTime = now - this.lastQueryFinishedTime;
        return idleTime;
    }

    public MysqlIO getIO() throws SQLException {
        if (this.io == null || this.isClosed) {
            throw SQLError.createSQLException("Operation not allowed on closed connection", "08003", this.getExceptionInterceptor());
        }
        return this.io;
    }

    public Log getLog() throws SQLException {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxBytesPerChar(String javaCharsetName) throws SQLException {
        block13: {
            Map mapToCheck;
            String charset;
            block15: {
                block14: {
                    charset = CharsetMapping.getMysqlEncodingForJavaEncoding(javaCharsetName, this);
                    if (this.io.serverCharsetIndex == 33 && this.versionMeetsMinimum(5, 5, 3) && javaCharsetName.equalsIgnoreCase("UTF-8")) {
                        charset = "utf8";
                    }
                    if (!this.versionMeetsMinimum(4, 1, 0)) break block13;
                    mapToCheck = null;
                    if (this.getUseDynamicCharsetInfo()) break block14;
                    mapToCheck = CharsetMapping.STATIC_CHARSET_TO_NUM_BYTES_MAP;
                    break block15;
                }
                mapToCheck = this.charsetToNumBytesMap;
                Map map = this.charsetToNumBytesMap;
                synchronized (map) {
                    if (this.charsetToNumBytesMap.isEmpty()) {
                        java.sql.Statement stmt;
                        block12: {
                            stmt = null;
                            ResultSet rs = null;
                            try {
                                stmt = this.getMetadataSafeStatement();
                                rs = stmt.executeQuery("SHOW CHARACTER SET");
                                while (rs.next()) {
                                    this.charsetToNumBytesMap.put(rs.getString("Charset"), rs.getInt("Maxlen"));
                                }
                                rs.close();
                                rs = null;
                                stmt.close();
                                stmt = null;
                                Object var8_7 = null;
                                if (rs == null) break block12;
                            }
                            catch (Throwable throwable) {
                                Object var8_8 = null;
                                if (rs != null) {
                                    rs.close();
                                    rs = null;
                                }
                                if (stmt != null) {
                                    stmt.close();
                                    stmt = null;
                                }
                                throw throwable;
                            }
                            rs.close();
                            rs = null;
                        }
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                    }
                }
            }
            Integer mbPerChar = (Integer)mapToCheck.get(charset);
            if (mbPerChar != null) {
                return mbPerChar;
            }
            return 1;
        }
        return 1;
    }

    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        return this.getMetaData(true, true);
    }

    private java.sql.DatabaseMetaData getMetaData(boolean checkClosed, boolean checkForInfoSchema) throws SQLException {
        if (checkClosed) {
            this.checkClosed();
        }
        return DatabaseMetaData.getInstance(this.getLoadBalanceSafeProxy(), this.database, checkForInfoSchema);
    }

    public java.sql.Statement getMetadataSafeStatement() throws SQLException {
        java.sql.Statement stmt = this.createStatement();
        if (stmt.getMaxRows() != 0) {
            stmt.setMaxRows(0);
        }
        stmt.setEscapeProcessing(false);
        if (stmt.getFetchSize() != 0) {
            stmt.setFetchSize(0);
        }
        return stmt;
    }

    public int getNetBufferLength() {
        return this.netBufferLength;
    }

    public String getServerCharacterEncoding() {
        if (this.io.versionMeetsMinimum(4, 1, 0)) {
            return (String)this.serverVariables.get("character_set_server");
        }
        return (String)this.serverVariables.get("character_set");
    }

    public int getServerMajorVersion() {
        return this.io.getServerMajorVersion();
    }

    public int getServerMinorVersion() {
        return this.io.getServerMinorVersion();
    }

    public int getServerSubMinorVersion() {
        return this.io.getServerSubMinorVersion();
    }

    public TimeZone getServerTimezoneTZ() {
        return this.serverTimezoneTZ;
    }

    public String getServerVariable(String variableName) {
        if (this.serverVariables != null) {
            return (String)this.serverVariables.get(variableName);
        }
        return null;
    }

    public String getServerVersion() {
        return this.io.getServerVersion();
    }

    public Calendar getSessionLockedCalendar() {
        return this.sessionCalendar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized int getTransactionIsolation() throws SQLException {
        String s;
        block12: {
            Exception ex22;
            int n;
            java.sql.Statement stmt;
            block13: {
                if (!this.hasIsolationLevels || this.getUseLocalSessionState()) return this.isolationLevel;
                stmt = null;
                ResultSet rs = null;
                try {
                    Integer intTI;
                    stmt = this.getMetadataSafeStatement();
                    String query = null;
                    int offset = 0;
                    if (this.versionMeetsMinimum(4, 0, 3)) {
                        query = "SELECT @@session.tx_isolation";
                        offset = 1;
                    } else {
                        query = "SHOW VARIABLES LIKE 'transaction_isolation'";
                        offset = 2;
                    }
                    rs = stmt.executeQuery(query);
                    if (!rs.next()) throw SQLError.createSQLException("Could not retrieve transaction isolation level from server", "S1000", this.getExceptionInterceptor());
                    s = rs.getString(offset);
                    if (s == null || (intTI = (Integer)mapTransIsolationNameToValue.get(s)) == null) break block12;
                    n = intTI;
                    Object var9_8 = null;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    Exception ex22;
                    Object var9_9 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception ex22) {
                            // empty catch block
                        }
                        rs = null;
                    }
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                    }
                    catch (Exception ex22) {
                        // empty catch block
                    }
                    stmt = null;
                    throw throwable;
                }
                try {
                    rs.close();
                }
                catch (Exception ex22) {
                    // empty catch block
                }
                rs = null;
            }
            if (stmt == null) return n;
            try {
                stmt.close();
            }
            catch (Exception ex22) {
                // empty catch block
            }
            stmt = null;
            return n;
        }
        throw SQLError.createSQLException("Could not map transaction isolation '" + s + " to a valid JDBC level.", "S1000", this.getExceptionInterceptor());
    }

    public synchronized Map getTypeMap() throws SQLException {
        if (this.typeMap == null) {
            this.typeMap = new HashMap();
        }
        return this.typeMap;
    }

    public String getURL() {
        return this.myURL;
    }

    public String getUser() {
        return this.user;
    }

    public Calendar getUtcCalendar() {
        return this.utcCalendar;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public boolean hasSameProperties(Connection c) {
        return this.props.equals(c.getProperties());
    }

    public Properties getProperties() {
        return this.props;
    }

    public boolean hasTriedMaster() {
        return this.hasTriedMasterFlag;
    }

    public void incrementNumberOfPreparedExecutes() {
        if (this.getGatherPerformanceMetrics()) {
            ++this.numberOfPreparedExecutes;
            ++this.numberOfQueriesIssued;
        }
    }

    public void incrementNumberOfPrepares() {
        if (this.getGatherPerformanceMetrics()) {
            ++this.numberOfPrepares;
        }
    }

    public void incrementNumberOfResultSetsCreated() {
        if (this.getGatherPerformanceMetrics()) {
            ++this.numberOfResultSetsCreated;
        }
    }

    private void initializeDriverProperties(Properties info) throws SQLException {
        this.initializeProperties(info);
        String exceptionInterceptorClasses = this.getExceptionInterceptors();
        if (exceptionInterceptorClasses != null && !"".equals(exceptionInterceptorClasses)) {
            this.exceptionInterceptor = new ExceptionInterceptorChain(exceptionInterceptorClasses);
            this.exceptionInterceptor.init(this, info);
        }
        this.usePlatformCharsetConverters = this.getUseJvmCharsetConverters();
        this.log = LogFactory.getLogger(this.getLogger(), LOGGER_INSTANCE_NAME, this.getExceptionInterceptor());
        if (this.getProfileSql() || this.getUseUsageAdvisor()) {
            this.eventSink = ProfilerEventHandlerFactory.getInstance(this.getLoadBalanceSafeProxy());
        }
        if (this.getCachePreparedStatements()) {
            this.createPreparedStatementCaches();
        }
        if (this.getNoDatetimeStringSync() && this.getUseTimezone()) {
            throw SQLError.createSQLException("Can't enable noDatetimeSync and useTimezone configuration properties at the same time", "01S00", this.getExceptionInterceptor());
        }
        if (this.getCacheCallableStatements()) {
            this.parsedCallableStatementCache = new LRUCache(this.getCallableStatementCacheSize());
        }
        if (this.getAllowMultiQueries()) {
            this.setCacheResultSetMetadata(false);
        }
        if (this.getCacheResultSetMetadata()) {
            this.resultSetMetadataCache = new LRUCache(this.getMetadataCacheSize());
        }
    }

    private void initializePropsFromServer() throws SQLException {
        String connectionInterceptorClasses = this.getConnectionLifecycleInterceptors();
        this.connectionLifecycleInterceptors = null;
        if (connectionInterceptorClasses != null) {
            this.connectionLifecycleInterceptors = Util.loadExtensions(this, this.props, connectionInterceptorClasses, "Connection.badLifecycleInterceptor", this.getExceptionInterceptor());
        }
        this.setSessionVariables();
        if (!this.versionMeetsMinimum(4, 1, 0)) {
            this.setTransformedBitIsBoolean(false);
        }
        this.parserKnowsUnicode = this.versionMeetsMinimum(4, 1, 0);
        if (this.getUseServerPreparedStmts() && this.versionMeetsMinimum(4, 1, 0)) {
            this.useServerPreparedStmts = true;
            if (this.versionMeetsMinimum(5, 0, 0) && !this.versionMeetsMinimum(5, 0, 3)) {
                this.useServerPreparedStmts = false;
            }
        }
        if (this.versionMeetsMinimum(3, 21, 22)) {
            this.loadServerVariables();
            this.autoIncrementIncrement = this.versionMeetsMinimum(5, 0, 2) ? this.getServerVariableAsInt("auto_increment_increment", 1) : 1;
            this.buildCollationMapping();
            LicenseConfiguration.checkLicenseType(this.serverVariables);
            String lowerCaseTables = (String)this.serverVariables.get("lower_case_table_names");
            this.lowerCaseTableNames = "on".equalsIgnoreCase(lowerCaseTables) || "1".equalsIgnoreCase(lowerCaseTables) || "2".equalsIgnoreCase(lowerCaseTables);
            this.storesLowerCaseTableName = "1".equalsIgnoreCase(lowerCaseTables) || "on".equalsIgnoreCase(lowerCaseTables);
            this.configureTimezone();
            if (this.serverVariables.containsKey("max_allowed_packet")) {
                int serverMaxAllowedPacket = this.getServerVariableAsInt("max_allowed_packet", -1);
                if (serverMaxAllowedPacket != -1 && (serverMaxAllowedPacket < this.getMaxAllowedPacket() || this.getMaxAllowedPacket() <= 0)) {
                    this.setMaxAllowedPacket(serverMaxAllowedPacket);
                } else if (serverMaxAllowedPacket == -1 && this.getMaxAllowedPacket() == -1) {
                    this.setMaxAllowedPacket(65535);
                }
                int preferredBlobSendChunkSize = this.getBlobSendChunkSize();
                int allowedBlobSendChunkSize = Math.min(preferredBlobSendChunkSize, this.getMaxAllowedPacket()) - 8192 - 11;
                this.setBlobSendChunkSize(String.valueOf(allowedBlobSendChunkSize));
            }
            if (this.serverVariables.containsKey("net_buffer_length")) {
                this.netBufferLength = this.getServerVariableAsInt("net_buffer_length", 16384);
            }
            this.checkTransactionIsolationLevel();
            if (!this.versionMeetsMinimum(4, 1, 0)) {
                this.checkServerEncoding();
            }
            this.io.checkForCharsetMismatch();
            if (this.serverVariables.containsKey("sql_mode")) {
                int sqlMode;
                block24: {
                    sqlMode = 0;
                    String sqlModeAsString = (String)this.serverVariables.get("sql_mode");
                    try {
                        sqlMode = Integer.parseInt(sqlModeAsString);
                    }
                    catch (NumberFormatException nfe) {
                        sqlMode = 0;
                        if (sqlModeAsString == null) break block24;
                        if (sqlModeAsString.indexOf("ANSI_QUOTES") != -1) {
                            sqlMode |= 4;
                        }
                        if (sqlModeAsString.indexOf("NO_BACKSLASH_ESCAPES") == -1) break block24;
                        this.noBackslashEscapes = true;
                    }
                }
                this.useAnsiQuotes = (sqlMode & 4) > 0;
            }
        }
        this.errorMessageEncoding = CharsetMapping.getCharacterEncodingForErrorMessages(this);
        boolean overrideDefaultAutocommit = this.isAutoCommitNonDefaultOnServer();
        this.configureClientCharacterSet(false);
        if (this.versionMeetsMinimum(3, 23, 15)) {
            this.transactionsSupported = true;
            if (!overrideDefaultAutocommit) {
                this.setAutoCommit(true);
            }
        } else {
            this.transactionsSupported = false;
        }
        this.hasIsolationLevels = this.versionMeetsMinimum(3, 23, 36);
        this.hasQuotedIdentifiers = this.versionMeetsMinimum(3, 23, 6);
        this.io.resetMaxBuf();
        if (this.io.versionMeetsMinimum(4, 1, 0)) {
            String characterSetResultsOnServerMysql = (String)this.serverVariables.get(JDBC_LOCAL_CHARACTER_SET_RESULTS);
            if (characterSetResultsOnServerMysql == null || StringUtils.startsWithIgnoreCaseAndWs(characterSetResultsOnServerMysql, "NULL") || characterSetResultsOnServerMysql.length() == 0) {
                String defaultMetadataCharsetMysql = (String)this.serverVariables.get("character_set_system");
                String defaultMetadataCharset = null;
                defaultMetadataCharset = defaultMetadataCharsetMysql != null ? CharsetMapping.getJavaEncodingForMysqlEncoding(defaultMetadataCharsetMysql, this) : "UTF-8";
                this.characterSetMetadata = defaultMetadataCharset;
            } else {
                this.characterSetMetadata = this.characterSetResultsOnServer = CharsetMapping.getJavaEncodingForMysqlEncoding(characterSetResultsOnServerMysql, this);
            }
        } else {
            this.characterSetMetadata = this.getEncoding();
        }
        if (this.versionMeetsMinimum(4, 1, 0) && !this.versionMeetsMinimum(4, 1, 10) && this.getAllowMultiQueries() && this.isQueryCacheEnabled()) {
            this.setAllowMultiQueries(false);
        }
        if (this.versionMeetsMinimum(5, 0, 0) && (this.getUseLocalTransactionState() || this.getElideSetAutoCommits()) && this.isQueryCacheEnabled() && !this.versionMeetsMinimum(6, 0, 10)) {
            this.setUseLocalTransactionState(false);
            this.setElideSetAutoCommits(false);
        }
        this.setupServerForTruncationChecks();
    }

    private boolean isQueryCacheEnabled() {
        return "ON".equalsIgnoreCase((String)this.serverVariables.get("query_cache_type")) && !"0".equalsIgnoreCase((String)this.serverVariables.get("query_cache_size"));
    }

    private int getServerVariableAsInt(String variableName, int fallbackValue) throws SQLException {
        try {
            return Integer.parseInt((String)this.serverVariables.get(variableName));
        }
        catch (NumberFormatException nfe) {
            this.getLog().logWarn(Messages.getString("Connection.BadValueInServerVariables", new Object[]{variableName, this.serverVariables.get(variableName), fallbackValue}));
            return fallbackValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAutoCommitNonDefaultOnServer() throws SQLException {
        boolean overrideDefaultAutocommit;
        block15: {
            block16: {
                SQLException sqlEx22;
                java.sql.Statement stmt;
                block14: {
                    overrideDefaultAutocommit = false;
                    String initConnectValue = (String)this.serverVariables.get("init_connect");
                    if (!this.versionMeetsMinimum(4, 1, 2) || initConnectValue == null || initConnectValue.length() <= 0) break block15;
                    if (this.getElideSetAutoCommits()) break block16;
                    ResultSet rs = null;
                    stmt = null;
                    try {
                        stmt = this.getMetadataSafeStatement();
                        rs = stmt.executeQuery("SELECT @@session.autocommit");
                        if (rs.next()) {
                            this.autoCommit = rs.getBoolean(1);
                            if (!this.autoCommit) {
                                overrideDefaultAutocommit = true;
                            }
                        }
                        Object var6_5 = null;
                        if (rs == null) break block14;
                    }
                    catch (Throwable throwable) {
                        SQLException sqlEx22;
                        Object var6_6 = null;
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException sqlEx22) {
                                // empty catch block
                            }
                        }
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException sqlEx22) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        rs.close();
                    }
                    catch (SQLException sqlEx22) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlEx22) {}
                }
                break block15;
            }
            if (this.getIO().isSetNeededForAutoCommitMode(true)) {
                this.autoCommit = false;
                overrideDefaultAutocommit = true;
            }
        }
        return overrideDefaultAutocommit;
    }

    public boolean isClientTzUTC() {
        return this.isClientTzUTC;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isCursorFetchEnabled() throws SQLException {
        return this.versionMeetsMinimum(5, 0, 2) && this.getUseCursorFetch();
    }

    public boolean isInGlobalTx() {
        return this.isInGlobalTx;
    }

    public synchronized boolean isMasterConnection() {
        return false;
    }

    public boolean isNoBackslashEscapesSet() {
        return this.noBackslashEscapes;
    }

    public boolean isReadInfoMsgEnabled() {
        return this.readInfoMsg;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public boolean isRunningOnJDK13() {
        return this.isRunningOnJDK13;
    }

    public synchronized boolean isSameResource(Connection otherConnection) {
        if (otherConnection == null) {
            return false;
        }
        boolean directCompare = true;
        String otherHost = ((ConnectionImpl)otherConnection).origHostToConnectTo;
        String otherOrigDatabase = ((ConnectionImpl)otherConnection).origDatabaseToConnectTo;
        String otherCurrentCatalog = ((ConnectionImpl)otherConnection).database;
        if (!ConnectionImpl.nullSafeCompare(otherHost, this.origHostToConnectTo)) {
            directCompare = false;
        } else if (otherHost != null && otherHost.indexOf(44) == -1 && otherHost.indexOf(58) == -1) {
            boolean bl = directCompare = ((ConnectionImpl)otherConnection).origPortToConnectTo == this.origPortToConnectTo;
        }
        if (directCompare) {
            if (!ConnectionImpl.nullSafeCompare(otherOrigDatabase, this.origDatabaseToConnectTo)) {
                directCompare = false;
                directCompare = false;
            } else if (!ConnectionImpl.nullSafeCompare(otherCurrentCatalog, this.database)) {
                directCompare = false;
            }
        }
        if (directCompare) {
            return true;
        }
        String otherResourceId = ((ConnectionImpl)otherConnection).getResourceId();
        String myResourceId = this.getResourceId();
        return (otherResourceId != null || myResourceId != null) && (directCompare = ConnectionImpl.nullSafeCompare(otherResourceId, myResourceId));
    }

    public boolean isServerTzUTC() {
        return this.isServerTzUTC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadServerVariables() throws SQLException {
        block29: {
            SQLException sqlE22;
            ResultSet results;
            java.sql.Statement stmt;
            block28: {
                if (this.getCacheServerConfiguration()) {
                    Map map = serverConfigByUrl;
                    synchronized (map) {
                        Map cachedVariableMap = (Map)serverConfigByUrl.get(this.getURL());
                        if (cachedVariableMap != null) {
                            this.serverVariables = cachedVariableMap;
                            this.usingCachedConfig = true;
                            return;
                        }
                    }
                }
                stmt = null;
                results = null;
                stmt = this.getMetadataSafeStatement();
                String version = this.dbmd.getDriverVersion();
                if (version != null && version.indexOf(42) != -1) {
                    StringBuffer buf = new StringBuffer(version.length() + 10);
                    for (int i = 0; i < version.length(); ++i) {
                        char c = version.charAt(i);
                        if (c == '*') {
                            buf.append("[star]");
                            continue;
                        }
                        buf.append(c);
                    }
                    version = buf.toString();
                }
                String versionComment = this.getParanoid() || version == null ? "" : "/* " + version + " */";
                String query = versionComment + "SHOW VARIABLES";
                if (this.versionMeetsMinimum(5, 0, 3)) {
                    query = versionComment + "SHOW VARIABLES WHERE Variable_name ='language'" + " OR Variable_name = 'net_write_timeout'" + " OR Variable_name = 'interactive_timeout'" + " OR Variable_name = 'wait_timeout'" + " OR Variable_name = 'character_set_client'" + " OR Variable_name = 'character_set_connection'" + " OR Variable_name = 'character_set'" + " OR Variable_name = 'character_set_server'" + " OR Variable_name = 'tx_isolation'" + " OR Variable_name = 'transaction_isolation'" + " OR Variable_name = 'character_set_results'" + " OR Variable_name = 'timezone'" + " OR Variable_name = 'time_zone'" + " OR Variable_name = 'system_time_zone'" + " OR Variable_name = 'lower_case_table_names'" + " OR Variable_name = 'max_allowed_packet'" + " OR Variable_name = 'net_buffer_length'" + " OR Variable_name = 'sql_mode'" + " OR Variable_name = 'query_cache_type'" + " OR Variable_name = 'query_cache_size'" + " OR Variable_name = 'init_connect'";
                }
                this.serverVariables = new HashMap();
                results = stmt.executeQuery(query);
                while (results.next()) {
                    this.serverVariables.put(results.getString(1), results.getString(2));
                }
                results.close();
                results = null;
                if (this.versionMeetsMinimum(5, 0, 2) && (results = stmt.executeQuery(versionComment + "SELECT @@session.auto_increment_increment")).next()) {
                    this.serverVariables.put("auto_increment_increment", results.getString(1));
                }
                if (this.getCacheServerConfiguration()) {
                    Map map = serverConfigByUrl;
                    synchronized (map) {
                        serverConfigByUrl.put(this.getURL(), this.serverVariables);
                        this.usingCachedConfig = true;
                    }
                }
                Object var9_12 = null;
                if (results == null) break block28;
                try {
                    results.close();
                }
                catch (SQLException sqlE22) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqlE22) {}
            }
            break block29;
            {
                catch (SQLException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                SQLException sqlE22;
                Object var9_13 = null;
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (SQLException sqlE22) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlE22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public int getAutoIncrementIncrement() {
        return this.autoIncrementIncrement;
    }

    public boolean lowerCaseTableNames() {
        return this.lowerCaseTableNames;
    }

    public synchronized void maxRowsChanged(Statement stmt) {
        if (this.statementsUsingMaxRows == null) {
            this.statementsUsingMaxRows = new HashMap();
        }
        this.statementsUsingMaxRows.put(stmt, stmt);
        this.maxRowsChanged = true;
    }

    public String nativeSQL(String sql) throws SQLException {
        if (sql == null) {
            return null;
        }
        Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.serverSupportsConvertFn(), this.getLoadBalanceSafeProxy());
        if (escapedSqlResult instanceof String) {
            return (String)escapedSqlResult;
        }
        return ((EscapeProcessorResult)escapedSqlResult).escapedSql;
    }

    private CallableStatement parseCallableStatement(String sql) throws SQLException {
        Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.serverSupportsConvertFn(), this.getLoadBalanceSafeProxy());
        boolean isFunctionCall = false;
        String parsedSql = null;
        if (escapedSqlResult instanceof EscapeProcessorResult) {
            parsedSql = ((EscapeProcessorResult)escapedSqlResult).escapedSql;
            isFunctionCall = ((EscapeProcessorResult)escapedSqlResult).callingStoredFunction;
        } else {
            parsedSql = (String)escapedSqlResult;
            isFunctionCall = false;
        }
        return CallableStatement.getInstance(this.getLoadBalanceSafeProxy(), parsedSql, this.database, isFunctionCall);
    }

    public boolean parserKnowsUnicode() {
        return this.parserKnowsUnicode;
    }

    public void ping() throws SQLException {
        this.pingInternal(true, 0);
    }

    public void pingInternal(boolean checkForClosedConnection, int timeoutMillis) throws SQLException {
        if (checkForClosedConnection) {
            this.checkClosed();
        }
        long pingMillisLifetime = this.getSelfDestructOnPingSecondsLifetime();
        int pingMaxOperations = this.getSelfDestructOnPingMaxOperations();
        if (pingMillisLifetime > 0L && System.currentTimeMillis() - this.connectionCreationTimeMillis > pingMillisLifetime || pingMaxOperations > 0 && pingMaxOperations <= this.io.getCommandCount()) {
            this.close();
            throw SQLError.createSQLException(Messages.getString("Connection.exceededConnectionLifetime"), "08S01", this.getExceptionInterceptor());
        }
        this.io.sendCommand(14, null, null, false, null, timeoutMillis);
    }

    public java.sql.CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.versionMeetsMinimum(5, 0, 0)) {
            CallableStatement cStmt = null;
            if (!this.getCacheCallableStatements()) {
                cStmt = this.parseCallableStatement(sql);
            } else {
                LRUCache lRUCache = this.parsedCallableStatementCache;
                synchronized (lRUCache) {
                    CompoundCacheKey key = new CompoundCacheKey(this.getCatalog(), sql);
                    CallableStatement.CallableStatementParamInfo cachedParamInfo = (CallableStatement.CallableStatementParamInfo)this.parsedCallableStatementCache.get(key);
                    if (cachedParamInfo != null) {
                        cStmt = CallableStatement.getInstance(this.getLoadBalanceSafeProxy(), cachedParamInfo);
                    } else {
                        CallableStatement callableStatement = cStmt = this.parseCallableStatement(sql);
                        synchronized (callableStatement) {
                            cachedParamInfo = cStmt.paramInfo;
                        }
                        this.parsedCallableStatementCache.put(key, cachedParamInfo);
                    }
                }
            }
            cStmt.setResultSetType(resultSetType);
            cStmt.setResultSetConcurrency(resultSetConcurrency);
            return cStmt;
        }
        throw SQLError.createSQLException("Callable statements not supported.", "S1C00", this.getExceptionInterceptor());
    }

    public java.sql.CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.getPedantic() && resultSetHoldability != 1) {
            throw SQLError.createSQLException("HOLD_CUSRORS_OVER_COMMIT is only supported holdability level", "S1009", this.getExceptionInterceptor());
        }
        CallableStatement cStmt = (CallableStatement)this.prepareCall(sql, resultSetType, resultSetConcurrency);
        return cStmt;
    }

    public java.sql.PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        java.sql.PreparedStatement pStmt = this.prepareStatement(sql);
        ((PreparedStatement)pStmt).setRetrieveGeneratedKeys(autoGenKeyIndex == 1);
        return pStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String nativeSql;
        this.checkClosed();
        PreparedStatement pStmt = null;
        boolean canServerPrepare = true;
        String string = nativeSql = this.getProcessEscapeCodesForPrepStmts() ? this.nativeSQL(sql) : sql;
        if (this.useServerPreparedStmts && this.getEmulateUnsupportedPstmts()) {
            canServerPrepare = this.canHandleAsServerPreparedStatement(nativeSql);
        }
        if (this.useServerPreparedStmts && canServerPrepare) {
            if (this.getCachePreparedStatements()) {
                LRUCache lRUCache = this.serverSideStatementCache;
                synchronized (lRUCache) {
                    pStmt = (ServerPreparedStatement)this.serverSideStatementCache.remove(sql);
                    if (pStmt != null) {
                        ((ServerPreparedStatement)pStmt).setClosed(false);
                        pStmt.clearParameters();
                    }
                    if (pStmt == null) {
                        try {
                            pStmt = ServerPreparedStatement.getInstance(this.getLoadBalanceSafeProxy(), nativeSql, this.database, resultSetType, resultSetConcurrency);
                            if (sql.length() < this.getPreparedStatementCacheSqlLimit()) {
                                ((ServerPreparedStatement)pStmt).isCached = true;
                            }
                            pStmt.setResultSetType(resultSetType);
                            pStmt.setResultSetConcurrency(resultSetConcurrency);
                        }
                        catch (SQLException sqlEx) {
                            if (this.getEmulateUnsupportedPstmts()) {
                                pStmt = (PreparedStatement)this.clientPrepareStatement(nativeSql, resultSetType, resultSetConcurrency, false);
                                if (sql.length() < this.getPreparedStatementCacheSqlLimit()) {
                                    this.serverSideStatementCheckCache.put(sql, Boolean.FALSE);
                                }
                            }
                            throw sqlEx;
                        }
                    }
                }
            }
            try {
                pStmt = ServerPreparedStatement.getInstance(this.getLoadBalanceSafeProxy(), nativeSql, this.database, resultSetType, resultSetConcurrency);
                pStmt.setResultSetType(resultSetType);
                pStmt.setResultSetConcurrency(resultSetConcurrency);
            }
            catch (SQLException sqlEx) {
                if (this.getEmulateUnsupportedPstmts()) {
                    pStmt = (PreparedStatement)this.clientPrepareStatement(nativeSql, resultSetType, resultSetConcurrency, false);
                }
                throw sqlEx;
            }
        } else {
            pStmt = (PreparedStatement)this.clientPrepareStatement(nativeSql, resultSetType, resultSetConcurrency, false);
        }
        return pStmt;
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.getPedantic() && resultSetHoldability != 1) {
            throw SQLError.createSQLException("HOLD_CUSRORS_OVER_COMMIT is only supported holdability level", "S1009", this.getExceptionInterceptor());
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        java.sql.PreparedStatement pStmt = this.prepareStatement(sql);
        ((PreparedStatement)pStmt).setRetrieveGeneratedKeys(autoGenKeyIndexes != null && autoGenKeyIndexes.length > 0);
        return pStmt;
    }

    public java.sql.PreparedStatement prepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        java.sql.PreparedStatement pStmt = this.prepareStatement(sql);
        ((PreparedStatement)pStmt).setRetrieveGeneratedKeys(autoGenKeyColNames != null && autoGenKeyColNames.length > 0);
        return pStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void realClose(boolean calledExplicitly, boolean issueRollback, boolean skipLocalTeardown, Throwable reason) throws SQLException {
        SQLException sqlEx = null;
        if (this.isClosed()) {
            return;
        }
        this.forceClosedReason = reason;
        try {
            if (!skipLocalTeardown) {
                if (!this.getAutoCommit() && issueRollback) {
                    try {
                        this.rollback();
                    }
                    catch (SQLException ex) {
                        sqlEx = ex;
                    }
                }
                this.reportMetrics();
                if (this.getUseUsageAdvisor()) {
                    long connectionLifeTime;
                    if (!calledExplicitly) {
                        String message = "Connection implicitly closed by Driver. You should call Connection.close() from your code to free resources more efficiently and avoid resource leaks.";
                        this.eventSink.consumeEvent(new ProfilerEvent(0, "", this.getCatalog(), this.getId(), -1, -1, System.currentTimeMillis(), 0L, Constants.MILLIS_I18N, null, this.pointOfOrigin, message));
                    }
                    if ((connectionLifeTime = System.currentTimeMillis() - this.connectionCreationTimeMillis) < 500L) {
                        String message = "Connection lifetime of < .5 seconds. You might be un-necessarily creating short-lived connections and should investigate connection pooling to be more efficient.";
                        this.eventSink.consumeEvent(new ProfilerEvent(0, "", this.getCatalog(), this.getId(), -1, -1, System.currentTimeMillis(), 0L, Constants.MILLIS_I18N, null, this.pointOfOrigin, message));
                    }
                }
                try {
                    this.closeAllOpenStatements();
                }
                catch (SQLException ex) {
                    sqlEx = ex;
                }
                if (this.io != null) {
                    try {
                        this.io.quit();
                    }
                    catch (Exception e) {}
                }
            } else {
                this.io.forceClose();
            }
            if (this.statementInterceptors != null) {
                for (int i = 0; i < this.statementInterceptors.size(); ++i) {
                    ((StatementInterceptorV2)this.statementInterceptors.get(i)).destroy();
                }
            }
            if (this.exceptionInterceptor != null) {
                this.exceptionInterceptor.destroy();
            }
            Object var10_14 = null;
            this.openStatements = null;
            this.io = null;
            this.statementInterceptors = null;
            this.exceptionInterceptor = null;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.openStatements = null;
            this.io = null;
            this.statementInterceptors = null;
            this.exceptionInterceptor = null;
            ProfilerEventHandlerFactory.removeInstance(this);
            ConnectionImpl connectionImpl = this;
            synchronized (connectionImpl) {
                if (this.cancelTimer != null) {
                    this.cancelTimer.cancel();
                }
            }
            this.isClosed = true;
            throw throwable;
        }
        ProfilerEventHandlerFactory.removeInstance(this);
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this.cancelTimer != null) {
                this.cancelTimer.cancel();
            }
        }
        this.isClosed = true;
        if (sqlEx != null) {
            throw sqlEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recachePreparedStatement(ServerPreparedStatement pstmt) throws SQLException {
        if (pstmt.isPoolable()) {
            LRUCache lRUCache = this.serverSideStatementCache;
            synchronized (lRUCache) {
                this.serverSideStatementCache.put(pstmt.originalSql, pstmt);
            }
        }
    }

    public void registerQueryExecutionTime(long queryTimeMs) {
        if (queryTimeMs > this.longestQueryTimeMs) {
            this.longestQueryTimeMs = queryTimeMs;
            this.repartitionPerformanceHistogram();
        }
        this.addToPerformanceHistogram(queryTimeMs, 1);
        if (queryTimeMs < this.shortestQueryTimeMs) {
            this.shortestQueryTimeMs = queryTimeMs == 0L ? 1L : queryTimeMs;
        }
        ++this.numberOfQueriesIssued;
        this.totalQueryTimeMs += (double)queryTimeMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStatement(Statement stmt) {
        Map map = this.openStatements;
        synchronized (map) {
            this.openStatements.put(stmt, stmt);
        }
    }

    public void releaseSavepoint(Savepoint arg0) throws SQLException {
    }

    private void repartitionHistogram(int[] histCounts, long[] histBreakpoints, long currentLowerBound, long currentUpperBound) {
        if (this.oldHistCounts == null) {
            this.oldHistCounts = new int[histCounts.length];
            this.oldHistBreakpoints = new long[histBreakpoints.length];
        }
        System.arraycopy(histCounts, 0, this.oldHistCounts, 0, histCounts.length);
        System.arraycopy(histBreakpoints, 0, this.oldHistBreakpoints, 0, histBreakpoints.length);
        this.createInitialHistogram(histBreakpoints, currentLowerBound, currentUpperBound);
        for (int i = 0; i < 20; ++i) {
            this.addToHistogram(histCounts, histBreakpoints, this.oldHistBreakpoints[i], this.oldHistCounts[i], currentLowerBound, currentUpperBound);
        }
    }

    private void repartitionPerformanceHistogram() {
        this.checkAndCreatePerformanceHistogram();
        this.repartitionHistogram(this.perfMetricsHistCounts, this.perfMetricsHistBreakpoints, this.shortestQueryTimeMs == Long.MAX_VALUE ? 0L : this.shortestQueryTimeMs, this.longestQueryTimeMs);
    }

    private void repartitionTablesAccessedHistogram() {
        this.checkAndCreateTablesAccessedHistogram();
        this.repartitionHistogram(this.numTablesMetricsHistCounts, this.numTablesMetricsHistBreakpoints, this.minimumNumberTablesAccessed == Long.MAX_VALUE ? 0L : this.minimumNumberTablesAccessed, this.maximumNumberTablesAccessed);
    }

    private void reportMetrics() {
        if (this.getGatherPerformanceMetrics()) {
            int j;
            int numPointsToGraph;
            int i;
            int highestCount;
            int maxNumPoints;
            StringBuffer logMessage = new StringBuffer(256);
            logMessage.append("** Performance Metrics Report **\n");
            logMessage.append("\nLongest reported query: " + this.longestQueryTimeMs + " ms");
            logMessage.append("\nShortest reported query: " + this.shortestQueryTimeMs + " ms");
            logMessage.append("\nAverage query execution time: " + this.totalQueryTimeMs / (double)this.numberOfQueriesIssued + " ms");
            logMessage.append("\nNumber of statements executed: " + this.numberOfQueriesIssued);
            logMessage.append("\nNumber of result sets created: " + this.numberOfResultSetsCreated);
            logMessage.append("\nNumber of statements prepared: " + this.numberOfPrepares);
            logMessage.append("\nNumber of prepared statement executions: " + this.numberOfPreparedExecutes);
            if (this.perfMetricsHistBreakpoints != null) {
                logMessage.append("\n\n\tTiming Histogram:\n");
                maxNumPoints = 20;
                highestCount = Integer.MIN_VALUE;
                for (i = 0; i < 20; ++i) {
                    if (this.perfMetricsHistCounts[i] <= highestCount) continue;
                    highestCount = this.perfMetricsHistCounts[i];
                }
                if (highestCount == 0) {
                    highestCount = 1;
                }
                for (i = 0; i < 19; ++i) {
                    if (i == 0) {
                        logMessage.append("\n\tless than " + this.perfMetricsHistBreakpoints[i + 1] + " ms: \t" + this.perfMetricsHistCounts[i]);
                    } else {
                        logMessage.append("\n\tbetween " + this.perfMetricsHistBreakpoints[i] + " and " + this.perfMetricsHistBreakpoints[i + 1] + " ms: \t" + this.perfMetricsHistCounts[i]);
                    }
                    logMessage.append("\t");
                    numPointsToGraph = (int)((double)maxNumPoints * ((double)this.perfMetricsHistCounts[i] / (double)highestCount));
                    for (j = 0; j < numPointsToGraph; ++j) {
                        logMessage.append("*");
                    }
                    if (this.longestQueryTimeMs < (long)this.perfMetricsHistCounts[i + 1]) break;
                }
                if (this.perfMetricsHistBreakpoints[18] < this.longestQueryTimeMs) {
                    logMessage.append("\n\tbetween ");
                    logMessage.append(this.perfMetricsHistBreakpoints[18]);
                    logMessage.append(" and ");
                    logMessage.append(this.perfMetricsHistBreakpoints[19]);
                    logMessage.append(" ms: \t");
                    logMessage.append(this.perfMetricsHistCounts[19]);
                }
            }
            if (this.numTablesMetricsHistBreakpoints != null) {
                logMessage.append("\n\n\tTable Join Histogram:\n");
                maxNumPoints = 20;
                highestCount = Integer.MIN_VALUE;
                for (i = 0; i < 20; ++i) {
                    if (this.numTablesMetricsHistCounts[i] <= highestCount) continue;
                    highestCount = this.numTablesMetricsHistCounts[i];
                }
                if (highestCount == 0) {
                    highestCount = 1;
                }
                for (i = 0; i < 19; ++i) {
                    if (i == 0) {
                        logMessage.append("\n\t" + this.numTablesMetricsHistBreakpoints[i + 1] + " tables or less: \t\t" + this.numTablesMetricsHistCounts[i]);
                    } else {
                        logMessage.append("\n\tbetween " + this.numTablesMetricsHistBreakpoints[i] + " and " + this.numTablesMetricsHistBreakpoints[i + 1] + " tables: \t" + this.numTablesMetricsHistCounts[i]);
                    }
                    logMessage.append("\t");
                    numPointsToGraph = (int)((double)maxNumPoints * ((double)this.numTablesMetricsHistCounts[i] / (double)highestCount));
                    for (j = 0; j < numPointsToGraph; ++j) {
                        logMessage.append("*");
                    }
                    if (this.maximumNumberTablesAccessed < this.numTablesMetricsHistBreakpoints[i + 1]) break;
                }
                if (this.numTablesMetricsHistBreakpoints[18] < this.maximumNumberTablesAccessed) {
                    logMessage.append("\n\tbetween ");
                    logMessage.append(this.numTablesMetricsHistBreakpoints[18]);
                    logMessage.append(" and ");
                    logMessage.append(this.numTablesMetricsHistBreakpoints[19]);
                    logMessage.append(" tables: ");
                    logMessage.append(this.numTablesMetricsHistCounts[19]);
                }
            }
            this.log.logInfo(logMessage);
            this.metricsLastReportedMs = System.currentTimeMillis();
        }
    }

    private void reportMetricsIfNeeded() {
        if (this.getGatherPerformanceMetrics() && System.currentTimeMillis() - this.metricsLastReportedMs > (long)this.getReportMetricsIntervalMillis()) {
            this.reportMetrics();
        }
    }

    public void reportNumberOfTablesAccessed(int numTablesAccessed) {
        if ((long)numTablesAccessed < this.minimumNumberTablesAccessed) {
            this.minimumNumberTablesAccessed = numTablesAccessed;
        }
        if ((long)numTablesAccessed > this.maximumNumberTablesAccessed) {
            this.maximumNumberTablesAccessed = numTablesAccessed;
            this.repartitionTablesAccessedHistogram();
        }
        this.addToTablesAccessedHistogram(numTablesAccessed, 1);
    }

    public void resetServerState() throws SQLException {
        if (!this.getParanoid() && this.io != null && this.versionMeetsMinimum(4, 0, 6)) {
            this.changeUser(this.user, this.password);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void rollback() throws SQLException {
        block11: {
            block10: {
                this.checkClosed();
                try {
                    try {
                        if (this.connectionLifecycleInterceptors != null) {
                            IterateBlock iter = new IterateBlock(this.connectionLifecycleInterceptors.iterator()){

                                void forEach(Object each) throws SQLException {
                                    if (!((ConnectionLifecycleInterceptor)each).rollback()) {
                                        this.stopIterating = true;
                                    }
                                }
                            };
                            iter.doForAll();
                            if (!iter.fullIteration()) {
                                Object var3_4 = null;
                                break block10;
                            }
                        }
                        if (this.autoCommit && !this.getRelaxAutoCommit()) {
                            throw SQLError.createSQLException("Can't call rollback when autocommit=true", "08003", this.getExceptionInterceptor());
                        }
                        if (!this.transactionsSupported) break block11;
                        try {
                            this.rollbackNoChecks();
                            break block11;
                        }
                        catch (SQLException sqlEx) {
                            if (!this.getIgnoreNonTxTables()) throw sqlEx;
                            if (sqlEx.getErrorCode() != 1196) throw sqlEx;
                            Object var3_5 = null;
                            this.needsPing = this.getReconnectAtTxEnd();
                            return;
                        }
                    }
                    catch (SQLException sqlException) {
                        if (!"08S01".equals(sqlException.getSQLState())) throw sqlException;
                        throw SQLError.createSQLException("Communications link failure during rollback(). Transaction resolution unknown.", "08007", this.getExceptionInterceptor());
                    }
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    this.needsPing = this.getReconnectAtTxEnd();
                    throw throwable;
                }
            }
            this.needsPing = this.getReconnectAtTxEnd();
            return;
        }
        Object var3_6 = null;
        this.needsPing = this.getReconnectAtTxEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void rollback(final Savepoint savepoint) throws SQLException {
        block12: {
            block11: {
                if (!this.versionMeetsMinimum(4, 0, 14)) {
                    if (!this.versionMeetsMinimum(4, 1, 1)) throw SQLError.notImplemented();
                }
                this.checkClosed();
                try {
                    if (this.connectionLifecycleInterceptors != null) {
                        IterateBlock iter = new IterateBlock(this.connectionLifecycleInterceptors.iterator()){

                            void forEach(Object each) throws SQLException {
                                if (!((ConnectionLifecycleInterceptor)each).rollback(savepoint)) {
                                    this.stopIterating = true;
                                }
                            }
                        };
                        iter.doForAll();
                        if (!iter.fullIteration()) {
                            Object var11_3 = null;
                            break block11;
                        }
                    }
                    StringBuffer rollbackQuery = new StringBuffer("ROLLBACK TO SAVEPOINT ");
                    rollbackQuery.append('`');
                    rollbackQuery.append(savepoint.getSavepointName());
                    rollbackQuery.append('`');
                    java.sql.Statement stmt = null;
                    try {
                        try {
                            stmt = this.getMetadataSafeStatement();
                            stmt.executeUpdate(rollbackQuery.toString());
                        }
                        catch (SQLException sqlEx) {
                            int indexOfError153;
                            String msg;
                            int errno = sqlEx.getErrorCode();
                            if (errno == 1181 && (msg = sqlEx.getMessage()) != null && (indexOfError153 = msg.indexOf("153")) != -1) {
                                throw SQLError.createSQLException("Savepoint '" + savepoint.getSavepointName() + "' does not exist", "S1009", errno, this.getExceptionInterceptor());
                            }
                            if (this.getIgnoreNonTxTables() && sqlEx.getErrorCode() != 1196) {
                                throw sqlEx;
                            }
                            if (!"08S01".equals(sqlEx.getSQLState())) throw sqlEx;
                            throw SQLError.createSQLException("Communications link failure during rollback(). Transaction resolution unknown.", "08007", this.getExceptionInterceptor());
                        }
                        Object var9_7 = null;
                        this.closeStatement(stmt);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var9_8 = null;
                        this.closeStatement(stmt);
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_5 = null;
                    this.needsPing = this.getReconnectAtTxEnd();
                    throw throwable;
                }
            }
            this.needsPing = this.getReconnectAtTxEnd();
            return;
        }
        Object var11_4 = null;
        this.needsPing = this.getReconnectAtTxEnd();
    }

    private void rollbackNoChecks() throws SQLException {
        if (this.getUseLocalTransactionState() && this.versionMeetsMinimum(5, 0, 0) && !this.io.inTransactionOnServer()) {
            return;
        }
        this.execSQL(null, "rollback", -1, null, 1003, 1007, false, this.database, null, false);
    }

    public java.sql.PreparedStatement serverPrepareStatement(String sql) throws SQLException {
        String nativeSql = this.getProcessEscapeCodesForPrepStmts() ? this.nativeSQL(sql) : sql;
        return ServerPreparedStatement.getInstance(this.getLoadBalanceSafeProxy(), nativeSql, this.getCatalog(), 1003, 1007);
    }

    public java.sql.PreparedStatement serverPrepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        String nativeSql = this.getProcessEscapeCodesForPrepStmts() ? this.nativeSQL(sql) : sql;
        ServerPreparedStatement pStmt = ServerPreparedStatement.getInstance(this.getLoadBalanceSafeProxy(), nativeSql, this.getCatalog(), 1003, 1007);
        pStmt.setRetrieveGeneratedKeys(autoGenKeyIndex == 1);
        return pStmt;
    }

    public java.sql.PreparedStatement serverPrepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String nativeSql = this.getProcessEscapeCodesForPrepStmts() ? this.nativeSQL(sql) : sql;
        return ServerPreparedStatement.getInstance(this.getLoadBalanceSafeProxy(), nativeSql, this.getCatalog(), resultSetType, resultSetConcurrency);
    }

    public java.sql.PreparedStatement serverPrepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.getPedantic() && resultSetHoldability != 1) {
            throw SQLError.createSQLException("HOLD_CUSRORS_OVER_COMMIT is only supported holdability level", "S1009", this.getExceptionInterceptor());
        }
        return this.serverPrepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public java.sql.PreparedStatement serverPrepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        PreparedStatement pStmt = (PreparedStatement)this.serverPrepareStatement(sql);
        pStmt.setRetrieveGeneratedKeys(autoGenKeyIndexes != null && autoGenKeyIndexes.length > 0);
        return pStmt;
    }

    public java.sql.PreparedStatement serverPrepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        PreparedStatement pStmt = (PreparedStatement)this.serverPrepareStatement(sql);
        pStmt.setRetrieveGeneratedKeys(autoGenKeyColNames != null && autoGenKeyColNames.length > 0);
        return pStmt;
    }

    public boolean serverSupportsConvertFn() throws SQLException {
        return this.versionMeetsMinimum(4, 0, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setAutoCommit(final boolean autoCommitFlag) throws SQLException {
        this.checkClosed();
        if (this.connectionLifecycleInterceptors != null) {
            IterateBlock iter = new IterateBlock(this.connectionLifecycleInterceptors.iterator()){

                void forEach(Object each) throws SQLException {
                    if (!((ConnectionLifecycleInterceptor)each).setAutoCommit(autoCommitFlag)) {
                        this.stopIterating = true;
                    }
                }
            };
            iter.doForAll();
            if (!iter.fullIteration()) {
                return;
            }
        }
        if (this.getAutoReconnectForPools()) {
            this.setHighAvailability(true);
        }
        try {
            if (this.transactionsSupported) {
                boolean needsSetOnServer = true;
                if (this.getUseLocalSessionState() && this.autoCommit == autoCommitFlag) {
                    needsSetOnServer = false;
                } else if (!this.getHighAvailability()) {
                    needsSetOnServer = this.getIO().isSetNeededForAutoCommitMode(autoCommitFlag);
                }
                this.autoCommit = autoCommitFlag;
                if (needsSetOnServer) {
                    this.execSQL(null, autoCommitFlag ? "SET autocommit=1" : "SET autocommit=0", -1, null, 1003, 1007, false, this.database, null, false);
                }
            } else {
                if (!autoCommitFlag && !this.getRelaxAutoCommit()) {
                    throw SQLError.createSQLException("MySQL Versions Older than 3.23.15 do not support transactions", "08003", this.getExceptionInterceptor());
                }
                this.autoCommit = autoCommitFlag;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (this.getAutoReconnectForPools()) {
                this.setHighAvailability(false);
            }
            throw throwable;
        }
        if (this.getAutoReconnectForPools()) {
            this.setHighAvailability(false);
        }
    }

    public synchronized void setCatalog(final String catalog) throws SQLException {
        this.checkClosed();
        if (catalog == null) {
            throw SQLError.createSQLException("Catalog can not be null", "S1009", this.getExceptionInterceptor());
        }
        if (this.connectionLifecycleInterceptors != null) {
            IterateBlock iter = new IterateBlock(this.connectionLifecycleInterceptors.iterator()){

                void forEach(Object each) throws SQLException {
                    if (!((ConnectionLifecycleInterceptor)each).setCatalog(catalog)) {
                        this.stopIterating = true;
                    }
                }
            };
            iter.doForAll();
            if (!iter.fullIteration()) {
                return;
            }
        }
        if (this.getUseLocalSessionState() && (this.lowerCaseTableNames ? this.database.equalsIgnoreCase(catalog) : this.database.equals(catalog))) {
            return;
        }
        String quotedId = this.dbmd.getIdentifierQuoteString();
        if (quotedId == null || quotedId.equals(" ")) {
            quotedId = "";
        }
        StringBuffer query = new StringBuffer("USE ");
        query.append(quotedId);
        query.append(catalog);
        query.append(quotedId);
        this.execSQL(null, query.toString(), -1, null, 1003, 1007, false, this.database, null, false);
        this.database = catalog;
    }

    public synchronized void setFailedOver(boolean flag) {
    }

    public void setHoldability(int arg0) throws SQLException {
    }

    public void setInGlobalTx(boolean flag) {
        this.isInGlobalTx = flag;
    }

    public void setPreferSlaveDuringFailover(boolean flag) {
    }

    public void setReadInfoMsgEnabled(boolean flag) {
        this.readInfoMsg = flag;
    }

    public void setReadOnly(boolean readOnlyFlag) throws SQLException {
        this.checkClosed();
        this.setReadOnlyInternal(readOnlyFlag);
    }

    public void setReadOnlyInternal(boolean readOnlyFlag) throws SQLException {
        this.readOnly = readOnlyFlag;
    }

    public Savepoint setSavepoint() throws SQLException {
        MysqlSavepoint savepoint = new MysqlSavepoint(this.getExceptionInterceptor());
        this.setSavepoint(savepoint);
        return savepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setSavepoint(MysqlSavepoint savepoint) throws SQLException {
        if (this.versionMeetsMinimum(4, 0, 14) || this.versionMeetsMinimum(4, 1, 1)) {
            this.checkClosed();
            StringBuffer savePointQuery = new StringBuffer("SAVEPOINT ");
            savePointQuery.append('`');
            savePointQuery.append(savepoint.getSavepointName());
            savePointQuery.append('`');
            java.sql.Statement stmt = null;
            try {
                stmt = this.getMetadataSafeStatement();
                stmt.executeUpdate(savePointQuery.toString());
                Object var5_4 = null;
                this.closeStatement(stmt);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.closeStatement(stmt);
                throw throwable;
            }
        } else {
            throw SQLError.notImplemented();
        }
    }

    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        MysqlSavepoint savepoint = new MysqlSavepoint(name, this.getExceptionInterceptor());
        this.setSavepoint(savepoint);
        return savepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setSessionVariables() throws SQLException {
        if (!this.versionMeetsMinimum(4, 0, 0) || this.getSessionVariables() == null) return;
        List<String> variablesToSet = StringUtils.split(this.getSessionVariables(), ",", "\"'", "\"'", false);
        int numVariablesToSet = variablesToSet.size();
        java.sql.Statement stmt = null;
        try {
            stmt = this.getMetadataSafeStatement();
            for (int i = 0; i < numVariablesToSet; ++i) {
                String variableValuePair = variablesToSet.get(i);
                if (variableValuePair.startsWith("@")) {
                    stmt.executeUpdate("SET " + variableValuePair);
                    continue;
                }
                stmt.executeUpdate("SET SESSION " + variableValuePair);
            }
            Object var7_6 = null;
            if (stmt == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (stmt == null) throw throwable;
            stmt.close();
            throw throwable;
        }
        stmt.close();
    }

    public synchronized void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        if (this.hasIsolationLevels) {
            String sql = null;
            boolean shouldSendSet = false;
            if (this.getAlwaysSendSetIsolation()) {
                shouldSendSet = true;
            } else if (level != this.isolationLevel) {
                shouldSendSet = true;
            }
            if (this.getUseLocalSessionState()) {
                boolean bl = shouldSendSet = this.isolationLevel != level;
            }
            if (shouldSendSet) {
                switch (level) {
                    case 0: {
                        throw SQLError.createSQLException("Transaction isolation level NONE not supported by MySQL", this.getExceptionInterceptor());
                    }
                    case 2: {
                        sql = "SET SESSION TRANSACTION ISOLATION LEVEL READ COMMITTED";
                        break;
                    }
                    case 1: {
                        sql = "SET SESSION TRANSACTION ISOLATION LEVEL READ UNCOMMITTED";
                        break;
                    }
                    case 4: {
                        sql = "SET SESSION TRANSACTION ISOLATION LEVEL REPEATABLE READ";
                        break;
                    }
                    case 8: {
                        sql = "SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE";
                        break;
                    }
                    default: {
                        throw SQLError.createSQLException("Unsupported transaction isolation level '" + level + "'", "S1C00", this.getExceptionInterceptor());
                    }
                }
                this.execSQL(null, sql, -1, null, 1003, 1007, false, this.database, null, false);
                this.isolationLevel = level;
            }
        } else {
            throw SQLError.createSQLException("Transaction Isolation Levels are not supported on MySQL versions older than 3.23.36.", "S1C00", this.getExceptionInterceptor());
        }
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    private void setupServerForTruncationChecks() throws SQLException {
        if (this.getJdbcCompliantTruncation() && this.versionMeetsMinimum(5, 0, 2)) {
            boolean strictTransTablesIsSet;
            String currentSqlMode = (String)this.serverVariables.get("sql_mode");
            boolean bl = strictTransTablesIsSet = StringUtils.indexOfIgnoreCase(currentSqlMode, "STRICT_TRANS_TABLES") != -1;
            if (currentSqlMode == null || currentSqlMode.length() == 0 || !strictTransTablesIsSet) {
                StringBuffer commandBuf = new StringBuffer("SET sql_mode='");
                if (currentSqlMode != null && currentSqlMode.length() > 0) {
                    commandBuf.append(currentSqlMode);
                    commandBuf.append(",");
                }
                commandBuf.append("STRICT_TRANS_TABLES'");
                this.execSQL(null, commandBuf.toString(), -1, null, 1003, 1007, false, this.database, null, false);
                this.setJdbcCompliantTruncation(false);
            } else if (strictTransTablesIsSet) {
                this.setJdbcCompliantTruncation(false);
            }
        }
    }

    public void shutdownServer() throws SQLException {
        try {
            this.io.sendCommand(8, null, null, false, null, 0);
        }
        catch (Exception ex) {
            SQLException sqlEx = SQLError.createSQLException(Messages.getString("Connection.UnhandledExceptionDuringShutdown"), "S1000", this.getExceptionInterceptor());
            sqlEx.initCause(ex);
            throw sqlEx;
        }
    }

    public boolean supportsIsolationLevel() {
        return this.hasIsolationLevels;
    }

    public boolean supportsQuotedIdentifiers() {
        return this.hasQuotedIdentifiers;
    }

    public boolean supportsTransactions() {
        return this.transactionsSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterStatement(Statement stmt) {
        if (this.openStatements != null) {
            Map map = this.openStatements;
            synchronized (map) {
                this.openStatements.remove(stmt);
            }
        }
    }

    public synchronized void unsetMaxRows(Statement stmt) throws SQLException {
        Object found;
        if (this.statementsUsingMaxRows != null && (found = this.statementsUsingMaxRows.remove(stmt)) != null && this.statementsUsingMaxRows.size() == 0) {
            this.execSQL(null, "SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, null, 1003, 1007, false, this.database, null, false);
            this.maxRowsChanged = false;
        }
    }

    public synchronized boolean useAnsiQuotedIdentifiers() {
        return this.useAnsiQuotes;
    }

    public synchronized boolean useMaxRows() {
        return this.maxRowsChanged;
    }

    public boolean versionMeetsMinimum(int major, int minor, int subminor) throws SQLException {
        this.checkClosed();
        return this.io.versionMeetsMinimum(major, minor, subminor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedResultSetMetaData getCachedMetaData(String sql) {
        if (this.resultSetMetadataCache != null) {
            LRUCache lRUCache = this.resultSetMetadataCache;
            synchronized (lRUCache) {
                return (CachedResultSetMetaData)this.resultSetMetadataCache.get(sql);
            }
        }
        return null;
    }

    public void initializeResultsMetadataFromCache(String sql, CachedResultSetMetaData cachedMetaData, ResultSetInternalMethods resultSet) throws SQLException {
        if (cachedMetaData == null) {
            cachedMetaData = new CachedResultSetMetaData();
            resultSet.buildIndexMapping();
            resultSet.initializeWithMetadata();
            if (resultSet instanceof UpdatableResultSet) {
                ((UpdatableResultSet)resultSet).checkUpdatability();
            }
            resultSet.populateCachedMetaData(cachedMetaData);
            this.resultSetMetadataCache.put(sql, cachedMetaData);
        } else {
            resultSet.initializeFromCachedMetaData(cachedMetaData);
            resultSet.initializeWithMetadata();
            if (resultSet instanceof UpdatableResultSet) {
                ((UpdatableResultSet)resultSet).checkUpdatability();
            }
        }
    }

    public String getStatementComment() {
        return this.statementComment;
    }

    public void setStatementComment(String comment) {
        this.statementComment = comment;
    }

    public synchronized void reportQueryTime(long millisOrNanos) {
        ++this.queryTimeCount;
        this.queryTimeSum += (double)millisOrNanos;
        this.queryTimeSumSquares += (double)(millisOrNanos * millisOrNanos);
        this.queryTimeMean = (this.queryTimeMean * (double)(this.queryTimeCount - 1L) + (double)millisOrNanos) / (double)this.queryTimeCount;
    }

    public synchronized boolean isAbonormallyLongQuery(long millisOrNanos) {
        if (this.queryTimeCount < 15L) {
            return false;
        }
        double stddev = Math.sqrt((this.queryTimeSumSquares - this.queryTimeSum * this.queryTimeSum / (double)this.queryTimeCount) / (double)(this.queryTimeCount - 1L));
        return (double)millisOrNanos > this.queryTimeMean + 5.0 * stddev;
    }

    public void initializeExtension(Extension ex) throws SQLException {
        ex.init(this, this.props);
    }

    public synchronized void transactionBegun() throws SQLException {
        if (this.connectionLifecycleInterceptors != null) {
            IterateBlock iter = new IterateBlock(this.connectionLifecycleInterceptors.iterator()){

                void forEach(Object each) throws SQLException {
                    ((ConnectionLifecycleInterceptor)each).transactionBegun();
                }
            };
            iter.doForAll();
        }
    }

    public synchronized void transactionCompleted() throws SQLException {
        if (this.connectionLifecycleInterceptors != null) {
            IterateBlock iter = new IterateBlock(this.connectionLifecycleInterceptors.iterator()){

                void forEach(Object each) throws SQLException {
                    ((ConnectionLifecycleInterceptor)each).transactionCompleted();
                }
            };
            iter.doForAll();
        }
    }

    public boolean storesLowerCaseTableName() {
        return this.storesLowerCaseTableName;
    }

    public ExceptionInterceptor getExceptionInterceptor() {
        return this.exceptionInterceptor;
    }

    public boolean getRequiresEscapingEncoder() {
        return this.requiresEscapingEncoder;
    }

    public synchronized boolean isServerLocal() throws SQLException {
        SocketFactory factory = this.getIO().socketFactory;
        if (factory instanceof SocketMetadata) {
            return ((SocketMetadata)((Object)factory)).isLocallyConnected(this);
        }
        this.getLog().logWarn(Messages.getString("Connection.NoMetadataOnSocketFactory"));
        return false;
    }

    static {
        mapTransIsolationNameToValue = null;
        NULL_LOGGER = new NullLogger(LOGGER_INSTANCE_NAME);
        serverCollationByUrl = new HashMap();
        serverConfigByUrl = new HashMap();
        mapTransIsolationNameToValue = new HashMap(8);
        mapTransIsolationNameToValue.put("READ-UNCOMMITED", 1);
        mapTransIsolationNameToValue.put("READ-UNCOMMITTED", 1);
        mapTransIsolationNameToValue.put("READ-COMMITTED", 2);
        mapTransIsolationNameToValue.put("REPEATABLE-READ", 4);
        mapTransIsolationNameToValue.put("SERIALIZABLE", 8);
        if (Util.isJdbc4()) {
            try {
                JDBC_4_CONNECTION_CTOR = Class.forName("com.mysql.jdbc.JDBC4Connection").getConstructor(String.class, Integer.TYPE, Properties.class, String.class, String.class);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            JDBC_4_CONNECTION_CTOR = null;
        }
        random = new Random();
    }

    static class CompoundCacheKey {
        String componentOne;
        String componentTwo;
        int hashCode;

        CompoundCacheKey(String partOne, String partTwo) {
            this.componentOne = partOne;
            this.componentTwo = partTwo;
            this.hashCode = ((this.componentOne != null ? this.componentOne : "") + this.componentTwo).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CompoundCacheKey) {
                CompoundCacheKey another = (CompoundCacheKey)obj;
                boolean firstPartEqual = false;
                firstPartEqual = this.componentOne == null ? another.componentOne == null : this.componentOne.equals(another.componentOne);
                return firstPartEqual && this.componentTwo.equals(another.componentTwo);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    class ExceptionInterceptorChain
    implements ExceptionInterceptor {
        List interceptors;

        ExceptionInterceptorChain(String interceptorClasses) throws SQLException {
            this.interceptors = Util.loadExtensions(ConnectionImpl.this, ConnectionImpl.this.props, interceptorClasses, "Connection.BadExceptionInterceptor", this);
        }

        public SQLException interceptException(SQLException sqlEx, Connection conn) {
            if (this.interceptors != null) {
                Iterator iter = this.interceptors.iterator();
                while (iter.hasNext()) {
                    sqlEx = ((ExceptionInterceptor)iter.next()).interceptException(sqlEx, ConnectionImpl.this);
                }
            }
            return sqlEx;
        }

        public void destroy() {
            if (this.interceptors != null) {
                Iterator iter = this.interceptors.iterator();
                while (iter.hasNext()) {
                    ((ExceptionInterceptor)iter.next()).destroy();
                }
            }
        }

        public void init(Connection conn, Properties props) throws SQLException {
            if (this.interceptors != null) {
                Iterator iter = this.interceptors.iterator();
                while (iter.hasNext()) {
                    ((ExceptionInterceptor)iter.next()).init(conn, props);
                }
            }
        }
    }
}

